/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.channel.giop;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.iiop.GIOPConnectionProfile;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.transport.ConnectionKey;
import com.ibm.wsspi.channel.framework.ChannelFrameworkFactory;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContext;
import java.net.InetSocketAddress;

public abstract class GIOPConnectionKey
implements TCPConnectRequestContext,
ConnectionKey {
    private GIOPConnectionContext connectionContext;
    private InetSocketAddress localAddress;
    private InetSocketAddress remoteAddress;
    private VirtualConnectionFactory virtualConnectionFactory;
    private int connectTimeOut;
    private GIOPConnectionProfile connProfile;
    private String remoteHost;
    private int remotePort;

    protected GIOPConnectionKey() {
    }

    protected GIOPConnectionKey(String string, GIOPConnectionProfile gIOPConnectionProfile, int n) {
        this.init(string, gIOPConnectionProfile, n);
    }

    protected void init(String string, GIOPConnectionProfile gIOPConnectionProfile, int n) {
        this.lookupVirtualConnectionFactory(string);
        this.setTimeout(n);
        this.connProfile = gIOPConnectionProfile;
        this.remoteHost = gIOPConnectionProfile.getHost();
        this.remotePort = gIOPConnectionProfile.getPort();
    }

    private void setTimeout(int n) {
        this.connectTimeOut = n == 0 ? -1 : n;
    }

    private void lookupVirtualConnectionFactory(String string) {
        try {
            this.virtualConnectionFactory = ChannelFrameworkFactory.getChannelFramework().getOutboundVCFactory(string);
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, this, "retrieveVirtualConenctionFactory:142", exception);
        }
    }

    public InetSocketAddress getLocalAddress() {
        return new InetSocketAddress(0);
    }

    public InetSocketAddress getRemoteAddress() {
        return new InetSocketAddress(this.remoteHost, this.remotePort);
    }

    public VirtualConnectionFactory getVirtualConnectionFactory() {
        return this.virtualConnectionFactory;
    }

    public int getConnectTimeout() {
        return this.connectTimeOut;
    }

    public String toString() {
        return "[localAddress=" + this.localAddress + ", remoteAddress=" + this.remoteAddress + ", VirtualConnectionFactory=" + this.virtualConnectionFactory.getName() + "]";
    }

    public GIOPConnectionProfile getGIOPConnectionProfile() {
        return this.connProfile;
    }

    public GIOPConnectionContext getGIOPConnectionContext() {
        return this.connectionContext;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract void addConnection(GIOPConnectionContext var1);

    public abstract void removeConnection();

    public abstract Object getConnectionData();

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public abstract void recycle();
}

