/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import com.ibm.security.auth.PolicyFile;
import com.ibm.security.util.Debug;
import java.io.Serializable;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.security.auth.AuthPermission;
import javax.security.auth.Policy;
import javax.security.auth.Subject;

public class SubjectDomainCombiner
implements DomainCombiner {
    private Subject subject;
    private Map cachedPDs = new WeakHashMap();
    private Set principalSet;
    private Principal[] principals;
    private static final Debug debug = Debug.getInstance("combiner", "\t[SubjectDomainCombiner]");
    private static final boolean useJavaxPolicy = SubjectDomainCombiner.compatPolicy();
    private static final boolean allowCaching = useJavaxPolicy && SubjectDomainCombiner.cachePolicy();

    public SubjectDomainCombiner(Subject subject) {
        this.subject = subject;
        if (subject.isReadOnly()) {
            this.principalSet = subject.getPrincipals();
            this.principals = this.principalSet.toArray(new Principal[this.principalSet.size()]);
        }
    }

    public Subject getSubject() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("getSubjectFromDomainCombiner"));
        }
        return this.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtectionDomain[] combine(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        if (debug != null) {
            if (this.subject == null) {
                debug.println("null subject");
            } else {
                final Subject subject = this.subject;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        debug.println(subject.toString());
                        return null;
                    }
                });
            }
            SubjectDomainCombiner.printInputDomains(protectionDomainArray, protectionDomainArray2);
        }
        if (protectionDomainArray == null || protectionDomainArray.length == 0) {
            return protectionDomainArray2;
        }
        protectionDomainArray = SubjectDomainCombiner.optimize(protectionDomainArray);
        if (debug != null) {
            debug.println("after optimize");
            SubjectDomainCombiner.printInputDomains(protectionDomainArray, protectionDomainArray2);
        }
        if (protectionDomainArray == null && protectionDomainArray2 == null) {
            return null;
        }
        if (useJavaxPolicy) {
            return this.combineJavaxPolicy(protectionDomainArray, protectionDomainArray2);
        }
        int n = protectionDomainArray == null ? 0 : protectionDomainArray.length;
        int n2 = protectionDomainArray2 == null ? 0 : protectionDomainArray2.length;
        ProtectionDomain[] protectionDomainArray3 = new ProtectionDomain[n + n2];
        boolean bl = true;
        Map map = this.cachedPDs;
        synchronized (map) {
            Object object;
            if (!this.subject.isReadOnly() && !((Object)this.subject.getPrincipals()).equals(this.principalSet)) {
                object = this.subject.getPrincipals();
                Set<Principal> set = object;
                synchronized (set) {
                    this.principalSet = new HashSet(object);
                }
                this.principals = this.principalSet.toArray(new Principal[this.principalSet.size()]);
                this.cachedPDs.clear();
                if (debug != null) {
                    debug.println("Subject mutated - clearing cache");
                }
            }
            for (int i = 0; i < n; ++i) {
                ProtectionDomain protectionDomain = protectionDomainArray[i];
                object = (ProtectionDomain)this.cachedPDs.get(protectionDomain);
                if (object == null) {
                    object = new ProtectionDomain(protectionDomain.getCodeSource(), protectionDomain.getPermissions(), protectionDomain.getClassLoader(), this.principals);
                    this.cachedPDs.put(protectionDomain, object);
                } else {
                    bl = false;
                }
                protectionDomainArray3[i] = object;
            }
        }
        if (debug != null) {
            debug.println("updated current: ");
            for (int i = 0; i < n; ++i) {
                debug.println("\tupdated[" + i + "] = " + SubjectDomainCombiner.printDomain(protectionDomainArray3[i]));
            }
        }
        if (n2 > 0) {
            System.arraycopy(protectionDomainArray2, 0, protectionDomainArray3, n, n2);
            if (!bl) {
                protectionDomainArray3 = SubjectDomainCombiner.optimize(protectionDomainArray3);
            }
        }
        if (debug != null) {
            if (protectionDomainArray3 == null || protectionDomainArray3.length == 0) {
                debug.println("returning null");
            } else {
                debug.println("combinedDomains: ");
                for (int i = 0; i < protectionDomainArray3.length; ++i) {
                    debug.println("newDomain " + i + ": " + SubjectDomainCombiner.printDomain(protectionDomainArray3[i]));
                }
            }
        }
        if (protectionDomainArray3 == null || protectionDomainArray3.length == 0) {
            return null;
        }
        return protectionDomainArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectionDomain[] combineJavaxPolicy(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        if (!allowCaching) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Policy.getPolicy().refresh();
                    return null;
                }
            });
        }
        int n = protectionDomainArray == null ? 0 : protectionDomainArray.length;
        int n2 = protectionDomainArray2 == null ? 0 : protectionDomainArray2.length;
        ProtectionDomain[] protectionDomainArray3 = new ProtectionDomain[n + n2];
        Map map = this.cachedPDs;
        synchronized (map) {
            Object object;
            if (!this.subject.isReadOnly() && !((Object)this.subject.getPrincipals()).equals(this.principalSet)) {
                Set<Principal> set = this.subject.getPrincipals();
                object = set;
                synchronized (object) {
                    this.principalSet = new HashSet<Principal>(set);
                }
                this.principals = this.principalSet.toArray(new Principal[this.principalSet.size()]);
                this.cachedPDs.clear();
                if (debug != null) {
                    debug.println("Subject mutated - clearing cache");
                }
            }
            for (int i = 0; i < n; ++i) {
                object = protectionDomainArray[i];
                ProtectionDomain protectionDomain = (ProtectionDomain)this.cachedPDs.get(object);
                if (protectionDomain == null) {
                    PermissionCollection permissionCollection;
                    Serializable serializable;
                    Enumeration<Permission> enumeration;
                    PermissionCollection permissionCollection2;
                    Permissions permissions = new Permissions();
                    Serializable serializable2 = permissionCollection2 = ((ProtectionDomain)object).getPermissions();
                    synchronized (serializable2) {
                        enumeration = permissionCollection2.elements();
                        while (enumeration.hasMoreElements()) {
                            serializable = enumeration.nextElement();
                            permissions.add((Permission)serializable);
                        }
                    }
                    serializable2 = ((ProtectionDomain)object).getCodeSource();
                    serializable = this.subject;
                    PermissionCollection permissionCollection3 = permissionCollection = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction((Subject)serializable, (CodeSource)serializable2){
                        final /* synthetic */ Subject val$finalS;
                        final /* synthetic */ CodeSource val$finalCs;
                        {
                            this.val$finalS = subject;
                            this.val$finalCs = codeSource;
                        }

                        public Object run() {
                            return Policy.getPolicy().getPermissions(this.val$finalS, this.val$finalCs);
                        }
                    });
                    synchronized (permissionCollection3) {
                        enumeration = permissionCollection.elements();
                        while (enumeration.hasMoreElements()) {
                            Permission permission = enumeration.nextElement();
                            if (permissions.implies(permission)) continue;
                            permissions.add(permission);
                            if (debug == null) continue;
                            debug.println("Adding perm " + permission + "\n");
                        }
                    }
                    protectionDomain = new ProtectionDomain((CodeSource)serializable2, permissions);
                    if (allowCaching) {
                        this.cachedPDs.put(object, protectionDomain);
                    }
                }
                protectionDomainArray3[i] = protectionDomain;
            }
        }
        if (debug != null) {
            debug.println("updated current: ");
            for (int i = 0; i < n; ++i) {
                debug.println("\tupdated[" + i + "] = " + protectionDomainArray3[i]);
            }
        }
        if (n2 > 0) {
            System.arraycopy(protectionDomainArray2, 0, protectionDomainArray3, n, n2);
        }
        if (debug != null) {
            if (protectionDomainArray3 == null || protectionDomainArray3.length == 0) {
                debug.println("returning null");
            } else {
                debug.println("combinedDomains: ");
                for (int i = 0; i < protectionDomainArray3.length; ++i) {
                    debug.println("newDomain " + i + ": " + protectionDomainArray3[i].toString());
                }
            }
        }
        if (protectionDomainArray3 == null || protectionDomainArray3.length == 0) {
            return null;
        }
        return protectionDomainArray3;
    }

    private static ProtectionDomain[] optimize(ProtectionDomain[] protectionDomainArray) {
        if (protectionDomainArray == null || protectionDomainArray.length == 0) {
            return null;
        }
        ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[protectionDomainArray.length];
        int n = 0;
        for (int i = 0; i < protectionDomainArray.length; ++i) {
            ProtectionDomain protectionDomain = protectionDomainArray[i];
            if (protectionDomain == null) continue;
            boolean bl = false;
            for (int j = 0; j < n && !bl; ++j) {
                bl = protectionDomainArray2[j] == protectionDomain;
            }
            if (bl) continue;
            protectionDomainArray2[n++] = protectionDomain;
        }
        if (n > 0 && n < protectionDomainArray.length) {
            ProtectionDomain[] protectionDomainArray3 = new ProtectionDomain[n];
            System.arraycopy(protectionDomainArray2, 0, protectionDomainArray3, 0, protectionDomainArray3.length);
            protectionDomainArray2 = protectionDomainArray3;
        }
        return n == 0 || protectionDomainArray2.length == 0 ? null : protectionDomainArray2;
    }

    private static boolean cachePolicy() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("cache.auth.policy");
            }
        });
        if (string != null) {
            Boolean bl = new Boolean(string);
            return bl;
        }
        return true;
    }

    private static boolean compatPolicy() {
        Policy policy = (Policy)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Policy.getPolicy();
            }
        });
        if (!(policy instanceof PolicyFile)) {
            if (debug != null) {
                debug.println("Providing backwards compatibility for javax.security.auth.policy implementation: " + policy.toString());
            }
            return true;
        }
        return false;
    }

    private static void printInputDomains(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        int n;
        if (protectionDomainArray == null || protectionDomainArray.length == 0) {
            debug.println("currentDomains null or 0 length");
        } else {
            for (n = 0; protectionDomainArray != null && n < protectionDomainArray.length; ++n) {
                if (protectionDomainArray[n] == null) {
                    debug.println("currentDomain " + n + ": SystemDomain");
                    continue;
                }
                debug.println("currentDomain " + n + ": " + SubjectDomainCombiner.printDomain(protectionDomainArray[n]));
            }
        }
        if (protectionDomainArray2 == null || protectionDomainArray2.length == 0) {
            debug.println("assignedDomains null or 0 length");
        } else {
            debug.println("assignedDomains = ");
            for (n = 0; protectionDomainArray2 != null && n < protectionDomainArray2.length; ++n) {
                if (protectionDomainArray2[n] == null) {
                    debug.println("assignedDomain " + n + ": SystemDomain");
                    continue;
                }
                debug.println("assignedDomain " + n + ": " + SubjectDomainCombiner.printDomain(protectionDomainArray2[n]));
            }
        }
    }

    private static String printDomain(final ProtectionDomain protectionDomain) {
        if (protectionDomain == null) {
            return "null";
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return protectionDomain.toString();
            }
        });
    }
}

