/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import com.ibm.security.util.ResourcesMgr;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.text.MessageFormat;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import javax.security.auth.AuthPermission;
import javax.security.auth.PrivateCredentialPermission;
import javax.security.auth.SubjectDomainCombiner;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Subject
implements Serializable {
    private static final long serialVersionUID = -8308522755600156056L;
    Set principals;
    transient Set pubCredentials;
    transient Set privCredentials;
    private volatile boolean readOnly = false;
    private static Constructor combiner_constructor;
    private static ClassLoader sysClassLoader;
    private static Method getSub;
    private static Method doAsPA;
    private static Method doAsPEA;
    private static Method doAsPPA;
    private static Method doAsPPEA;
    private static boolean overrideActive;
    private static final int PRINCIPAL_SET = 1;
    private static final int PUB_CREDENTIAL_SET = 2;
    private static final int PRIV_CREDENTIAL_SET = 3;

    public Subject() {
        this.principals = Collections.synchronizedSet(new SecureSet(this, 1));
        this.pubCredentials = Collections.synchronizedSet(new SecureSet(this, 2));
        this.privCredentials = Collections.synchronizedSet(new SecureSet(this, 3));
    }

    public Subject(boolean bl, Set<? extends Principal> set, Set<?> set2, Set<?> set3) {
        if (set == null || set2 == null || set3 == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null input(s)"));
        }
        this.principals = Collections.synchronizedSet(new SecureSet(this, 1, set));
        this.pubCredentials = Collections.synchronizedSet(new SecureSet(this, 2, set2));
        this.privCredentials = Collections.synchronizedSet(new SecureSet(this, 3, set3));
        this.readOnly = bl;
    }

    public void setReadOnly() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("setReadOnly"));
        }
        this.readOnly = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public static Subject getSubject(final AccessControlContext accessControlContext) {
        if (overrideActive) {
            try {
                return (Subject)getSub.invoke(null, accessControlContext);
            }
            catch (Exception exception) {
                if (exception instanceof IllegalAccessException || exception instanceof IllegalArgumentException) {
                    overrideActive = false;
                    throw new InternalError("doAsPrivileged error (" + exception.getMessage() + "), override ended");
                }
                if (exception instanceof InvocationTargetException) {
                    throw (RuntimeException)((InvocationTargetException)exception).getTargetException();
                }
                throw (RuntimeException)exception;
            }
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("getSubject"));
        }
        if (accessControlContext == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null AccessControlContext provided"));
        }
        return (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DomainCombiner domainCombiner = accessControlContext.getDomainCombiner();
                if (!(domainCombiner instanceof SubjectDomainCombiner)) {
                    return null;
                }
                SubjectDomainCombiner subjectDomainCombiner = (SubjectDomainCombiner)domainCombiner;
                return subjectDomainCombiner.getSubject();
            }
        });
    }

    public static Object doAs(Subject subject, PrivilegedAction privilegedAction) {
        if (overrideActive) {
            try {
                return doAsPA.invoke(null, subject, privilegedAction);
            }
            catch (Exception exception) {
                if (exception instanceof IllegalAccessException || exception instanceof IllegalArgumentException) {
                    overrideActive = false;
                    throw new InternalError("doAsPrivileged error (" + exception.getMessage() + "), override ended");
                }
                if (exception instanceof InvocationTargetException) {
                    throw (RuntimeException)((InvocationTargetException)exception).getTargetException();
                }
                throw (RuntimeException)exception;
            }
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("doAs"));
        }
        if (privilegedAction == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext = AccessController.getContext();
        return AccessController.doPrivileged(privilegedAction, Subject.createContext(subject, accessControlContext));
    }

    public static Object doAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        if (overrideActive) {
            try {
                return doAsPEA.invoke(null, subject, privilegedExceptionAction);
            }
            catch (Exception exception) {
                if (exception instanceof IllegalAccessException || exception instanceof IllegalArgumentException) {
                    overrideActive = false;
                    throw new InternalError("doAsPrivileged error (" + exception.getMessage() + "), override ended");
                }
                if (exception instanceof InvocationTargetException) {
                    Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                    if (throwable instanceof PrivilegedActionException) {
                        throw (PrivilegedActionException)throwable;
                    }
                    throw (RuntimeException)throwable;
                }
                throw (RuntimeException)exception;
            }
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("doAs"));
        }
        if (privilegedExceptionAction == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext = AccessController.getContext();
        return AccessController.doPrivileged(privilegedExceptionAction, Subject.createContext(subject, accessControlContext));
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        if (overrideActive) {
            try {
                return doAsPPA.invoke(null, subject, privilegedAction, accessControlContext);
            }
            catch (Exception exception) {
                if (exception instanceof IllegalAccessException || exception instanceof IllegalArgumentException) {
                    overrideActive = false;
                    throw new InternalError("doAsPrivileged error (" + exception.getMessage() + "), override ended");
                }
                if (exception instanceof InvocationTargetException) {
                    throw (RuntimeException)((InvocationTargetException)exception).getTargetException();
                }
                throw (RuntimeException)exception;
            }
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("doAsPrivileged"));
        }
        if (privilegedAction == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext2 = accessControlContext == null ? new AccessControlContext(new ProtectionDomain[0]) : accessControlContext;
        return AccessController.doPrivileged(privilegedAction, Subject.createContext(subject, accessControlContext2));
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        if (overrideActive) {
            try {
                return doAsPPEA.invoke(null, subject, privilegedExceptionAction, accessControlContext);
            }
            catch (Exception exception) {
                if (exception instanceof IllegalAccessException || exception instanceof IllegalArgumentException) {
                    overrideActive = false;
                    throw new InternalError("doAsPrivileged error (" + exception.getMessage() + "), override ended");
                }
                if (exception instanceof InvocationTargetException) {
                    Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                    if (throwable instanceof PrivilegedActionException) {
                        throw (PrivilegedActionException)throwable;
                    }
                    throw (RuntimeException)throwable;
                }
                throw (RuntimeException)exception;
            }
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("doAsPrivileged"));
        }
        if (privilegedExceptionAction == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext2 = accessControlContext == null ? new AccessControlContext(new ProtectionDomain[0]) : accessControlContext;
        return AccessController.doPrivileged(privilegedExceptionAction, Subject.createContext(subject, accessControlContext2));
    }

    private static AccessControlContext createContext(final Subject subject, final AccessControlContext accessControlContext) {
        return (AccessControlContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (subject == null) {
                    return new AccessControlContext(accessControlContext, null);
                }
                try {
                    Object[] objectArray = new Object[]{subject};
                    DomainCombiner domainCombiner = (DomainCombiner)combiner_constructor.newInstance(objectArray);
                    return new AccessControlContext(accessControlContext, domainCombiner);
                }
                catch (Exception exception) {
                    throw new SecurityException(exception.toString());
                }
            }
        });
    }

    public Set<Principal> getPrincipals() {
        return this.principals;
    }

    public <T extends Principal> Set<T> getPrincipals(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null Class provided"));
        }
        return new ClassSet(1, clazz);
    }

    public Set<Object> getPublicCredentials() {
        return this.pubCredentials;
    }

    public Set<Object> getPrivateCredentials() {
        return this.privCredentials;
    }

    public <T> Set<T> getPublicCredentials(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null Class provided"));
        }
        return new ClassSet(2, clazz);
    }

    public <T> Set<T> getPrivateCredentials(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null Class provided"));
        }
        return new ClassSet(3, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof Subject) {
            HashSet hashSet;
            Subject subject = (Subject)object;
            HashSet hashSet2 = subject.principals;
            synchronized (hashSet2) {
                hashSet = new HashSet(subject.principals);
            }
            if (!((Object)this.principals).equals(hashSet)) {
                return false;
            }
            HashSet hashSet3 = subject.pubCredentials;
            synchronized (hashSet3) {
                hashSet2 = new HashSet(subject.pubCredentials);
            }
            if (!((Object)this.pubCredentials).equals(hashSet2)) {
                return false;
            }
            Set set = subject.privCredentials;
            synchronized (set) {
                hashSet3 = new HashSet(subject.privCredentials);
            }
            return ((Object)this.privCredentials).equals(hashSet3);
        }
        return false;
    }

    public String toString() {
        return this.toString(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String toString(boolean bl) {
        String string = new String(ResourcesMgr.getString("Subject:\n"));
        String string2 = new String();
        Set set = this.principals;
        synchronized (set) {
            for (Principal principal : this.principals) {
                string2 = string2 + ResourcesMgr.getString("\tPrincipal: ") + ((Object)principal).toString() + ResourcesMgr.getString("\n");
            }
        }
        set = this.pubCredentials;
        synchronized (set) {
            for (Principal principal : this.pubCredentials) {
                string2 = string2 + ResourcesMgr.getString("\tPublic Credential: ") + ((Object)principal).toString() + ResourcesMgr.getString("\n");
            }
        }
        if (bl) {
            set = this.privCredentials;
            synchronized (set) {
                Iterator iterator = this.privCredentials.iterator();
                while (iterator.hasNext()) {
                    try {
                        Principal principal;
                        principal = iterator.next();
                        string2 = string2 + ResourcesMgr.getString("\tPrivate Credential: ") + ((Object)principal).toString() + ResourcesMgr.getString("\n");
                    }
                    catch (SecurityException securityException) {
                        string2 = string2 + ResourcesMgr.getString("\tPrivate Credential inaccessible\n");
                        break;
                    }
                }
            }
        }
        return string + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int n = 0;
        Set set = this.principals;
        synchronized (set) {
            for (Principal principal : this.principals) {
                n ^= ((Object)principal).hashCode();
            }
        }
        set = this.pubCredentials;
        synchronized (set) {
            Iterator iterator = this.pubCredentials.iterator();
            while (iterator.hasNext()) {
                n ^= this.getCredHashCode(iterator.next());
            }
        }
        return n;
    }

    private int getCredHashCode(Object object) {
        try {
            return object.hashCode();
        }
        catch (IllegalStateException illegalStateException) {
            return object.getClass().toString().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Set set = this.principals;
        synchronized (set) {
            objectOutputStream.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.pubCredentials = Collections.synchronizedSet(new SecureSet(this, 2));
        this.privCredentials = Collections.synchronizedSet(new SecureSet(this, 3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        overrideActive = false;
        Object object = AccessController.doPrivileged(new GetPropertyAction("com.ibm.SubjectOverrideClassName"));
        if (object != null) {
            AccessController.doPrivileged(new PrivilegedAction((String)object){
                final /* synthetic */ String val$overrideName;
                {
                    this.val$overrideName = string;
                }

                public Object run() {
                    try {
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        Class<?> clazz = Class.forName(this.val$overrideName, true, classLoader);
                        Class<?> clazz2 = Class.forName("java.security.AccessControlContext", true, classLoader);
                        Class<?> clazz3 = Class.forName("java.security.PrivilegedAction", true, classLoader);
                        Class<?> clazz4 = Class.forName("java.security.PrivilegedExceptionAction", true, classLoader);
                        Class<?> clazz5 = Class.forName("javax.security.auth.Subject", true, classLoader);
                        getSub = clazz.getMethod("getSubject", clazz2);
                        doAsPA = clazz.getMethod("doAs", clazz5, clazz3);
                        doAsPEA = clazz.getMethod("doAs", clazz5, clazz4);
                        doAsPPA = clazz.getMethod("doAsPrivileged", clazz5, clazz3, clazz2);
                        doAsPPEA = clazz.getMethod("doAsPrivileged", clazz5, clazz4, clazz2);
                        return null;
                    }
                    catch (Throwable throwable) {
                        throw new InternalError("Could not initialize Subject overrides from " + this.val$overrideName + " because " + throwable.getMessage());
                    }
                }
            });
            overrideActive = true;
        }
        if (sysClassLoader != null) return;
        object = Subject.class;
        synchronized (Subject.class) {
            Object object2;
            if (sysClassLoader != null) return;
            sysClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ClassLoader.getSystemClassLoader();
                }
            });
            Class[] classArray = new Class[]{Subject.class};
            String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("combiner.provider");
                }
            });
            if (string == null) {
                string = "javax.security.auth.SubjectDomainCombiner";
            } else {
                object2 = System.getSecurityManager();
                if (object2 != null) {
                    ((SecurityManager)object2).checkPermission(new AuthPermission("specifyDomainCombiner"));
                }
            }
            try {
                object2 = Class.forName(string, true, sysClassLoader);
                combiner_constructor = ((Class)object2).getConstructor(classArray);
            }
            catch (Exception exception) {
                throw new SecurityException(exception.toString());
            }
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassSet<T>
    extends AbstractSet<T> {
        private int which;
        private Class c;
        private Set<T> set;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClassSet(int n, Class clazz) {
            this.which = n;
            this.c = clazz;
            this.set = new HashSet<T>();
            switch (n) {
                case 1: {
                    Set set = Subject.this.principals;
                    synchronized (set) {
                        this.populateSet();
                        break;
                    }
                }
                case 2: {
                    Set set = Subject.this.pubCredentials;
                    synchronized (set) {
                        this.populateSet();
                        break;
                    }
                }
                default: {
                    Set set = Subject.this.privCredentials;
                    synchronized (set) {
                        this.populateSet();
                        break;
                    }
                }
            }
        }

        private void populateSet() {
            Iterator iterator;
            switch (this.which) {
                case 1: {
                    iterator = Subject.this.principals.iterator();
                    break;
                }
                case 2: {
                    iterator = Subject.this.pubCredentials.iterator();
                    break;
                }
                default: {
                    iterator = Subject.this.privCredentials.iterator();
                }
            }
            while (iterator.hasNext()) {
                Object object = this.which == 3 ? AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return iterator.next();
                    }
                }) : iterator.next();
                if (object == null || !this.c.isAssignableFrom(object.getClass())) continue;
                if (this.which != 3) {
                    this.set.add(object);
                    continue;
                }
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkPermission(new PrivateCredentialPermission(object.getClass().getName(), Subject.this.getPrincipals()));
                }
                this.set.add(object);
            }
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public Iterator<T> iterator() {
            return this.set.iterator();
        }

        @Override
        public boolean add(T t) {
            if (!t.getClass().isAssignableFrom(this.c)) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("attempting to add an object which is not an instance of class"));
                Object[] objectArray = new Object[]{this.c.toString()};
                throw new SecurityException(messageFormat.format(objectArray));
            }
            return this.set.add(t);
        }
    }

    private static class SecureSet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 7911754171111800359L;
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("this$0", Subject.class), new ObjectStreamField("elements", LinkedList.class), new ObjectStreamField("which", Integer.TYPE)};
        Subject subject;
        LinkedList elements;
        private int which;

        SecureSet(Subject subject, int n) {
            this.subject = subject;
            this.which = n;
            this.elements = new LinkedList();
        }

        SecureSet(Subject subject, int n, Set set) {
            this.subject = subject;
            this.which = n;
            this.elements = new LinkedList(set);
        }

        public int size() {
            return this.elements.size();
        }

        public Iterator iterator() {
            final LinkedList linkedList = this.elements;
            return new Iterator(){
                ListIterator i;
                {
                    this.i = linkedList.listIterator(0);
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    if (SecureSet.this.which != 3) {
                        return this.i.next();
                    }
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        try {
                            securityManager.checkPermission(new PrivateCredentialPermission(linkedList.get(this.i.nextIndex()).getClass().getName(), SecureSet.this.subject.getPrincipals()));
                        }
                        catch (SecurityException securityException) {
                            this.i.next();
                            throw securityException;
                        }
                    }
                    return this.i.next();
                }

                public void remove() {
                    if (SecureSet.this.subject.isReadOnly()) {
                        throw new IllegalStateException(ResourcesMgr.getString("Subject is read-only"));
                    }
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        switch (SecureSet.this.which) {
                            case 1: {
                                securityManager.checkPermission(new AuthPermission("modifyPrincipals"));
                                break;
                            }
                            case 2: {
                                securityManager.checkPermission(new AuthPermission("modifyPublicCredentials"));
                                break;
                            }
                            default: {
                                securityManager.checkPermission(new AuthPermission("modifyPrivateCredentials"));
                            }
                        }
                    }
                    this.i.remove();
                }
            };
        }

        public boolean add(Object object) {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException(ResourcesMgr.getString("Subject is read-only"));
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                switch (this.which) {
                    case 1: {
                        securityManager.checkPermission(new AuthPermission("modifyPrincipals"));
                        break;
                    }
                    case 2: {
                        securityManager.checkPermission(new AuthPermission("modifyPublicCredentials"));
                        break;
                    }
                    default: {
                        securityManager.checkPermission(new AuthPermission("modifyPrivateCredentials"));
                    }
                }
            }
            switch (this.which) {
                case 1: {
                    if (object instanceof Principal) break;
                    throw new SecurityException(ResourcesMgr.getString("attempting to add an object which is not an instance of java.security.Principal to a Subject's Principal Set"));
                }
            }
            if (!this.elements.contains(object)) {
                return this.elements.add(object);
            }
            return false;
        }

        public boolean remove(Object object) {
            final Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object object2 = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return iterator.next();
                    }
                });
                if (object2 == null) {
                    if (object != null) continue;
                    iterator.remove();
                    return true;
                }
                if (!object2.equals(object)) continue;
                iterator.remove();
                return true;
            }
            return false;
        }

        public boolean contains(Object object) {
            final Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object object2;
                if (this.which != 3) {
                    object2 = iterator.next();
                } else {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkPermission(new PrivateCredentialPermission(object.getClass().getName(), this.subject.getPrincipals()));
                    }
                    object2 = AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return iterator.next();
                        }
                    });
                }
                if (!(object2 == null ? object == null : object2.equals(object))) continue;
                return true;
            }
            return false;
        }

        public boolean removeAll(Collection collection) {
            boolean bl = false;
            final Iterator iterator = this.iterator();
            block0: while (iterator.hasNext()) {
                Object object = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return iterator.next();
                    }
                });
                for (Object e : collection) {
                    if (object == null) {
                        if (e != null) continue;
                        iterator.remove();
                        bl = true;
                        continue block0;
                    }
                    if (!object.equals(e)) continue;
                    iterator.remove();
                    bl = true;
                    continue block0;
                }
            }
            return bl;
        }

        public boolean retainAll(Collection collection) {
            boolean bl = false;
            boolean bl2 = false;
            final Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                bl2 = false;
                Object object = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return iterator.next();
                    }
                });
                for (Object e : collection) {
                    if (object == null) {
                        if (e != null) continue;
                        bl2 = true;
                        break;
                    }
                    if (!object.equals(e)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                iterator.remove();
                bl2 = false;
                bl = true;
            }
            return bl;
        }

        public void clear() {
            final Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object object = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return iterator.next();
                    }
                });
                iterator.remove();
            }
        }

        private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object;
            if (this.which == 3) {
                object = this.iterator();
                while (object.hasNext()) {
                    object.next();
                }
            }
            object = objectOutputStream.putFields();
            ((ObjectOutputStream.PutField)object).put("this$0", this.subject);
            ((ObjectOutputStream.PutField)object).put("elements", this.elements);
            ((ObjectOutputStream.PutField)object).put("which", this.which);
            objectOutputStream.writeFields();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            this.subject = (Subject)getField.get("this$0", null);
            this.elements = (LinkedList)getField.get("elements", null);
            this.which = getField.get("which", 0);
        }
    }
}

