/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.scan;

import com.ibm.xml.xlxp.scan.ScannerHelper;
import com.ibm.xml.xlxp.scan.util.AttrList;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.NSDeclList;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.scan.util.QName;
import com.ibm.xml.xlxp.scan.util.UntestedCode;
import com.ibm.xml.xlxp.scan.util.XMLString;

public final class DocumentEntityScanner {
    private static final int STATE_START_ELEMENT = 0;
    private static final int STATE_END_ELEMENT = 1;
    private static final int STATE_CONTENT = 2;
    private static final int STATE_XML_DECL = 0;
    private static final int STATE_START_DOCUMENT = 1;
    private static final int STATE_PROLOG = 2;
    private static final int STATE_TRAILING_MISC = 3;
    private static final int STATE_UNBUFFERED = 4;
    private static final int STATE_UNBUFFERED_START_ELEMENT = 4;
    private static final int STATE_UNBUFFERED_END_ELEMENT = 5;
    private static final int STATE_UNBUFFERED_CONTENT = 6;
    private static final int STATE_FINAL = 7;
    private static final int STATE_BUFFERED = 8;
    private static final int STATE_BUFFERED_START_ELEMENT = 8;
    private static final int STATE_BUFFERED_END_ELEMENT = 9;
    private static final int STATE_BUFFERED_CONTENT = 10;
    private static final int STATE_INT_SUBSET = 11;
    private static final int STATE_EXT_SUBSET = 12;
    private static final int STATE_CHECKS_BUFFERED = 12;
    private static final int STATE_START = 0;
    private static final int STATE_VERSION = 1;
    private static final int STATE_ENCODING = 2;
    private static final int STATE_STANDALONE = 3;
    private static final int STATE_FINISHED = 4;
    private static final byte[] XMLDECL_BYTES = new byte[]{60, 63, 120, 109, 108};
    private static final byte[] VERSION_BYTES = new byte[]{118, 101, 114, 115, 105, 111, 110};
    private static final byte[] VERSION10_BYTES = new byte[]{49, 46, 48};
    private static final byte[] ENCODING_BYTES = new byte[]{101, 110, 99, 111, 100, 105, 110, 103};
    private static final byte[] STANDALONE_BYTES = new byte[]{115, 116, 97, 110, 100, 97, 108, 111, 110, 101};
    private static final byte[] YES_BYTES = new byte[]{121, 101, 115};
    private static final byte[] NO_BYTES = new byte[]{110, 111};
    private static final byte[] DOCTYPE_BYTES = new byte[]{68, 79, 67, 84, 89, 80, 69};
    private static final byte[] CDSTART_BYTES = new byte[]{91, 67, 68, 65, 84, 65, 91};
    private static final byte[] CDEND_BYTES = new byte[]{93, 93, 62};
    private static final byte[] COMMENT_START_BYTES = new byte[]{60, 33};
    private static final byte[] PI_START_BYTES = new byte[]{60, 63};
    private static final byte[] PI_END_BYTES = new byte[]{63, 62};
    private static final byte[] contentMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] normalizedContentMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] elementContentMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] normalizedElementContentMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] cdSectMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final byte[] piMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final byte[] commentMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    protected static final byte[] attValueMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] encNameCharMap = new byte[]{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 2, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] markupMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 3, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final byte[] digitMap = new byte[]{-2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private ScannerHelper fHelper;
    private int fCurrentState;
    private boolean fActiveContentScan;
    private ParsedEntity fCurrentEntity;
    private boolean fLineBreaksNormalized;
    private DataBuffer fCurrentBuffer;
    private byte[] fData;
    private int fCurrentOffset;
    private int fEndOffset;
    private int fThisByte;
    private boolean fEndOfEntity;
    private DTDSupport fDTDSupport;
    private boolean fSeenDoctype;
    private XMLString fAttValueChars;
    private QName fTempQName = new QName();
    private int fSkippedElementDepth;

    public DocumentEntityScanner() {
        this.fAttValueChars = new XMLString();
    }

    public void setScannerHelper(ScannerHelper scannerHelper) {
        this.fHelper = scannerHelper;
    }

    public void reset(boolean bl) {
        this.fActiveContentScan = false;
        this.fSeenDoctype = false;
        this.fCurrentEntity = null;
        if (!bl) {
            this.fAttValueChars.clear();
        }
    }

    public void setDTDSupport(DTDSupport dTDSupport) {
        this.fDTDSupport = dTDSupport;
    }

    public void parseDocumentEntity(ParsedEntity parsedEntity) {
        this.setDocumentEntity(parsedEntity);
        this.produceEvents(false);
    }

    public void setDocumentEntity(ParsedEntity parsedEntity) {
        this.fCurrentState = 0;
        this.fEndOfEntity = false;
        if (this.fDTDSupport != null) {
            this.fDTDSupport.setDocumentEntity(parsedEntity);
        }
        this.setEntityContent(parsedEntity);
        this.fHelper.initialize();
    }

    public int currentState() {
        return this.fCurrentState;
    }

    public void setCurrentState(int n) {
        this.fCurrentState = n;
    }

    private boolean stateXMLDecl() {
        if (this.scanXMLDecl()) {
            return this.fHelper.produceStartDocumentEvent();
        }
        this.fCurrentState = 1;
        return false;
    }

    private boolean stateStartDocument() {
        this.fCurrentState = 2;
        if (this.fHelper.produceStartDocumentEvent()) {
            return this.scanProlog();
        }
        return false;
    }

    private boolean stateUnbufferedStartElement() {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        boolean bl = this.fHelper.scanStartElementUnbuffered(this.fCurrentEntity);
        if (this.fCurrentBuffer == this.fCurrentEntity.buffer) {
            this.fCurrentOffset = this.fCurrentEntity.offset;
            this.fThisByte = this.fData[this.fCurrentOffset];
            if (this.fThisByte == 0) {
                this.checkForLoad();
            }
        } else if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        if (bl && !this.fActiveContentScan) {
            bl = this.stateUnbufferedContent();
        }
        return bl;
    }

    private boolean stateUnbufferedEndElement() {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        boolean bl = this.fHelper.scanEndElementUnbuffered(this.fCurrentEntity);
        if (this.fCurrentBuffer == this.fCurrentEntity.buffer) {
            this.fCurrentOffset = this.fCurrentEntity.offset;
            this.fThisByte = this.fData[this.fCurrentOffset];
            if (this.fThisByte == 0) {
                this.checkForLoad();
            }
        } else if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        if (bl && !this.fActiveContentScan) {
            bl = this.stateUnbufferedContent();
        }
        return bl;
    }

    private boolean stateUnbufferedContent() {
        this.fActiveContentScan = true;
        boolean bl = this.fThisByte == 60 ? this.scanMarkupUnbuffered() : this.fHelper.scanContentUnbuffered(this.fCurrentEntity);
        this.fActiveContentScan = false;
        return bl;
    }

    private boolean stateBufferedStartElement() {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        boolean bl = this.fHelper.scanStartElementBuffered(this.fCurrentEntity);
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        return bl;
    }

    private boolean stateBufferedEndElement() {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        boolean bl = this.fHelper.scanEndElementBuffered(this.fCurrentEntity);
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        return bl;
    }

    private boolean stateBufferedContent() {
        if (this.fThisByte == 60) {
            return this.scanMarkupBuffered();
        }
        return this.fHelper.scanContentBuffered(this.fCurrentEntity);
    }

    private boolean stateIntSubset() {
        if (this.fDTDSupport != null) {
            return this.fDTDSupport.scanInternalDTDSubset();
        }
        return true;
    }

    private boolean stateExtSubset() {
        if (this.fDTDSupport != null) {
            return this.fDTDSupport.scanExternalDTDSubset();
        }
        return true;
    }

    public boolean produceEvent() {
        switch (this.fCurrentState) {
            case 0: {
                return this.stateXMLDecl();
            }
            case 1: {
                return this.stateStartDocument();
            }
            case 2: {
                return this.scanProlog();
            }
            case 3: {
                return this.scanTrailingMisc();
            }
            case 4: {
                return this.stateUnbufferedStartElement();
            }
            case 5: {
                return this.stateUnbufferedEndElement();
            }
            case 6: {
                return this.stateUnbufferedContent();
            }
            case 8: {
                return this.stateBufferedStartElement();
            }
            case 9: {
                return this.stateBufferedEndElement();
            }
            case 10: {
                return this.stateBufferedContent();
            }
            case 11: {
                return this.stateIntSubset();
            }
            case 12: {
                return this.stateExtSubset();
            }
        }
        return false;
    }

    public boolean produceEvents(boolean bl) {
        if (!bl) {
            while (this.produceEvent()) {
            }
            return true;
        }
        return this.produceEvent();
    }

    private int invalidCharParameter() {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        int n = this.fCurrentEntity.decodeInvalidCharacter();
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        return n;
    }

    protected void setInvalidCharParameter(int n) {
        int n2 = this.invalidCharParameter();
        this.fHelper.setInvalidCharParameter(n, n2);
    }

    public boolean endDocument() {
        this.fCurrentState = 7;
        return this.fHelper.produceEndDocumentEvent();
    }

    protected int scanNCName(XMLString xMLString) {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        int n = this.fHelper.scanNCName(this.fCurrentEntity, xMLString);
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        return n;
    }

    protected int scanQName(QName qName) {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        int n = this.fHelper.scanQName(this.fCurrentEntity, qName);
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        return n;
    }

    public boolean hasDefaultAttributes() {
        if (this.fDTDSupport != null) {
            return this.fDTDSupport.hasDefaultAttributes();
        }
        return false;
    }

    public boolean addDefaultAttributes(QName qName, NSDeclList nSDeclList, AttrList attrList, boolean bl) {
        if (this.fDTDSupport != null) {
            return this.fDTDSupport.addDefaultAttributes(qName, nSDeclList, attrList, bl);
        }
        return true;
    }

    public void finishStartElementBuffered() {
        this.fCurrentState = 10;
    }

    public void finishStartElementUnbuffered() {
        this.fCurrentState = 6;
    }

    public void finishStartElement() {
        if (this.fCurrentEntity.unbuffered) {
            this.finishStartElementUnbuffered();
        } else {
            this.finishStartElementBuffered();
        }
    }

    public void finishEmptyElementBuffered(int n) {
        if (n > 0) {
            this.fCurrentState = 10;
        } else {
            this.fActiveContentScan = true;
            this.fCurrentState = 3;
        }
    }

    public void finishEmptyElementUnbuffered(int n) {
        if (n > 0) {
            this.fCurrentState = 6;
        } else {
            this.fActiveContentScan = true;
            this.fCurrentState = 3;
        }
    }

    public void finishEmptyElement(int n) {
        if (this.fCurrentEntity.unbuffered) {
            this.finishEmptyElementUnbuffered(n);
        } else {
            this.finishEmptyElementBuffered(n);
        }
    }

    public void finishEndElementBuffered(int n) {
        if (n > 0) {
            this.fCurrentState = 10;
        } else {
            this.fActiveContentScan = true;
            this.fCurrentState = 3;
        }
    }

    public void finishEndElementUnbuffered(int n) {
        if (n > 0) {
            this.fCurrentState = 6;
        } else {
            this.fActiveContentScan = true;
            this.fCurrentState = 3;
        }
    }

    private void setMark(int n) {
        this.fCurrentEntity.offset = n;
        this.fCurrentEntity.setMark();
    }

    private void resetToMark() {
        this.fCurrentEntity.resetToMark();
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
    }

    private void checkForLoad() {
        if (this.fCurrentOffset == this.fEndOffset) {
            if (!this.fCurrentEntity.unbuffered) {
                this.loadMore();
            } else {
                this.fEndOfEntity = true;
            }
        }
    }

    private int loadMore() {
        ParsedEntity parsedEntity = this.fCurrentEntity;
        while (parsedEntity != null) {
            parsedEntity.offset = this.fCurrentOffset;
            this.fEndOfEntity = parsedEntity.load();
            if (parsedEntity.error == null) {
                if (this.setEntityLocals(parsedEntity) != 0 || this.fEndOfEntity) {
                    return this.fThisByte;
                }
                this.fThisByte = 0;
                continue;
            }
            this.fThisByte = 0;
            return 0;
        }
        this.fThisByte = 0;
        return 0;
    }

    protected boolean skippedValidChar() {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        boolean bl = this.fCurrentEntity.skippedValidCharacter();
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        return bl;
    }

    private boolean skippedNameStartChar() {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        boolean bl = this.fCurrentEntity.skippedNameStartCharacter();
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        return bl;
    }

    protected boolean skippedNameChar() {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        boolean bl = this.fCurrentEntity.skippedNameCharacter();
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        return bl;
    }

    protected void nextStateProlog() {
        this.fCurrentState = 2;
        this.fCurrentEntity.offset = this.fCurrentOffset;
    }

    protected void nextStateIntSubset() {
        this.fCurrentState = 11;
        this.fCurrentEntity.offset = this.fCurrentOffset;
    }

    protected void nextStateExtSubset() {
        this.fCurrentState = 12;
        this.fCurrentEntity.offset = this.fCurrentOffset;
    }

    public void setEntityContent(ParsedEntity parsedEntity) {
        if (this.fCurrentEntity == parsedEntity) {
            this.setEntityLocals(parsedEntity);
        } else {
            if (this.fCurrentEntity != null && this.fCurrentEntity.offset != this.fCurrentOffset) {
                this.fCurrentEntity.offset = this.fCurrentOffset;
            }
            this.fCurrentEntity = parsedEntity;
            this.fLineBreaksNormalized = parsedEntity.lineBreaksNormalized;
            this.fCurrentBuffer = parsedEntity.buffer;
            this.fData = parsedEntity.bytes;
            this.fEndOffset = parsedEntity.endOffset;
            this.fCurrentOffset = parsedEntity.offset;
            this.fEndOfEntity = false;
            this.fThisByte = this.fData[this.fCurrentOffset];
            if (this.fThisByte == 0) {
                this.checkForLoad();
            }
        }
    }

    private int setEntityLocals(ParsedEntity parsedEntity) {
        if (this.fCurrentBuffer == parsedEntity.buffer) {
            if (this.fData != parsedEntity.bytes || this.fEndOffset != parsedEntity.endOffset) {
                UntestedCode.needTest("yikes");
            }
        } else {
            this.fCurrentBuffer = parsedEntity.buffer;
            this.fData = parsedEntity.bytes;
            this.fEndOffset = parsedEntity.endOffset;
        }
        this.fCurrentOffset = parsedEntity.offset;
        this.fThisByte = this.fData[this.fCurrentOffset];
        return this.fThisByte;
    }

    protected boolean atEndOfEntity() {
        return this.fEndOfEntity;
    }

    protected int currentByte() {
        return this.fThisByte;
    }

    protected boolean lineBreaksNormalized() {
        return this.fLineBreaksNormalized;
    }

    protected int nextByte() {
        ++this.fCurrentOffset;
        this.fThisByte = this.fData[this.fCurrentOffset];
        if (this.fThisByte != 0 || this.fCurrentOffset < this.fEndOffset) {
            return this.fThisByte;
        }
        return this.loadMore();
    }

    protected boolean lookingAt(int n) {
        return this.fThisByte == n;
    }

    protected boolean skippedByte(int n) {
        if (this.fThisByte == n) {
            this.nextByte();
            return true;
        }
        return false;
    }

    protected boolean skippedBytes(byte[] byArray) {
        return this.skippedBytesInRange(byArray, 0, byArray.length);
    }

    private boolean skippedBytesInRange(byte[] byArray, int n, int n2) {
        if (this.fThisByte == byArray[n] && this.fCurrentOffset + (n2 - n) <= this.fEndOffset) {
            int n3 = this.fCurrentOffset++;
            int n4 = this.fData[this.fCurrentOffset];
            while (++n < n2) {
                if (n4 == byArray[n]) {
                    ++this.fCurrentOffset;
                    n4 = this.fData[this.fCurrentOffset];
                    continue;
                }
                this.fCurrentOffset = n3;
                return false;
            }
            if (n4 != 0 || this.fCurrentOffset < this.fEndOffset) {
                this.fThisByte = n4;
            } else {
                this.loadMore();
            }
            return true;
        }
        return this.skippedBytesBuffered(byArray, n, n2);
    }

    private boolean skippedBytesBuffered(byte[] byArray, int n, int n2) {
        if (this.fThisByte == byArray[n]) {
            boolean bl = false;
            int n3 = this.fCurrentOffset++;
            int n4 = n + 1;
            int n5 = this.fData[this.fCurrentOffset];
            while (n4 < n2) {
                if (n5 == byArray[n4]) {
                    ++this.fCurrentOffset;
                    ++n4;
                    n5 = this.fData[this.fCurrentOffset];
                    continue;
                }
                if (n5 != 0 || this.fCurrentOffset < this.fEndOffset) {
                    if (bl) {
                        this.resetToMark();
                    } else {
                        this.fCurrentOffset = n3;
                    }
                    return false;
                }
                if (!bl) {
                    this.setMark(n3);
                    bl = true;
                }
                if (this.loadMore() == 0) {
                    this.resetToMark();
                    return false;
                }
                n5 = this.fThisByte;
            }
            if (bl) {
                this.fCurrentEntity.clearMark();
            }
            if (n5 != 0 || this.fCurrentOffset < this.fEndOffset) {
                this.fThisByte = n5;
            } else {
                this.loadMore();
            }
            return true;
        }
        return false;
    }

    private boolean skippedBytesBuffered2(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2) {
        byte[] byArray = dataBuffer.bytes;
        int n3 = dataBuffer.endOffset;
        if (this.fThisByte == byArray[n]) {
            boolean bl = false;
            int n4 = this.fCurrentOffset++;
            int n5 = this.fData[this.fCurrentOffset];
            ++n;
            while (true) {
                if (n == n3) {
                    if (dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n = dataBuffer.startOffset;
                    int n6 = n3 = dataBuffer == dataBuffer2 ? n2 : dataBuffer.endOffset;
                }
                if (n5 == byArray[n]) {
                    ++this.fCurrentOffset;
                    ++n;
                    n5 = this.fData[this.fCurrentOffset];
                    continue;
                }
                if (n5 != 0 || this.fCurrentOffset < this.fEndOffset) {
                    if (bl) {
                        this.resetToMark();
                    } else {
                        this.fCurrentOffset = n4;
                    }
                    return false;
                }
                if (!bl) {
                    this.setMark(n4);
                    bl = true;
                }
                if (this.loadMore() == 0) {
                    this.resetToMark();
                    return false;
                }
                n5 = this.fThisByte;
            }
            if (bl) {
                this.fCurrentEntity.clearMark();
            }
            if (n5 != 0 || this.fCurrentOffset < this.fEndOffset) {
                this.fThisByte = n5;
            } else {
                this.loadMore();
            }
            return true;
        }
        return false;
    }

    protected boolean skippedSpace() {
        int n = this.fThisByte;
        if (n == 32 || n == 10 || n == 9 || n == 13) {
            this.nextByte();
            return true;
        }
        return false;
    }

    protected void skipSpaces() {
        int n;
        while ((n = this.fThisByte) == 32 || n == 10 || n == 9 || n == 13) {
            this.nextByte();
        }
    }

    protected boolean skippedSpaces() {
        int n = this.fThisByte;
        if (n == 32 || n == 10 || n == 9 || n == 13) {
            while ((n = this.nextByte()) == 32 || n == 10 || n == 9 || n == 13) {
            }
            return true;
        }
        return false;
    }

    private boolean skipToChar(int n) {
        int n2 = this.fThisByte;
        while (n2 != n) {
            n2 = this.nextByte();
            if (n2 != 0) continue;
            return false;
        }
        return true;
    }

    private boolean skippedValidXMLBytesUsingMapForXMLString(byte[] byArray, int n, XMLString xMLString) {
        boolean bl = false;
        while (true) {
            if (byArray[this.fThisByte & 0xFF] == n) {
                ++this.fCurrentOffset;
                return this.skipMoreValidXMLBytesUsingMapForXMLString(byArray, n, xMLString);
            }
            if (this.fThisByte < 0) break;
            if (this.fThisByte != 13) {
                return bl;
            }
            xMLString.flags |= 4;
            this.nextByte();
            bl = true;
        }
        if (this.skippedValidChar()) {
            return this.skipMoreValidXMLBytesUsingMapForXMLString(byArray, n, xMLString);
        }
        return bl;
    }

    private boolean skipMoreValidXMLBytesUsingMapForXMLString(byte[] byArray, int n, XMLString xMLString) {
        while (true) {
            if (byArray[this.fData[this.fCurrentOffset] & 0xFF] == n) {
                ++this.fCurrentOffset;
                continue;
            }
            this.fThisByte = this.fData[this.fCurrentOffset];
            if (this.fThisByte >= 0) {
                if (this.fThisByte != 13) {
                    if (this.fThisByte != 0 || this.fCurrentOffset < this.fEndOffset) {
                        return true;
                    }
                    if (this.loadMore() != 0) continue;
                    return true;
                }
                xMLString.flags |= 4;
                this.nextByte();
                continue;
            }
            if (!this.skippedValidChar()) break;
        }
        return true;
    }

    protected boolean skippedValidXMLBytesUsingMap(byte[] byArray, int n) {
        if (byArray[this.fThisByte & 0xFF] == n) {
            ++this.fCurrentOffset;
            return this.skipMoreValidXMLBytesUsingMap(byArray, n);
        }
        if (this.fThisByte >= 0) {
            return false;
        }
        if (this.skippedValidChar()) {
            return this.skipMoreValidXMLBytesUsingMap(byArray, n);
        }
        return false;
    }

    private boolean skipMoreValidXMLBytesUsingMap(byte[] byArray, int n) {
        block4: {
            while (true) {
                if (byArray[this.fData[this.fCurrentOffset] & 0xFF] == n) {
                    ++this.fCurrentOffset;
                    continue;
                }
                this.fThisByte = this.fData[this.fCurrentOffset];
                if (this.fThisByte > 0) {
                    return true;
                }
                if (this.fThisByte < 0) {
                    if (this.skippedValidChar()) continue;
                    return true;
                }
                if (this.fCurrentOffset != this.fEndOffset) break block4;
                if (this.loadMore() == 0) break;
            }
            return true;
        }
        return true;
    }

    protected boolean skippedBytesUsingMap(byte[] byArray, int n) {
        if (byArray[this.fThisByte & 0xFF] == n) {
            return this.skipMoreBytesUsingMap(byArray, n);
        }
        if (this.fThisByte != 0 || this.fCurrentOffset < this.fEndOffset) {
            return false;
        }
        if (this.loadMore() == 0) {
            return false;
        }
        if (byArray[this.fThisByte & 0xFF] == n) {
            return this.skipMoreBytesUsingMap(byArray, n);
        }
        return false;
    }

    private boolean skipMoreBytesUsingMap(byte[] byArray, int n) {
        ++this.fCurrentOffset;
        while (true) {
            if (byArray[this.fData[this.fCurrentOffset] & 0xFF] == n) {
                ++this.fCurrentOffset;
                continue;
            }
            this.fThisByte = this.fData[this.fCurrentOffset];
            if (this.fThisByte != 0 || this.fCurrentOffset < this.fEndOffset) {
                return true;
            }
            if (this.loadMore() == 0) break;
        }
        return true;
    }

    protected void startString(XMLString xMLString) {
        xMLString.setStartPos(this.fCurrentBuffer, this.fCurrentOffset);
        xMLString.flags = 0;
    }

    protected void endString(XMLString xMLString) {
        xMLString.setEndPos(this.fCurrentBuffer, this.fCurrentOffset, 0);
    }

    protected void endStringWithFlags(XMLString xMLString, int n) {
        xMLString.setEndPos(this.fCurrentBuffer, this.fCurrentOffset, n);
    }

    private void setValues(XMLString xMLString, int n, int n2, int n3) {
        xMLString.setValues(this.fCurrentBuffer, n, n2, n3);
    }

    public boolean scanAttrValueBuffered(XMLString xMLString, int n) {
        boolean bl;
        ParsedEntity parsedEntity = this.fCurrentEntity;
        if (this.setEntityLocals(parsedEntity) == 0) {
            this.checkForLoad();
        }
        if (bl = this.scanAttValueBuffered(xMLString, n, this.fDTDSupport != null ? this.fDTDSupport.entityDepth() : 0)) {
            this.fHelper.saveSpecifiedAttValue();
        }
        if (this.fCurrentEntity == parsedEntity) {
            parsedEntity.offset = this.fCurrentOffset;
        }
        return bl;
    }

    public boolean scanAttrValueUnbuffered(XMLString xMLString, int n) {
        boolean bl;
        ParsedEntity parsedEntity = this.fCurrentEntity;
        if (this.setEntityLocals(parsedEntity) == 0) {
            this.checkForLoad();
        }
        if (bl = this.scanAttValueUnbuffered(xMLString, n)) {
            this.fHelper.saveSpecifiedAttValue();
        }
        if (this.fCurrentEntity == parsedEntity) {
            parsedEntity.offset = this.fCurrentOffset;
        }
        return bl;
    }

    public boolean scanNamespaceURIBuffered(XMLString xMLString, int n) {
        boolean bl;
        ParsedEntity parsedEntity = this.fCurrentEntity;
        if (this.setEntityLocals(parsedEntity) == 0) {
            this.checkForLoad();
        }
        if (bl = this.scanAttValueBuffered(xMLString, n, this.fDTDSupport != null ? this.fDTDSupport.entityDepth() : 0)) {
            this.fHelper.saveSpecifiedNamespaceURI();
        }
        if (this.fCurrentEntity == parsedEntity) {
            parsedEntity.offset = this.fCurrentOffset;
        }
        return bl;
    }

    public boolean scanNamespaceURIUnbuffered(XMLString xMLString, int n) {
        boolean bl;
        ParsedEntity parsedEntity = this.fCurrentEntity;
        if (this.setEntityLocals(parsedEntity) == 0) {
            this.checkForLoad();
        }
        if (bl = this.scanAttValueUnbuffered(xMLString, n)) {
            this.fHelper.saveSpecifiedNamespaceURI();
        }
        if (this.fCurrentEntity == parsedEntity) {
            parsedEntity.offset = this.fCurrentOffset;
        }
        return bl;
    }

    private boolean scanXMLDecl() {
        this.fCurrentState = 2;
        return this.scanXMLDeclOrTextDecl(true);
    }

    protected boolean scanTextDecl() {
        return this.scanXMLDeclOrTextDecl(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scanXMLDeclOrTextDecl(boolean bl) {
        int n;
        this.setMark(this.fCurrentOffset);
        if (!this.skippedBytes(XMLDECL_BYTES) || !this.skippedSpaces()) {
            this.resetToMark();
            return true;
        }
        XMLString xMLString = this.fHelper.versionToProduce();
        XMLString xMLString2 = this.fHelper.encNameToProduce();
        XMLString xMLString3 = this.fHelper.standaloneToProduce();
        int n2 = 0;
        this.fCurrentEntity.clearMark();
        do {
            int n3;
            if (bl) {
                if (n2 == 0) {
                    if (!this.skippedBytes(VERSION_BYTES)) return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 10);
                    n2 = 1;
                    n3 = 28;
                } else if (n2 != 1 || !this.skippedBytes(ENCODING_BYTES)) {
                    if (!this.skippedBytes(STANDALONE_BYTES)) break;
                    if (n2 == 1) {
                        xMLString2.clear();
                    }
                    n2 = 3;
                    n3 = 30;
                } else {
                    n2 = 2;
                    n3 = 29;
                }
            } else if (n2 == 0 && this.skippedBytes(VERSION_BYTES)) {
                n2 = 1;
                n3 = 28;
            } else {
                if (!this.skippedBytes(ENCODING_BYTES)) return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 45);
                if (n2 == 0) {
                    xMLString.clear();
                }
                n2 = 2;
                n3 = 29;
            }
            this.skipSpaces();
            if (!this.skippedByte(61)) {
                int n4 = bl ? 7 : 41;
                this.fHelper.setParameter(0, n3);
                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", n4);
            }
            this.skipSpaces();
            if (this.skippedByte(34)) {
                n = 34;
            } else if (this.skippedByte(39)) {
                n = 39;
            } else {
                int n5 = bl ? 8 : 42;
                this.fHelper.setParameter(0, n3);
                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", n5);
            }
            switch (n2) {
                case 1: {
                    this.startString(xMLString);
                    if (!this.skippedBytes(VERSION10_BYTES) || !this.lookingAt(n)) {
                        if (!this.skipToChar(n)) {
                            int n6 = bl ? 8 : 42;
                            this.fHelper.setParameter(0, n3);
                            return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", n6);
                        }
                        this.endString(xMLString);
                        this.fHelper.setParameter(0, xMLString);
                        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 34);
                    }
                    this.endString(xMLString);
                    this.nextByte();
                    if (this.skippedSpaces()) break;
                    if (!bl) return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 43);
                    xMLString2.clear();
                    xMLString3.clear();
                    n2 = 4;
                    break;
                }
                case 2: {
                    this.startString(xMLString2);
                    if (!this.skipToChar(n)) {
                        int n7 = bl ? 8 : 42;
                        this.fHelper.setParameter(0, n3);
                        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", n7);
                    }
                    this.endString(xMLString2);
                    if (!DocumentEntityScanner.validEncName(xMLString2)) {
                        this.fHelper.setParameter(0, xMLString2);
                        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 46);
                    }
                    this.nextByte();
                    if (!this.skippedSpaces()) {
                        if (bl) {
                            xMLString3.clear();
                        }
                        n2 = 4;
                        break;
                    }
                    if (bl) break;
                    n2 = 4;
                    break;
                }
                case 3: {
                    this.startString(xMLString3);
                    if (!this.skippedBytes(YES_BYTES) && !this.skippedBytes(NO_BYTES) || !this.lookingAt(n)) {
                        if (!this.skipToChar(n)) {
                            this.fHelper.setParameter(0, n3);
                            return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 8);
                        }
                        this.endString(xMLString3);
                        this.fHelper.setParameter(0, xMLString3);
                        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 13);
                    }
                    this.endString(xMLString3);
                    this.nextByte();
                    this.skipSpaces();
                    n2 = 4;
                }
            }
        } while (n2 != 4);
        if (!this.skippedByte(63) || !this.skippedByte(62)) {
            n = bl ? 9 : 44;
            return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", n);
        }
        this.fCurrentEntity.offset = this.fCurrentOffset;
        if (!bl) return this.fHelper.produceTextDeclEvent();
        if (this.fDTDSupport == null || xMLString3.length != 3) return this.fHelper.produceXMLDeclEvent();
        this.fDTDSupport.setStandalone();
        return this.fHelper.produceXMLDeclEvent();
    }

    private static boolean validEncName(XMLString xMLString) {
        byte[] byArray = xMLString.bytes;
        int n = xMLString.startOffset;
        int n2 = xMLString.endOffset;
        if (byArray != null) {
            if (n < n2) {
                byte by = byArray[n];
                ++n;
                if (encNameCharMap[by & 0xFF] == 1) {
                    while (n < n2) {
                        by = byArray[n];
                        ++n;
                        if (encNameCharMap[by & 0xFF] != 0) continue;
                        return false;
                    }
                    return true;
                }
            }
        } else {
            DataBuffer dataBuffer = xMLString.firstBuffer;
            byArray = dataBuffer.bytes;
            byte by = byArray[n];
            ++n;
            if (encNameCharMap[by & 0xFF] == 1) {
                int n3 = dataBuffer.endOffset;
                while (true) {
                    if (n < n3) {
                        by = byArray[n];
                        ++n;
                        if (encNameCharMap[by & 0xFF] != 0) continue;
                        return false;
                    }
                    if (dataBuffer == null) {
                        return true;
                    }
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n = dataBuffer.startOffset;
                    if (dataBuffer == xMLString.lastBuffer) {
                        n3 = n2;
                        dataBuffer = null;
                        continue;
                    }
                    n3 = dataBuffer.endOffset;
                }
            }
        }
        return false;
    }

    private boolean scanProlog() {
        block6: {
            block7: {
                block8: {
                    while (true) {
                        this.skipSpaces();
                        if (!this.lookingAt(60)) break block6;
                        if (!this.skippedBytes(COMMENT_START_BYTES)) {
                            if (!this.skippedBytes(PI_START_BYTES)) {
                                return this.scanRootElement();
                            }
                            if (this.scanPI()) continue;
                            return false;
                        }
                        if (!this.skippedByte(45)) break block7;
                        if (!this.skippedByte(45)) break block8;
                        if (!this.scanComment()) break;
                    }
                    return false;
                }
                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 27);
            }
            if (!this.fSeenDoctype && this.skippedBytes(DOCTYPE_BYTES)) {
                this.fSeenDoctype = true;
                return this.scanDoctypeDecl();
            }
            return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 11);
        }
        if (this.lookingAt(38)) {
            return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 11);
        }
        if (this.fEndOfEntity) {
            return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 0);
        }
        this.setInvalidCharParameter(0);
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 4);
    }

    private boolean scanDoctypeDecl() {
        if (this.fDTDSupport != null) {
            this.fCurrentEntity.offset = this.fCurrentOffset;
            return this.fDTDSupport.scanDoctypeDecl(this.fCurrentEntity);
        }
        return this.skipDoctypeDecl();
    }

    private boolean skipDoctypeDecl() {
        if (!this.skippedSpaces()) {
            return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 11);
        }
        this.fCurrentEntity.offset = this.fCurrentOffset;
        int n = this.scanQName(this.fTempQName);
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        if (n == 0) {
            return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 11);
        }
        do {
            if (this.skippedByte(91)) {
                do {
                    if (!this.skippedByte(93)) continue;
                    this.skipSpaces();
                    if (!this.skippedByte(62)) continue;
                    return true;
                } while (this.skippedValidChar());
                if (this.fEndOfEntity) {
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 11);
                }
                this.setInvalidCharParameter(0);
                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 4);
            }
            if (!this.skippedByte(62)) continue;
            return true;
        } while (this.skippedValidChar());
        if (this.fEndOfEntity) {
            return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 11);
        }
        this.setInvalidCharParameter(0);
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 4);
    }

    private boolean scanRootElement() {
        int n = this.fData[this.fCurrentOffset + 1];
        if (this.fCurrentEntity.unbuffered) {
            this.fCurrentState = 4;
            if (markupMap[n & 0xFF] == 1) {
                return this.stateUnbufferedStartElement();
            }
        } else {
            this.fCurrentState = 8;
            if (n == 0 && this.fCurrentOffset + 1 >= this.fEndOffset) {
                this.setMark(this.fCurrentOffset);
                n = this.nextByte();
                this.resetToMark();
            }
            if (markupMap[n & 0xFF] == 1) {
                return true;
            }
        }
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 19);
    }

    public boolean scanContentBuffered(XMLString xMLString) {
        boolean bl = false;
        this.startString(xMLString);
        block9: while (true) {
            if (!this.fLineBreaksNormalized) {
                if (this.skippedValidXMLBytesUsingMapForXMLString(contentMap, 1, xMLString)) {
                    bl = true;
                }
            } else if (this.skippedValidXMLBytesUsingMap(contentMap, 1)) {
                bl = true;
            }
            if (bl) {
                this.endStringWithFlags(xMLString, xMLString.flags);
                this.fCurrentEntity.offset = this.fCurrentOffset;
                this.fCurrentState = 10;
                this.fHelper.produceCharactersEvent();
                bl = false;
            }
            switch (contentMap[this.fThisByte & 0xFF]) {
                case 2: {
                    return this.scanMarkupBuffered();
                }
                case 3: {
                    this.nextByte();
                    this.fCurrentState = 10;
                    if (!this.checkReferenceInContent()) {
                        return false;
                    }
                    xMLString = this.fHelper.contentToProduce();
                    this.startString(xMLString);
                    continue block9;
                }
                case 4: {
                    if (this.skippedBytes(CDEND_BYTES)) {
                        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 5);
                    }
                    xMLString = this.fHelper.contentToProduce();
                    this.startString(xMLString);
                    this.nextByte();
                    bl = true;
                    continue block9;
                }
                case 5: {
                    continue block9;
                }
                case 6: {
                    if (!this.fLineBreaksNormalized) {
                        UntestedCode.needTest("not called");
                    }
                    xMLString = this.fHelper.contentToProduce();
                    this.startString(xMLString);
                    this.nextByte();
                    bl = true;
                    continue block9;
                }
                case 7: {
                    xMLString = this.fHelper.contentToProduce();
                    this.startString(xMLString);
                    if (!this.skippedValidChar()) {
                        this.setInvalidCharParameter(0);
                        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 2);
                    }
                    bl = true;
                    continue block9;
                }
                case 8: {
                    if (!this.fEndOfEntity) break block9;
                    if (this.fDTDSupport != null && this.fDTDSupport.endOfEntity(1)) {
                        int n = this.fCurrentState & 0xC;
                        if (n != 0 && this.fCurrentEntity.unbuffered != ((n & 8) == 0)) {
                            this.fCurrentState ^= 0xC;
                        }
                        return true;
                    }
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 19);
                }
            }
            break;
        }
        this.setInvalidCharParameter(0);
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 2);
    }

    public boolean scanElementContentBuffered(XMLString xMLString) {
        if (!this.fLineBreaksNormalized) {
            this.startString(xMLString);
            if (this.skippedValidXMLBytesUsingMapForXMLString(elementContentMap, 5, xMLString)) {
                this.endStringWithFlags(xMLString, xMLString.flags);
                this.fCurrentEntity.offset = this.fCurrentOffset;
                this.fCurrentState = 10;
                this.fHelper.produceWhitespaceEvent();
                if (this.fThisByte == 60) {
                    return this.scanMarkupBuffered();
                }
                xMLString = this.fHelper.contentToProduce();
            }
            return this.scanElementContentBufferedNotNormalized(xMLString);
        }
        return this.scanElementContentBufferedNormalized(xMLString);
    }

    private boolean scanElementContentBufferedNotNormalized(XMLString xMLString) {
        boolean bl = false;
        while (true) {
            switch (elementContentMap[this.fThisByte & 0xFF]) {
                case 1: {
                    xMLString.flags &= 0xFFFFFFFD;
                    xMLString.flags |= 1;
                    this.fCurrentState = 10;
                    return this.scanContentBuffered(xMLString);
                }
                case 2: {
                    return this.scanMarkupBuffered();
                }
                case 3: {
                    this.nextByte();
                    this.fCurrentState = 10;
                    if (!this.checkReferenceInContent()) {
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        return false;
                    }
                    xMLString = this.fHelper.contentToProduce();
                    this.startString(xMLString);
                    break;
                }
                case 4: {
                    if (this.skippedBytes(CDEND_BYTES)) {
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 5);
                    }
                    xMLString = this.fHelper.contentToProduce();
                    xMLString.flags &= 0xFFFFFFFD;
                    xMLString.flags |= 1;
                    this.fCurrentState = 10;
                    return this.scanContentBuffered(xMLString);
                }
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    xMLString = this.fHelper.contentToProduce();
                    this.startString(xMLString);
                    if (this.skippedValidChar()) {
                        bl = true;
                        break;
                    }
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    this.setInvalidCharParameter(0);
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 2);
                }
                case 8: {
                    if (this.fEndOfEntity) {
                        if (this.fDTDSupport != null && this.fDTDSupport.endOfEntity(1)) {
                            int n = this.fCurrentState & 0xC;
                            if (n != 0 && this.fCurrentEntity.unbuffered != ((n & 8) == 0)) {
                                this.fCurrentState ^= 0xC;
                            }
                            this.fCurrentEntity.offset = this.fCurrentOffset;
                            return false;
                        }
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 19);
                    }
                }
                default: {
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    this.setInvalidCharParameter(0);
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 2);
                }
            }
            if (!this.skippedValidXMLBytesUsingMapForXMLString(elementContentMap, 5, xMLString) && !bl) continue;
            this.endStringWithFlags(xMLString, xMLString.flags);
            this.fCurrentEntity.offset = this.fCurrentOffset;
            this.fCurrentState = 10;
            this.fHelper.produceWhitespaceEvent();
            bl = false;
        }
    }

    private boolean scanElementContentBufferedNormalized(XMLString xMLString) {
        boolean bl = false;
        this.startString(xMLString);
        block9: while (true) {
            if (this.skippedValidXMLBytesUsingMap(normalizedElementContentMap, 5)) {
                bl = true;
            }
            if (bl) {
                this.endStringWithFlags(xMLString, xMLString.flags);
                if (this.fCurrentEntity != null && this.fCurrentEntity.offset != this.fCurrentOffset) {
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    UntestedCode.needTest("updateCursor(9)");
                }
                this.fCurrentState = 10;
                this.fHelper.produceWhitespaceEvent();
                bl = false;
            }
            switch (normalizedElementContentMap[this.fThisByte & 0xFF]) {
                case 1: {
                    xMLString.flags &= 0xFFFFFFFD;
                    xMLString.flags |= 1;
                    this.fCurrentState = 10;
                    return this.scanContentBuffered(xMLString);
                }
                case 2: {
                    return this.scanMarkupBuffered();
                }
                case 3: {
                    this.nextByte();
                    this.fCurrentState = 10;
                    if (!this.checkReferenceInContent()) {
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        return false;
                    }
                    xMLString = this.fHelper.contentToProduce();
                    this.startString(xMLString);
                    continue block9;
                }
                case 4: {
                    if (this.skippedBytes(CDEND_BYTES)) {
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 5);
                    }
                    xMLString = this.fHelper.contentToProduce();
                    xMLString.flags &= 0xFFFFFFFD;
                    xMLString.flags |= 1;
                    this.fCurrentState = 10;
                    return this.scanContentBuffered(xMLString);
                }
                case 5: 
                case 6: {
                    continue block9;
                }
                case 7: {
                    xMLString = this.fHelper.contentToProduce();
                    this.startString(xMLString);
                    if (this.skippedValidChar()) {
                        bl = true;
                        continue block9;
                    }
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    this.setInvalidCharParameter(0);
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 2);
                }
                case 8: {
                    if (!this.fEndOfEntity) break block9;
                    if (this.fDTDSupport != null && this.fDTDSupport.endOfEntity(1)) {
                        int n = this.fCurrentState & 0xC;
                        if (n != 0 && this.fCurrentEntity.unbuffered != ((n & 8) == 0)) {
                            this.fCurrentState ^= 0xC;
                        }
                        if (this.fCurrentEntity != null && this.fCurrentEntity.offset != this.fCurrentOffset) {
                            this.fCurrentEntity.offset = this.fCurrentOffset;
                            UntestedCode.needTest("updateCursor(10)");
                        }
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        return false;
                    }
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 19);
                }
            }
            break;
        }
        this.fCurrentEntity.offset = this.fCurrentOffset;
        this.setInvalidCharParameter(0);
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 2);
    }

    private boolean scanMarkupBuffered() {
        int n = this.fData[this.fCurrentOffset + 1];
        if (n == 0 && this.fCurrentOffset + 1 == this.fEndOffset) {
            this.setMark(this.fCurrentOffset);
            n = this.nextByte();
            this.resetToMark();
        }
        switch (markupMap[n & 0xFF]) {
            case 1: {
                this.fCurrentState = 8;
                this.fCurrentEntity.offset = this.fCurrentOffset;
                return true;
            }
            case 2: {
                this.fCurrentState = 9;
                this.fCurrentEntity.offset = this.fCurrentOffset;
                return true;
            }
            case 3: {
                this.nextByte();
                this.nextByte();
                this.fCurrentState = 10;
                boolean bl = this.scanPI();
                this.fCurrentEntity.offset = this.fCurrentOffset;
                return bl;
            }
            case 4: {
                this.nextByte();
                this.nextByte();
                if (this.skippedByte(45)) {
                    if (this.skippedByte(45)) {
                        this.fCurrentState = 10;
                        boolean bl = this.scanComment();
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        return bl;
                    }
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 27);
                }
                if (this.skippedBytes(CDSTART_BYTES)) {
                    this.fCurrentState = 10;
                    boolean bl = this.scanCDSectBuffered();
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    return bl;
                }
                this.fCurrentEntity.offset = this.fCurrentOffset;
                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 19);
            }
        }
        this.fCurrentEntity.offset = this.fCurrentOffset;
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 19);
    }

    /*
     * Unable to fully structure code
     */
    public boolean scanStartElementBuffered() {
        var1_1 = this.fHelper.setupStartElement();
        this.nextByte();
        this.fCurrentEntity.offset = this.fCurrentOffset;
        var2_2 = this.fHelper.scanQName(this.fCurrentEntity, var1_1);
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        switch (var2_2) {
            case 4: {
                this.nextByte();
                var4_3 = false;
                var3_4 = true;
                ** GOTO lbl86
            }
            case 5: {
                this.nextByte();
                var4_3 = false;
                var3_4 = false;
                ** GOTO lbl86
            }
            case 6: {
                this.nextByte();
                this.skipSpaces();
                var3_4 = this.skippedByte(47);
                if (!var3_4 && !this.skippedByte(62)) ** GOTO lbl29
                var4_3 = false;
                ** GOTO lbl86
lbl29:
                // 1 sources

                var4_3 = true;
                if (true) ** GOTO lbl86
            }
            case 2: 
            case 7: {
                this.fHelper.setParameter(0, var1_1);
                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 15);
            }
            default: {
                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 19);
            }
            case 1: {
                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 49);
            }
        }
        do {
            var5_5 = this.fHelper.currentAttributeName();
            this.fCurrentEntity.offset = this.fCurrentOffset;
            var2_2 = this.fHelper.scanQName(this.fCurrentEntity, var5_5);
            if (this.setEntityLocals(this.fCurrentEntity) == 0) {
                this.checkForLoad();
            }
            switch (var2_2) {
                case 7: {
                    this.nextByte();
                    this.skipSpaces();
                    break;
                }
                case 6: {
                    this.nextByte();
                    this.skipSpaces();
                    if (this.skippedByte(61)) {
                        this.skipSpaces();
                        break;
                    }
                }
                case 2: 
                case 4: 
                case 5: {
                    this.fHelper.setParameter(0, var1_1);
                    this.fHelper.setParameter(1, var5_5);
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 16);
                }
                default: {
                    this.fHelper.setParameter(0, var1_1);
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 15);
                }
                case 1: {
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 49);
                }
            }
            var6_6 = this.fHelper.setupSpecifiedAttribute();
            if (this.skippedByte(34)) {
                var8_8 = 34;
            } else if (this.skippedByte(39)) {
                var8_8 = 39;
            } else {
                this.fHelper.setParameter(0, var1_1);
                this.fHelper.setParameter(1, var5_5);
                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 24);
            }
            if (!this.scanAttValueBuffered(var6_6, var8_8, this.fDTDSupport != null ? this.fDTDSupport.entityDepth() : 0)) {
                return false;
            }
            this.fHelper.addSpecifiedAttribute();
            var7_7 = this.skippedSpaces();
            var3_4 = this.skippedByte(47);
            if (var3_4 || this.skippedByte(62)) break;
            if (var7_7) continue;
            this.fHelper.setParameter(0, var1_1);
            return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 15);
lbl86:
            // 5 sources

        } while (var4_3);
        if (var3_4) {
            if (this.skippedByte(62)) {
                this.fCurrentEntity.offset = this.fCurrentOffset;
                return this.fHelper.finishEmptyElement();
            }
            this.fHelper.setParameter(0, var1_1);
            return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 15);
        }
        this.fCurrentEntity.offset = this.fCurrentOffset;
        return this.fHelper.finishStartElement();
    }

    private boolean scanAttValueBuffered(XMLString xMLString, int n, int n2) {
        boolean bl = true;
        int n3 = 0;
        boolean bl2 = false;
        this.startString(xMLString);
        block9: while (true) {
            if (this.skippedValidXMLBytesUsingMap(attValueMap, 1) || bl2) {
                this.endStringWithFlags(xMLString, n3);
                this.fHelper.attributeValueCharacters(xMLString, bl);
                xMLString = this.fAttValueChars;
                bl = true;
                bl2 = false;
                n3 = 0;
            } else if (xMLString == this.fAttValueChars) {
                xMLString.clear();
            }
            switch (attValueMap[this.fThisByte & 0xFF]) {
                case 2: {
                    if ((n2 == 0 || this.fDTDSupport != null && this.fDTDSupport.entityDepth() == n2) && this.skippedByte(n)) {
                        return true;
                    }
                    xMLString = this.fAttValueChars;
                    this.startString(xMLString);
                    this.nextByte();
                    bl2 = true;
                    continue block9;
                }
                case 3: {
                    this.nextByte();
                    if (!this.checkReferenceInAttValue()) {
                        return false;
                    }
                    xMLString = this.fAttValueChars;
                    this.startString(xMLString);
                    continue block9;
                }
                case 4: {
                    this.fHelper.setParameter(0, this.fHelper.currentElementType());
                    this.fHelper.setParameter(1, this.fHelper.currentAttributeName());
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 25);
                }
                case 5: {
                    bl = false;
                    xMLString = this.fAttValueChars;
                    this.startString(xMLString);
                    this.nextByte();
                    bl2 = true;
                    continue block9;
                }
                case 6: {
                    if (!this.fLineBreaksNormalized) {
                        n3 |= 4;
                    }
                    bl = false;
                    xMLString = this.fAttValueChars;
                    this.startString(xMLString);
                    this.skipSpaces();
                    bl2 = true;
                    continue block9;
                }
                case 7: {
                    xMLString = this.fAttValueChars;
                    this.startString(xMLString);
                    if (!this.skippedValidChar()) {
                        this.fHelper.setParameter(0, this.fHelper.currentElementType());
                        this.fHelper.setParameter(1, this.fHelper.currentAttributeName());
                        this.setInvalidCharParameter(2);
                        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 21);
                    }
                    bl2 = true;
                    continue block9;
                }
                case 8: {
                    if (!this.fEndOfEntity) break block9;
                    if (this.fDTDSupport != null && this.fDTDSupport.endOfEntity(1)) {
                        xMLString = this.fAttValueChars;
                        this.startString(xMLString);
                        continue block9;
                    }
                    this.fHelper.setParameter(0, this.fHelper.currentElementType());
                    this.fHelper.setParameter(1, this.fHelper.currentAttributeName());
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 26);
                }
            }
            break;
        }
        this.fHelper.setParameter(0, this.fHelper.currentElementType());
        this.fHelper.setParameter(1, this.fHelper.currentAttributeName());
        this.setInvalidCharParameter(2);
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 21);
    }

    public boolean scanEndElementBuffered() {
        QName qName = this.fHelper.popElement();
        this.nextByte();
        this.nextByte();
        if (qName != null) {
            boolean bl = qName.bytes != null ? this.skippedBytesInRange(qName.bytes, qName.startOffset, qName.endOffset) : this.skippedBytesBuffered2(qName.firstBuffer, qName.lastBuffer, qName.startOffset, qName.endOffset);
            if (bl) {
                if (this.skippedByte(62) || this.skippedSpaces() && this.skippedByte(62)) {
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    this.finishEndElementBuffered(this.fHelper.elementDepth());
                    return this.fHelper.produceEndElementEvent(qName);
                }
                this.fHelper.setParameter(0, qName);
                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 18);
            }
            return this.scanEndElementNoMatch(qName);
        }
        this.fHelper.setParameter(0, this.fHelper.topElement());
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 20);
    }

    private boolean scanCDSectBuffered() {
        boolean bl = false;
        this.fCurrentEntity.offset = this.fCurrentOffset;
        if (!this.fHelper.produceStartCDATASectionEvent()) {
            // empty if block
        }
        XMLString xMLString = this.fHelper.contentToProduce();
        this.startString(xMLString);
        block6: while (true) {
            if (!this.fLineBreaksNormalized) {
                if (this.skippedValidXMLBytesUsingMapForXMLString(cdSectMap, 1, xMLString)) {
                    bl = true;
                }
            } else if (this.skippedValidXMLBytesUsingMap(cdSectMap, 1)) {
                bl = true;
            }
            if (bl) {
                this.endStringWithFlags(xMLString, xMLString.flags);
                this.fCurrentEntity.offset = this.fCurrentOffset;
                if (!this.fHelper.produceCharactersEvent()) {
                    // empty if block
                }
                bl = false;
            }
            switch (cdSectMap[this.fThisByte & 0xFF]) {
                case 2: {
                    if (this.skippedBytes(CDEND_BYTES)) {
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        this.fCurrentState = 10;
                        return this.fHelper.produceEndCDATASectionEvent();
                    }
                    xMLString = this.fHelper.contentToProduce();
                    this.startString(xMLString);
                    this.nextByte();
                    bl = true;
                    continue block6;
                }
                case 3: {
                    if (!this.fLineBreaksNormalized) {
                        UntestedCode.needTest("not called");
                    }
                    xMLString = this.fHelper.contentToProduce();
                    this.startString(xMLString);
                    this.nextByte();
                    bl = true;
                    continue block6;
                }
                case 4: {
                    xMLString = this.fHelper.contentToProduce();
                    this.startString(xMLString);
                    if (!this.skippedValidChar()) {
                        this.setInvalidCharParameter(0);
                        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 1);
                    }
                    bl = true;
                    continue block6;
                }
                case 5: {
                    if (!this.fEndOfEntity) break block6;
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 6);
                }
            }
            break;
        }
        this.setInvalidCharParameter(0);
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 1);
    }

    public boolean scanContentUnbuffered(XMLString xMLString) {
        int n;
        int n2;
        byte[] byArray = this.fLineBreaksNormalized ? normalizedContentMap : contentMap;
        if (byArray[this.fData[n2 = this.fCurrentOffset] & 0xFF] == 1) {
            n = n2++;
            while (byArray[this.fData[n2] & 0xFF] == 1) {
                ++n2;
            }
            if (byArray[this.fData[n2] & 0xFF] != 6) {
                xMLString.setValues(this.fCurrentBuffer, n, n2, 0);
            } else {
                ++n2;
                while (normalizedContentMap[this.fData[n2] & 0xFF] == 1) {
                    ++n2;
                }
                xMLString.setValues(this.fCurrentBuffer, n, n2, 4);
            }
        } else if (byArray[this.fData[n2] & 0xFF] == 6) {
            n = n2++;
            while (normalizedContentMap[this.fData[n2] & 0xFF] == 1) {
                ++n2;
            }
            xMLString.setValues(this.fCurrentBuffer, n, n2, 4);
        } else {
            ParsedEntity parsedEntity = this.fCurrentEntity;
            boolean bl = this.scanContentUnbuffered2(xMLString, 0);
            if (this.fCurrentEntity == parsedEntity) {
                parsedEntity.offset = this.fCurrentOffset;
            }
            return bl;
        }
        this.fCurrentEntity.offset = this.fCurrentOffset = n2;
        this.fCurrentState = 6;
        if (!this.fHelper.produceCharactersEvent()) {
            // empty if block
        }
        if (byArray[this.fData[n2] & 0xFF] == 2) {
            switch (markupMap[this.fData[n2 + 1] & 0xFF]) {
                case 1: {
                    this.fThisByte = this.fData[n2];
                    this.fCurrentState = 4;
                    return this.stateUnbufferedStartElement();
                }
                case 2: {
                    this.fThisByte = this.fData[n2];
                    this.fCurrentState = 5;
                    return this.stateUnbufferedEndElement();
                }
            }
            return this.scanMarkupUnbuffered();
        }
        ParsedEntity parsedEntity = this.fCurrentEntity;
        xMLString = this.fHelper.contentToProduce();
        boolean bl = this.scanContentUnbuffered2(xMLString, 0);
        if (this.fCurrentEntity == parsedEntity) {
            parsedEntity.offset = this.fCurrentOffset;
        }
        return bl;
    }

    private boolean scanContentUnbuffered2(XMLString xMLString, int n) {
        int n2;
        byte[] byArray = this.fLineBreaksNormalized ? normalizedContentMap : contentMap;
        byte[] byArray2 = this.fData;
        int n3 = n2 = this.fCurrentOffset;
        block15: while (true) {
            if (byArray[byArray2[n2] & 0xFF] == 1) {
                ++n2;
                continue;
            }
            switch (byArray[byArray2[n2] & 0xFF]) {
                case 2: {
                    if (n2 > n3) {
                        xMLString.setValues(this.fCurrentBuffer, n3, n2, n);
                        this.fCurrentEntity.offset = this.fCurrentOffset = n2;
                        this.fCurrentState = 6;
                        if (!this.fHelper.produceCharactersEvent()) {
                            // empty if block
                        }
                    }
                    switch (markupMap[byArray2[n2 + 1] & 0xFF]) {
                        case 1: {
                            this.fCurrentOffset = n2;
                            this.fThisByte = this.fData[this.fCurrentOffset];
                            this.fCurrentState = 4;
                            return this.stateUnbufferedStartElement();
                        }
                        case 2: {
                            this.fCurrentOffset = n2;
                            this.fThisByte = this.fData[this.fCurrentOffset];
                            this.fCurrentState = 5;
                            return this.stateUnbufferedEndElement();
                        }
                        case 3: {
                            this.fCurrentOffset = n2 + 2;
                            this.fThisByte = this.fData[this.fCurrentOffset];
                            if (this.scanPI()) break;
                            return false;
                        }
                        case 4: {
                            if (byArray2[n2 + 2] == 45) {
                                if (byArray2[n2 + 3] == 45) {
                                    this.fCurrentOffset = n2 + 4;
                                    this.fThisByte = this.fData[this.fCurrentOffset];
                                    if (this.scanComment()) break;
                                    return false;
                                }
                                this.fCurrentOffset = n2;
                                this.fThisByte = this.fData[this.fCurrentOffset];
                                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 27);
                            }
                            if (byArray2[n2 + 2] == 91 && byArray2[n2 + 3] == 67 && byArray2[n2 + 4] == 68 && byArray2[n2 + 5] == 65 && byArray2[n2 + 6] == 84 && byArray2[n2 + 7] == 65 && byArray2[n2 + 8] == 91) {
                                this.fCurrentOffset = n2 + 9;
                                if (this.scanCDSectUnbuffered()) break;
                                return false;
                            }
                            this.fCurrentOffset = n2;
                            return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 19);
                        }
                        default: {
                            this.fCurrentOffset = n2;
                            return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 19);
                        }
                    }
                    byArray = this.fLineBreaksNormalized ? normalizedContentMap : contentMap;
                    xMLString = this.fHelper.contentToProduce();
                    n3 = n2 = this.fCurrentOffset;
                    continue block15;
                }
                case 3: {
                    this.fCurrentOffset = n2;
                    if (n2 > n3) {
                        this.setValues(xMLString, n3, n2, n);
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        this.fCurrentState = 6;
                        if (!this.fHelper.produceCharactersEvent()) {
                            // empty if block
                        }
                    }
                    ++this.fCurrentOffset;
                    this.fThisByte = this.fData[this.fCurrentOffset];
                    this.fCurrentState = 6;
                    if (!this.checkReferenceInContent()) {
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        return false;
                    }
                    if (this.fCurrentEntity.unbuffered) {
                        byArray = this.fLineBreaksNormalized ? normalizedContentMap : contentMap;
                        xMLString = this.fHelper.contentToProduce();
                        byArray2 = this.fData;
                        n3 = n2 = this.fCurrentOffset;
                        continue block15;
                    }
                    this.fCurrentState = 10;
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    return true;
                }
                case 4: {
                    if (byArray2[++n2] != 93 || byArray2[n2 + 1] != 62) continue block15;
                    this.fCurrentOffset = --n2;
                    if (n2 > n3) {
                        this.setValues(xMLString, n3, n2, n);
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        this.fCurrentState = 6;
                        if (!this.fHelper.produceCharactersEvent()) {
                            // empty if block
                        }
                    }
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 5);
                }
                case 5: {
                    continue block15;
                }
                case 6: {
                    n |= 4;
                    byArray = normalizedContentMap;
                    ++n2;
                    continue block15;
                }
                case 7: {
                    this.fCurrentOffset = n2;
                    if (this.skippedValidChar()) {
                        n2 = this.fCurrentOffset;
                        continue block15;
                    }
                    if (n2 > n3) {
                        this.setValues(xMLString, n3, n2, n);
                        this.fCurrentOffset = n2;
                        if (this.fCurrentEntity != null && this.fCurrentEntity.offset != this.fCurrentOffset) {
                            this.fCurrentEntity.offset = this.fCurrentOffset;
                            UntestedCode.needTest("updateCursor(18)");
                        }
                        this.fCurrentState = 6;
                        if (!this.fHelper.produceCharactersEvent()) {
                            // empty if block
                        }
                    }
                    this.setInvalidCharParameter(0);
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 2);
                }
                case 8: {
                    if (n2 != this.fEndOffset) break block15;
                    this.fCurrentOffset = n2;
                    if (n2 > n3) {
                        this.setValues(xMLString, n3, n2, n);
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        this.fCurrentState = 6;
                        if (!this.fHelper.produceCharactersEvent()) {
                            // empty if block
                        }
                    }
                    if (this.fDTDSupport != null && this.fDTDSupport.endOfEntity(1)) {
                        int n4 = this.fCurrentState & 0xC;
                        if (n4 != 0 && this.fCurrentEntity.unbuffered != ((n4 & 8) == 0)) {
                            this.fCurrentState ^= 0xC;
                        }
                        return this.fHelper.continueAfterEndOfEntity();
                    }
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 19);
                }
            }
            break;
        }
        this.fCurrentOffset = n2;
        if (n2 > n3) {
            this.setValues(xMLString, n3, n2, n);
            if (this.fCurrentEntity != null && this.fCurrentEntity.offset != this.fCurrentOffset) {
                this.fCurrentEntity.offset = this.fCurrentOffset;
                UntestedCode.needTest("updateCursor(20)");
            }
            this.fCurrentState = 6;
            if (!this.fHelper.produceCharactersEvent()) {
                // empty if block
            }
        }
        this.setInvalidCharParameter(0);
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 2);
    }

    public boolean scanElementContentUnbuffered(XMLString xMLString) {
        int n;
        int n2;
        byte[] byArray = this.fLineBreaksNormalized ? normalizedElementContentMap : elementContentMap;
        if (byArray[this.fData[n2 = this.fCurrentOffset] & 0xFF] == 6) {
            n = n2++;
            while (normalizedElementContentMap[this.fData[n2] & 0xFF] == 5) {
                ++n2;
            }
            xMLString.setValues(this.fCurrentBuffer, n, n2, 6);
        } else if (byArray[this.fData[n2] & 0xFF] == 5) {
            n = n2++;
            while (byArray[this.fData[n2] & 0xFF] == 5) {
                ++n2;
            }
            if (byArray[this.fData[n2] & 0xFF] != 6) {
                xMLString.setValues(this.fCurrentBuffer, n, n2, 2);
            } else {
                ++n2;
                while (normalizedElementContentMap[this.fData[n2] & 0xFF] == 5) {
                    ++n2;
                }
                xMLString.setValues(this.fCurrentBuffer, n, n2, 6);
            }
        } else {
            ParsedEntity parsedEntity = this.fCurrentEntity;
            boolean bl = this.scanElementContentUnbuffered2(xMLString);
            if (this.fCurrentEntity == parsedEntity) {
                parsedEntity.offset = this.fCurrentOffset;
            }
            return bl;
        }
        this.fCurrentEntity.offset = this.fCurrentOffset = n2;
        this.fCurrentState = 6;
        if (!this.fHelper.produceWhitespaceEvent()) {
            // empty if block
        }
        if (byArray[this.fData[n2] & 0xFF] == 2) {
            switch (markupMap[this.fData[n2 + 1] & 0xFF]) {
                case 1: {
                    this.fThisByte = this.fData[n2];
                    this.fCurrentState = 4;
                    return this.stateUnbufferedStartElement();
                }
                case 2: {
                    this.fThisByte = this.fData[n2];
                    this.fCurrentState = 5;
                    return this.stateUnbufferedEndElement();
                }
            }
            return this.scanMarkupUnbuffered();
        }
        ParsedEntity parsedEntity = this.fCurrentEntity;
        xMLString = this.fHelper.contentToProduce();
        boolean bl = this.scanElementContentUnbuffered2(xMLString);
        if (this.fCurrentEntity == parsedEntity) {
            parsedEntity.offset = this.fCurrentOffset;
        }
        return bl;
    }

    private boolean scanElementContentUnbuffered2(XMLString xMLString) {
        int n;
        byte[] byArray = this.fLineBreaksNormalized ? normalizedElementContentMap : elementContentMap;
        byte[] byArray2 = this.fData;
        int n2 = n = this.fCurrentOffset;
        int n3 = 2;
        block16: while (true) {
            if (byArray[byArray2[n] & 0xFF] == 5) {
                ++n;
                continue;
            }
            switch (byArray[byArray2[n] & 0xFF]) {
                case 1: {
                    n3 &= 0xFFFFFFFD;
                    this.fCurrentOffset = n2;
                    this.fCurrentState = 6;
                    return this.scanContentUnbuffered2(xMLString, n3 |= 1);
                }
                case 2: {
                    if (n > n2) {
                        xMLString.setValues(this.fCurrentBuffer, n2, n, n3);
                        this.fCurrentEntity.offset = this.fCurrentOffset = n;
                        this.fCurrentState = 6;
                        if (!this.fHelper.produceWhitespaceEvent()) {
                            // empty if block
                        }
                    }
                    switch (markupMap[byArray2[n + 1] & 0xFF]) {
                        case 1: {
                            this.fCurrentOffset = n;
                            this.fThisByte = this.fData[this.fCurrentOffset];
                            this.fCurrentState = 4;
                            return this.stateUnbufferedStartElement();
                        }
                        case 2: {
                            this.fCurrentOffset = n;
                            this.fThisByte = this.fData[this.fCurrentOffset];
                            this.fCurrentEntity.offset = this.fCurrentOffset;
                            this.fCurrentState = 5;
                            return this.stateUnbufferedEndElement();
                        }
                        case 3: {
                            this.fCurrentOffset = n + 2;
                            this.fThisByte = this.fData[this.fCurrentOffset];
                            if (this.scanPI()) break;
                            this.fCurrentEntity.offset = this.fCurrentOffset;
                            return false;
                        }
                        case 4: {
                            if (byArray2[n + 2] == 45) {
                                if (byArray2[n + 3] == 45) {
                                    this.fCurrentOffset = n + 4;
                                    this.fThisByte = this.fData[this.fCurrentOffset];
                                    if (this.scanComment()) break;
                                    this.fCurrentEntity.offset = this.fCurrentOffset;
                                    return false;
                                }
                                this.fCurrentOffset = n;
                                this.fThisByte = this.fData[this.fCurrentOffset];
                                this.fCurrentEntity.offset = this.fCurrentOffset;
                                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 27);
                            }
                            if (byArray2[n + 2] == 91 && byArray2[n + 3] == 67 && byArray2[n + 4] == 68 && byArray2[n + 5] == 65 && byArray2[n + 6] == 84 && byArray2[n + 7] == 65 && byArray2[n + 8] == 91) {
                                this.fCurrentOffset = n + 9;
                                if (this.scanCDSectUnbuffered()) break;
                                this.fCurrentEntity.offset = this.fCurrentOffset;
                                return false;
                            }
                            this.fCurrentEntity.offset = this.fCurrentOffset = n;
                            return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 19);
                        }
                        default: {
                            this.fCurrentEntity.offset = this.fCurrentOffset = n;
                            return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 19);
                        }
                    }
                    xMLString = this.fHelper.contentToProduce();
                    n2 = n = this.fCurrentOffset;
                    continue block16;
                }
                case 3: {
                    this.fCurrentOffset = n;
                    if (n > n2) {
                        this.setValues(xMLString, n2, n, n3);
                        if (this.fCurrentEntity != null && this.fCurrentEntity.offset != this.fCurrentOffset) {
                            this.fCurrentEntity.offset = this.fCurrentOffset;
                            UntestedCode.needTest("updateCursor(23)");
                        }
                        this.fCurrentState = 6;
                        if (!this.fHelper.produceWhitespaceEvent()) {
                            // empty if block
                        }
                    }
                    ++this.fCurrentOffset;
                    this.fThisByte = this.fData[this.fCurrentOffset];
                    this.fCurrentState = 6;
                    if (!this.checkReferenceInContent()) {
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        return false;
                    }
                    if (this.fCurrentEntity.unbuffered) {
                        xMLString = this.fHelper.contentToProduce();
                        byArray2 = this.fData;
                        n2 = n = this.fCurrentOffset;
                        continue block16;
                    }
                    this.fCurrentState = 10;
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    return true;
                }
                case 4: {
                    if (byArray2[++n] == 93 && byArray2[n + 1] == 62) {
                        this.fCurrentOffset = --n;
                        if (n > n2) {
                            this.setValues(xMLString, n2, n, n3);
                            if (this.fCurrentEntity != null && this.fCurrentEntity.offset != this.fCurrentOffset) {
                                this.fCurrentEntity.offset = this.fCurrentOffset;
                                UntestedCode.needTest("updateCursor(24)");
                            }
                            this.fCurrentState = 6;
                            if (!this.fHelper.produceWhitespaceEvent()) {
                                // empty if block
                            }
                        }
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 5);
                    }
                    n3 &= 0xFFFFFFFD;
                    this.fCurrentOffset = n2;
                    this.fCurrentState = 6;
                    return this.scanContentUnbuffered2(xMLString, n3 |= 1);
                }
                case 5: {
                    continue block16;
                }
                case 6: {
                    n3 |= 4;
                    byArray = normalizedElementContentMap;
                    ++n;
                    continue block16;
                }
                case 7: {
                    this.fCurrentOffset = n;
                    if (this.skippedValidChar()) {
                        n = this.fCurrentOffset;
                        continue block16;
                    }
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    if (n > n2) {
                        this.setValues(xMLString, n2, n, n3);
                        this.fCurrentState = 6;
                        if (!this.fHelper.produceWhitespaceEvent()) {
                            // empty if block
                        }
                    }
                    this.setInvalidCharParameter(0);
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 2);
                }
                case 8: {
                    if (n != this.fEndOffset) break block16;
                    this.fCurrentOffset = n;
                    if (n > n2) {
                        this.setValues(xMLString, n2, n, n3);
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        this.fCurrentState = 6;
                        if (!this.fHelper.produceWhitespaceEvent()) {
                            // empty if block
                        }
                    }
                    if (this.fDTDSupport != null && this.fDTDSupport.endOfEntity(1)) {
                        int n4 = this.fCurrentState & 0xC;
                        if (n4 != 0 && this.fCurrentEntity.unbuffered != ((n4 & 8) == 0)) {
                            this.fCurrentState ^= 0xC;
                        }
                        return false;
                    }
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 19);
                }
            }
            break;
        }
        this.fCurrentOffset = n;
        if (n > n2) {
            this.setValues(xMLString, n2, n, n3);
            if (this.fCurrentEntity != null && this.fCurrentEntity.offset != this.fCurrentOffset) {
                this.fCurrentEntity.offset = this.fCurrentOffset;
                UntestedCode.needTest("updateCursor(27)");
            }
            this.fCurrentState = 6;
            if (!this.fHelper.produceWhitespaceEvent()) {
                // empty if block
            }
        }
        this.fCurrentEntity.offset = this.fCurrentOffset;
        this.setInvalidCharParameter(0);
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 2);
    }

    private boolean scanMarkupUnbuffered() {
        byte by = this.fData[this.fCurrentOffset + 1];
        switch (markupMap[by & 0xFF]) {
            case 1: {
                this.fCurrentState = 4;
                return this.stateUnbufferedStartElement();
            }
            case 2: {
                this.fCurrentState = 5;
                return this.stateUnbufferedEndElement();
            }
            case 3: {
                this.nextByte();
                this.nextByte();
                this.fCurrentState = 6;
                return this.scanPI();
            }
            case 4: {
                this.nextByte();
                this.nextByte();
                if (this.skippedByte(45)) {
                    if (this.skippedByte(45)) {
                        this.fCurrentState = 6;
                        return this.scanComment();
                    }
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 27);
                }
                if (this.skippedBytes(CDSTART_BYTES)) {
                    this.fCurrentState = 6;
                    return this.scanCDSectUnbuffered();
                }
                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 19);
            }
        }
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 19);
    }

    /*
     * Unable to fully structure code
     */
    public boolean scanStartElementUnbuffered() {
        var1_1 = this.fHelper.setupStartElement();
        this.fCurrentEntity.offset = this.fCurrentOffset + 1;
        var4_2 = this.fHelper.scanQName(this.fCurrentEntity, var1_1);
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        var2_3 = this.fData;
        var3_4 = this.fCurrentOffset;
        switch (var4_2) {
            case 4: {
                var7_5 = false;
                var6_6 = true;
                ** GOTO lbl82
            }
            case 5: {
                var7_5 = false;
                var6_6 = false;
                ** GOTO lbl82
            }
            case 6: {
                while ((var5_7 = var2_3[++var3_4]) == 32 || var5_7 == 10 || var5_7 == 9 || var5_7 == 13) {
                }
                var6_6 = var5_7 == 47;
                var7_5 = var6_6 == false && var5_7 != 62;
                if (true) ** GOTO lbl82
            }
            case 2: 
            case 7: {
                this.fHelper.setParameter(0, var1_1);
                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 15);
            }
            default: {
                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 19);
            }
            case 1: {
                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 49);
            }
        }
        do {
            var8_8 = this.fHelper.currentAttributeName();
            this.fCurrentEntity.offset = this.fCurrentOffset = var3_4;
            var4_2 = this.fHelper.scanQName(this.fCurrentEntity, var8_8);
            if (this.setEntityLocals(this.fCurrentEntity) == 0) {
                this.checkForLoad();
            }
            var2_3 = this.fData;
            var3_4 = this.fCurrentOffset;
            switch (var4_2) {
                case 7: {
                    while ((var5_7 = var2_3[++var3_4]) == 32 || var5_7 == 10 || var5_7 == 9 || var5_7 == 13) {
                    }
                    break;
                }
                case 6: {
                    while ((var5_7 = var2_3[++var3_4]) == 32 || var5_7 == 10 || var5_7 == 9 || var5_7 == 13) {
                    }
                    if (var5_7 == 61) {
                        while ((var5_7 = var2_3[++var3_4]) == 32 || var5_7 == 10 || var5_7 == 9 || var5_7 == 13) {
                        }
                        break;
                    }
                }
                case 2: 
                case 4: 
                case 5: {
                    this.fHelper.setParameter(0, var1_1);
                    this.fHelper.setParameter(1, var8_8);
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 16);
                }
                default: {
                    this.fHelper.setParameter(0, var1_1);
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 15);
                }
                case 1: {
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 49);
                }
            }
            var9_9 = this.fHelper.setupSpecifiedAttribute();
            var11_11 = var2_3[var3_4];
            if (var11_11 != 34 && var11_11 != 39) {
                this.fHelper.setParameter(0, var1_1);
                this.fHelper.setParameter(1, var8_8);
                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 24);
            }
            this.fCurrentOffset = var3_4 + 1;
            if (!this.scanAttValueUnbuffered(var9_9, var11_11)) {
                return false;
            }
            var2_3 = this.fData;
            var3_4 = this.fCurrentOffset;
            this.fHelper.addSpecifiedAttribute();
            var5_7 = var2_3[var3_4];
            v0 = var10_10 = var5_7 == 32 || var5_7 == 10 || var5_7 == 9 || var5_7 == 13;
            if (var10_10) {
                while ((var5_7 = var2_3[++var3_4]) == 32 || var5_7 == 10 || var5_7 == 9 || var5_7 == 13) {
                }
            }
            v1 = var6_6 = var5_7 == 47;
            if (var6_6 || var5_7 == 62) break;
            if (var10_10) continue;
            this.fHelper.setParameter(0, var1_1);
            return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 15);
lbl82:
            // 4 sources

        } while (var7_5);
        if (var6_6) {
            if (var2_3[var3_4 + 1] == 62) {
                this.fCurrentEntity.offset = this.fCurrentOffset = var3_4 + 2;
                return this.fHelper.finishEmptyElement();
            }
            this.fHelper.setParameter(0, var1_1);
            return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 15);
        }
        this.fCurrentEntity.offset = this.fCurrentOffset = var3_4 + 1;
        return this.fHelper.finishStartElement();
    }

    private boolean scanAttValueUnbuffered(XMLString xMLString, int n) {
        int n2;
        byte[] byArray = attValueMap;
        byte[] byArray2 = this.fData;
        int n3 = n2 = this.fCurrentOffset;
        boolean bl = true;
        int n4 = this.fDTDSupport != null ? this.fDTDSupport.entityDepth() : 0;
        int n5 = 0;
        block9: while (true) {
            if (byArray[byArray2[n2] & 0xFF] == 1) {
                ++n2;
                continue;
            }
            switch (byArray[byArray2[n2] & 0xFF]) {
                case 2: {
                    if ((n4 == 0 || this.fDTDSupport != null && this.fDTDSupport.entityDepth() == n4) && byArray2[n2] == n) {
                        if (n2 > n3) {
                            this.setValues(xMLString, n3, n2, n5);
                            this.fHelper.attributeValueCharacters(xMLString, bl);
                        }
                        if (xMLString == this.fAttValueChars) {
                            this.fAttValueChars.clear();
                        }
                        this.fCurrentOffset = n2 + 1;
                        return true;
                    }
                    ++n2;
                    continue block9;
                }
                case 3: {
                    this.fCurrentOffset = n2;
                    if (n2 > n3) {
                        this.setValues(xMLString, n3, n2, n5);
                        this.fHelper.attributeValueCharacters(xMLString, bl);
                        if (xMLString != this.fAttValueChars) {
                            this.fAttValueChars.clear();
                            this.fHelper.attributeValueCharacters(this.fAttValueChars, true);
                        }
                        xMLString = this.fAttValueChars;
                        bl = true;
                        n5 = 0;
                    }
                    ++this.fCurrentOffset;
                    this.fThisByte = this.fData[this.fCurrentOffset];
                    if (!this.checkReferenceInAttValue()) {
                        return false;
                    }
                    if (this.fCurrentEntity.unbuffered) {
                        byArray2 = this.fData;
                        n3 = n2 = this.fCurrentOffset;
                        continue block9;
                    }
                    return this.scanAttValueBuffered(xMLString, n, n4);
                }
                case 4: {
                    if (n2 > n3) {
                        this.setValues(xMLString, n3, n2, n5);
                        this.fHelper.attributeValueCharacters(xMLString, bl);
                        xMLString = this.fAttValueChars;
                        bl = true;
                        n5 = 0;
                    }
                    this.fHelper.setParameter(0, this.fHelper.currentElementType());
                    this.fHelper.setParameter(1, this.fHelper.currentAttributeName());
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 25);
                }
                case 5: {
                    bl = false;
                    ++n2;
                    continue block9;
                }
                case 6: {
                    if (!this.fLineBreaksNormalized) {
                        n5 |= 4;
                    }
                    bl = false;
                    ++n2;
                    continue block9;
                }
                case 7: {
                    this.fCurrentOffset = n2;
                    if (this.skippedValidChar()) {
                        n2 = this.fCurrentOffset;
                        continue block9;
                    }
                    this.fHelper.setParameter(0, this.fHelper.currentElementType());
                    this.fHelper.setParameter(1, this.fHelper.currentAttributeName());
                    this.setInvalidCharParameter(2);
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 21);
                }
                case 8: {
                    if (n2 > n3) {
                        this.setValues(xMLString, n3, n2, n5);
                        this.fHelper.attributeValueCharacters(xMLString, bl);
                        xMLString = this.fAttValueChars;
                        bl = true;
                        n5 = 0;
                    }
                    if (n2 != this.fEndOffset) break block9;
                    this.fCurrentOffset = n2;
                    if (this.fDTDSupport != null && this.fDTDSupport.endOfEntity(1)) {
                        int n6 = this.fCurrentState & 0xC;
                        if (n6 != 0 && this.fCurrentEntity.unbuffered != ((n6 & 8) == 0)) {
                            this.fCurrentState ^= 0xC;
                        }
                        byArray2 = this.fData;
                        n3 = n2 = this.fCurrentOffset;
                        continue block9;
                    }
                    this.fHelper.setParameter(0, this.fHelper.currentElementType());
                    this.fHelper.setParameter(1, this.fHelper.currentAttributeName());
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 26);
                }
            }
            break;
        }
        this.fCurrentOffset = n2;
        this.fHelper.setParameter(0, this.fHelper.currentElementType());
        this.fHelper.setParameter(1, this.fHelper.currentAttributeName());
        this.setInvalidCharParameter(2);
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 21);
    }

    public boolean scanEndElementUnbuffered() {
        QName qName = this.fHelper.popElement();
        this.fCurrentOffset += 2;
        this.fThisByte = this.fData[this.fCurrentOffset];
        if (qName != null) {
            int n;
            byte[] byArray;
            block7: {
                byArray = this.fData;
                int n2 = this.fCurrentOffset;
                byte[] byArray2 = qName.bytes;
                int n3 = qName.length;
                n = n2 + n3;
                int n4 = qName.endOffset - 1;
                int n5 = n - 1;
                if (byArray2 != null && n <= this.fEndOffset) {
                    while (byArray2[n4] == byArray[n5]) {
                        if (n5-- > n2) {
                            --n4;
                            continue;
                        }
                        break block7;
                    }
                    return this.scanEndElementNoMatch(qName);
                }
                return this.scanEndElementUnbuffered2(qName);
            }
            byte by = byArray[n];
            if (by != 62) {
                while (by == 32 || by == 10 || by == 9 || by == 13) {
                    by = byArray[++n];
                }
                if (by != 62) {
                    this.fHelper.setParameter(0, qName);
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 18);
                }
            }
            this.fCurrentOffset = n + 1;
            this.fThisByte = this.fData[this.fCurrentOffset];
            this.fCurrentEntity.offset = this.fCurrentOffset;
            this.finishEndElementUnbuffered(this.fHelper.elementDepth());
            return this.fHelper.produceEndElementEvent(qName);
        }
        this.fHelper.setParameter(0, this.fHelper.topElement());
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 20);
    }

    private boolean scanEndElementUnbuffered2(QName qName) {
        boolean bl = qName.bytes != null ? this.skippedBytesInRange(qName.bytes, qName.startOffset, qName.endOffset) : this.skippedBytesBuffered2(qName.firstBuffer, qName.lastBuffer, qName.startOffset, qName.endOffset);
        int n = this.fCurrentOffset;
        if (bl) {
            byte by = this.fData[n];
            if (by != 62) {
                while (by == 32 || by == 10 || by == 9 || by == 13) {
                    by = this.fData[++n];
                }
                if (by != 62) {
                    this.fHelper.setParameter(0, qName);
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 18);
                }
            }
            this.fCurrentOffset = n + 1;
            this.fThisByte = this.fData[this.fCurrentOffset];
            this.fCurrentEntity.offset = this.fCurrentOffset;
            this.finishEndElementUnbuffered(this.fHelper.elementDepth());
            return this.fHelper.produceEndElementEvent(qName);
        }
        return this.scanEndElementNoMatch(qName);
    }

    private boolean scanEndElementNoMatch(QName qName) {
        this.scanQName(this.fTempQName);
        this.fHelper.setParameter(0, this.fTempQName);
        this.fHelper.setParameter(1, qName);
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 14);
    }

    private boolean scanCDSectUnbuffered() {
        int n;
        byte[] byArray = cdSectMap;
        byte[] byArray2 = this.fData;
        int n2 = n = this.fCurrentOffset;
        int n3 = 0;
        this.fCurrentEntity.offset = this.fCurrentOffset;
        if (!this.fHelper.produceStartCDATASectionEvent()) {
            // empty if block
        }
        XMLString xMLString = this.fHelper.contentToProduce();
        byte by = byArray2[n];
        block6: while (true) {
            if (byArray[by & 0xFF] == 1) {
                by = byArray2[++n];
                continue;
            }
            switch (byArray[by & 0xFF]) {
                case 2: {
                    by = byArray2[++n];
                    do {
                        if (by != 93) continue block6;
                    } while ((by = byArray2[++n]) != 62);
                    this.fCurrentOffset = n - 2;
                    if (this.fCurrentOffset > n2) {
                        this.setValues(xMLString, n2, this.fCurrentOffset, n3);
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        if (!this.fHelper.produceCharactersEvent()) {
                            // empty if block
                        }
                    }
                    this.fCurrentOffset += 3;
                    this.fThisByte = this.fData[this.fCurrentOffset];
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    this.fCurrentState = 6;
                    return this.fHelper.produceEndCDATASectionEvent();
                }
                case 3: {
                    if (!this.fLineBreaksNormalized) {
                        n3 |= 4;
                    }
                    by = byArray2[++n];
                    continue block6;
                }
                case 4: {
                    this.fCurrentOffset = n;
                    if (this.skippedValidChar()) {
                        n = this.fCurrentOffset;
                        by = byArray2[n];
                        continue block6;
                    }
                    if (n > n2) {
                        this.setValues(xMLString, n2, n, n3);
                        if (this.fCurrentEntity != null && this.fCurrentEntity.offset != this.fCurrentOffset) {
                            this.fCurrentEntity.offset = this.fCurrentOffset;
                            UntestedCode.needTest("updateCursor(33)");
                        }
                        this.fCurrentState = 6;
                        this.fHelper.produceCharactersEvent();
                    }
                    this.setInvalidCharParameter(0);
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 1);
                }
                case 5: {
                    if (n != this.fEndOffset) break block6;
                    this.fCurrentOffset = n;
                    if (n > n2) {
                        this.setValues(xMLString, n2, n, n3);
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        this.fCurrentState = 6;
                        this.fHelper.produceCharactersEvent();
                    }
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 6);
                }
            }
            break;
        }
        this.fCurrentOffset = n;
        if (n > n2) {
            this.setValues(xMLString, n2, n, n3);
            if (this.fCurrentEntity != null && this.fCurrentEntity.offset != this.fCurrentOffset) {
                this.fCurrentEntity.offset = this.fCurrentOffset;
                UntestedCode.needTest("updateCursor(35)");
            }
            this.fCurrentState = 6;
            this.fHelper.produceCharactersEvent();
        }
        this.setInvalidCharParameter(0);
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 1);
    }

    private boolean scanTrailingMisc() {
        while (true) {
            if (this.fEndOfEntity) {
                if (this.fDTDSupport != null) {
                    this.fDTDSupport.endOfEntity(0);
                    this.fCurrentEntity = null;
                } else if (this.fCurrentEntity != null) {
                    this.fCurrentEntity.release();
                    this.fCurrentEntity = null;
                }
                return this.endDocument();
            }
            if (this.skippedSpaces()) continue;
            if (this.skippedByte(60)) {
                if (this.skippedByte(63)) {
                    if (this.scanPI()) continue;
                    return false;
                }
                if (this.skippedByte(33)) {
                    if (this.skippedByte(45)) {
                        if (this.skippedByte(45)) {
                            if (this.scanComment()) continue;
                            return false;
                        }
                        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 27);
                    }
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 12);
                }
                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 12);
            }
            if (this.skippedByte(38)) {
                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 12);
            }
            if (!this.fEndOfEntity) break;
        }
        this.setInvalidCharParameter(0);
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 3);
    }

    private boolean scanPI() {
        XMLString xMLString = this.fHelper.targetToProduce();
        int n = this.scanNCName(xMLString);
        switch (n) {
            case 0: {
                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 30);
            }
            case 2: 
            case 6: {
                if (!DocumentEntityScanner.reservedPITarget(xMLString)) {
                    XMLString xMLString2 = this.fHelper.contentToProduce();
                    if (n == 6) {
                        this.skipSpaces();
                        if (this.scanPIData(xMLString2)) {
                            this.fCurrentEntity.offset = this.fCurrentOffset;
                            return this.fHelper.produceProcessingInstructionEvent();
                        }
                        return false;
                    }
                    if (!this.skippedBytes(PI_END_BYTES)) break;
                    this.startString(xMLString2);
                    this.endString(xMLString2);
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    return this.fHelper.produceProcessingInstructionEvent();
                }
                return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 33);
            }
        }
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 31);
    }

    protected static boolean reservedPITarget(XMLString xMLString) {
        if (xMLString.length == 3) {
            byte[] byArray = xMLString.bytes;
            int n = xMLString.startOffset;
            if (byArray != null) {
                return !(byArray[n + 0] != 120 && byArray[n + 0] != 88 || byArray[n + 1] != 109 && byArray[n + 1] != 77 || byArray[n + 2] != 108 && byArray[n + 2] != 76);
            }
            int n2 = xMLString.firstBuffer.endOffset;
            byArray = xMLString.firstBuffer.bytes;
            if (byArray[n] == 120 || byArray[n] == 88) {
                if (++n == n2) {
                    byArray = xMLString.lastBuffer.bytes;
                    n = xMLString.lastBuffer.startOffset;
                    n2 = xMLString.endOffset;
                }
                if (byArray[n] == 109 || byArray[n] == 77) {
                    if (++n == n2) {
                        byArray = xMLString.lastBuffer.bytes;
                        n = xMLString.lastBuffer.startOffset;
                        n2 = xMLString.endOffset;
                    }
                    return byArray[n] == 108 || byArray[n] == 76;
                }
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean scanPIData(XMLString var1_1) {
        var2_2 = 0;
        this.startString(var1_1);
        block6: while (true) {
            this.skippedValidXMLBytesUsingMap(DocumentEntityScanner.piMap, 1);
            switch (DocumentEntityScanner.piMap[this.fThisByte & 255]) {
                case 2: {
                    this.endString(var1_1);
                    this.nextByte();
                    if (!this.skippedByte(62)) continue block6;
                    if (var2_2 != 0) {
                        var1_1.flags |= var2_2;
                    }
                    return true;
                }
                case 3: {
                    if (!this.fLineBreaksNormalized) {
                        var2_2 |= 4;
                    }
                    this.nextByte();
                    continue block6;
                }
                case 4: {
                    if (!this.skippedValidChar()) ** break;
                    continue block6;
                    this.setInvalidCharParameter(0);
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 23);
                }
                case 5: {
                    if (!this.fEndOfEntity) break block6;
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 32);
                }
            }
            break;
        }
        this.setInvalidCharParameter(0);
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 23);
    }

    private boolean scanComment() {
        if (this.scanComment(this.fHelper.contentToProduce())) {
            this.fCurrentEntity.offset = this.fCurrentOffset;
            return this.fHelper.produceCommentEvent();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean scanComment(XMLString var1_1) {
        var2_2 = 0;
        this.startString(var1_1);
        block6: while (true) {
            this.skippedValidXMLBytesUsingMap(DocumentEntityScanner.commentMap, 1);
            switch (DocumentEntityScanner.commentMap[this.fThisByte & 255]) {
                case 2: {
                    this.endString(var1_1);
                    this.nextByte();
                    if (!this.skippedByte(45)) continue block6;
                    if (this.skippedByte(62)) {
                        if (var2_2 != 0) {
                            var1_1.flags |= var2_2;
                        }
                        return true;
                    }
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 28);
                }
                case 3: {
                    if (!this.fLineBreaksNormalized) {
                        var2_2 |= 4;
                    }
                    this.nextByte();
                    continue block6;
                }
                case 4: {
                    if (!this.skippedValidChar()) ** break;
                    continue block6;
                    this.setInvalidCharParameter(0);
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 22);
                }
                case 5: {
                    if (!this.fEndOfEntity) break block6;
                    return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 29);
                }
            }
            break;
        }
        this.setInvalidCharParameter(0);
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 22);
    }

    protected int scanCharacterReference() {
        int n;
        boolean bl = false;
        this.startString(this.fHelper.entityNameToProduce());
        if (this.skippedByte(120)) {
            int n2 = digitMap[this.fThisByte & 0xFF];
            if (n2 < 0) {
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 36);
                return -1;
            }
            this.nextByte();
            n = n2;
            while (!this.skippedByte(59)) {
                n2 = digitMap[this.fThisByte & 0xFF];
                if (n2 < 0) {
                    this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 37);
                    return -1;
                }
                this.nextByte();
                if ((n = (n << 4) + n2) <= 0x10FFFF) continue;
                bl = true;
                n = 0;
            }
        } else {
            int n3 = digitMap[this.fThisByte & 0xFF];
            if (n3 < 0 || n3 > 9) {
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 35);
                return -1;
            }
            this.nextByte();
            n = n3;
            while (!this.skippedByte(59)) {
                n3 = digitMap[this.fThisByte & 0xFF];
                if (n3 < 0 || n3 > 9) {
                    this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 37);
                    return -1;
                }
                this.nextByte();
                if ((n = n * 10 + n3) <= 0x10FFFF) continue;
                bl = true;
                n = 0;
            }
        }
        if (!bl) {
            if (n < 55296) {
                bl = n < 32 && n != 10 && n != 9 && n != 13;
            } else {
                boolean bl2 = bl = n < 57344 || n >= 65534 && n < 65536 || n >= 0x110000;
            }
            if (!bl) {
                this.fHelper.entityNameToProduce().clear();
                return n;
            }
        }
        this.endString(this.fHelper.entityNameToProduce());
        this.fHelper.setParameter(0, this.fHelper.entityNameToProduce());
        this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 38);
        return -1;
    }

    private int checkPredefinedEntities(XMLString xMLString) {
        byte[] byArray = xMLString.firstBuffer.bytes;
        int n = xMLString.startOffset;
        int n2 = xMLString.length;
        switch (byArray[n] + n2) {
            case 110: {
                if (byArray[n + 1] != 116) break;
                return 60;
            }
            case 105: {
                if (byArray[n + 1] != 116) break;
                return 62;
            }
            case 100: {
                if (byArray[n + 1] != 109 || byArray[n + 2] != 112) break;
                return 38;
            }
            case 101: {
                if (byArray[n + 1] != 112 || byArray[n + 2] != 111 || byArray[n + 3] != 115) break;
                return 39;
            }
            case 117: {
                if (byArray[n + 1] != 117 || byArray[n + 2] != 111 || byArray[n + 3] != 116) break;
                return 34;
            }
            default: {
                return -1;
            }
        }
        if (n2 >= 2 && n2 <= 4 && xMLString.bytes == null) {
            DataBuffer dataBuffer = xMLString.firstBuffer;
            switch (byArray[n] + n2) {
                case 110: {
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 116) break;
                    return 60;
                }
                case 105: {
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 116) break;
                    return 62;
                }
                case 100: {
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 109) break;
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 112) break;
                    return 38;
                }
                case 101: {
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 112) break;
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 111) break;
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 115) break;
                    return 39;
                }
                case 117: {
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 117) break;
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 111) break;
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 116) break;
                    return 34;
                }
            }
        }
        return -1;
    }

    private boolean checkReferenceInContent() {
        if (this.skippedByte(35)) {
            int n = this.scanCharacterReference();
            if (n != -1) {
                this.fCurrentEntity.offset = this.fCurrentOffset;
                return this.fHelper.produceCharacterEvent(n);
            }
            return false;
        }
        int n = this.scanNCName(this.fHelper.entityNameToProduce());
        if (n == 8) {
            this.nextByte();
            return this.entityReferenceInContent();
        }
        if (n == 0) {
            return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 39);
        }
        this.fHelper.setParameter(0, this.fHelper.entityNameToProduce());
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 40);
    }

    private boolean entityReferenceInContent() {
        if (this.fDTDSupport != null) {
            return this.fDTDSupport.entityReferenceInContent();
        }
        int n = this.checkPredefinedEntities(this.fHelper.entityNameToProduce());
        if (n != -1) {
            this.fCurrentEntity.offset = this.fCurrentOffset;
            return this.fHelper.producePredefinedEntityEvent(n);
        }
        this.fHelper.setParameter(0, this.fHelper.entityNameToProduce());
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 47);
    }

    private boolean checkReferenceInAttValue() {
        if (this.skippedByte(35)) {
            int n = this.scanCharacterReference();
            if (n != -1) {
                this.fHelper.attributeValueCharacter(n, false);
                return true;
            }
            return false;
        }
        int n = this.scanNCName(this.fHelper.entityNameToProduce());
        if (n == 8) {
            this.nextByte();
            return this.entityReferenceInAttValue();
        }
        if (n == 0) {
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 39);
            return false;
        }
        this.fHelper.setParameter(0, this.fHelper.entityNameToProduce());
        this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 40);
        return false;
    }

    private boolean entityReferenceInAttValue() {
        if (this.fDTDSupport != null) {
            return this.fDTDSupport.entityReferenceInAttValue();
        }
        int n = this.checkPredefinedEntities(this.fHelper.entityNameToProduce());
        if (n != -1) {
            this.fHelper.attributeValueCharacter(n, true);
            return true;
        }
        this.fHelper.setParameter(0, this.fHelper.entityNameToProduce());
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 47);
    }

    public boolean skipContentBuffered(XMLString xMLString) {
        this.fSkippedElementDepth = 0;
        this.startString(xMLString);
        xMLString.flags = 0;
        this.setMark(this.fCurrentOffset);
        block6: while (true) {
            if (this.fThisByte == 60) {
                int n = this.fData[this.fCurrentOffset + 1];
                if (n == 0 && this.fCurrentOffset + 1 == this.fEndOffset) {
                    this.setMark(this.fCurrentOffset);
                    n = this.nextByte();
                    this.resetToMark();
                }
                switch (markupMap[n & 0xFF]) {
                    case 1: {
                        this.nextByte();
                        if (this.skipStartElementBuffered(xMLString)) continue block6;
                        this.resetToMark();
                        return false;
                    }
                    case 2: {
                        if (this.fSkippedElementDepth == 0) {
                            this.endStringWithFlags(xMLString, xMLString.flags);
                            this.fCurrentEntity.offset = this.fCurrentOffset;
                            this.fCurrentEntity.clearMark();
                            return true;
                        }
                        this.nextByte();
                        this.nextByte();
                        if (this.skipEndElementBuffered(xMLString)) continue block6;
                        this.resetToMark();
                        return false;
                    }
                    case 3: {
                        this.nextByte();
                        this.nextByte();
                        if (this.skipPIBuffered(xMLString)) continue block6;
                        this.resetToMark();
                        return false;
                    }
                    case 4: {
                        this.nextByte();
                        this.nextByte();
                        if (!(this.skippedByte(45) ? this.skippedByte(45) && this.skipCommentBuffered(xMLString) : this.skippedBytes(CDSTART_BYTES) && this.skipCDSectBuffered(xMLString))) break;
                        continue block6;
                    }
                }
                this.resetToMark();
                return false;
            }
            if (!this.fLineBreaksNormalized && this.fThisByte == 13) {
                xMLString.flags |= 4;
                this.nextByte();
                continue;
            }
            if (this.fThisByte == 0) break;
            this.nextByte();
        }
        this.resetToMark();
        return false;
    }

    private boolean skipStartElementBuffered(XMLString xMLString) {
        while (true) {
            int n;
            if ((n = this.fThisByte) == 62) {
                ++this.fSkippedElementDepth;
                return true;
            }
            if (n == 47) {
                this.nextByte();
                return this.skippedByte(62);
            }
            if (n == 34 || n == 39) {
                this.nextByte();
                if (this.skipToChar(n)) {
                    this.nextByte();
                    continue;
                }
                return false;
            }
            if (!this.fLineBreaksNormalized && this.fThisByte == 13) {
                xMLString.flags |= 4;
                this.nextByte();
                continue;
            }
            if (n == 0) break;
            this.nextByte();
        }
        return false;
    }

    private boolean skipEndElementBuffered(XMLString xMLString) {
        while (true) {
            if (this.fThisByte == 62) {
                --this.fSkippedElementDepth;
                return true;
            }
            if (!this.fLineBreaksNormalized && this.fThisByte == 13) {
                xMLString.flags |= 4;
                this.nextByte();
                continue;
            }
            if (this.fThisByte == 0) break;
            this.nextByte();
        }
        return false;
    }

    private boolean skipPIBuffered(XMLString xMLString) {
        block5: while (true) {
            this.skippedValidXMLBytesUsingMap(piMap, 1);
            switch (piMap[this.fThisByte & 0xFF]) {
                case 2: {
                    this.nextByte();
                    if (!this.skippedByte(62)) continue block5;
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    return true;
                }
                case 3: {
                    if (!this.fLineBreaksNormalized) {
                        xMLString.flags |= 4;
                    }
                    this.nextByte();
                    continue block5;
                }
                case 4: {
                    if (!this.skippedValidChar()) break block5;
                    continue block5;
                }
            }
            break;
        }
        return false;
    }

    private boolean skipCommentBuffered(XMLString xMLString) {
        block5: while (true) {
            this.skippedValidXMLBytesUsingMap(commentMap, 1);
            switch (commentMap[this.fThisByte & 0xFF]) {
                case 2: {
                    this.nextByte();
                    if (!this.skippedByte(45)) continue block5;
                    return this.skippedByte(62);
                }
                case 3: {
                    if (!this.fLineBreaksNormalized) {
                        xMLString.flags |= 4;
                    }
                    this.nextByte();
                    continue block5;
                }
                case 4: {
                    if (!this.skippedValidChar()) break block5;
                    continue block5;
                }
            }
            break;
        }
        return false;
    }

    private boolean skipCDSectBuffered(XMLString xMLString) {
        block5: while (true) {
            this.skippedValidXMLBytesUsingMap(cdSectMap, 1);
            switch (cdSectMap[this.fThisByte & 0xFF]) {
                case 2: {
                    if (this.skippedBytes(CDEND_BYTES)) {
                        return true;
                    }
                    this.nextByte();
                    continue block5;
                }
                case 3: {
                    if (!this.fLineBreaksNormalized) {
                        xMLString.flags |= 4;
                    }
                    this.nextByte();
                    continue block5;
                }
                case 4: {
                    if (!this.skippedValidChar()) break block5;
                    continue block5;
                }
            }
            break;
        }
        return false;
    }

    public boolean skipContentUnbuffered(XMLString xMLString) {
        this.fSkippedElementDepth = 0;
        this.startString(xMLString);
        this.setMark(this.fCurrentOffset);
        byte[] byArray = this.fData;
        int n = this.fCurrentOffset;
        byte by = byArray[n];
        while (true) {
            if (by == 60) {
                if ((by = byArray[++n]) == 47 && this.fSkippedElementDepth == 0) {
                    this.fCurrentOffset = n - 1;
                    this.endStringWithFlags(xMLString, xMLString.flags);
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    this.fCurrentEntity.clearMark();
                    return true;
                }
                if ((n = this.skipMarkupUnbuffered(byArray, n, by, xMLString)) == 0) {
                    this.resetToMark();
                    return false;
                }
                by = byArray[n];
                continue;
            }
            if (!this.fLineBreaksNormalized && by == 13) {
                xMLString.flags |= 4;
                by = byArray[++n];
                continue;
            }
            if (by == 0) break;
            by = byArray[++n];
        }
        return false;
    }

    private int skipMarkupUnbuffered(byte[] byArray, int n, int n2, XMLString xMLString) {
        byte[] byArray2 = markupMap;
        byte by = n2 >= 0 ? byArray2[n2] : (byte)1;
        switch (by) {
            case 1: {
                return this.skipStartElementUnbuffered(byArray, n, xMLString);
            }
            case 2: {
                return this.skipEndElementUnbuffered(byArray, n + 1, xMLString);
            }
            case 3: {
                return this.skipPIUnbuffered(byArray, n + 1, xMLString);
            }
            case 4: {
                n2 = byArray[n + 1];
                if (n2 == 45) {
                    if (byArray[n + 2] != 45) {
                        return 0;
                    }
                    return this.skipCommentUnbuffered(byArray, n + 3, xMLString);
                }
                if (n2 == 91 && byArray[n + 2] == 67 && byArray[n + 3] == 68 && byArray[n + 4] == 65 && byArray[n + 5] == 84 && byArray[n + 6] == 65 && byArray[n + 7] == 91) {
                    return this.skipCDSectUnbuffered(byArray, n + 8, xMLString);
                }
                return 0;
            }
        }
        return 0;
    }

    private int skipStartElementUnbuffered(byte[] byArray, int n, XMLString xMLString) {
        byte by = byArray[n];
        while (true) {
            if (by == 62) {
                ++this.fSkippedElementDepth;
                return n + 1;
            }
            if (by == 47) {
                if (byArray[n + 1] == 62) {
                    return n + 2;
                }
                return 0;
            }
            if (by == 34 || by == 39) {
                byte by2 = by;
                while ((by = byArray[++n]) != by2) {
                    if (by == 0) {
                        return 0;
                    }
                    if (this.fLineBreaksNormalized || by != 13) continue;
                    xMLString.flags |= 4;
                }
            } else if (by == 0) {
                return 0;
            }
            if (!this.fLineBreaksNormalized && by == 13) {
                xMLString.flags |= 4;
            }
            by = byArray[++n];
        }
    }

    private int skipEndElementUnbuffered(byte[] byArray, int n, XMLString xMLString) {
        byte by = byArray[n];
        while (true) {
            if (by == 62) {
                --this.fSkippedElementDepth;
                return n + 1;
            }
            if (by == 0) {
                return 0;
            }
            if (!this.fLineBreaksNormalized && by == 13) {
                xMLString.flags |= 4;
            }
            by = byArray[++n];
        }
    }

    private int skipPIUnbuffered(byte[] byArray, int n, XMLString xMLString) {
        byte by = byArray[n];
        while (by != 63 || byArray[n + 1] != 62) {
            if (by == 0) {
                return 0;
            }
            if (!this.fLineBreaksNormalized && by == 13) {
                xMLString.flags |= 4;
            }
            by = byArray[++n];
        }
        return n + 2;
    }

    private int skipCommentUnbuffered(byte[] byArray, int n, XMLString xMLString) {
        byte by = byArray[n];
        while (true) {
            if (by == 45 && byArray[n + 1] == 45) {
                if (byArray[n + 2] == 62) {
                    return n + 3;
                }
                return 0;
            }
            if (by == 0) {
                return 0;
            }
            if (!this.fLineBreaksNormalized && by == 13) {
                xMLString.flags |= 4;
            }
            by = byArray[++n];
        }
    }

    private int skipCDSectUnbuffered(byte[] byArray, int n, XMLString xMLString) {
        byte by = byArray[n];
        while (by != 93 || byArray[n + 1] != 93 || byArray[n + 2] != 62) {
            if (by == 0) {
                return 0;
            }
            if (!this.fLineBreaksNormalized && by == 13) {
                xMLString.flags |= 4;
            }
            by = byArray[++n];
        }
        return n + 3;
    }

    public static interface DTDSupport {
        public void setDocumentEntity(ParsedEntity var1);

        public void setStandalone();

        public boolean endOfEntity(int var1);

        public int entityDepth();

        public boolean scanDoctypeDecl(ParsedEntity var1);

        public boolean scanInternalDTDSubset();

        public boolean scanExternalDTDSubset();

        public boolean hasDefaultAttributes();

        public boolean addDefaultAttributes(QName var1, NSDeclList var2, AttrList var3, boolean var4);

        public boolean entityReferenceInContent();

        public boolean entityReferenceInAttValue();
    }
}

