/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.was;

import com.ibm.xml.xlxp.api.sax.impl.SAX2DTDScanner;
import com.ibm.xml.xlxp.api.sax.impl.SAX2ParsedEntityFactory;
import com.ibm.xml.xlxp.api.sax.impl.SAX2ParserBase;
import com.ibm.xml.xlxp.api.sax.impl.SAX2ParserCallbacks;
import com.ibm.xml.xlxp.api.sax.impl.SAXExceptionWrapper;
import com.ibm.xml.xlxp.api.util.ParsedEntityStream;
import com.ibm.xml.xlxp.api.util.SimpleDTDScannerHelper;
import com.ibm.xml.xlxp.scan.DocumentEntityScanner;
import com.ibm.xml.xlxp.scan.Version;
import com.ibm.xml.xlxp.scan.util.DTDGrammar;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.scan.util.QName;
import com.ibm.xml.xlxp.scan.util.SymbolTable;
import com.ibm.xml.xlxp.scan.util.XMLString;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;
import java.io.InputStream;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.DeclHandler;

public class WSXMLReader
extends SAX2ParserBase
implements SAX2ParserCallbacks {
    protected static final String XLXP_PROPERTIES_PREFIX = "http://ibm.com/xlxp/properties/";
    protected static final int ELEMENT_EVENT_EMPTY = 0;
    protected static final int ELEMENT_EVENT_START = 1;
    protected static final int ELEMENT_EVENT_INVALID = 2;
    protected DocumentEntityScanner fScanner = new DocumentEntityScanner();
    protected SAX2ParsedEntityFactory fEntityFactory = new SAX2ParsedEntityFactory(this.fBufferFactory, this.fStringBuffer);
    protected SAX2DTDScanner fDTDScanner;
    protected DTDGrammar fDTDGrammar;
    protected WSScannerHelper fHelper;
    private boolean[] fInElementContentStack = new boolean[16];
    protected int fElementEventState = 2;

    public WSXMLReader() {
        this(true);
    }

    protected WSXMLReader(boolean bl) {
        if (bl) {
            this.initialize();
        }
    }

    protected void initialize() {
        this.fHelper = this.createScannerHelper();
        this.fDTDScanner = this.createSAX2DTDScanner();
    }

    protected void reset(boolean bl) {
        super.reset(bl);
        this.fHelper.reset(bl);
        this.fDTDScanner.reset(bl);
        this.fEntityFactory.reset(bl);
        this.fElementEventState = 2;
    }

    protected WSScannerHelper createScannerHelper() {
        WSScannerHelper wSScannerHelper = new WSScannerHelper(this.fScanner, this.fBufferFactory, this.fSymbolTable, this.fStringBuffer, this);
        return wSScannerHelper;
    }

    protected SAX2DTDScanner createSAX2DTDScanner() {
        return new SAX2DTDScanner(this.fHelper, this.fScanner, this.fSymbolTable, this.fStringBuffer, this.fEntityFactory, this.fBufferFactory, this, this.fSymbolStringMappings);
    }

    protected void parseEvents(InputSource inputSource) {
        this.fHelper.setNamespaceAwareness(this.fNamespaces);
        ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntity(inputSource);
        if (parsedEntity != null) {
            this.fHelper.parseDocumentEntity(parsedEntity);
        }
    }

    protected boolean pushInElementContent(boolean bl) {
        if (this.fElementDepth == this.fInElementContentStack.length) {
            boolean[] blArray = new boolean[this.fElementDepth << 1];
            System.arraycopy(this.fInElementContentStack, 0, blArray, 0, this.fElementDepth);
            this.fInElementContentStack = blArray;
        }
        this.fInElementContentStack[this.fElementDepth] = this.fInElementContent;
        return bl;
    }

    protected boolean popInElementContent() {
        boolean bl = this.fInElementContentStack[this.fElementDepth];
        return bl;
    }

    protected void startElementAction(QName qName, boolean bl) {
        this.fElementEventState = bl ? 0 : 1;
        super.startElementAction(qName, bl);
        this.fElementEventState = 2;
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith(XLXP_PROPERTIES_PREFIX)) {
            String string2 = string.substring(XLXP_PROPERTIES_PREFIX.length());
            if (string2.equals("subtree-as-stream")) {
                if (this.fElementEventState == 2) {
                    throw new SAXNotSupportedException(string);
                }
                return this.subtreeAsStream();
            }
            if (string2.equals("build-time-stamp")) {
                return Version.getBuildTimeStamp();
            }
        }
        return super.getProperty(string);
    }

    public void setGrammar(DTDGrammar dTDGrammar) {
        this.fDTDGrammar = dTDGrammar;
    }

    public void endDTD() {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.endDTD();
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public boolean skippedExternalSubsetEntity() {
        if (this.fContentHandler != null) {
            try {
                this.fContentHandler.skippedEntity("[dtd]");
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
        return true;
    }

    public boolean skippedEntityInContent(int n) {
        if (this.fContentHandler != null) {
            try {
                this.fContentHandler.skippedEntity(this.handleToString(n));
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
        return true;
    }

    public void startDTDEntity() {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.startEntity("[dtd]");
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void endDTDEntity() {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.endEntity("[dtd]");
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void startPE(XMLString xMLString) {
        if (this.fLexicalHandler != null) {
            try {
                String string = xMLString.toString();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('%');
                stringBuffer.append(string);
                string = stringBuffer.toString();
                this.fLexicalHandler.startEntity(string);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void endPE(XMLString xMLString) {
        if (this.fLexicalHandler != null) {
            try {
                String string = xMLString.toString();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('%');
                stringBuffer.append(string);
                string = stringBuffer.toString();
                this.fLexicalHandler.endEntity(string);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    protected void pushElement(QName qName) {
        if (this.fDTDGrammar != null && this.fDTDGrammar.hasElementContentElements()) {
            this.fInElementContent = this.pushInElementContent(this.fDTDGrammar.hasElementContent(qName.handle));
        }
    }

    protected void popElement() {
        if (this.fDTDGrammar != null && this.fDTDGrammar.hasElementContentElements()) {
            this.fInElementContent = this.popInElementContent();
        }
    }

    protected boolean getScanExternalGeneralEntities(String string) {
        return this.fDTDScanner.getScanExternalGeneralEntities();
    }

    protected void setScanExternalGeneralEntities(String string, boolean bl) {
        this.fDTDScanner.setScanExternalGeneralEntities(bl);
    }

    protected boolean getScanExternalParameterEntities(String string) {
        return this.fDTDScanner.getScanExternalParameterEntities();
    }

    protected void setScanExternalParameterEntities(String string, boolean bl) {
        this.fDTDScanner.setScanExternalParameterEntities(bl);
    }

    protected DeclHandler getDeclHandler() {
        return this.fDTDScanner.getDeclHandler();
    }

    protected void setDeclHandler(DeclHandler declHandler) {
        this.fDTDScanner.setDeclHandler(declHandler);
    }

    public DTDHandler getDTDHandler() {
        return this.fDTDScanner.getDTDHandler();
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.fDTDScanner.setDTDHandler(dTDHandler);
    }

    public EntityResolver getEntityResolver() {
        return this.fEntityFactory.getEntityResolver();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.fEntityFactory.setEntityResolver(entityResolver);
    }

    protected InputStream subtreeAsStream() {
        ParsedEntityStream parsedEntityStream = new ParsedEntityStream(this.fStringBuffer);
        XMLString xMLString = parsedEntityStream.skippedContent();
        if (this.fElementEventState == 1) {
            if (this.fHelper.skipSubtree(xMLString)) {
                return parsedEntityStream;
            }
            return null;
        }
        this.fStringBuffer.setStringValues(0, 0, xMLString);
        return parsedEntityStream;
    }

    static final class WSScannerHelper
    extends SimpleDTDScannerHelper {
        private WSXMLReader fParser;

        public WSScannerHelper(DocumentEntityScanner documentEntityScanner, DataBufferFactory dataBufferFactory, SymbolTable symbolTable, XMLStringBuffer xMLStringBuffer, WSXMLReader wSXMLReader) {
            super(documentEntityScanner, dataBufferFactory, symbolTable, xMLStringBuffer);
            this.fParser = wSXMLReader;
        }

        public boolean skipSubtree(XMLString xMLString) {
            if (this.fCurrentEntity.unbuffered) {
                return this.fDocumentEntityScanner.skipContentUnbuffered(xMLString);
            }
            return this.fDocumentEntityScanner.skipContentBuffered(xMLString);
        }

        public boolean produceEmptyElementEvent() {
            boolean bl = super.produceEmptyElementEvent();
            this.fParser.startElementEvent(this.fElementType, this.fNSDecls, this.fAttributes, true);
            return bl;
        }

        public boolean produceStartElementEvent() {
            boolean bl = super.produceStartElementEvent();
            this.fParser.startElementEvent(this.fElementType, this.fNSDecls, this.fAttributes, false);
            return bl;
        }

        public boolean produceEndElementEvent(QName qName) {
            boolean bl = super.produceEndElementEvent(qName);
            this.fParser.endElementEvent(this.fElementType, this.fNSDecls);
            return bl;
        }

        public boolean produceCharactersEvent() {
            boolean bl = super.produceCharactersEvent();
            this.fParser.characters(this.fContent);
            return bl;
        }

        public boolean produceWhitespaceEvent() {
            boolean bl = super.produceWhitespaceEvent();
            this.fParser.whitespace(this.fContent);
            return bl;
        }

        public boolean produceCharacterEvent(int n) {
            boolean bl = super.produceCharacterEvent(n);
            this.fParser.character(n, false);
            return bl;
        }

        public boolean producePredefinedEntityEvent(int n) {
            boolean bl = super.producePredefinedEntityEvent(n);
            this.fParser.startEntity(this.fEntityName);
            this.fParser.character(n, true);
            this.fParser.endEntity(this.fEntityName);
            return bl;
        }

        public boolean produceProcessingInstructionEvent() {
            boolean bl = super.produceProcessingInstructionEvent();
            this.fParser.processingInstruction(this.fTarget, this.fContent);
            return bl;
        }

        public boolean produceCommentEvent() {
            boolean bl = super.produceCommentEvent();
            this.fParser.comment(this.fContent);
            return bl;
        }

        public boolean produceStartCDATASectionEvent() {
            boolean bl = super.produceStartCDATASectionEvent();
            this.fParser.startCDATASection();
            return bl;
        }

        public boolean produceEndCDATASectionEvent() {
            boolean bl = super.produceEndCDATASectionEvent();
            this.fParser.endCDATASection();
            return bl;
        }

        public boolean produceDoctypeEvent(boolean bl) {
            boolean bl2 = super.produceDoctypeEvent(bl);
            WSXMLReader.super.startDTD(this.fRootElementType, this.fPublicID, this.fSystemID, this.fInternalSubset);
            return bl2;
        }

        public boolean produceStartEntityEvent() {
            boolean bl = super.produceStartEntityEvent();
            this.fParser.startEntity(this.fEntityName);
            return bl;
        }

        public boolean produceEndEntityEvent() {
            boolean bl = super.produceEndEntityEvent();
            this.fParser.endEntity(this.fEntityName);
            return bl;
        }

        public boolean produceEntityReferenceEvent() {
            boolean bl = super.produceEntityReferenceEvent();
            this.fParser.skippedEntityInContent(this.fSymbolTable.addSymbol(this.fEntityName));
            return bl;
        }

        public boolean produceWarningEvent(String string, int n) {
            boolean bl = super.produceWarningEvent(string, n);
            this.fParser.reportWarning(this.fErrorURI, this.fErrorCode, this.fErrorParamsCount, this.fErrorParams);
            return bl;
        }

        public boolean produceRecoverableErrorEvent(String string, int n) {
            boolean bl = super.produceRecoverableErrorEvent(string, n);
            this.fParser.reportRecoverableError(this.fErrorURI, this.fErrorCode, this.fErrorParamsCount, this.fErrorParams);
            return bl;
        }

        public boolean produceFatalErrorEvent(String string, int n) {
            boolean bl = super.produceFatalErrorEvent(string, n);
            this.fParser.reportFatalError(this.fErrorURI, this.fErrorCode, this.fErrorParamsCount, this.fErrorParams);
            return bl;
        }
    }
}

