/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util.encoding;

import com.ibm.xml.xlxp.api.util.encoding.DataSourceFactory;
import com.ibm.xml.xlxp.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.scan.util.CharConversionError;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.DataSource;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import java.io.IOException;
import java.io.InputStream;

final class ByteStreamDataSource
implements DataSource {
    public ByteStreamDataSource nextFreeDataSource;
    public int bufferLength;
    public InputStream stream;
    public byte[] byteBuffer;
    public int byteOffset;
    public boolean checkForBOM;
    public boolean checkAvailable;
    private static final boolean CLEAR_TO_END_OF_BUFFER = false;
    private DataSourceFactory fSourceFactory;
    private DataBufferFactory fBufferFactory;
    private EncodingSupport fEncodingSupport;

    public ByteStreamDataSource(DataSourceFactory dataSourceFactory, DataBufferFactory dataBufferFactory, int n) {
        this.fSourceFactory = dataSourceFactory;
        this.fBufferFactory = dataBufferFactory;
        this.bufferLength = n;
        this.byteBuffer = new byte[n];
    }

    public void setByteStream(InputStream inputStream, EncodingSupport encodingSupport, boolean bl) {
        this.stream = inputStream;
        this.fEncodingSupport = encodingSupport;
        this.checkForBOM = bl;
        this.byteOffset = 0;
    }

    public CharConversionError load(ParsedEntity parsedEntity) {
        DataBuffer dataBuffer = this.fBufferFactory.createBuffer();
        byte[] byArray = dataBuffer.bytes;
        if (byArray == null) {
            byArray = dataBuffer.bytes = new byte[this.bufferLength + 3];
        }
        CharConversionError charConversionError = this.fEncodingSupport.load(this, dataBuffer);
        int n = dataBuffer.endOffset;
        byArray[n] = 0;
        dataBuffer.startOffset = 0;
        if (this.stream == null && this.byteOffset == 0) {
            parsedEntity.setValues(dataBuffer, 0, n, null);
            this.release();
        } else {
            parsedEntity.setValues(dataBuffer, 0, n, this);
        }
        dataBuffer.removeReference();
        return charConversionError;
    }

    public void release() {
        if (this.stream != null) {
            try {
                this.stream.close();
                this.stream = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fSourceFactory.releaseByteStreamDataSource(this);
    }
}

