/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.event;

import com.ibm.xml.xlxp.api.event.ScannerEvent;
import com.ibm.xml.xlxp.api.event.ScannerEventConsumer;
import com.ibm.xml.xlxp.api.util.NamespaceContext;
import com.ibm.xml.xlxp.api.util.SimpleDataBufferFactory;
import com.ibm.xml.xlxp.scan.DocumentEntityScanner;
import com.ibm.xml.xlxp.scan.ScannerHelper;
import com.ibm.xml.xlxp.scan.util.AttrList;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.NSDeclList;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.scan.util.QName;
import com.ibm.xml.xlxp.scan.util.SymbolTable;
import com.ibm.xml.xlxp.scan.util.XMLString;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;

public class SimpleScannerEventQueue
implements ScannerHelper {
    protected static final int ATTR_VALUE_NORMALIZED = 1;
    protected static final int ATTR_WAS_DEFAULTED = 2;
    protected static final int USE_HASHTABLE_ATTR_COUNT = 16;
    protected ScannerEventConsumer fEventConsumer;
    protected final DocumentEntityScanner fDocumentEntityScanner;
    protected final DataBufferFactory fBufferFactory;
    protected final SymbolTable fSymbolTable;
    protected final XMLStringBuffer fStringBuffer;
    protected final NamespaceContext fNamespaceContext;
    protected final XMLString fErrorString;
    protected final XMLString fEntityName;
    protected boolean fIsNamespaceAware;
    protected boolean fInElementContent;
    protected boolean fHasDefaultAttributes;
    protected boolean fSeenDefaultNamespaceMapping;
    protected boolean fSeenNSDecl;
    protected boolean fSeenAttrWithPrefix;
    protected int fCurAttName;
    protected int fCurAttVal;
    protected int fCurAttParam;
    protected int fNamespaceDeclPrefix;
    protected int fAttValueOffset;
    protected ParsedEntity fCurrentEntity;
    protected int fElementDepth;
    protected QName[] fElementTypeStack;
    protected int[] fElementEntityStack;
    protected int[] fAttrHashtable;
    protected int[] fNextAttrInBucket;
    protected final ScannerEvent.Document fStartDocumentProducer;
    protected final ScannerEvent.Document fEndDocumentProducer;
    protected final ScannerEvent.XMLDecl fXMLDeclProducer;
    protected final ScannerEvent.TextDecl fTextDeclProducer;
    protected final ScannerEvent.StartElement fEmptyElementProducer;
    protected final ScannerEvent.StartElement fStartElementProducer;
    protected final ScannerEvent.EndElement fEndElementProducer;
    protected final ScannerEvent.Characters fCharactersProducer;
    protected final ScannerEvent.Characters fWhitespaceProducer;
    protected final ScannerEvent.Character fCharacterProducer;
    protected final ScannerEvent.Character fPredefinedEntityProducer;
    protected final ScannerEvent.ProcessingInstruction fProcessingInstructionProducer;
    protected final ScannerEvent.Comment fCommentProducer;
    protected final ScannerEvent.CDATASection fStartCDATASectionProducer;
    protected final ScannerEvent.CDATASection fEndCDATASectionProducer;
    protected final ScannerEvent.Entity fStartEntityProducer;
    protected final ScannerEvent.Entity fEndEntityProducer;
    protected final ScannerEvent.Error fWarningProducer;
    protected final ScannerEvent.Error fRecoverableErrorProducer;
    protected final ScannerEvent.Error fFatalErrorProducer;
    protected final ScannerEvent.Document fStartDocumentEvent;
    protected final ScannerEvent.Document fEndDocumentEvent;
    protected final ScannerEvent.XMLDecl fXMLDeclEvent;
    protected final ScannerEvent.TextDecl fTextDeclEvent;
    protected final ScannerEvent.StartElement fEmptyElementEvent;
    protected final ScannerEvent.StartElement fStartElementEvent;
    protected final ScannerEvent.StartElement fLeafElementEvent;
    protected final ScannerEvent.EndElement fEndElementEvent;
    protected final ScannerEvent.Characters fCharactersEvent;
    protected final ScannerEvent.Characters fWhitespaceEvent;
    protected final ScannerEvent.Character fCharacterEvent;
    protected final ScannerEvent.Character fPredefinedEntityEvent;
    protected final ScannerEvent.ProcessingInstruction fProcessingInstructionEvent;
    protected final ScannerEvent.Comment fCommentEvent;
    protected final ScannerEvent.CDATASection fStartCDATASectionEvent;
    protected final ScannerEvent.CDATASection fEndCDATASectionEvent;
    protected final ScannerEvent.Entity fStartEntityEvent;
    protected final ScannerEvent.Entity fEndEntityEvent;
    protected final ScannerEvent.Error fWarningEvent;
    protected final ScannerEvent.Error fRecoverableErrorEvent;
    protected final ScannerEvent.Error fFatalErrorEvent;
    protected ScannerEvent fCurrentScannerEvent;
    protected int fCurrentEvent;
    protected int fLastEvent;
    protected ScannerEvent[] fEvents;
    protected int fCurrentEventParam;
    protected int fLastEventParam;
    protected int[] fEventParams;
    protected int fCurrentEventString;
    protected int fLastEventString;
    protected XMLString[] fEventStrings;
    protected int fCurrentEventQName;
    protected int fLastEventQName;
    protected QName[] fEventQNames;
    protected int fCurrentErrorURI;
    protected int fLastErrorURI;
    protected String[] fErrorURIs;
    protected int fCurrentErrorParam;
    protected int fLastErrorParam;
    protected int[] fErrorParams;
    protected int fCurrentErrorString;
    protected int fLastErrorString;
    protected XMLString[] fErrorStrings;

    public SimpleScannerEventQueue() {
        this(new DocumentEntityScanner(), new SimpleDataBufferFactory());
    }

    private SimpleScannerEventQueue(DocumentEntityScanner documentEntityScanner, DataBufferFactory dataBufferFactory) {
        this(documentEntityScanner, dataBufferFactory, new SymbolTable(dataBufferFactory), new XMLStringBuffer(dataBufferFactory));
    }

    public SimpleScannerEventQueue(DocumentEntityScanner documentEntityScanner, DataBufferFactory dataBufferFactory, SymbolTable symbolTable, XMLStringBuffer xMLStringBuffer) {
        this.fDocumentEntityScanner = documentEntityScanner;
        this.fBufferFactory = dataBufferFactory;
        this.fSymbolTable = symbolTable;
        this.fStringBuffer = xMLStringBuffer;
        this.fIsNamespaceAware = true;
        this.fNamespaceContext = new NamespaceContext(this, symbolTable);
        this.fErrorString = new XMLString();
        this.fEntityName = new XMLString();
        this.fStartDocumentEvent = this.createStartDocumentEvent();
        this.fEndDocumentEvent = this.createEndDocumentEvent();
        this.fXMLDeclEvent = this.createXMLDeclEvent();
        this.fTextDeclEvent = this.createTextDeclEvent();
        this.fEmptyElementEvent = this.createEmptyElementEvent();
        this.fStartElementEvent = this.createStartElementEvent();
        this.fLeafElementEvent = this.createLeafElementEvent();
        this.fEndElementEvent = this.createEndElementEvent();
        this.fCharactersEvent = this.createCharactersEvent();
        this.fWhitespaceEvent = this.createWhitespaceEvent();
        this.fCharacterEvent = this.createCharacterEvent();
        this.fPredefinedEntityEvent = this.createPredefinedEntityEvent();
        this.fProcessingInstructionEvent = this.createProcessingInstructionEvent();
        this.fCommentEvent = this.createCommentEvent();
        this.fStartCDATASectionEvent = this.createStartCDATASectionEvent();
        this.fEndCDATASectionEvent = this.createEndCDATASectionEvent();
        this.fStartEntityEvent = this.createStartEntityEvent();
        this.fEndEntityEvent = this.createEndEntityEvent();
        this.fWarningEvent = this.createWarningEvent();
        this.fRecoverableErrorEvent = this.createRecoverableErrorEvent();
        this.fFatalErrorEvent = this.createFatalErrorEvent();
        this.fStartDocumentProducer = this.createStartDocumentProducer();
        this.fEndDocumentProducer = this.createEndDocumentProducer();
        this.fXMLDeclProducer = this.createXMLDeclProducer();
        this.fTextDeclProducer = this.createTextDeclProducer();
        this.fEmptyElementProducer = this.createEmptyElementProducer();
        this.fStartElementProducer = this.createStartElementProducer();
        this.fEndElementProducer = this.createEndElementProducer();
        this.fCharactersProducer = this.createCharactersProducer();
        this.fWhitespaceProducer = this.createWhitespaceProducer();
        this.fCharacterProducer = this.createCharacterProducer();
        this.fPredefinedEntityProducer = this.createPredefinedEntityProducer();
        this.fProcessingInstructionProducer = this.createProcessingInstructionProducer();
        this.fCommentProducer = this.createCommentProducer();
        this.fStartCDATASectionProducer = this.createStartCDATASectionProducer();
        this.fEndCDATASectionProducer = this.createEndCDATASectionProducer();
        this.fStartEntityProducer = this.createStartEntityProducer();
        this.fEndEntityProducer = this.createEndEntityProducer();
        this.fWarningProducer = this.createWarningProducer();
        this.fRecoverableErrorProducer = this.createRecoverableErrorProducer();
        this.fFatalErrorProducer = this.createFatalErrorProducer();
        this.fElementTypeStack = new QName[32];
        this.fElementEntityStack = new int[32];
        this.fEvents = new ScannerEvent[16];
        this.fEventParams = new int[8];
        this.fEventStrings = new XMLString[8];
        this.fEventQNames = new QName[8];
        this.fErrorURIs = new String[8];
        this.fErrorParams = new int[8];
        this.fErrorStrings = new XMLString[8];
        int n = 0;
        while (n < this.fEventStrings.length) {
            this.fEventStrings[n] = new XMLString();
            ++n;
        }
        n = 0;
        while (n < this.fEventQNames.length) {
            this.fEventQNames[n] = new QName();
            ++n;
        }
        n = 0;
        while (n < this.fErrorStrings.length) {
            this.fErrorStrings[n] = new XMLString();
            ++n;
        }
        this.fDocumentEntityScanner.setScannerHelper(this);
    }

    public void reset(boolean bl) {
        this.fDocumentEntityScanner.reset(bl);
        this.fSymbolTable.reset(bl);
        this.fStringBuffer.reset(bl);
        this.fCurrentEvent = 0;
        this.fLastEvent = 0;
        this.fCurrentEventParam = 0;
        this.fLastEventParam = 0;
        this.fCurrentEventString = 0;
        this.fLastEventString = 0;
        this.fCurrentEventQName = 0;
        this.fLastEventQName = 0;
        this.fCurrentErrorURI = 0;
        this.fLastErrorURI = 0;
        this.fCurrentErrorParam = 0;
        this.fLastErrorParam = 0;
        this.fCurrentErrorString = 0;
        this.fLastErrorString = 0;
        this.fCurrentScannerEvent = null;
        this.fInElementContent = false;
        this.fSeenDefaultNamespaceMapping = false;
        this.fErrorParams[this.fLastErrorParam + 2] = 0;
        this.fElementDepth = 0;
        if (!bl) {
            int n = 0;
            while (n < this.fEventStrings.length) {
                if (this.fEventStrings[n].firstBuffer != null) {
                    this.fEventStrings[n].clear();
                }
                ++n;
            }
            n = 0;
            while (n < this.fEventQNames.length) {
                if (this.fEventQNames[n].firstBuffer != null) {
                    this.fEventQNames[n].clear();
                }
                ++n;
            }
            n = 0;
            while (n < this.fErrorStrings.length) {
                if (this.fErrorStrings[n].firstBuffer != null) {
                    this.fErrorStrings[n].clear();
                }
                ++n;
            }
            n = 0;
            while (n < this.fElementTypeStack.length) {
                if (this.fElementTypeStack[n] != null && this.fElementTypeStack[n].firstBuffer != null) {
                    this.fElementTypeStack[n].clear();
                }
                ++n;
            }
            n = 0;
            while (n < this.fElementTypeStack.length) {
                if (this.fElementTypeStack[n] == null) break;
                this.fElementTypeStack[n] = null;
                ++n;
            }
        }
    }

    public void setEventConsumer(ScannerEventConsumer scannerEventConsumer) {
        this.fEventConsumer = scannerEventConsumer;
    }

    public void setNamespaceAwareness(boolean bl) {
        this.fIsNamespaceAware = bl;
    }

    public NamespaceContext namespaceContext() {
        return this.fNamespaceContext;
    }

    public void parseDocumentEntity(ParsedEntity parsedEntity) {
        this.fCurrentEntity = parsedEntity;
        this.fDocumentEntityScanner.setDocumentEntity(parsedEntity);
        this.run();
    }

    protected void setDocumentEntity(ParsedEntity parsedEntity) {
        this.fCurrentEntity = parsedEntity;
        this.fDocumentEntityScanner.setDocumentEntity(parsedEntity);
    }

    public void initialize() {
        this.fNamespaceContext.initialize();
        this.rewindReader();
    }

    public void run() {
        block1: {
            ScannerEvent scannerEvent;
            do {
                this.rewindWriter();
                if (!this.fDocumentEntityScanner.produceEvents(false)) break block1;
                this.rewindReader();
            } while (!(this.fEventConsumer != null ? !this.fEventConsumer.consumeEvents() : (scannerEvent = this.nextEvent(2)) != null));
            return;
        }
    }

    public final ScannerEvent nextEvent(int n) {
        if (n == -1) {
            if (this.fCurrentEvent < this.fLastEvent) {
                if (this.fCurrentScannerEvent != null) {
                    this.advance(this.fCurrentScannerEvent.eventType);
                }
                this.fCurrentScannerEvent = this.fEvents[this.fCurrentEvent];
                ++this.fCurrentEvent;
                return this.fCurrentScannerEvent;
            }
            this.fCurrentScannerEvent = null;
            return null;
        }
        while (this.fCurrentEvent < this.fLastEvent) {
            if (this.fCurrentScannerEvent != null) {
                this.advance(this.fCurrentScannerEvent.eventType);
            }
            this.fCurrentScannerEvent = this.fEvents[this.fCurrentEvent];
            ++this.fCurrentEvent;
            if ((n & 1 << this.fCurrentScannerEvent.eventType) == 0) continue;
            return this.fCurrentScannerEvent;
        }
        this.fCurrentScannerEvent = null;
        return null;
    }

    protected void rewindWriter() {
        this.fLastEvent = 0;
        this.fLastEventParam = 0;
        this.fLastEventString = 0;
        this.fLastEventQName = 0;
        this.fLastErrorURI = 0;
        this.fLastErrorParam = 0;
        this.fLastErrorString = 0;
        this.fErrorParams[this.fLastErrorParam + 2] = 0;
    }

    protected void rewindReader() {
        this.fCurrentEvent = 0;
        this.fCurrentEventParam = 0;
        this.fCurrentEventString = 0;
        this.fCurrentEventQName = 0;
        this.fCurrentErrorURI = 0;
        this.fCurrentErrorParam = 0;
        this.fCurrentErrorString = 0;
        this.fCurrentScannerEvent = null;
    }

    protected void advance(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 23: {
                break;
            }
            case 14: 
            case 15: {
                ++this.fCurrentEventParam;
                break;
            }
            case 6: {
                ++this.fCurrentEventString;
            }
            case 4: 
            case 5: {
                int n2 = this.fEventParams[this.fCurrentEventParam + 1];
                this.fCurrentEventParam += 2 + (n2 << 1);
                this.fCurrentEventString += n2;
                this.fCurrentEventQName += 1 + n2;
                break;
            }
            case 7: {
                ++this.fCurrentEventParam;
                ++this.fCurrentEventQName;
                break;
            }
            case 2: {
                this.fCurrentEventString += 3;
                break;
            }
            case 3: {
                this.fCurrentEventString += 2;
                break;
            }
            case 8: 
            case 9: {
                ++this.fCurrentEventParam;
                ++this.fCurrentEventString;
                break;
            }
            case 10: 
            case 11: {
                this.fCurrentEventParam += 2;
                break;
            }
            case 12: {
                ++this.fCurrentEventParam;
                this.fCurrentEventString += 2;
                break;
            }
            case 13: {
                ++this.fCurrentEventParam;
                ++this.fCurrentEventString;
                break;
            }
            case 16: {
                this.fCurrentEventString += 3;
                ++this.fCurrentEventParam;
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                ++this.fCurrentEventParam;
                ++this.fCurrentEventString;
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                int n3 = this.fErrorParams[this.fCurrentErrorParam + 2];
                ++this.fCurrentErrorURI;
                this.fCurrentErrorParam += 5;
                this.fCurrentErrorString += n3;
            }
        }
    }

    public boolean reportWarning(String string, int n) {
        return this.produceWarningEvent(string, n);
    }

    public boolean reportRecoverableError(String string, int n) {
        return this.produceRecoverableErrorEvent(string, n);
    }

    public boolean reportFatalError(String string, int n) {
        return this.produceFatalErrorEvent(string, n);
    }

    public void setParameter(int n, String string) {
        this.fStringBuffer.addString(string, this.fErrorString);
        this.setParameter(n, this.fErrorString);
    }

    public void setParameter(int n, int n2) {
        this.fSymbolTable.setStringValues(n2, this.fErrorString);
        this.setParameter(n, this.fErrorString);
    }

    public void setParameter(int n, QName qName) {
        this.setParameter(n, qName.handle);
    }

    public void setInvalidCharParameter(int n, int n2) {
        this.setParameter(n, Integer.toHexString(n2));
    }

    protected void checkQueueLength(int n) {
        if (this.fLastEvent + n < this.fEvents.length) {
            return;
        }
        this.growQueue();
    }

    protected void checkParamLength(int n) {
        if (this.fLastEventParam + n < this.fEventParams.length) {
            return;
        }
        this.growParams();
    }

    protected void checkStringLength(int n) {
        if (this.fLastEventString + n < this.fEventStrings.length) {
            return;
        }
        this.growStrings();
    }

    protected void checkQNameLength(int n) {
        if (this.fLastEventQName + n < this.fEventQNames.length) {
            return;
        }
        this.growQNames();
    }

    protected void checkErrorURILength(int n) {
        if (this.fLastErrorURI + n < this.fErrorURIs.length) {
            return;
        }
        this.growErrorURIs();
    }

    protected void checkErrorParamLength(int n) {
        if (this.fLastErrorParam + n < this.fErrorParams.length) {
            return;
        }
        this.growErrorParams();
    }

    protected void checkErrorStringLength(int n) {
        if (this.fLastErrorString + n < this.fErrorStrings.length) {
            return;
        }
        this.growErrorStrings();
    }

    protected void addEventToQueue(ScannerEvent scannerEvent) {
        this.checkQueueLength(2);
        this.fEvents[this.fLastEvent] = scannerEvent;
        ++this.fLastEvent;
    }

    protected void addParamsToQueue(int n) {
        this.fLastEventParam += n;
        this.checkParamLength(2);
    }

    protected void addStringsToQueue(int n) {
        this.fLastEventString += n;
        this.checkStringLength(3);
    }

    private void addQNamesToQueue(int n) {
        this.fLastEventQName += n;
        this.checkQNameLength(1);
    }

    private void addErrorURIsToQueue(int n) {
        this.fLastErrorURI += n;
        this.checkErrorURILength(1);
    }

    private void addErrorParamsToQueue(int n) {
        this.fLastErrorParam += n;
        this.checkErrorParamLength(5);
    }

    protected boolean commitDocumentEvent(ScannerEvent.Document document, ScannerEvent.Document document2) {
        this.addEventToQueue(document);
        return document == this.fStartDocumentEvent;
    }

    public final boolean produceStartDocumentEvent() {
        return this.commitDocumentEvent(this.fStartDocumentEvent, this.fStartDocumentProducer);
    }

    public final boolean produceEndDocumentEvent() {
        return this.commitDocumentEvent(this.fEndDocumentEvent, this.fEndDocumentProducer);
    }

    public final ScannerEvent.Document startDocumentProducer() {
        return this.fStartDocumentProducer;
    }

    public final ScannerEvent.Document endDocumentProducer() {
        return this.fEndDocumentProducer;
    }

    private ScannerEvent.Document createStartDocumentEvent() {
        DocumentEvent documentEvent = new DocumentEvent(0);
        return documentEvent;
    }

    private ScannerEvent.Document createEndDocumentEvent() {
        DocumentEvent documentEvent = new DocumentEvent(1);
        return documentEvent;
    }

    private ScannerEvent.Document createStartDocumentProducer() {
        DocumentProducer documentProducer = new DocumentProducer(0);
        return documentProducer;
    }

    private ScannerEvent.Document createEndDocumentProducer() {
        DocumentProducer documentProducer = new DocumentProducer(1);
        return documentProducer;
    }

    public final XMLString versionToProduce() {
        return this.fEventStrings[this.fLastEventString];
    }

    public final XMLString encNameToProduce() {
        return this.fEventStrings[this.fLastEventString + 1];
    }

    public final XMLString standaloneToProduce() {
        return this.fEventStrings[this.fLastEventString + 2];
    }

    protected boolean commitXMLDeclEvent(ScannerEvent.XMLDecl xMLDecl, ScannerEvent.XMLDecl xMLDecl2) {
        this.addStringsToQueue(3);
        this.addEventToQueue(xMLDecl);
        return true;
    }

    public final boolean produceXMLDeclEvent() {
        return this.commitXMLDeclEvent(this.fXMLDeclEvent, this.fXMLDeclProducer);
    }

    public final ScannerEvent.XMLDecl xmlDeclProducer() {
        return this.fXMLDeclProducer;
    }

    private ScannerEvent.XMLDecl createXMLDeclEvent() {
        XMLDeclEvent xMLDeclEvent = new XMLDeclEvent();
        return xMLDeclEvent;
    }

    private ScannerEvent.XMLDecl createXMLDeclProducer() {
        XMLDeclProducer xMLDeclProducer = new XMLDeclProducer();
        return xMLDeclProducer;
    }

    protected boolean commitTextDeclEvent(ScannerEvent.TextDecl textDecl, ScannerEvent.TextDecl textDecl2) {
        this.addStringsToQueue(2);
        this.addEventToQueue(textDecl);
        return true;
    }

    public final boolean produceTextDeclEvent() {
        return this.commitTextDeclEvent(this.fTextDeclEvent, this.fTextDeclProducer);
    }

    public final ScannerEvent.TextDecl textDeclProducer() {
        return this.fTextDeclProducer;
    }

    private ScannerEvent.TextDecl createTextDeclEvent() {
        TextDeclEvent textDeclEvent = new TextDeclEvent();
        return textDeclEvent;
    }

    private ScannerEvent.TextDecl createTextDeclProducer() {
        TextDeclProducer textDeclProducer = new TextDeclProducer();
        return textDeclProducer;
    }

    protected boolean commitStartElementEvent(ScannerEvent.StartElement startElement, ScannerEvent.StartElement startElement2) {
        int n = this.fEventParams[this.fLastEventParam + 1];
        this.addQNamesToQueue(1 + n);
        this.addStringsToQueue(n);
        this.addParamsToQueue(2 + (n << 1));
        this.addEventToQueue(startElement);
        return false;
    }

    public final boolean produceEmptyElementEvent() {
        return this.commitStartElementEvent(this.fEmptyElementEvent, this.fEmptyElementProducer);
    }

    public final boolean produceStartElementEvent() {
        return this.commitStartElementEvent(this.fStartElementEvent, this.fStartElementProducer);
    }

    public final ScannerEvent.StartElement emptyElementProducer() {
        return this.fEmptyElementProducer;
    }

    public final ScannerEvent.StartElement startElementProducer() {
        return this.fStartElementProducer;
    }

    private ScannerEvent.StartElement createEmptyElementEvent() {
        StartElementEvent startElementEvent = new StartElementEvent(4);
        return startElementEvent;
    }

    private ScannerEvent.StartElement createStartElementEvent() {
        StartElementEvent startElementEvent = new StartElementEvent(5);
        return startElementEvent;
    }

    private ScannerEvent.StartElement createLeafElementEvent() {
        StartElementEvent startElementEvent = new StartElementEvent(6);
        return startElementEvent;
    }

    private ScannerEvent.StartElement createEmptyElementProducer() {
        StartElementProducer startElementProducer = new StartElementProducer(4);
        return startElementProducer;
    }

    private ScannerEvent.StartElement createStartElementProducer() {
        StartElementProducer startElementProducer = new StartElementProducer(5);
        return startElementProducer;
    }

    protected boolean commitEndElementEvent(ScannerEvent.EndElement endElement, ScannerEvent.EndElement endElement2) {
        this.addQNamesToQueue(1);
        this.addParamsToQueue(1);
        this.addEventToQueue(endElement);
        return false;
    }

    public final boolean produceEndElementEvent(QName qName) {
        this.fEventQNames[this.fLastEventQName].setValues(qName);
        this.fEventParams[this.fLastEventParam] = this.endNamespacesScope();
        return this.commitEndElementEvent(this.fEndElementEvent, this.fEndElementProducer);
    }

    public final ScannerEvent.EndElement endElementProducer() {
        return this.fEndElementProducer;
    }

    private ScannerEvent.EndElement createEndElementEvent() {
        EndElementEvent endElementEvent = new EndElementEvent();
        return endElementEvent;
    }

    private ScannerEvent.EndElement createEndElementProducer() {
        EndElementProducer endElementProducer = new EndElementProducer();
        return endElementProducer;
    }

    public final XMLString contentToProduce() {
        return this.fEventStrings[this.fLastEventString];
    }

    protected boolean commitCharactersEvent(ScannerEvent.Characters characters, ScannerEvent.Characters characters2) {
        this.addParamsToQueue(1);
        this.addStringsToQueue(1);
        this.addEventToQueue(characters);
        return true;
    }

    public final boolean produceCharactersEvent() {
        this.fEventParams[this.fLastEventParam] = this.fNamespaceContext.currentContext();
        return this.commitCharactersEvent(this.fCharactersEvent, this.fCharactersProducer);
    }

    public final boolean produceWhitespaceEvent() {
        this.fEventParams[this.fLastEventParam] = this.fNamespaceContext.currentContext();
        return this.commitCharactersEvent(this.fWhitespaceEvent, this.fWhitespaceProducer);
    }

    public final ScannerEvent.Characters charactersProducer() {
        return this.fCharactersProducer;
    }

    public final ScannerEvent.Characters whitespaceProducer() {
        return this.fWhitespaceProducer;
    }

    private ScannerEvent.Characters createCharactersEvent() {
        CharactersEvent charactersEvent = new CharactersEvent(8);
        return charactersEvent;
    }

    private ScannerEvent.Characters createWhitespaceEvent() {
        CharactersEvent charactersEvent = new CharactersEvent(9);
        return charactersEvent;
    }

    private ScannerEvent.Characters createCharactersProducer() {
        CharactersProducer charactersProducer = new CharactersProducer(8);
        return charactersProducer;
    }

    private ScannerEvent.Characters createWhitespaceProducer() {
        CharactersProducer charactersProducer = new CharactersProducer(9);
        return charactersProducer;
    }

    public final XMLString entityNameToProduce() {
        return this.fEntityName;
    }

    protected boolean commitCharacterEvent(ScannerEvent.Character character, ScannerEvent.Character character2) {
        this.addParamsToQueue(2);
        this.addEventToQueue(character);
        return true;
    }

    public final boolean produceCharacterEvent(int n) {
        this.fEventParams[this.fLastEventParam] = this.fNamespaceContext.currentContext();
        this.fEventParams[this.fLastEventParam + 1] = n;
        return this.commitCharacterEvent(this.fCharacterEvent, this.fCharacterProducer);
    }

    public final boolean producePredefinedEntityEvent(int n) {
        if (!this.produceStartEntityEvent()) {
            return false;
        }
        this.fEventParams[this.fLastEventParam] = this.fNamespaceContext.currentContext();
        this.fEventParams[this.fLastEventParam + 1] = n;
        if (!this.commitCharacterEvent(this.fPredefinedEntityEvent, this.fPredefinedEntityProducer)) {
            return false;
        }
        return this.produceEndEntityEvent();
    }

    public final ScannerEvent.Character characterProducer() {
        return this.fCharacterProducer;
    }

    public final ScannerEvent.Character predefinedEntityProducer() {
        return this.fPredefinedEntityProducer;
    }

    private ScannerEvent.Character createCharacterEvent() {
        CharacterEvent characterEvent = new CharacterEvent(10);
        return characterEvent;
    }

    private ScannerEvent.Character createPredefinedEntityEvent() {
        CharacterEvent characterEvent = new CharacterEvent(11);
        return characterEvent;
    }

    private ScannerEvent.Character createCharacterProducer() {
        CharacterProducer characterProducer = new CharacterProducer(10);
        return characterProducer;
    }

    private ScannerEvent.Character createPredefinedEntityProducer() {
        CharacterProducer characterProducer = new CharacterProducer(11);
        return characterProducer;
    }

    public final XMLString targetToProduce() {
        return this.fEventStrings[this.fLastEventString + 1];
    }

    protected boolean commitProcessingInstructionEvent(ScannerEvent.ProcessingInstruction processingInstruction, ScannerEvent.ProcessingInstruction processingInstruction2) {
        this.addParamsToQueue(1);
        this.addStringsToQueue(2);
        this.addEventToQueue(processingInstruction);
        return true;
    }

    public final boolean produceProcessingInstructionEvent() {
        this.fEventParams[this.fLastEventParam] = this.fNamespaceContext.currentContext();
        return this.commitProcessingInstructionEvent(this.fProcessingInstructionEvent, this.fProcessingInstructionProducer);
    }

    public final ScannerEvent.ProcessingInstruction processingInstructionProducer() {
        return this.fProcessingInstructionProducer;
    }

    private ScannerEvent.ProcessingInstruction createProcessingInstructionEvent() {
        ProcessingInstructionEvent processingInstructionEvent = new ProcessingInstructionEvent();
        return processingInstructionEvent;
    }

    private ScannerEvent.ProcessingInstruction createProcessingInstructionProducer() {
        ProcessingInstructionProducer processingInstructionProducer = new ProcessingInstructionProducer();
        return processingInstructionProducer;
    }

    protected boolean commitCommentEvent(ScannerEvent.Comment comment, ScannerEvent.Comment comment2) {
        this.addParamsToQueue(1);
        this.addStringsToQueue(1);
        this.addEventToQueue(comment);
        return true;
    }

    public final boolean produceCommentEvent() {
        this.fEventParams[this.fLastEventParam] = this.fNamespaceContext.currentContext();
        return this.commitCommentEvent(this.fCommentEvent, this.fCommentProducer);
    }

    public final ScannerEvent.Comment commentProducer() {
        return this.fCommentProducer;
    }

    private ScannerEvent.Comment createCommentEvent() {
        CommentEvent commentEvent = new CommentEvent();
        return commentEvent;
    }

    private ScannerEvent.Comment createCommentProducer() {
        CommentProducer commentProducer = new CommentProducer();
        return commentProducer;
    }

    protected boolean commitCDATASectionEvent(ScannerEvent.CDATASection cDATASection, ScannerEvent.CDATASection cDATASection2) {
        this.addParamsToQueue(1);
        this.addEventToQueue(cDATASection);
        return true;
    }

    public final boolean produceStartCDATASectionEvent() {
        this.fEventParams[this.fLastEventParam] = this.fNamespaceContext.currentContext();
        return this.commitCDATASectionEvent(this.fStartCDATASectionEvent, this.fStartCDATASectionProducer);
    }

    public final boolean produceEndCDATASectionEvent() {
        this.fEventParams[this.fLastEventParam] = this.fNamespaceContext.currentContext();
        return this.commitCDATASectionEvent(this.fEndCDATASectionEvent, this.fEndCDATASectionProducer);
    }

    public final ScannerEvent.CDATASection startCDATASectionProducer() {
        return this.fStartCDATASectionProducer;
    }

    public final ScannerEvent.CDATASection endCDATASectionProducer() {
        return this.fEndCDATASectionProducer;
    }

    private ScannerEvent.CDATASection createStartCDATASectionEvent() {
        CDATASectionEvent cDATASectionEvent = new CDATASectionEvent(14);
        return cDATASectionEvent;
    }

    private ScannerEvent.CDATASection createEndCDATASectionEvent() {
        CDATASectionEvent cDATASectionEvent = new CDATASectionEvent(15);
        return cDATASectionEvent;
    }

    private ScannerEvent.CDATASection createStartCDATASectionProducer() {
        CDATASectionProducer cDATASectionProducer = new CDATASectionProducer(14);
        return cDATASectionProducer;
    }

    private ScannerEvent.CDATASection createEndCDATASectionProducer() {
        CDATASectionProducer cDATASectionProducer = new CDATASectionProducer(15);
        return cDATASectionProducer;
    }

    protected boolean commitEntityEvent(ScannerEvent.Entity entity, ScannerEvent.Entity entity2) {
        this.addParamsToQueue(1);
        this.addStringsToQueue(1);
        this.addEventToQueue(entity);
        return true;
    }

    public final boolean produceStartEntityEvent() {
        this.fEventParams[this.fLastEventParam] = this.fNamespaceContext.currentContext();
        this.fEventStrings[this.fLastEventString].setValues(this.fEntityName);
        return this.commitEntityEvent(this.fStartEntityEvent, this.fStartEntityProducer);
    }

    public final boolean produceEndEntityEvent() {
        this.fEventParams[this.fLastEventParam] = this.fNamespaceContext.currentContext();
        this.fEventStrings[this.fLastEventString].setValues(this.fEntityName);
        return this.commitEntityEvent(this.fEndEntityEvent, this.fEndEntityProducer);
    }

    public final ScannerEvent.Entity startEntityProducer() {
        return this.fStartEntityProducer;
    }

    public final ScannerEvent.Entity endEntityProducer() {
        return this.fEndEntityProducer;
    }

    private ScannerEvent.Entity createStartEntityEvent() {
        EntityEvent entityEvent = new EntityEvent(17);
        return entityEvent;
    }

    private ScannerEvent.Entity createEndEntityEvent() {
        EntityEvent entityEvent = new EntityEvent(18);
        return entityEvent;
    }

    private ScannerEvent.Entity createStartEntityProducer() {
        EntityProducer entityProducer = new EntityProducer(17);
        return entityProducer;
    }

    private ScannerEvent.Entity createEndEntityProducer() {
        EntityProducer entityProducer = new EntityProducer(18);
        return entityProducer;
    }

    protected boolean commitErrorEvent(ScannerEvent.Error error, ScannerEvent.Error error2) {
        this.addErrorURIsToQueue(1);
        this.fErrorParams[this.fLastErrorParam + 3] = 0;
        this.fErrorParams[this.fLastErrorParam + 4] = 0;
        this.fLastErrorString += this.fErrorParams[this.fLastErrorParam + 2];
        this.addErrorParamsToQueue(5);
        this.fErrorParams[this.fLastErrorParam + 2] = 0;
        this.addEventToQueue(error);
        return error.eventType != 22;
    }

    public final boolean produceWarningEvent(String string, int n) {
        this.fErrorURIs[this.fLastErrorURI] = string;
        this.fErrorParams[this.fLastErrorParam] = this.fNamespaceContext.currentContext();
        this.fErrorParams[this.fLastErrorParam + 1] = n;
        return this.commitErrorEvent(this.fWarningEvent, this.fWarningProducer);
    }

    public final boolean produceRecoverableErrorEvent(String string, int n) {
        this.fErrorURIs[this.fLastErrorURI] = string;
        this.fErrorParams[this.fLastErrorParam] = this.fNamespaceContext.currentContext();
        this.fErrorParams[this.fLastErrorParam + 1] = n;
        return this.commitErrorEvent(this.fRecoverableErrorEvent, this.fRecoverableErrorProducer);
    }

    public final boolean produceFatalErrorEvent(String string, int n) {
        this.fErrorURIs[this.fLastErrorURI] = string;
        this.fErrorParams[this.fLastErrorParam] = this.fNamespaceContext.currentContext();
        this.fErrorParams[this.fLastErrorParam + 1] = n;
        return this.commitErrorEvent(this.fFatalErrorEvent, this.fFatalErrorProducer);
    }

    public final ScannerEvent.Error warningProducer() {
        return this.fWarningProducer;
    }

    public final ScannerEvent.Error recoverableErrorProducer() {
        return this.fRecoverableErrorProducer;
    }

    public final ScannerEvent.Error fatalErrorProducer() {
        return this.fFatalErrorProducer;
    }

    private ScannerEvent.Error createWarningEvent() {
        ErrorEvent errorEvent = new ErrorEvent(20);
        return errorEvent;
    }

    private ScannerEvent.Error createRecoverableErrorEvent() {
        ErrorEvent errorEvent = new ErrorEvent(21);
        return errorEvent;
    }

    private ScannerEvent.Error createFatalErrorEvent() {
        ErrorEvent errorEvent = new ErrorEvent(22);
        return errorEvent;
    }

    private ScannerEvent.Error createWarningProducer() {
        ErrorProducer errorProducer = new ErrorProducer(20);
        return errorProducer;
    }

    private ScannerEvent.Error createRecoverableErrorProducer() {
        ErrorProducer errorProducer = new ErrorProducer(21);
        return errorProducer;
    }

    private ScannerEvent.Error createFatalErrorProducer() {
        ErrorProducer errorProducer = new ErrorProducer(22);
        return errorProducer;
    }

    protected boolean commitExtensionEvent(ScannerEvent.Extension extension) {
        this.addEventToQueue(extension);
        return true;
    }

    public boolean produceExtensionEvent(ScannerEvent.Extension extension) {
        return this.commitExtensionEvent(extension);
    }

    public int scanQName(ParsedEntity parsedEntity, QName qName) {
        if (this.fIsNamespaceAware) {
            if (parsedEntity.unbuffered) {
                return this.fSymbolTable.scanQNameUnbuffered(parsedEntity, qName);
            }
            return this.fSymbolTable.scanQNameBuffered(parsedEntity, qName);
        }
        return this.fSymbolTable.scanName(parsedEntity, qName);
    }

    public int scanNCName(ParsedEntity parsedEntity, XMLString xMLString) {
        if (this.fIsNamespaceAware) {
            return this.fSymbolTable.scanNCName(parsedEntity, xMLString);
        }
        return this.fSymbolTable.scanName(parsedEntity, xMLString);
    }

    public boolean scanAttrValueBuffered(ParsedEntity parsedEntity, XMLString xMLString, int n) {
        return this.fDocumentEntityScanner.scanAttrValueBuffered(xMLString, n);
    }

    public boolean scanAttrValueUnbuffered(ParsedEntity parsedEntity, XMLString xMLString, int n) {
        return this.fDocumentEntityScanner.scanAttrValueUnbuffered(xMLString, n);
    }

    public boolean scanNamespaceURIBuffered(ParsedEntity parsedEntity, XMLString xMLString, int n) {
        return this.fDocumentEntityScanner.scanNamespaceURIBuffered(xMLString, n);
    }

    public boolean scanNamespaceURIUnbuffered(ParsedEntity parsedEntity, XMLString xMLString, int n) {
        return this.fDocumentEntityScanner.scanNamespaceURIUnbuffered(xMLString, n);
    }

    private int startNamespacesScope() {
        return this.fIsNamespaceAware || this.fElementDepth == 0 ? this.fNamespaceContext.startNamespacesScope() : this.fNamespaceContext.currentContext();
    }

    private int endNamespacesScope() {
        return this.fIsNamespaceAware || this.fElementDepth == 0 ? this.fNamespaceContext.endNamespacesScope() : this.fNamespaceContext.currentContext();
    }

    public QName setupStartElement() {
        if (this.fElementDepth == 0) {
            this.fHasDefaultAttributes = this.fDocumentEntityScanner.hasDefaultAttributes();
        }
        this.fEventParams[this.fLastEventParam] = this.startNamespacesScope();
        this.fEventParams[this.fLastEventParam + 1] = 0;
        this.fCurAttName = this.fLastEventQName + 1;
        this.fCurAttVal = this.fLastEventString;
        this.fCurAttParam = this.fLastEventParam + 2;
        this.checkAttrLength();
        this.fSeenAttrWithPrefix = false;
        this.fSeenNSDecl = false;
        return this.fEventQNames[this.fLastEventQName];
    }

    public QName currentElementType() {
        return this.fEventQNames[this.fLastEventQName];
    }

    public QName currentAttributeName() {
        return this.fEventQNames[this.fCurAttName];
    }

    public XMLString setupSpecifiedAttribute() {
        this.processAttributeName(this.fEventQNames[this.fCurAttName], true);
        return this.fEventStrings[this.fCurAttVal];
    }

    public boolean addSpecifiedAttribute() {
        if (this.fNamespaceDeclPrefix == -1) {
            return this.saveSpecifiedAttValue();
        }
        return this.saveSpecifiedNamespaceURI();
    }

    public boolean addDefaultNSDecl(QName qName, XMLString xMLString) {
        if (this.fIsNamespaceAware) {
            this.processAttributeName(qName, false);
            return this.saveNamespaceDecl(qName, xMLString);
        }
        return this.addDefaultAttribute(qName, 14, xMLString);
    }

    public boolean addDefaultAttribute(QName qName, int n, XMLString xMLString) {
        this.processAttributeName(qName, false);
        this.fEventQNames[this.fCurAttName].setValues(qName);
        this.fEventParams[this.fCurAttParam] = n;
        this.fEventStrings[this.fCurAttVal].setValues(xMLString);
        return this.saveAttribute();
    }

    protected void processAttributeName(QName qName, boolean bl) {
        if (this.fIsNamespaceAware) {
            int n = qName.prefixHandle;
            int n2 = qName.localHandle;
            if (n != 1) {
                if (n == 0) {
                    this.fNamespaceDeclPrefix = n2 != 1 ? -1 : 0;
                } else {
                    this.fNamespaceDeclPrefix = -1;
                    this.fSeenAttrWithPrefix = true;
                }
            } else {
                this.fNamespaceDeclPrefix = n2;
            }
        } else {
            this.fNamespaceDeclPrefix = -1;
        }
        this.checkAttrLength();
        this.fEventParams[this.fCurAttParam] = 0;
        this.fEventParams[this.fCurAttParam + 1] = bl ? 1 : 2;
        this.fEventStrings[this.fCurAttVal].endOffset = -1;
        this.fAttValueOffset = -1;
    }

    protected void checkAttrLength() {
        if (this.fCurAttName + 1 >= this.fEventQNames.length) {
            this.growQNames();
        }
        if (this.fCurAttVal + 3 >= this.fEventStrings.length) {
            this.growStrings();
        }
        if (this.fCurAttParam + 4 >= this.fEventParams.length) {
            this.growParams();
        }
    }

    public void setAttributeType(int n, int n2) {
        this.fEventParams[this.fLastEventParam + 2 + (n << 1)] = n2;
    }

    public final void attributeValueCharacters(XMLString xMLString, boolean bl) {
        if (this.fAttValueOffset == -1) {
            if (xMLString == this.fEventStrings[this.fCurAttVal]) {
                if (bl || xMLString.length == 0) {
                    return;
                }
                this.fAttValueOffset = this.fStringBuffer.getOffset();
            } else {
                this.fAttValueOffset = this.fStringBuffer.getOffset();
                if (this.fEventStrings[this.fCurAttVal].endOffset != -1) {
                    this.fStringBuffer.appendXMLString(this.fEventStrings[this.fCurAttVal]);
                }
            }
        }
        if (xMLString.length > 0) {
            if (bl) {
                this.fStringBuffer.appendXMLString(xMLString);
            } else {
                this.fStringBuffer.normalizedAppend(xMLString);
            }
        }
    }

    public void attributeValueCharacter(int n, boolean bl) {
        if (this.fAttValueOffset == -1) {
            this.fAttValueOffset = this.fStringBuffer.getOffset();
            if (this.fEventStrings[this.fCurAttVal].endOffset != -1) {
                this.fStringBuffer.appendXMLString(this.fEventStrings[this.fCurAttVal]);
            }
        }
        this.fStringBuffer.appendChar(n);
    }

    public boolean saveSpecifiedAttValue() {
        this.saveAttValue();
        return this.saveAttribute();
    }

    protected boolean saveAttribute() {
        int n = this.fLastEventParam + 1;
        this.fEventParams[n] = this.fEventParams[n] + 1;
        ++this.fCurAttName;
        ++this.fCurAttVal;
        this.fCurAttParam += 2;
        return true;
    }

    public boolean saveSpecifiedNamespaceURI() {
        return this.saveNamespaceDecl(this.fEventQNames[this.fCurAttName], this.saveAttValue());
    }

    protected boolean saveNamespaceDecl(QName qName, XMLString xMLString) {
        boolean bl;
        if (this.fNamespaceDeclPrefix == 0) {
            this.fSeenDefaultNamespaceMapping = true;
        }
        if ((bl = this.fNamespaceContext.createPrefixMapping(this.fNamespaceDeclPrefix, xMLString, qName.handle)) && !this.fSeenNSDecl) {
            this.fEventParams[this.fLastEventParam] = this.fNamespaceContext.currentContext();
            this.fSeenNSDecl = true;
        }
        return bl;
    }

    protected XMLString saveAttValue() {
        XMLString xMLString = this.fEventStrings[this.fCurAttVal];
        if (this.fAttValueOffset != -1) {
            this.fStringBuffer.setStringValues(this.fAttValueOffset, this.fStringBuffer.getOffset(), xMLString);
        } else if (xMLString.endOffset == -1) {
            this.fStringBuffer.setStringValues(0, 0, xMLString);
        }
        return xMLString;
    }

    public boolean finishElement() {
        if (this.fIsNamespaceAware) {
            if (!this.resolveNamespaceURIs()) {
                return false;
            }
            if (this.fNamespaceContext.nsDeclCount(this.fEventParams[this.fLastEventParam]) > 1 && !this.fNamespaceContext.checkDuplicateNamespaces(this.fEventQNames[this.fLastEventQName])) {
                return false;
            }
        }
        return this.fEventParams[this.fLastEventParam + 1] <= 1 || this.checkDuplicateAttrs();
    }

    private boolean addDefaultAttributes(QName qName, NSDeclList nSDeclList, AttrList attrList) {
        return this.fDocumentEntityScanner.addDefaultAttributes(qName, nSDeclList, attrList, this.fIsNamespaceAware);
    }

    public boolean finishEmptyElement() {
        if ((!this.fHasDefaultAttributes || this.addDefaultAttributes(this.fEmptyElementProducer.elementType(), this.fEmptyElementProducer.nsDecls(), this.fEmptyElementProducer.attributes())) && this.finishElement()) {
            this.endNamespacesScope();
            this.fDocumentEntityScanner.finishEmptyElement(this.fElementDepth);
            return this.produceEmptyElementEvent();
        }
        return false;
    }

    public boolean finishStartElement() {
        if ((!this.fHasDefaultAttributes || this.addDefaultAttributes(this.fStartElementProducer.elementType(), this.fStartElementProducer.nsDecls(), this.fStartElementProducer.attributes())) && this.finishElement()) {
            QName qName = this.fEventQNames[this.fLastEventQName];
            this.pushElement(qName);
            this.fDocumentEntityScanner.finishStartElement();
            return this.produceStartElementEvent();
        }
        return false;
    }

    public void setNSDeclURI(int n, int n2) {
        this.fNamespaceContext.setNSDeclURI(this.fEventParams[this.fLastEventParam], n, n2);
    }

    public boolean setNamespaceURI(QName qName) {
        if (qName.prefixHandle != 0 || qName == this.fEventQNames[this.fLastEventQName]) {
            return this.fNamespaceContext.setNamespaceURI(this.fEventParams[this.fLastEventParam], qName);
        }
        return true;
    }

    protected boolean resolveNamespaceURIs() {
        int n = this.fEventParams[this.fLastEventParam];
        if (this.fSeenAttrWithPrefix) {
            int n2 = this.fLastEventQName + 1;
            int n3 = n2 + this.fEventParams[this.fLastEventParam + 1];
            int n4 = n2;
            while (n4 < n3) {
                QName qName = this.fEventQNames[n4];
                int n5 = qName.prefixHandle;
                if (n5 != 0 && n5 != 1 && !this.fNamespaceContext.setNamespaceURI(n, qName)) {
                    return this.undeclaredPrefix(n5);
                }
                ++n4;
            }
        }
        QName qName = this.fEventQNames[this.fLastEventQName];
        if (qName.prefixHandle != 0 || this.fSeenDefaultNamespaceMapping) {
            if (!this.fNamespaceContext.setNamespaceURI(n, qName)) {
                return this.undeclaredPrefix(qName.prefixHandle);
            }
        } else {
            qName.nsHandle = 0;
        }
        return true;
    }

    private boolean undeclaredPrefix(int n) {
        this.fSymbolTable.setStringValues(n, this.fErrorString);
        this.setParameter(0, this.fErrorString);
        return this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 50);
    }

    protected boolean checkDuplicateAttrs() {
        QName qName = this.checkDuplicateAttrs2();
        if (qName != null) {
            return this.duplicateAttribute(qName);
        }
        return true;
    }

    protected boolean duplicateAttribute(QName qName) {
        this.setParameter(0, this.fEventQNames[this.fLastEventQName]);
        this.setParameter(1, qName);
        return this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 17);
    }

    protected QName checkDuplicateAttrs2() {
        int n = this.fEventParams[this.fLastEventParam + 1];
        if (n < 16) {
            int n2 = this.fLastEventQName + 1;
            int n3 = n2 + n;
            int n4 = n2;
            while (n4 < n3 - 1) {
                QName qName = this.fEventQNames[n4];
                int n5 = qName.localHandle;
                int n6 = n4 + 1;
                while (n6 < n3) {
                    if (this.fEventQNames[n6].localHandle == n5 && this.fEventQNames[n6].nsHandle == this.fEventQNames[n4].nsHandle) {
                        return this.fEventQNames[n6];
                    }
                    ++n6;
                }
                ++n4;
            }
            return null;
        }
        return this.checkManyDuplicateAttrs(n);
    }

    protected QName checkManyDuplicateAttrs(int n) {
        int n2 = n >> 4;
        int n3 = 1024;
        while (n3 < n2) {
            n3 <<= 1;
        }
        if (this.fAttrHashtable == null || n3 > this.fAttrHashtable.length) {
            this.fAttrHashtable = new int[n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            this.fAttrHashtable[n4] = -1;
            ++n4;
        }
        --n3;
        int n5 = this.fEventQNames.length;
        if (this.fNextAttrInBucket == null || n5 > this.fNextAttrInBucket.length) {
            this.fNextAttrInBucket = new int[n5];
        }
        int n6 = this.fLastEventQName + 1;
        int n7 = n6 + n;
        n4 = n6;
        while (n4 < n7) {
            int n8 = this.fEventQNames[n4].localHandle;
            int n9 = this.fEventQNames[n4].nsHandle;
            int n10 = n8 + n9;
            int n11 = n10 & n3;
            int n12 = this.fAttrHashtable[n11];
            if (n12 >= 0) {
                int n13 = n12;
                while (n13 >= 0) {
                    if (this.fEventQNames[n13].localHandle == n8 && this.fEventQNames[n13].nsHandle == n9) {
                        return this.fEventQNames[n4];
                    }
                    n13 = this.fNextAttrInBucket[n13];
                }
            }
            this.fNextAttrInBucket[n4] = n12;
            this.fAttrHashtable[n11] = n4++;
        }
        return null;
    }

    private void pushElement(QName qName) {
        if (this.fElementDepth < this.fElementTypeStack.length) {
            QName qName2 = this.fElementTypeStack[this.fElementDepth];
            if (qName2 != null) {
                this.fSymbolTable.shareQNameValues(qName, qName2);
            } else {
                qName2 = this.fElementTypeStack[this.fElementDepth] = new QName();
                this.fSymbolTable.shareQNameValues(qName, qName2);
            }
            this.fElementEntityStack[this.fElementDepth] = this.fCurrentEntity.id;
            ++this.fElementDepth;
        } else {
            this.growElements();
            this.pushElement(qName);
        }
    }

    public int elementDepth() {
        return this.fElementDepth;
    }

    public QName popElement() {
        --this.fElementDepth;
        if (this.fElementEntityStack[this.fElementDepth] == this.fCurrentEntity.id) {
            return this.fElementTypeStack[this.fElementDepth];
        }
        return null;
    }

    public QName topElement() {
        return this.fElementTypeStack[this.fElementDepth];
    }

    private void growElements() {
        QName[] qNameArray = new QName[this.fElementDepth << 1];
        System.arraycopy(this.fElementTypeStack, 0, qNameArray, 0, this.fElementDepth);
        this.fElementTypeStack = qNameArray;
        int[] nArray = new int[this.fElementDepth << 1];
        System.arraycopy(this.fElementEntityStack, 0, nArray, 0, this.fElementDepth);
        this.fElementEntityStack = nArray;
    }

    public boolean continueAfterEndOfEntity() {
        return false;
    }

    public boolean scanStartElementBuffered(ParsedEntity parsedEntity) {
        return this.fDocumentEntityScanner.scanStartElementBuffered();
    }

    public boolean scanStartElementUnbuffered(ParsedEntity parsedEntity) {
        return this.fDocumentEntityScanner.scanStartElementUnbuffered();
    }

    public boolean scanEndElementBuffered(ParsedEntity parsedEntity) {
        return this.fDocumentEntityScanner.scanEndElementBuffered();
    }

    public boolean scanEndElementUnbuffered(ParsedEntity parsedEntity) {
        return this.fDocumentEntityScanner.scanEndElementUnbuffered();
    }

    public void setInElementContent(boolean bl) {
        this.fInElementContent = bl;
    }

    public boolean scanContentBuffered(ParsedEntity parsedEntity) {
        if (!this.fInElementContent) {
            return this.fDocumentEntityScanner.scanContentBuffered(this.fEventStrings[this.fLastEventString]);
        }
        return this.fDocumentEntityScanner.scanElementContentBuffered(this.fEventStrings[this.fLastEventString]);
    }

    public boolean scanContentUnbuffered(ParsedEntity parsedEntity) {
        if (!this.fInElementContent) {
            return this.fDocumentEntityScanner.scanContentUnbuffered(this.fEventStrings[this.fLastEventString]);
        }
        return this.fDocumentEntityScanner.scanElementContentUnbuffered(this.fEventStrings[this.fLastEventString]);
    }

    public void setParameter(int n, XMLString xMLString) {
        int n2 = this.fErrorParams[this.fLastErrorParam + 2];
        if (n >= n2) {
            this.checkErrorStringLength(n + 1);
            this.fErrorParams[this.fLastErrorParam + 2] = n + 1;
        }
        this.fErrorStrings[this.fLastErrorString + n].setValues(xMLString);
    }

    private void growQueue() {
        int n = this.fEvents.length;
        ScannerEvent[] scannerEventArray = new ScannerEvent[n << 1];
        System.arraycopy(this.fEvents, 0, scannerEventArray, 0, n);
        this.fEvents = scannerEventArray;
    }

    private void growParams() {
        int n = this.fEventParams.length;
        int[] nArray = new int[n << 1];
        System.arraycopy(this.fEventParams, 0, nArray, 0, n);
        this.fEventParams = nArray;
    }

    private void growStrings() {
        int n = this.fEventStrings.length;
        XMLString[] xMLStringArray = new XMLString[n << 1];
        System.arraycopy(this.fEventStrings, 0, xMLStringArray, 0, n);
        this.fEventStrings = xMLStringArray;
        int n2 = (n << 1) - 1;
        while (n2 >= n) {
            this.fEventStrings[n2] = new XMLString();
            --n2;
        }
    }

    private void growQNames() {
        int n = this.fEventQNames.length;
        QName[] qNameArray = new QName[n << 1];
        System.arraycopy(this.fEventQNames, 0, qNameArray, 0, n);
        this.fEventQNames = qNameArray;
        int n2 = (n << 1) - 1;
        while (n2 >= n) {
            this.fEventQNames[n2] = new QName();
            --n2;
        }
    }

    private void growErrorURIs() {
        int n = this.fErrorURIs.length;
        String[] stringArray = new String[n << 1];
        System.arraycopy(this.fErrorURIs, 0, stringArray, 0, n);
        this.fErrorURIs = stringArray;
    }

    private void growErrorParams() {
        int n = this.fErrorParams.length;
        int[] nArray = new int[n << 1];
        System.arraycopy(this.fErrorParams, 0, nArray, 0, n);
        this.fErrorParams = nArray;
    }

    private void growErrorStrings() {
        int n = this.fErrorStrings.length;
        XMLString[] xMLStringArray = new XMLString[n << 1];
        System.arraycopy(this.fErrorStrings, 0, xMLStringArray, 0, n);
        this.fErrorStrings = xMLStringArray;
        int n2 = (n << 1) - 1;
        while (n2 >= n) {
            this.fErrorStrings[n2] = new XMLString();
            --n2;
        }
    }

    protected final class ErrorProducer
    extends ScannerEvent.Error {
        public ErrorProducer(int n) {
            super(n);
        }

        public int nsContext() {
            return SimpleScannerEventQueue.this.fErrorParams[SimpleScannerEventQueue.this.fLastErrorParam];
        }

        public String errorURI() {
            return SimpleScannerEventQueue.this.fErrorURIs[SimpleScannerEventQueue.this.fLastErrorURI];
        }

        public int errorCode() {
            return SimpleScannerEventQueue.this.fErrorParams[SimpleScannerEventQueue.this.fLastErrorParam + 1];
        }

        public int errorParamsCount() {
            return SimpleScannerEventQueue.this.fErrorParams[SimpleScannerEventQueue.this.fLastErrorParam + 2];
        }

        public XMLString errorParam(int n) {
            return SimpleScannerEventQueue.this.fErrorStrings[SimpleScannerEventQueue.this.fLastErrorString + n];
        }

        public long errorOffset() {
            return SimpleScannerEventQueue.this.fErrorParams[SimpleScannerEventQueue.this.fLastErrorParam + 3] << 32 | SimpleScannerEventQueue.this.fErrorParams[SimpleScannerEventQueue.this.fLastErrorParam + 4];
        }
    }

    protected final class ErrorEvent
    extends ScannerEvent.Error {
        public ErrorEvent(int n) {
            super(n);
        }

        public int nsContext() {
            return SimpleScannerEventQueue.this.fErrorParams[SimpleScannerEventQueue.this.fCurrentErrorParam];
        }

        public String errorURI() {
            return SimpleScannerEventQueue.this.fErrorURIs[SimpleScannerEventQueue.this.fCurrentErrorURI];
        }

        public int errorCode() {
            return SimpleScannerEventQueue.this.fErrorParams[SimpleScannerEventQueue.this.fCurrentErrorParam + 1];
        }

        public int errorParamsCount() {
            return SimpleScannerEventQueue.this.fErrorParams[SimpleScannerEventQueue.this.fCurrentErrorParam + 2];
        }

        public XMLString errorParam(int n) {
            return SimpleScannerEventQueue.this.fErrorStrings[SimpleScannerEventQueue.this.fCurrentErrorString + n];
        }

        public long errorOffset() {
            return SimpleScannerEventQueue.this.fErrorParams[SimpleScannerEventQueue.this.fCurrentErrorParam + 3] << 32 | SimpleScannerEventQueue.this.fErrorParams[SimpleScannerEventQueue.this.fCurrentErrorParam + 4];
        }
    }

    protected final class EntityProducer
    extends ScannerEvent.Entity {
        public EntityProducer(int n) {
            super(n);
        }

        public int nsContext() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam];
        }

        public XMLString entityName() {
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fLastEventString];
        }
    }

    protected final class EntityEvent
    extends ScannerEvent.Entity {
        public EntityEvent(int n) {
            super(n);
        }

        public int nsContext() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam];
        }

        public XMLString entityName() {
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fCurrentEventString];
        }
    }

    protected final class CDATASectionProducer
    extends ScannerEvent.CDATASection {
        public CDATASectionProducer(int n) {
            super(n);
        }

        public int nsContext() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam];
        }
    }

    protected final class CDATASectionEvent
    extends ScannerEvent.CDATASection {
        public CDATASectionEvent(int n) {
            super(n);
        }

        public int nsContext() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam];
        }
    }

    protected final class CommentProducer
    extends ScannerEvent.Comment {
        public int nsContext() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam];
        }

        public XMLString content() {
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fLastEventString];
        }
    }

    protected final class CommentEvent
    extends ScannerEvent.Comment {
        public int nsContext() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam];
        }

        public XMLString content() {
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fCurrentEventString];
        }
    }

    protected final class ProcessingInstructionProducer
    extends ScannerEvent.ProcessingInstruction {
        public int nsContext() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam];
        }

        public XMLString target() {
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fLastEventString + 1];
        }

        public XMLString content() {
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fLastEventString];
        }
    }

    protected final class ProcessingInstructionEvent
    extends ScannerEvent.ProcessingInstruction {
        public int nsContext() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam];
        }

        public XMLString target() {
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fCurrentEventString + 1];
        }

        public XMLString content() {
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fCurrentEventString];
        }
    }

    protected final class CharacterProducer
    extends ScannerEvent.Character {
        public CharacterProducer(int n) {
            super(n);
        }

        public int nsContext() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam];
        }

        public int singleCh() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam + 1];
        }
    }

    protected final class CharacterEvent
    extends ScannerEvent.Character {
        public CharacterEvent(int n) {
            super(n);
        }

        public int nsContext() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam];
        }

        public int singleCh() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam + 1];
        }
    }

    protected final class CharactersProducer
    extends ScannerEvent.Characters {
        public CharactersProducer(int n) {
            super(n);
        }

        public int nsContext() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam];
        }

        public XMLString content() {
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fLastEventString];
        }
    }

    protected final class CharactersEvent
    extends ScannerEvent.Characters {
        public CharactersEvent(int n) {
            super(n);
        }

        public int nsContext() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam];
        }

        public XMLString content() {
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fCurrentEventString];
        }
    }

    protected final class EndElementProducer
    extends ScannerEvent.EndElement
    implements NSDeclList {
        public int nsContext() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam];
        }

        public QName elementType() {
            return SimpleScannerEventQueue.this.fEventQNames[SimpleScannerEventQueue.this.fLastEventQName];
        }

        public NSDeclList nsDecls() {
            return this;
        }

        public int nsDeclCount() {
            return SimpleScannerEventQueue.this.fNamespaceContext.nsDeclCount(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam]);
        }

        public int nsDeclPrefix(int n) {
            return SimpleScannerEventQueue.this.fNamespaceContext.nsDeclPrefix(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam], n);
        }

        public int nsDeclURI(int n) {
            return SimpleScannerEventQueue.this.fNamespaceContext.nsDeclURI(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam], n);
        }

        public int nsDeclQName(int n) {
            return SimpleScannerEventQueue.this.fNamespaceContext.nsDeclQName(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam], n);
        }

        public int prefixMapping(int n) {
            return SimpleScannerEventQueue.this.fNamespaceContext.prefixMapping(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam], n);
        }
    }

    protected final class EndElementEvent
    extends ScannerEvent.EndElement
    implements NSDeclList {
        public int nsContext() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam];
        }

        public QName elementType() {
            return SimpleScannerEventQueue.this.fEventQNames[SimpleScannerEventQueue.this.fCurrentEventQName];
        }

        public NSDeclList nsDecls() {
            return this;
        }

        public int nsDeclCount() {
            return SimpleScannerEventQueue.this.fNamespaceContext.nsDeclCount(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam]);
        }

        public int nsDeclPrefix(int n) {
            return SimpleScannerEventQueue.this.fNamespaceContext.nsDeclPrefix(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam], n);
        }

        public int nsDeclURI(int n) {
            return SimpleScannerEventQueue.this.fNamespaceContext.nsDeclURI(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam], n);
        }

        public int nsDeclQName(int n) {
            return SimpleScannerEventQueue.this.fNamespaceContext.nsDeclQName(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam], n);
        }

        public int prefixMapping(int n) {
            return SimpleScannerEventQueue.this.fNamespaceContext.prefixMapping(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam], n);
        }
    }

    protected final class StartElementProducer
    extends ScannerEvent.StartElement
    implements NSDeclList,
    AttrList {
        public StartElementProducer(int n) {
            super(n);
        }

        public int nsContext() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam];
        }

        public QName elementType() {
            return SimpleScannerEventQueue.this.fEventQNames[SimpleScannerEventQueue.this.fLastEventQName];
        }

        public NSDeclList nsDecls() {
            return this;
        }

        public AttrList attributes() {
            return this;
        }

        public int nsDeclCount() {
            return SimpleScannerEventQueue.this.fNamespaceContext.nsDeclCount(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam]);
        }

        public int nsDeclPrefix(int n) {
            return SimpleScannerEventQueue.this.fNamespaceContext.nsDeclPrefix(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam], n);
        }

        public int nsDeclURI(int n) {
            return SimpleScannerEventQueue.this.fNamespaceContext.nsDeclURI(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam], n);
        }

        public int nsDeclQName(int n) {
            return SimpleScannerEventQueue.this.fNamespaceContext.nsDeclQName(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam], n);
        }

        public int prefixMapping(int n) {
            return SimpleScannerEventQueue.this.fNamespaceContext.prefixMapping(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam], n);
        }

        public int attributeCount() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam + 1];
        }

        public QName attributeName(int n) {
            return SimpleScannerEventQueue.this.fEventQNames[SimpleScannerEventQueue.this.fLastEventQName + 1 + n];
        }

        public int attributeType(int n) {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam + 2 + (n << 1)];
        }

        public XMLString attributeValue(int n) {
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fLastEventString + n];
        }

        public XMLString normalizedAttributeValue(int n) {
            if ((SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam + 2 + (n << 1) + 1] & 1) == 0) {
                SimpleScannerEventQueue.this.fStringBuffer.normalizeTextValue(SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fLastEventString + n], null);
                int n2 = SimpleScannerEventQueue.this.fLastEventParam + 2 + (n << 1) + 1;
                SimpleScannerEventQueue.this.fEventParams[n2] = SimpleScannerEventQueue.this.fEventParams[n2] | 1;
            }
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fLastEventString + n];
        }

        public boolean attributeValueNormalized(int n) {
            return (SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam + 2 + (n << 1) + 1] & 1) == 1;
        }

        public boolean attributeSpecified(int n) {
            if (!SimpleScannerEventQueue.this.fHasDefaultAttributes) {
                return true;
            }
            return (SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam + 2 + (n << 1) + 1] & 2) == 0;
        }

        public void normalizeAttributeValue(int n) {
            SimpleScannerEventQueue.this.fStringBuffer.normalizeTextValue(SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fLastEventString + n], null);
            int n2 = SimpleScannerEventQueue.this.fLastEventParam + 2 + (n << 1) + 1;
            SimpleScannerEventQueue.this.fEventParams[n2] = SimpleScannerEventQueue.this.fEventParams[n2] | 1;
        }

        public void setAttributeValueNormalized(int n, boolean bl) {
            if (bl) {
                int n2 = SimpleScannerEventQueue.this.fLastEventParam + 2 + (n << 1) + 1;
                SimpleScannerEventQueue.this.fEventParams[n2] = SimpleScannerEventQueue.this.fEventParams[n2] | 1;
            } else {
                int n3 = SimpleScannerEventQueue.this.fLastEventParam + 2 + (n << 1) + 1;
                SimpleScannerEventQueue.this.fEventParams[n3] = SimpleScannerEventQueue.this.fEventParams[n3] & 0xFFFFFFFE;
            }
        }

        public XMLString elementValue() {
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fLastEventString + SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fLastEventParam + 1]];
        }
    }

    protected final class StartElementEvent
    extends ScannerEvent.StartElement
    implements NSDeclList,
    AttrList {
        public StartElementEvent(int n) {
            super(n);
        }

        public int nsContext() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam];
        }

        public QName elementType() {
            return SimpleScannerEventQueue.this.fEventQNames[SimpleScannerEventQueue.this.fCurrentEventQName];
        }

        public NSDeclList nsDecls() {
            return this;
        }

        public AttrList attributes() {
            return this;
        }

        public int nsDeclCount() {
            return SimpleScannerEventQueue.this.fNamespaceContext.nsDeclCount(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam]);
        }

        public int nsDeclPrefix(int n) {
            return SimpleScannerEventQueue.this.fNamespaceContext.nsDeclPrefix(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam], n);
        }

        public int nsDeclURI(int n) {
            return SimpleScannerEventQueue.this.fNamespaceContext.nsDeclURI(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam], n);
        }

        public int nsDeclQName(int n) {
            return SimpleScannerEventQueue.this.fNamespaceContext.nsDeclQName(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam], n);
        }

        public int prefixMapping(int n) {
            return SimpleScannerEventQueue.this.fNamespaceContext.prefixMapping(SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam], n);
        }

        public int attributeCount() {
            return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam + 1];
        }

        public QName attributeName(int n) {
            if (n >= 0 && n < this.attributeCount()) {
                return SimpleScannerEventQueue.this.fEventQNames[SimpleScannerEventQueue.this.fCurrentEventQName + 1 + n];
            }
            this.throwAIOOBException("attributeName");
            return null;
        }

        public int attributeType(int n) {
            if (n >= 0 && n < this.attributeCount()) {
                return SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam + 2 + (n << 1)];
            }
            this.throwAIOOBException("attributeType");
            return -1;
        }

        public XMLString attributeValue(int n) {
            if (n >= 0 && n < this.attributeCount()) {
                return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fCurrentEventString + n];
            }
            this.throwAIOOBException("attributeValue");
            return null;
        }

        public XMLString normalizedAttributeValue(int n) {
            if (n >= 0 && n < this.attributeCount()) {
                if ((SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam + 2 + (n << 1) + 1] & 1) == 0) {
                    SimpleScannerEventQueue.this.fStringBuffer.normalizeTextValue(SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fCurrentEventString + n], null);
                    int n2 = SimpleScannerEventQueue.this.fCurrentEventParam + 2 + (n << 1) + 1;
                    SimpleScannerEventQueue.this.fEventParams[n2] = SimpleScannerEventQueue.this.fEventParams[n2] | 1;
                }
                return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fCurrentEventString + n];
            }
            this.throwAIOOBException("normalizedAttributeValue");
            return null;
        }

        public boolean attributeValueNormalized(int n) {
            if (n >= 0 && n < this.attributeCount()) {
                return (SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam + 2 + (n << 1) + 1] & 1) == 1;
            }
            this.throwAIOOBException("attributeValueNormalized");
            return false;
        }

        public boolean attributeSpecified(int n) {
            if (n >= 0 && n < this.attributeCount()) {
                if (!SimpleScannerEventQueue.this.fHasDefaultAttributes) {
                    return true;
                }
                return (SimpleScannerEventQueue.this.fEventParams[SimpleScannerEventQueue.this.fCurrentEventParam + 2 + (n << 1) + 1] & 2) == 0;
            }
            this.throwAIOOBException("attributeSpecified");
            return false;
        }

        public void normalizeAttributeValue(int n) {
            if (n >= 0 && n < this.attributeCount()) {
                SimpleScannerEventQueue.this.fStringBuffer.normalizeTextValue(SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fCurrentEventString + n], null);
                int n2 = SimpleScannerEventQueue.this.fCurrentEventParam + 2 + (n << 1) + 1;
                SimpleScannerEventQueue.this.fEventParams[n2] = SimpleScannerEventQueue.this.fEventParams[n2] | 1;
            } else {
                this.throwAIOOBException("normalizeAttributeValue");
            }
        }

        public void setAttributeValueNormalized(int n, boolean bl) {
            if (n >= 0 && n < this.attributeCount()) {
                if (bl) {
                    int n2 = SimpleScannerEventQueue.this.fCurrentEventParam + 2 + (n << 1) + 1;
                    SimpleScannerEventQueue.this.fEventParams[n2] = SimpleScannerEventQueue.this.fEventParams[n2] | 1;
                } else {
                    int n3 = SimpleScannerEventQueue.this.fCurrentEventParam + 2 + (n << 1) + 1;
                    SimpleScannerEventQueue.this.fEventParams[n3] = SimpleScannerEventQueue.this.fEventParams[n3] & 0xFFFFFFFE;
                }
            } else {
                this.throwAIOOBException("setAttributeValueNormalized");
            }
        }

        public XMLString elementValue() {
            if (this.eventType != 6) {
                return null;
            }
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fCurrentEventString + this.attributeCount()];
        }

        private void throwAIOOBException(String string) {
            throw new ArrayIndexOutOfBoundsException(string);
        }
    }

    protected final class TextDeclProducer
    extends ScannerEvent.TextDecl {
        public XMLString version() {
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fLastEventString];
        }

        public XMLString encName() {
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fLastEventString + 1];
        }
    }

    protected final class TextDeclEvent
    extends ScannerEvent.TextDecl {
        public XMLString version() {
            XMLString xMLString = SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fCurrentEventString];
            if (xMLString.length == 0) {
                xMLString = null;
            }
            return xMLString;
        }

        public XMLString encName() {
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fCurrentEventString + 1];
        }
    }

    protected final class XMLDeclProducer
    extends ScannerEvent.XMLDecl {
        public XMLString version() {
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fLastEventString];
        }

        public XMLString encName() {
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fLastEventString + 1];
        }

        public XMLString standalone() {
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fLastEventString + 2];
        }
    }

    protected final class XMLDeclEvent
    extends ScannerEvent.XMLDecl {
        public XMLString version() {
            return SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fCurrentEventString];
        }

        public XMLString encName() {
            XMLString xMLString = SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fCurrentEventString + 1];
            if (xMLString.length == 0) {
                xMLString = null;
            }
            return xMLString;
        }

        public XMLString standalone() {
            XMLString xMLString = SimpleScannerEventQueue.this.fEventStrings[SimpleScannerEventQueue.this.fCurrentEventString + 2];
            if (xMLString.length == 0) {
                xMLString = null;
            }
            return xMLString;
        }
    }

    protected final class DocumentProducer
    extends ScannerEvent.Document {
        public DocumentProducer(int n) {
            super(n);
        }
    }

    protected final class DocumentEvent
    extends ScannerEvent.Document {
        public DocumentEvent(int n) {
            super(n);
        }
    }
}

