/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class ConfigArchiveCommand
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ConfigArchiveCommand.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    protected Class composerCls = null;
    private boolean unload = true;
    private Session configArchiveSession = null;

    public ConfigArchiveCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        this.init();
    }

    public ConfigArchiveCommand(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
        this.init();
    }

    private void init() {
        try {
            this.composerCls = Class.forName("com.ibm.ws.management.configarchive.ConfigArchiveComposer");
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.wsspi.configarchive.ConfigArchiveCommand.initImpl", "56");
        }
    }

    public Session getConfigArchiveSession() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigArchiveSession");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigArchiveSession", this.configArchiveSession);
        }
        return this.configArchiveSession;
    }

    public void setConfigArchiveSession(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setConfigArchiveSession", session);
        }
        this.configArchiveSession = session;
        try {
            if (this.getParameter("archive") == null) {
                this.setParameter("archive", "");
                this.unload = false;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fail to set archive parameter", exception);
            }
            FFDCFilter.processException(exception, "com.ibm.wsspi.configarchive.ConfigArchiveCommand.setArchiveWorkspace", "62");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setConfigArchiveSession");
        }
    }

    protected final void unload() throws Exception {
        if (this.unload) {
            Method method = this.composerCls.getMethod("unloadConfigArchive", String.class);
            method.invoke(null, this.configArchiveSession.toString());
        }
    }

    protected void taskCommandExecuted(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "taskCommandExecuted," + bl);
        }
        try {
            this.unload();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.wsspi.configarchive.ConfigArchiveCommandBase.taskCommandExecuted", "86");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "taskCommandExecuted");
        }
    }

    protected File getArchiveLocation() {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getArchiveLocation");
        }
        String string = null;
        try {
            object = this.getParameter("archive");
            string = object == null ? null : object.toString();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", exception);
            }
            FFDCFilter.processException(exception, "com.ibm.wsspi.configarchive.ConfigArchiveCommand.getArchiveLocation", "73");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "archivePath", string);
        }
        object = new File(string);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getArchiveLocation", object);
        }
        return object;
    }

    private ManagedObjectMetadataHelper getMetadataHelper(Session session) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetadataHelper", session);
        }
        ManagedObjectMetadataHelper managedObjectMetadataHelper = null;
        try {
            Method method = this.composerCls.getMethod("getMetadataHelper", Session.class);
            managedObjectMetadataHelper = (ManagedObjectMetadataHelper)method.invoke(null, session);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ConfigArchiveException) {
                throw (ConfigArchiveException)throwable;
            }
            throw new ConfigArchiveException(throwable, "failed to get ManagedObjectMetadataHelper for session " + session);
        }
        catch (Throwable throwable) {
            throw new ConfigArchiveException(throwable, "failed to get ManagedObjectMetadataHelper for session " + session);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetadataHelper", managedObjectMetadataHelper);
        }
        return managedObjectMetadataHelper;
    }

    public ManagedObjectMetadataHelper getConfigArchiveMetadataHelper() throws ConfigArchiveException {
        return this.getMetadataHelper(this.getConfigArchiveSession());
    }

    public ManagedObjectMetadataHelper getMetadataHelper() throws ConfigArchiveException {
        return this.getMetadataHelper(this.getConfigSession());
    }
}

