/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.multiprotocol.provider.StubGenerator;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingFaultRefEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildFaultPartEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Element;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntryComparator;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import com.ibm.ws.webservices.wsdl.utils.OperationDescBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;

public class JavaStubWriter
extends JavaClassWriter
implements StubGenerator {
    private BindingEntry bEntry;
    private Binding binding;
    private SymbolTable symbolTable;
    private int suffixId = 0;
    private HashMap op_getter = new HashMap();
    private boolean callStaticInit = false;
    private int methodNumber = 0;

    public JavaStubWriter(Emitter emitter, BindingEntry bindingEntry, SymbolTable symbolTable) {
        super(emitter, bindingEntry.getName() + "Stub", "stub");
        this.bEntry = bindingEntry;
        this.binding = bindingEntry.getBinding();
        this.symbolTable = symbolTable;
        this.setDeployPhaseOnly(true);
    }

    protected String getExtendsText() {
        return "extends com.ibm.ws.webservices.engine.client.Stub ";
    }

    protected String getImplementsText() {
        return "implements " + this.bEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME) + " ";
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        PortType portType = this.binding.getPortType();
        ArrayList arrayList = JavaStubWriter.getTypesInPortType(portType, this.bEntry, this.symbolTable);
        boolean bl = Utils.hasMIME(this.bEntry);
        boolean bl2 = arrayList.size() > 0 || bl;
        this.writeConstructors(printWriter, bl2);
        if (bl2) {
            this.writeInitTypeMapping(printWriter, arrayList, bl);
        }
        List list = this.binding.getBindingOperations();
        for (int i = 0; i < list.size(); ++i) {
            BindingOperation bindingOperation = (BindingOperation)list.get(i);
            BindingOperationEntry bindingOperationEntry = this.bEntry.getOperation(bindingOperation.getOperation());
            String string = (String)bindingOperationEntry.getDynamicVar(BindingOperationEntry.SOAP_ACTION_URI);
            string = string == null ? "" : string;
            Operation operation = bindingOperation.getOperation();
            OperationType operationType = operation.getStyle();
            if (operationType == OperationType.NOTIFICATION || operationType == OperationType.SOLICIT_RESPONSE) {
                printWriter.println(bindingOperationEntry.getDynamicVar(JavaGeneratorFactory.SIGNATURE));
                printWriter.println();
                continue;
            }
            this.writeGetOperation(printWriter, bindingOperationEntry, string);
            this.writeGetInvoke(printWriter, bindingOperationEntry, string, bl);
            this.writeOperation(printWriter, bindingOperationEntry, operationType == OperationType.ONE_WAY);
            ++this.methodNumber;
        }
        this.writePrivateStaticInitMethod(printWriter);
        this.writeStaticInit(printWriter);
    }

    protected void writePrivateStaticInitMethod(PrintWriter printWriter) {
        if (this.op_getter != null && this.op_getter.size() > 0) {
            this.callStaticInit = true;
            Iterator iterator = this.op_getter.keySet().iterator();
            printWriter.println("    private static void _staticInit() {");
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = null;
                string2 = (String)this.op_getter.get(string);
                string = string == null ? "null" : string;
                string2 = string2 == null ? "null" : string2;
                printWriter.println("        " + string + " = " + string2 + ";");
            }
            printWriter.println("    }");
            printWriter.println();
            this.op_getter.clear();
        }
    }

    protected void writeStaticInit(PrintWriter printWriter) {
        if (this.callStaticInit) {
            printWriter.println("    static {");
            printWriter.println("       _staticInit();");
            printWriter.println("    }");
        }
    }

    protected void writeConstructors(PrintWriter printWriter, boolean bl) {
        String string = this.bEntry.getName();
        printWriter.println("    public " + this.className + "(java.net.URL endpointURL, javax.xml.rpc.Service service) throws com.ibm.ws.webservices.engine.WebServicesFault {");
        printWriter.println("        if (service == null) {");
        printWriter.println("            super.service = new com.ibm.ws.webservices.engine.client.Service();");
        printWriter.println("        }");
        printWriter.println("        else {");
        printWriter.println("            super.service = service;");
        printWriter.println("        }");
        printWriter.println("        super.engine = ((com.ibm.ws.webservices.engine.client.Service) super.service).getEngine();");
        printWriter.println("        super.messageContexts = new com.ibm.ws.webservices.engine.MessageContext[" + this.binding.getBindingOperations().size() + "];");
        if (bl) {
            printWriter.println("        java.lang.String theOption = (java.lang.String)super._getProperty(\"lastStubMapping\");");
            printWriter.println("        if (theOption == null || !theOption.equals(\"" + string + "\")) {");
            printWriter.println("                initTypeMapping();");
            printWriter.println("                super._setProperty(\"lastStubMapping\",\"" + string + "\");");
            printWriter.println("        }");
        }
        printWriter.println("        super.cachedEndpoint = endpointURL;");
        printWriter.println("        super.connection = ((com.ibm.ws.webservices.engine.client.Service) super.service).getConnection(endpointURL);");
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeInitTypeMapping(PrintWriter printWriter, ArrayList arrayList, boolean bl) throws IOException {
        String string = this.bEntry.hasLiteral() ? "com.ibm.ws.webservices.engine.Constants.URI_LITERAL_ENC" : "com.ibm.ws.webservices.engine.Constants.URI_SOAP11_ENC";
        printWriter.println("    private void initTypeMapping() {");
        printWriter.println("        javax.xml.rpc.encoding.TypeMapping tm = super.getTypeMapping(" + string + ");");
        this.writeMappingHeader(printWriter);
        int n = 0;
        int n2 = 1;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            TypeEntry typeEntry = (TypeEntry)iterator.next();
            if (!JavaStubWriter.needTypeMapping(typeEntry, this.emitter) || !(typeEntry instanceof Type)) continue;
            if (n < 150) {
                this.writeSerializationInit(printWriter, (Type)typeEntry);
                ++n;
                continue;
            }
            printWriter.println("        initTypeMapping" + ++n2 + "(tm);");
            printWriter.println("    }");
            printWriter.println("");
            printWriter.println("    private void initTypeMapping" + n2 + "(javax.xml.rpc.encoding.TypeMapping tm) {");
            this.writeMappingHeader(printWriter);
            this.writeSerializationInit(printWriter, (Type)typeEntry);
            n = 0;
        }
        printWriter.println("    }");
        printWriter.println();
    }

    private void writeMappingHeader(PrintWriter printWriter) throws IOException {
        printWriter.println("        java.lang.Class javaType = null;");
        printWriter.println("        javax.xml.namespace.QName xmlType = null;");
        printWriter.println("        javax.xml.namespace.QName compQName = null;");
        printWriter.println("        javax.xml.namespace.QName compTypeQName = null;");
        printWriter.println("        com.ibm.ws.webservices.engine.encoding.SerializerFactory sf = null;");
        printWriter.println("        com.ibm.ws.webservices.engine.encoding.DeserializerFactory df = null;");
    }

    protected void writeGetOperation(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry, String string) throws IOException {
        String string2 = bindingOperationEntry.getName();
        String string3 = "_" + string2 + "Operation" + this.methodNumber;
        String string4 = "_get" + string2 + "Operation" + this.methodNumber + "()";
        this.op_getter.put(string3, string4);
        printWriter.println("    private static com.ibm.ws.webservices.engine.description.OperationDesc " + string3 + " = null;");
        printWriter.println("    private static com.ibm.ws.webservices.engine.description.OperationDesc " + string4 + " {");
        OperationDescBuilder operationDescBuilder = OperationDescBuilder.create(bindingOperationEntry, this.bEntry, this.symbolTable);
        operationDescBuilder.writeOperationDesc(printWriter, false, "        ", string3, this.suffixId++);
        printWriter.println("        return " + string3 + ";");
        printWriter.println();
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeGetInvoke(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry, String string, boolean bl) throws IOException {
        String string2 = bindingOperationEntry.getName();
        String string3 = "_" + string2 + "Index" + this.methodNumber;
        printWriter.println("    private int " + string3 + " = " + this.methodNumber + ";");
        printWriter.println("    private synchronized com.ibm.ws.webservices.engine.client.Stub.Invoke _get" + string2 + "Invoke" + this.methodNumber + "(Object[] parameters) throws com.ibm.ws.webservices.engine.WebServicesFault  {");
        printWriter.println("        com.ibm.ws.webservices.engine.MessageContext mc = super.messageContexts[" + string3 + "];");
        printWriter.println("        if (mc == null) {");
        printWriter.println("            mc = new com.ibm.ws.webservices.engine.MessageContext(super.engine);");
        printWriter.println("            mc.setOperation(" + this.className + "._" + string2 + "Operation" + this.methodNumber + ");");
        if (string == null) {
            string = "";
        }
        printWriter.println("            mc.setUseSOAPAction(true);");
        printWriter.println("            mc.setSOAPActionURI(\"" + string + "\");");
        Use use = bindingOperationEntry.getInputBodyUse();
        if (use == Use.LITERAL) {
            printWriter.println("            mc.setEncodingStyle(com.ibm.ws.webservices.engine.Constants.URI_LITERAL_ENC);");
            printWriter.println("            mc.setProperty(com.ibm.wsspi.webservices.Constants.SEND_TYPE_ATTR_PROPERTY, Boolean.FALSE);");
            printWriter.println("            mc.setProperty(com.ibm.wsspi.webservices.Constants.ENGINE_DO_MULTI_REFS_PROPERTY, Boolean.FALSE);");
        }
        printWriter.println("            super.primeMessageContext(mc);");
        printWriter.println("            super.messageContexts[" + string3 + "] = mc;");
        printWriter.println("        }");
        printWriter.println("        try {");
        printWriter.println("            mc = (com.ibm.ws.webservices.engine.MessageContext) mc.clone();");
        printWriter.println("        }");
        printWriter.println("        catch (CloneNotSupportedException cnse) {");
        printWriter.println("            throw com.ibm.ws.webservices.engine.WebServicesFault.makeFault(cnse);");
        printWriter.println("        }");
        printWriter.println("        return new com.ibm.ws.webservices.engine.client.Stub.Invoke(connection, mc, parameters);");
        printWriter.println("    }");
        printWriter.println();
    }

    public static ArrayList getTypesInPortType(PortType portType, BindingEntry bindingEntry, SymbolTable symbolTable) {
        Serializable serializable;
        TreeSet<Operation> treeSet = new TreeSet<Operation>(new SymTabEntryComparator());
        TreeSet treeSet2 = new TreeSet(new SymTabEntryComparator());
        List list = portType.getOperations();
        for (int i = 0; i < list.size(); ++i) {
            serializable = (Operation)list.get(i);
            treeSet2.addAll(JavaStubWriter.getTypesInOperation(serializable, bindingEntry));
        }
        Iterator iterator = treeSet2.iterator();
        while (iterator.hasNext()) {
            serializable = (TypeEntry)iterator.next();
            if (treeSet.contains(serializable)) continue;
            treeSet.add((Operation)serializable);
            treeSet.addAll(Utils.getNestedTypes((TypeEntry)serializable, symbolTable));
        }
        return new ArrayList(treeSet);
    }

    public static Set getTypesInOperation(Operation operation, BindingEntry bindingEntry) {
        Entry entry;
        int n;
        TreeSet treeSet = new TreeSet(new SymTabEntryComparator());
        Vector<TypeEntry> vector = new Vector<TypeEntry>();
        BindingOperationEntry bindingOperationEntry = bindingEntry.getOperation(operation);
        for (n = 0; n < bindingOperationEntry.numParameters(); ++n) {
            entry = bindingOperationEntry.getParameter(n);
            vector.add(((BindingParamEntry)entry).getType());
        }
        if (bindingOperationEntry.getReturn() != null) {
            vector.add(bindingOperationEntry.getReturn().getType());
        }
        if (bindingOperationEntry.numFaults() > 0) {
            for (n = 0; n < bindingOperationEntry.numFaults(); ++n) {
                entry = bindingOperationEntry.getFault(n).getMessageEntry();
                for (int i = 0; i < ((MessageEntry)entry).getFaultParts().size(); ++i) {
                    ChildFaultPartEntry childFaultPartEntry = (ChildFaultPartEntry)((MessageEntry)entry).getFaultParts().elementAt(i);
                    vector.add(childFaultPartEntry.getType());
                }
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            treeSet.add(vector.get(n));
        }
        return treeSet;
    }

    private void writeSerializationInit(PrintWriter printWriter, Type type) throws IOException {
        String string = type.getName();
        if (string.endsWith("[]")) {
            String string2 = JavaUtils.getWrapper(string = string.substring(0, string.length() - 2));
            if (string2 != null) {
                this.writeSerializationInit(printWriter, type, string2 + "[]");
            }
        } else {
            String string3 = JavaUtils.getWrapper(string);
            if (string3 != null) {
                this.writeSerializationInit(printWriter, type, string3);
            }
        }
        this.writeSerializationInit(printWriter, type, type.getName());
    }

    private void writeSerializationInit(PrintWriter printWriter, Type type, String string) {
        QName qName = type.getQName();
        printWriter.println("        javaType = " + string + ".class;");
        printWriter.println("        xmlType = com.ibm.ws.webservices.engine.utils.QNameTable.createQName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\");");
        String string2 = JavaStubWriter.getSerializerFactoryName(type, string, this.emitter) + ".class";
        String string3 = JavaStubWriter.getDeserializerFactoryName(type, string, this.emitter) + ".class";
        String string4 = "";
        if (type.getDynamicVar("CustomBinderName") != null) {
            string4 = ", \"" + type.getDynamicVar("CustomBinderName") + "\"";
        } else if (type.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN) != null) {
            qName = ((Entry)type.getChildren().get(0)).getQName();
            printWriter.println("        compQName = com.ibm.ws.webservices.engine.utils.QNameTable.createQName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\");");
            qName = ((TypeEntry)type.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN)).getQName();
            printWriter.println("        compTypeQName = com.ibm.ws.webservices.engine.utils.QNameTable.createQName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\");");
            string4 = ", compQName, compTypeQName";
        } else if (type.isList()) {
            Type type2 = type;
            while (type2.getRefType() != null && ((Type)type2.getRefType()).isList()) {
                type2 = (Type)type2.getRefType();
            }
            qName = type2.getRefType().getQName();
            printWriter.println("        compTypeQName = com.ibm.ws.webservices.engine.utils.QNameTable.createQName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\");");
            string4 = ", null, compTypeQName";
        } else if (type.getDimensions().length() > 0 && string2.equals("com.ibm.ws.webservices.engine.encoding.ser.ArraySerializerFactory.class")) {
            TypeEntry typeEntry = type.getRefType();
            if (typeEntry != null) {
                while (typeEntry.getRefType() != null && !(typeEntry instanceof Type)) {
                    typeEntry = typeEntry.getRefType();
                }
                qName = typeEntry.getQName();
                printWriter.println("        compTypeQName = com.ibm.ws.webservices.engine.utils.QNameTable.createQName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\");");
                string4 = ", null, compTypeQName";
            }
        } else if (type.isSimpleType()) {
            Type type3;
            for (type3 = type.getRestrictionBase(); type3 != null && type3.getRestrictionBase() != null; type3 = type3.getRestrictionBase()) {
            }
            if (type3 != null) {
                qName = type3.getQName();
                printWriter.println("        compTypeQName = com.ibm.ws.webservices.engine.utils.QNameTable.createQName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\");");
                string4 = ", null, compTypeQName";
            }
        }
        printWriter.println("        sf = com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory.createFactory(" + string2 + ", javaType, xmlType" + string4 + ");");
        printWriter.println("        df = com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory.createFactory(" + string3 + ", javaType, xmlType" + string4 + ");");
        printWriter.println("        if (sf != null || df != null) {");
        printWriter.println("            tm.register(javaType, xmlType, sf, df);");
        printWriter.println("        }");
        printWriter.println();
    }

    private void writeOperation(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry, boolean bl) throws IOException {
        this.writeComment(printWriter, bindingOperationEntry.getBindingOperation().getOperation().getDocumentationElement());
        String string = (String)bindingOperationEntry.getDynamicVar(JavaGeneratorFactory.SIGNATURE);
        printWriter.println(string + " {");
        printWriter.println("        if (super.cachedEndpoint == null) {");
        printWriter.println("            throw new com.ibm.ws.webservices.engine.NoEndPointException();");
        printWriter.println("        }");
        if (bindingOperationEntry.numOuts() > 0 || bindingOperationEntry.numInOuts() > 0) {
            printWriter.println("        java.util.Vector _resp = null;");
        }
        String string2 = bindingOperationEntry.getName();
        String string3 = "_get" + string2 + "Invoke" + this.methodNumber;
        printWriter.println("        try {");
        printWriter.print("            ");
        if (bindingOperationEntry.numOuts() > 0 || bindingOperationEntry.numInOuts() > 0) {
            printWriter.print("_resp = ");
        }
        printWriter.print(string3 + "(new java.lang.Object[] {");
        this.writeParameters(printWriter, bindingOperationEntry);
        printWriter.println("}).invoke();");
        printWriter.println();
        boolean bl2 = false;
        printWriter.println("        } catch (com.ibm.ws.webservices.engine.WebServicesFault wsf) {");
        printWriter.println("            Exception e = wsf.getUserException();");
        if (this.emitter.getNoDataBinding()) {
            printWriter.println("                if (e instanceof javax.xml.rpc.soap.SOAPFaultException) {");
            printWriter.println("                    throw (javax.xml.rpc.soap.SOAPFaultException) e;");
            printWriter.println("                }");
            bl2 = true;
        }
        if (bindingOperationEntry.numFaults() > 0) {
            printWriter.println("            if (e != null) {");
            for (int i = 0; i < bindingOperationEntry.numFaults(); ++i) {
                BindingFaultRefEntry bindingFaultRefEntry = bindingOperationEntry.getFault(i);
                MessageEntry messageEntry = bindingFaultRefEntry.getMessageEntry();
                SymTabEntry symTabEntry = (SymTabEntry)messageEntry.getDynamicVar(JavaGeneratorFactory.EXCEPTION_SYMTAB_ENTRY);
                String string4 = symTabEntry.getName();
                if ("javax.xml.soap.SOAPElement".equals(symTabEntry.getName())) {
                    string4 = "javax.xml.rpc.soap.SOAPFaultException";
                    if (bl2) continue;
                    bl2 = true;
                }
                printWriter.println("                if (e instanceof " + string4 + ") {");
                printWriter.println("                    throw (" + string4 + ") e;");
                printWriter.println("                }");
            }
            printWriter.println("            }");
        }
        printWriter.println("            throw wsf;");
        printWriter.println("        } ");
        if (!bl) {
            this.writeResponseHandling(printWriter, bindingOperationEntry);
        }
        printWriter.println("    }");
        printWriter.println();
    }

    private void writeParameters(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry) {
        boolean bl = false;
        for (int i = 0; i < bindingOperationEntry.numParameters(); ++i) {
            BindingParamEntry bindingParamEntry = bindingOperationEntry.getParameter(i);
            if (bindingParamEntry.getMode() == 2) continue;
            if (bl) {
                printWriter.print(", ");
            } else {
                bl = true;
            }
            String string = bindingParamEntry.getName();
            if (bindingParamEntry.getMode() != 1) {
                string = string + ".value";
            }
            if (bindingParamEntry.getMIMEType() == null) {
                string = Utils.wrapPrimitiveType(bindingParamEntry.getType().getQName(), string, (String)bindingParamEntry.getDynamicVar("parameterType"));
            }
            printWriter.print(string);
        }
    }

    private void writeResponseHandling(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry) {
        int n = bindingOperationEntry.numOuts() + bindingOperationEntry.numInOuts();
        if (n > 0) {
            if (n == 1) {
                if (bindingOperationEntry.getReturn() != null) {
                    this.writeOutputAssign(printWriter, "        ", "return ", bindingOperationEntry.getReturn(), "((com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue) _resp.get(0)).getValue()");
                } else {
                    int n2 = 0;
                    BindingParamEntry bindingParamEntry = bindingOperationEntry.getParameter(n2);
                    while (bindingParamEntry.getMode() == 1) {
                        bindingParamEntry = bindingOperationEntry.getParameter(++n2);
                    }
                    String string = bindingParamEntry.getName();
                    this.writeOutputAssign(printWriter, "            ", string + ".value = ", bindingParamEntry, "((com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue) _resp.get(0)).getValue()");
                }
            } else {
                if (bindingOperationEntry.getReturn() != null) {
                    printWriter.println("        Object _returnObj = null;");
                }
                printWriter.println("        for (int _i = 0; _i < _resp.size(); ++_i) {");
                printWriter.println("            com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue _param = (com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue) _resp.get(_i);");
                String string = "if";
                for (int i = 0; i < bindingOperationEntry.numParameters(); ++i) {
                    BindingParamEntry bindingParamEntry = bindingOperationEntry.getParameter(i);
                    if (bindingParamEntry.getMode() == 1) continue;
                    String string2 = bindingParamEntry.getName();
                    String string3 = Utils.getNewQName((QName)bindingParamEntry.getDynamicVar("parameterWireQName"));
                    printWriter.println("            " + string + " (" + string3 + ".equals(_param.getQName())) {");
                    this.writeOutputAssign(printWriter, "                ", string2 + ".value = ", bindingParamEntry, "_param.getValue()");
                    printWriter.println("            }");
                    string = "else if";
                }
                if (bindingOperationEntry.getReturn() != null) {
                    printWriter.println("            else {");
                    printWriter.println("                _returnObj = _param.getValue();");
                    printWriter.println("            }");
                }
                printWriter.println("        }");
                if (bindingOperationEntry.getReturn() != null) {
                    this.writeOutputAssign(printWriter, "        ", "return ", bindingOperationEntry.getReturn(), "_returnObj");
                }
            }
        }
    }

    private void writeOutputAssign(PrintWriter printWriter, String string, String string2, BindingParamEntry bindingParamEntry, String string3) {
        TypeEntry typeEntry = bindingParamEntry.getType();
        String string4 = bindingParamEntry.getMIMEType();
        while (typeEntry instanceof Element && !typeEntry.isCollectionTypeEntry()) {
            typeEntry = typeEntry.getRefType();
        }
        if (typeEntry != null && typeEntry.getName() != null) {
            printWriter.println(string + "try {");
            printWriter.println(string + "    " + string2 + Utils.getResponseString(bindingParamEntry, string3));
            printWriter.println(string + "} catch (java.lang.Exception _exception) {");
            String string5 = string4 == null ? typeEntry.getName() : JavaUtils.mimeToJava(string4);
            printWriter.println(string + "    " + string2 + Utils.getResponseString(bindingParamEntry, "super.convert(" + string3 + ", " + Utils.realType(bindingParamEntry) + ".class)"));
            printWriter.println(string + "}");
        } else {
            printWriter.println(string + string2 + Utils.getResponseString(bindingParamEntry, string3));
        }
    }

    static boolean needTypeMapping(TypeEntry typeEntry, Emitter emitter) {
        boolean bl = true;
        if (!typeEntry.isReferenced() || typeEntry.isOnlyWrappedLiteralReferenced() || emitter.getNoDataBinding() || typeEntry.isBaseType() && typeEntry.getRefType() == null || typeEntry.isCollectionTypeEntry() || !(typeEntry instanceof Type)) {
            bl = false;
        }
        return bl;
    }

    static String getSerializerFactoryName(Type type, String string, Emitter emitter) {
        Type type2;
        String string2 = null;
        for (type2 = type.getRestrictionBase(); type2 != null && type2.getRestrictionBase() != null; type2 = type2.getRestrictionBase()) {
        }
        QName qName = type2 != null ? type2.getQName() : null;
        String string3 = (String)type.getDynamicVar("CustomBinderName");
        string2 = string3 != null ? "com.ibm.ws.webservices.engine.encoding.ser.CustomSerializerFactory" : (string.equals("org.w3c.dom.Element") ? "com.ibm.ws.webservices.engine.encoding.ser.ElementSerializerFactory" : (string.equals("javax.xml.soap.SOAPElement") ? "com.ibm.ws.webservices.engine.encoding.ser.SOAPElementSerializerFactory" : (type.isList() ? "com.ibm.ws.webservices.engine.encoding.ser.ListSerializerFactory" : (string.equals("byte[]") && Constants.equals(Constants.XSD_BASE64, qName) ? "com.ibm.ws.webservices.engine.encoding.ser.Base64SerializerFactory" : (string.equals("byte[]") && Constants.equals(Constants.XSD_HEXBIN, qName) ? "com.ibm.ws.webservices.engine.encoding.ser.HexSerializerFactory" : (string.endsWith("[]") ? "com.ibm.ws.webservices.engine.encoding.ser.ArraySerializerFactory" : (type.getNode() != null && type.isEnumeration() ? "com.ibm.ws.webservices.engine.encoding.ser.EnumSerializerFactory" : (string.equals("java.util.Calendar") ? "com.ibm.ws.webservices.engine.encoding.ser.CalendarSerializerFactory" : (string.equals("javax.xml.namespace.QName") ? "com.ibm.ws.webservices.engine.encoding.ser.QNameSerializerFactory" : (string.equals("java.util.Date") ? "com.ibm.ws.webservices.engine.encoding.ser.DateSerializerFactory" : (type.isSimpleContent() ? "com.ibm.ws.webservices.engine.encoding.ser.SimpleBeanSerializerFactory" : (type.isSimpleType() ? "com.ibm.ws.webservices.engine.encoding.ser.SimpleSerializerFactory" : "com.ibm.ws.webservices.engine.encoding.ser.BeanSerializerFactory"))))))))))));
        return string2;
    }

    static String getDeserializerFactoryName(Type type, String string, Emitter emitter) {
        Type type2;
        String string2 = null;
        for (type2 = type.getRestrictionBase(); type2 != null && type2.getRestrictionBase() != null; type2 = type2.getRestrictionBase()) {
        }
        QName qName = type2 != null ? type2.getQName() : null;
        String string3 = (String)type.getDynamicVar("CustomBinderName");
        string2 = string3 != null ? "com.ibm.ws.webservices.engine.encoding.ser.CustomDeserializerFactory" : (string.equals("org.w3c.dom.Element") ? "com.ibm.ws.webservices.engine.encoding.ser.ElementDeserializerFactory" : (string.equals("javax.xml.soap.SOAPElement") ? "com.ibm.ws.webservices.engine.encoding.ser.SOAPElementDeserializerFactory" : (type.isList() ? "com.ibm.ws.webservices.engine.encoding.ser.ListDeserializerFactory" : (string.equals("byte[]") && Constants.equals(Constants.XSD_BASE64, qName) ? "com.ibm.ws.webservices.engine.encoding.ser.Base64DeserializerFactory" : (string.equals("byte[]") && Constants.equals(Constants.XSD_HEXBIN, qName) ? "com.ibm.ws.webservices.engine.encoding.ser.HexDeserializerFactory" : (string.endsWith("[]") ? "com.ibm.ws.webservices.engine.encoding.ser.ArrayDeserializerFactory" : (type.getNode() != null && type.isEnumeration() ? "com.ibm.ws.webservices.engine.encoding.ser.EnumDeserializerFactory" : (string.equals("java.util.Calendar") ? "com.ibm.ws.webservices.engine.encoding.ser.CalendarDeserializerFactory" : (string.equals("javax.xml.namespace.QName") ? "com.ibm.ws.webservices.engine.encoding.ser.QNameDeserializerFactory" : (string.equals("java.util.Date") ? "com.ibm.ws.webservices.engine.encoding.ser.DateDeserializerFactory" : (type.isSimpleContent() ? "com.ibm.ws.webservices.engine.encoding.ser.SimpleBeanDeserializerFactory" : (type.isSimpleType() ? "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializerFactory" : "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializerFactory"))))))))))));
        return string2;
    }
}

