/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.wsdl.Generator;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.GenCriteria;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaServiceIfaceWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaServiceImplWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaServiceInformationWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaTestCaseWriter;
import com.ibm.ws.webservices.wsdl.toJava.Role;
import java.io.IOException;
import javax.wsdl.Service;

public class JavaServiceWriter
implements Generator {
    protected Emitter emitter;
    Generator serviceIfaceWriter = null;
    Generator serviceImplWriter = null;
    Generator serviceDataWriter = null;
    Generator testCaseWriter = null;
    private boolean isDeploy = false;

    public JavaServiceWriter(Emitter emitter, Service service, SymbolTable symbolTable) {
        this.emitter = emitter;
        ServiceEntry serviceEntry = symbolTable.getServiceEntry(service.getQName());
        if (serviceEntry.isReferenced()) {
            if (emitter.getRole() == Role.CLIENT || emitter.getRole() == Role.DEVELOP_CLIENT || emitter.getRole() == Role.DEPLOY_CLIENT) {
                this.serviceIfaceWriter = new JavaServiceIfaceWriter(emitter, serviceEntry, symbolTable);
                if (emitter.getRole() == Role.DEPLOY_CLIENT && emitter.getToolEnv().fileExists(((JavaClassWriter)this.serviceIfaceWriter).getFileName())) {
                    this.serviceIfaceWriter = null;
                }
            }
            if (emitter.getRole() == Role.CLIENT || emitter.getRole() == Role.DEPLOY_CLIENT) {
                this.serviceImplWriter = new JavaServiceImplWriter(emitter, serviceEntry, symbolTable);
            }
            if (emitter.getRole() == Role.CLIENT || emitter.getRole() == Role.DEPLOY_CLIENT) {
                this.serviceDataWriter = new JavaServiceInformationWriter(emitter, serviceEntry, symbolTable);
            }
            if (emitter.isTestCaseWanted() && (emitter.getRole() == Role.CLIENT || emitter.getRole() == Role.DEVELOP_CLIENT)) {
                this.testCaseWriter = new JavaTestCaseWriter(emitter, serviceEntry, symbolTable);
            }
        }
    }

    public boolean isDeployPhaseOnlyWriter() {
        return this.isDeploy;
    }

    public void setDeployPhaseOnly(boolean bl) {
        this.isDeploy = bl;
    }

    public void generate() throws IOException {
        if (this.emitter.getGenJava() != GenCriteria.NO) {
            if (this.serviceIfaceWriter != null) {
                this.serviceIfaceWriter.generate();
            }
            if (this.serviceImplWriter != null) {
                this.serviceImplWriter.generate();
            }
            if (this.serviceDataWriter != null) {
                this.serviceDataWriter.generate();
            }
            if (this.testCaseWriter != null) {
                this.testCaseWriter.generate();
            }
        }
    }
}

