/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntryComparator;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaStubWriter;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import com.ibm.ws.webservices.wsdl.utils.OperationDescBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;

public class JavaServiceInformationWriter
extends JavaClassWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;

    protected JavaServiceInformationWriter(Emitter emitter, ServiceEntry serviceEntry, SymbolTable symbolTable) {
        super(emitter, serviceEntry.getName() + "Information", "service");
        this.sEntry = serviceEntry;
        this.symbolTable = symbolTable;
        this.setDeployPhaseOnly(true);
    }

    protected String getExtendsText() {
        return "";
    }

    protected String getImplementsText() {
        return "implements com.ibm.ws.webservices.multiprotocol.ServiceInformation ";
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        Service service = this.sEntry.getService();
        this.writeComment(printWriter, service.getDocumentationElement());
        TreeSet treeSet = new TreeSet(new SymTabEntryComparator());
        ArrayList<PortType> arrayList = new ArrayList<PortType>();
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.sEntry.numPorts(); ++i) {
            ArrayList<BindingOperationEntry> arrayList2 = new ArrayList<BindingOperationEntry>();
            PortEntry portEntry = this.sEntry.getPort(i);
            Port port2 = portEntry.getPort();
            Binding binding = port2.getBinding();
            if (binding == null) {
                throw new IOException(Messages.getMessage("emitFailNoBinding01", new String[]{port2.getName()}));
            }
            BindingEntry bindingEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bindingEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoBindingEntry01", new String[]{binding.getQName().toString()}));
            }
            PortTypeEntry portTypeEntry = this.symbolTable.getPortTypeEntry(binding.getPortType().getQName());
            if (portTypeEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoPortType01", new String[]{binding.getPortType().getQName().toString()}));
            }
            this.populateTypesFromPortType(binding.getPortType(), bindingEntry, treeSet);
            if (bindingEntry.isReferenced() && !arrayList.contains(binding.getPortType())) {
                arrayList.add(binding.getPortType());
                List list = binding.getBindingOperations();
                for (int j = 0; j < list.size(); ++j) {
                    BindingOperation bindingOperation = (BindingOperation)list.get(j);
                    BindingOperationEntry bindingOperationEntry = bindingEntry.getOperation(bindingOperation.getOperation());
                    Operation operation = bindingOperation.getOperation();
                    OperationType operationType = operation.getStyle();
                    if (operationType == OperationType.NOTIFICATION || operationType == OperationType.SOLICIT_RESPONSE) continue;
                    arrayList2.add(bindingOperationEntry);
                }
            }
            if (arrayList2.size() > 1) {
                Collections.sort(arrayList2, new Comparator(){

                    public int compare(Object object, Object object2) {
                        int n = 0;
                        try {
                            n = ((BindingOperationEntry)object).getName().compareTo(((BindingOperationEntry)object2).getName());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return n;
                    }
                });
            }
            hashMap.put(port2, arrayList2);
        }
        this.writeStaticInitializer(printWriter);
        this.writeOperationDescriptions(printWriter, hashMap);
        this.writeTypeMappingMethods(printWriter, treeSet);
        this.writeGetOperationDescMethods(printWriter);
    }

    private void populateTypesFromPortType(PortType portType, BindingEntry bindingEntry, Set set) {
        Serializable serializable;
        TreeSet treeSet = new TreeSet(new SymTabEntryComparator());
        List list = portType.getOperations();
        for (int i = 0; i < list.size(); ++i) {
            serializable = (Operation)list.get(i);
            treeSet.addAll(JavaStubWriter.getTypesInOperation(serializable, bindingEntry));
        }
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            serializable = (TypeEntry)iterator.next();
            if (set.contains(serializable)) continue;
            set.add(serializable);
            set.addAll(Utils.getNestedTypes((TypeEntry)serializable, this.symbolTable));
        }
    }

    protected void writeTypeMappingMethods(PrintWriter printWriter, Set set) throws IOException {
        this.writeTypeMappingInitialization(printWriter, set);
        this.writeGetTypeMappings(printWriter);
        this.writeGetJavaType(printWriter);
    }

    protected void writeTypeMappingInitialization(PrintWriter printWriter, Set set) throws IOException {
        printWriter.println("    private static void initTypeMappings() {");
        printWriter.println("        typeMappings = new java.util.HashMap();");
        this.writeTypeMappings(printWriter, set);
        printWriter.println("        typeMappings = java.util.Collections.unmodifiableMap(typeMappings);");
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeGetTypeMappings(PrintWriter printWriter) throws IOException {
        printWriter.println("    public java.util.Map getTypeMappings() {");
        printWriter.println("        return typeMappings;");
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeGetJavaType(PrintWriter printWriter) throws IOException {
        printWriter.println("    public Class getJavaType(javax.xml.namespace.QName xmlName) {");
        printWriter.println("        return (Class) typeMappings.get(xmlName);");
        printWriter.println("    }");
        printWriter.println();
    }

    private void writeTypeMappings(PrintWriter printWriter, Set set) throws IOException {
        int n = 0;
        int n2 = 1;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            TypeEntry typeEntry = (TypeEntry)iterator.next();
            if (typeEntry.isBaseType() && typeEntry.getRefType() == null || typeEntry.isCollectionTypeEntry() || !(typeEntry instanceof Type) || !typeEntry.isReferenced() || typeEntry.isOnlyWrappedLiteralReferenced()) continue;
            if (n < 200) {
                this.writeType(printWriter, (Type)typeEntry);
                ++n;
                continue;
            }
            printWriter.println("        initTypeMappings" + ++n2 + "();");
            printWriter.println("    }");
            printWriter.println("");
            printWriter.println("    private static void initTypeMappings" + n2 + "() {");
            printWriter.println("        typeMappings = new java.util.HashMap();");
            this.writeType(printWriter, (Type)typeEntry);
            n = 0;
        }
    }

    private void writeType(PrintWriter printWriter, Type type) throws IOException {
        QName qName = type.getQName();
        printWriter.println("        typeMappings.put(com.ibm.ws.webservices.engine.utils.QNameTable.createQName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\"),");
        printWriter.println("                         " + type.getName() + ".class);");
        printWriter.println();
    }

    protected void writeStaticInitializer(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("    private static java.util.Map operationDescriptions;");
        printWriter.println("    private static java.util.Map typeMappings;");
        printWriter.println();
        printWriter.println("    static {");
        printWriter.println("         initOperationDescriptions();");
        printWriter.println("         initTypeMappings();");
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeOperationDescriptions(PrintWriter printWriter, HashMap hashMap) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter2 = new PrintWriter(byteArrayOutputStream);
        printWriter.println("    private static void initOperationDescriptions() { ");
        printWriter.println("        operationDescriptions = new java.util.HashMap();");
        printWriter.println();
        HashMap<QName, String> hashMap2 = new HashMap<QName, String>();
        Iterator iterator = hashMap.keySet().iterator();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            Port port2 = (Port)iterator.next();
            List list = (List)hashMap.get(port2);
            QName qName = port2.getBinding().getPortType().getQName();
            BindingEntry bindingEntry = this.symbolTable.getBindingEntry(port2.getBinding().getQName());
            String string = "";
            String string2 = (String)hashMap2.get(qName);
            if (string2 != null) {
                string = string2;
            } else {
                string = "inner" + n;
                hashMap2.put(qName, string);
                printWriter.println("        java.util.Map " + string + " = new java.util.HashMap();");
                printWriter.println();
            }
            String string3 = null;
            String string4 = null;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                BindingOperationEntry bindingOperationEntry = (BindingOperationEntry)iterator2.next();
                if (!bindingOperationEntry.getName().equals(string3)) {
                    string4 = "list" + n2;
                    printWriter.println("        java.util.List " + string4 + " = new java.util.ArrayList();");
                    printWriter.println("        " + string + ".put(\"" + bindingOperationEntry.getName() + "\", " + string4 + ");");
                    printWriter.println();
                }
                this.writeOperationEntry(printWriter, printWriter2, bindingOperationEntry, bindingEntry, string4, n2);
                string3 = bindingOperationEntry.getName();
                ++n2;
            }
            if (string != null) {
                printWriter.println("        operationDescriptions.put(\"" + port2.getName() + "\"," + string + ");");
            }
            ++n;
        }
        printWriter.println("        operationDescriptions = java.util.Collections.unmodifiableMap(operationDescriptions);");
        printWriter.println("    }");
        printWriter.println();
        printWriter2.flush();
        printWriter.println(byteArrayOutputStream.toString());
    }

    protected void writeOperationEntryOld(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry, BindingEntry bindingEntry, String string, int n) throws IOException {
        String string2 = bindingOperationEntry.getName();
        String string3 = string2 + n + "Op";
        this.writeOperationDesc(printWriter, bindingOperationEntry, bindingEntry, string3, n);
        printWriter.println("        " + string + ".add(" + string3 + ");");
        printWriter.println();
    }

    protected void writeOperationEntry(PrintWriter printWriter, PrintWriter printWriter2, BindingOperationEntry bindingOperationEntry, BindingEntry bindingEntry, String string, int n) throws IOException {
        String string2 = bindingOperationEntry.getName();
        String string3 = string2 + n + "Op";
        this.writeOperationDescCall(printWriter, string3);
        printWriter.println("        " + string + ".add(" + string3 + ");");
        printWriter.println();
        this.writeOperationDescMethod(printWriter2, bindingOperationEntry, bindingEntry, string3);
    }

    protected void writeOperationDesc(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry, BindingEntry bindingEntry, String string, int n) throws IOException {
        OperationDescBuilder operationDescBuilder = OperationDescBuilder.create(bindingOperationEntry, bindingEntry, this.symbolTable);
        printWriter.println("        com.ibm.ws.webservices.engine.description.OperationDesc " + string + " = null;");
        operationDescBuilder.writeOperationDesc(printWriter, true, "        ", string, n);
    }

    protected void writeOperationDescMethod(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry, BindingEntry bindingEntry, String string) throws IOException {
        OperationDescBuilder operationDescBuilder = OperationDescBuilder.create(bindingOperationEntry, bindingEntry, this.symbolTable);
        printWriter.println("    private static com.ibm.ws.webservices.engine.description.OperationDesc _" + string + "() {");
        printWriter.println("        com.ibm.ws.webservices.engine.description.OperationDesc " + string + " = null;");
        operationDescBuilder.writeOperationDesc(printWriter, true, "        ", string, 0);
        printWriter.println("        return " + string + ";");
        printWriter.println();
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeOperationDescCall(PrintWriter printWriter, String string) throws IOException {
        printWriter.println("        com.ibm.ws.webservices.engine.description.OperationDesc " + string + " = _" + string + "();");
    }

    protected void writeGetOperationDescMethods(PrintWriter printWriter) throws IOException {
        printWriter.println("    public java.util.Map getOperationDescriptions(String portName) {");
        printWriter.println("        return (java.util.Map) operationDescriptions.get(portName);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public java.util.List getOperationDescriptions(String portName, String operationName) {");
        printWriter.println("        java.util.Map map = (java.util.Map) operationDescriptions.get(portName);");
        printWriter.println("        if (map != null) {");
        printWriter.println("            return (java.util.List) map.get(operationName);");
        printWriter.println("        }");
        printWriter.println("        return null;");
        printWriter.println("    }");
        printWriter.println();
    }
}

