/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.models;

import com.ibm.ws.webservices.multiprotocol.provider.StubGenerator;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import com.ibm.ws.webservices.wsdl.utils.OperationDescBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;

public abstract class ModelStubGenerator
extends JavaClassWriter
implements StubGenerator {
    protected BindingEntry bindingEntry;
    protected Binding binding;
    protected SymbolTable symbolTable;
    private static final String indent = "    ";
    private static final String indent2 = "        ";
    private static final String indent3 = "            ";
    private static final String indent4 = "                ";
    private int suffixId = 0;
    private int methodNumber = 0;

    public ModelStubGenerator(Emitter emitter, BindingEntry bindingEntry, SymbolTable symbolTable) {
        super(emitter, bindingEntry.getName() + "Stub", "stub");
        this.bindingEntry = bindingEntry;
        this.binding = bindingEntry.getBinding();
        this.symbolTable = symbolTable;
    }

    protected abstract String getExtendsText();

    protected String getImplementsText() {
        return "implements " + this.bindingEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME) + " ";
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        PortType portType = this.binding.getPortType();
        boolean bl = Utils.hasMIME(this.bindingEntry);
        this.writeConstructors(printWriter, false);
        List list = this.binding.getBindingOperations();
        for (int i = 0; i < list.size(); ++i) {
            BindingOperation bindingOperation = (BindingOperation)list.get(i);
            BindingOperationEntry bindingOperationEntry = this.bindingEntry.getOperation(bindingOperation.getOperation());
            Operation operation = bindingOperation.getOperation();
            OperationType operationType = operation.getStyle();
            if (operationType == OperationType.NOTIFICATION || operationType == OperationType.SOLICIT_RESPONSE) {
                printWriter.println(bindingOperationEntry.getDynamicVar(JavaGeneratorFactory.SIGNATURE));
                printWriter.println();
                continue;
            }
            this.writeOperation(printWriter, bindingOperationEntry, operationType == OperationType.ONE_WAY);
            ++this.methodNumber;
        }
    }

    protected void writeConstructors(PrintWriter printWriter, boolean bl) {
        printWriter.println("    public " + this.className + "(java.net.URL endpointURL, javax.xml.rpc.Service service) throws com.ibm.ws.webservices.engine.WebServicesFault {");
        printWriter.println("        if (service == null) {");
        printWriter.println("            super.service = new com.ibm.ws.webservices.multiprotocol.AgnosticService();");
        printWriter.println("        }");
        printWriter.println("        else {");
        printWriter.println("            super.service = service;");
        printWriter.println("        }");
        printWriter.println("        setEndpoint(endpointURL);");
        printWriter.println("        setSEIClass(" + this.bindingEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME) + ".class);");
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeOperationDesc(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry, BindingEntry bindingEntry, String string, String string2) throws IOException {
        OperationDescBuilder operationDescBuilder = OperationDescBuilder.create(bindingOperationEntry, bindingEntry, this.symbolTable);
        operationDescBuilder.writeOperationDesc(printWriter, true, indent2, string2, this.suffixId++);
    }

    private void writeSerializationInit(PrintWriter printWriter, Type type) throws IOException {
        QName qName = type.getQName();
        printWriter.println("        javaType = " + type.getName() + ".class;");
        printWriter.println("        xmlType = com.ibm.ws.webservices.engine.utils.QNameTable.createQName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\");");
        String string = null;
        String string2 = null;
        if (type.getName().equals("org.w3c.dom.Element")) {
            string = "com.ibm.ws.webservices.engine.encoding.ser.ElementSerializerFactory.class";
            string2 = "com.ibm.ws.webservices.engine.encoding.ser.ElementDeserializerFactory.class";
        } else if (type.getName().equals("javax.xml.soap.SOAPElement")) {
            string = "com.ibm.ws.webservices.engine.encoding.ser.SOAPElementSerializerFactory.class";
            string2 = "com.ibm.ws.webservices.engine.encoding.ser.SOAPElementDeserializerFactory.class";
        } else if (type.getName().endsWith("[]")) {
            string = "com.ibm.ws.webservices.engine.encoding.ser.ArraySerializerFactory.class";
            string2 = "com.ibm.ws.webservices.engine.encoding.ser.ArrayDeserializerFactory.class";
        } else if (type.getNode() != null && type.isEnumeration()) {
            string = "com.ibm.ws.webservices.engine.encoding.ser.EnumSerializerFactory.class";
            string2 = "com.ibm.ws.webservices.engine.encoding.ser.EnumDeserializerFactory.class";
        } else if (type.isSimpleType()) {
            string = "com.ibm.ws.webservices.engine.encoding.ser.SimpleSerializerFactory.class";
            string2 = "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializerFactory.class";
        } else if (type.isSimpleContent()) {
            string = "com.ibm.ws.webservices.engine.encoding.ser.SimpleBeanSerializerFactory.class";
            string2 = "com.ibm.ws.webservices.engine.encoding.ser.SimpleBeanDeserializerFactory.class";
        } else {
            string = "com.ibm.ws.webservices.engine.encoding.ser.BeanSerializerFactory.class";
            string2 = "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializerFactory.class";
        }
        printWriter.println("        sf = com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory.createFactory(" + string + ", javaType, xmlType);");
        printWriter.println("        df = com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory.createFactory(" + string2 + ", javaType, xmlType);");
        printWriter.println("        if (sf != null || df != null) {");
        printWriter.println("            tm.register(javaType, xmlType, sf, df);");
        printWriter.println("        }");
        printWriter.println();
    }

    private void writeOperation(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry, boolean bl) throws IOException {
        this.writeComment(printWriter, bindingOperationEntry.getBindingOperation().getOperation().getDocumentationElement());
        String string = (String)bindingOperationEntry.getDynamicVar(JavaGeneratorFactory.SIGNATURE);
        printWriter.println(string + " {");
        String string2 = (String)this.bindingEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME);
        printWriter.println(indent2 + string2 + " _obj = \n" + indent3 + "(" + string2 + ") getTargetObject();");
        String string3 = bindingOperationEntry.getName();
        printWriter.print(indent2);
        if (!bl && bindingOperationEntry.getReturn() != null) {
            printWriter.print(bindingOperationEntry.getReturn().getType().getName() + " _resp = ");
        }
        printWriter.print("_obj." + string3 + "(");
        this.writeParameters(printWriter, bindingOperationEntry);
        printWriter.println(");");
        if (!bl && bindingOperationEntry.getReturn() != null) {
            printWriter.println("        return _resp;");
        }
        printWriter.println("    }");
        printWriter.println();
    }

    private void writeParameters(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry) {
        boolean bl = false;
        for (int i = 0; i < bindingOperationEntry.numParameters(); ++i) {
            BindingParamEntry bindingParamEntry = bindingOperationEntry.getParameter(i);
            if (bindingParamEntry.getMode() == 2) continue;
            if (bl) {
                printWriter.print(", ");
            } else {
                bl = true;
            }
            String string = bindingParamEntry.getName();
            if (bindingParamEntry.getMode() != 1) {
                string = string + ".value";
            }
            printWriter.print(string);
        }
    }

    private void writeResponseHandling(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry) {
        int n = bindingOperationEntry.numOuts() + bindingOperationEntry.numInOuts();
        if (n > 0) {
            if (n == 1) {
                if (bindingOperationEntry.getReturn() != null) {
                    this.writeOutputAssign(printWriter, indent2, "return ", bindingOperationEntry.getReturn(), "((com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue) _resp.get(0)).getValue()");
                } else {
                    int n2 = 0;
                    BindingParamEntry bindingParamEntry = bindingOperationEntry.getParameter(n2);
                    while (bindingParamEntry.getMode() == 1) {
                        bindingParamEntry = bindingOperationEntry.getParameter(++n2);
                    }
                    String string = bindingParamEntry.getName();
                    this.writeOutputAssign(printWriter, indent3, string + ".value = ", bindingParamEntry, "((com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue) _resp.get(0)).getValue()");
                }
            } else {
                if (bindingOperationEntry.getReturn() != null) {
                    printWriter.println("        Object _return = null;");
                }
                printWriter.println("        for (int _i = 0; _i < _resp.size(); ++_i) {");
                printWriter.println("            com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue _param = (com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue) _resp.get(_i);");
                String string = "if";
                for (int i = 0; i < bindingOperationEntry.numParameters(); ++i) {
                    BindingParamEntry bindingParamEntry = bindingOperationEntry.getParameter(i);
                    if (bindingParamEntry.getMode() == 1) continue;
                    String string2 = bindingParamEntry.getName();
                    String string3 = Utils.getNewQName((QName)bindingParamEntry.getDynamicVar("parameterWireQName"));
                    printWriter.println(indent3 + string + " (" + string3 + ".equals(_param.getQName())) {");
                    this.writeOutputAssign(printWriter, indent4, string2 + ".value = ", bindingParamEntry, "_param.getValue()");
                    printWriter.println("            }");
                    string = "else if";
                }
                if (bindingOperationEntry.getReturn() != null) {
                    printWriter.println("            else {");
                    printWriter.println("                _return = _param.getValue();");
                    printWriter.println("            }");
                }
                printWriter.println("        }");
                if (bindingOperationEntry.getReturn() != null) {
                    this.writeOutputAssign(printWriter, indent2, "return ", bindingOperationEntry.getReturn(), "_return");
                }
            }
        }
    }

    private void writeOutputAssign(PrintWriter printWriter, String string, String string2, BindingParamEntry bindingParamEntry, String string3) {
        if (bindingParamEntry != null && bindingParamEntry.getName() != null) {
            printWriter.println(string + "try {");
            printWriter.println(string + indent + string2 + Utils.getResponseString(bindingParamEntry, string3));
            printWriter.println(string + "} catch (java.lang.Exception _exception) {");
            printWriter.println(string + indent + string2 + Utils.getResponseString(bindingParamEntry, "com.ibm.ws.webservices.engine.utils.JavaUtils.convert(" + string3 + ", " + bindingParamEntry.getName() + ".class)"));
            printWriter.println(string + "}");
        } else {
            printWriter.println(string + string2 + Utils.getResponseString(bindingParamEntry, string3));
        }
    }
}

