/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.modutils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.client.ApplicationWSDLLocator;
import com.ibm.ws.webservices.client.ModuleWSDLLocator;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.modutils.ClientBndUtil;
import com.ibm.ws.webservices.modutils.PreferredPortDescriptor;
import com.ibm.ws.webservices.multiprotocol.utils.WSDLFactoryImpl;
import com.ibm.ws.webservices.tools.WSDLQuery;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.w3c.dom.Document;

public class WSDLPPMapper {
    protected static final TraceComponent tc = Tr.register(WSDLPPMapper.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private String wsdlName;
    private ResourceSet resourceSet;
    private WSDLQuery queryTool;
    private String noneValue;
    private WSDLFactoryImpl wsdlFactory;

    public WSDLPPMapper(String string, InputStream inputStream, LoadStrategy loadStrategy) {
        block8: {
            this.wsdlName = null;
            this.resourceSet = null;
            this.queryTool = null;
            this.noneValue = "none";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "WSDLPPMapper(wName,InputStream), WSDL: ", string);
            }
            this.wsdlName = string;
            try {
                if (this.wsdlFactory == null) {
                    this.wsdlFactory = new WSDLFactoryImpl();
                }
                WSDLReader wSDLReader = this.wsdlFactory.newWSDLReader();
                Definition definition = wSDLReader.readWSDL(new ModuleWSDLLocator(string, inputStream, loadStrategy));
                this.queryTool = new WSDLQuery();
                Document document = null;
                if (definition != null) {
                    WSDLWriter wSDLWriter = this.wsdlFactory.newWSDLWriter();
                    document = wSDLWriter.getDocument(definition);
                }
                this.queryTool.parse(string, document, definition);
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException(webServicesFault, "com.ibm.ws.webservices.modutils.WSDLPPMapper", "120");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception: " + JavaUtils.stackToString(webServicesFault));
                }
                Tr.error(tc, "WSWS0020E", "Failed to parse WSDL: " + this.wsdlName);
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception: " + JavaUtils.stackToString(throwable));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSDLPPMapper(wName ,InputStream) c'tor");
        }
    }

    public WSDLPPMapper(ResourceSet resourceSet, String string) {
        this.wsdlName = null;
        this.resourceSet = null;
        this.queryTool = null;
        this.noneValue = "none";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSDLPPMapper, WSDL: ", string);
        }
        this.resourceSet = resourceSet;
        this.wsdlName = string;
        URIConverter uRIConverter = resourceSet.getURIConverter();
        URI uRI = URI.createURI(this.wsdlName);
        try {
            InputStream inputStream = uRIConverter.createInputStream(uRI);
            if (this.wsdlFactory == null) {
                this.wsdlFactory = new WSDLFactoryImpl();
            }
            WSDLReader wSDLReader = this.wsdlFactory.newWSDLReader();
            Definition definition = wSDLReader.readWSDL(new ApplicationWSDLLocator(string, inputStream, resourceSet));
            this.queryTool = new WSDLQuery();
            Document document = null;
            if (definition != null) {
                WSDLWriter wSDLWriter = this.wsdlFactory.newWSDLWriter();
                document = wSDLWriter.getDocument(definition);
            }
            this.queryTool.parse(string, document, definition);
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException(webServicesFault, "com.ibm.ws.webservices.modutils.WSDLPPMapper", "179");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception: " + JavaUtils.stackToString(webServicesFault));
            }
            Tr.error(tc, "WSWS0020E", "Failed to parse WSDL: " + this.wsdlName);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.webservices.modutils.WSDLPPMapper", "187");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception: " + JavaUtils.stackToString(throwable));
            }
            Tr.error(tc, "WSWS0020E", "Failed to parse WSDL: " + this.wsdlName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Exiting WSDLPPMapper c'tor");
        }
    }

    public HashMap getPreferredPortMap(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPreferredPortMap", string);
        }
        HashMap<String, PreferredPortDescriptor> hashMap = new HashMap<String, PreferredPortDescriptor>();
        String string2 = ClientBndUtil.normalizeServiceName(string);
        if (this.queryTool == null) {
            Tr.error(tc, "WSWS0020E", "Failed to parse WSDL: " + this.wsdlName);
        } else {
            HashMap hashMap2 = this.queryTool.getServices();
            Iterator iterator = hashMap2.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                QName qName = QName.valueOf(string3);
                String string4 = qName.getLocalPart();
                if (!string4.equals(string2)) continue;
                HashMap hashMap3 = this.queryTool.getPorts(string3);
                Iterator iterator2 = hashMap3.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string5 = (String)iterator2.next();
                    PortEntry portEntry = (PortEntry)hashMap3.get(string5);
                    Port port2 = portEntry.getPort();
                    Binding binding = port2.getBinding();
                    PortType portType = binding.getPortType();
                    String string6 = portType.getQName().toString();
                    PreferredPortDescriptor preferredPortDescriptor = (PreferredPortDescriptor)hashMap.get(string6);
                    if (preferredPortDescriptor == null) {
                        preferredPortDescriptor = new PreferredPortDescriptor();
                        preferredPortDescriptor.addSupportedPort(this.noneValue);
                    }
                    preferredPortDescriptor.addSupportedPort(string5);
                    hashMap.put(string6, preferredPortDescriptor);
                }
                break block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPreferredPortMap");
        }
        return hashMap;
    }

    public void setNoneValue(String string) {
        if (string != null) {
            this.noneValue = string;
        }
    }

    public static boolean validPreferredPort(HashMap hashMap, String string, String string2) {
        Serializable serializable;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validPreferredPort", new Object[]{string, string2});
        }
        boolean bl = false;
        QName qName = QName.valueOf(string2);
        if (qName.getNamespaceURI() == null || qName.getNamespaceURI().equals("")) {
            object = QName.valueOf(string);
            serializable = new QName(((QName)object).getNamespaceURI(), string2);
            string2 = ((QName)serializable).toString();
        }
        object = (PreferredPortDescriptor)hashMap.get(string);
        serializable = ((PreferredPortDescriptor)object).getSupportedPorts();
        bl = ((ArrayList)serializable).contains(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validPreferredPort", new Boolean(bl));
        }
        return bl;
    }
}

