/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.channel.WSAddress;
import com.ibm.ws.webservices.engine.transport.channel.WSChannelManager;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class OutboundConnectionGroup {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register(OutboundConnectionGroup.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static final Integer STATE_INVALID = new Integer(0);
    private static final Integer STATE_NOT_IN_USE = new Integer(1);
    private static final Integer STATE_IN_USE = new Integer(2);
    private static float ldFactor = 0.75f;
    private static int initSize = 131;
    private static WSChannelManager wMgr = null;
    private VirtualConnectionFactory vcf = null;
    private long idleTime = Long.getLong("com.ibm.websphere.webservices.http.connectionIdleTimeout", 5L) * 1000L;
    private HashMap thePool = new HashMap(initSize, ldFactor);
    private Vector Cleanup = new Vector();

    public OutboundConnectionGroup() {
        wMgr = WSChannelManager.getInstance();
    }

    public WSOutboundConnection createConnection(WSAddress wSAddress) throws WebServicesFault, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.createConnection()");
        }
        WSOutboundConnection wSOutboundConnection = null;
        String string = wSAddress.keyValueforPool();
        if (this.vcf == null) {
            this.vcf = wMgr.getVCFactory(wSAddress);
        }
        wSOutboundConnection = wMgr.getWSOutboundConnection(string, wSAddress, this.vcf);
        this.thePool.put(wSOutboundConnection, STATE_IN_USE);
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("createdOCobject", wSOutboundConnection.toString(), String.valueOf(this.vcf)));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionGroup.createConnection()");
        }
        return wSOutboundConnection;
    }

    protected WSOutboundConnection invalidateConnection(WSAddress wSAddress) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.invalidateConnection()");
        }
        WSOutboundConnection wSOutboundConnection = null;
        if (this.thePool.size() > 0) {
            Iterator iterator = this.thePool.keySet().iterator();
            while (iterator.hasNext()) {
                wSOutboundConnection = (WSOutboundConnection)iterator.next();
                if (!wSOutboundConnection.getTargetAddress().equals(wSAddress)) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, Messages.getMessage("invalidatedConnObject01", wSAddress.toString(), wSOutboundConnection.toString()));
                }
                this.thePool.put(wSOutboundConnection, STATE_INVALID);
                break;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionGroup.invalidateConnection()");
        }
        return wSOutboundConnection;
    }

    protected WSOutboundConnection getConnection(WSAddress wSAddress) throws WebServicesFault, InterruptedException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.getConnection()");
        }
        WSOutboundConnection wSOutboundConnection = null;
        if (this.thePool.size() > 0) {
            Iterator iterator = this.thePool.keySet().iterator();
            while (iterator.hasNext()) {
                wSOutboundConnection = (WSOutboundConnection)iterator.next();
                int n = (Integer)this.thePool.get(wSOutboundConnection);
                if (n == STATE_NOT_IN_USE) {
                    long l = wSOutboundConnection.timeFromLastAccess();
                    if (l >= this.idleTime) {
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("expiredOCobject", wSOutboundConnection.toString(), String.valueOf(l)));
                        }
                        wSOutboundConnection.release(null);
                        this.Cleanup.add(wSOutboundConnection);
                        iterator.remove();
                        wSOutboundConnection = this.createConnection(wSAddress);
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "OutboundConnectionGroup.getConnection()");
                        }
                        return wSOutboundConnection;
                    }
                    if (!_tc.isEventEnabled()) break;
                    Tr.event(_tc, Messages.getMessage("existedOCobject", wSOutboundConnection.toString()));
                    break;
                }
                wSOutboundConnection = null;
            }
            if (wSOutboundConnection != null) {
                wSOutboundConnection.updateEndpoint(wSAddress);
                this.thePool.put(wSOutboundConnection, STATE_IN_USE);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionGroup.getConnection()");
        }
        return wSOutboundConnection;
    }

    protected WSOutboundConnection addConnection(WSAddress wSAddress, WSOutboundConnection wSOutboundConnection, String string) throws WebServicesFault, InterruptedException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.addConnection()");
        }
        WSOutboundConnection wSOutboundConnection2 = null;
        if (!string.equals(wSOutboundConnection.groupID())) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The intended connection object: " + wSOutboundConnection + " does not originally belong to this group:" + this);
                Tr.debug(_tc, "Original connection group ID: " + wSOutboundConnection.groupID() + ". Current connection group ID: " + string);
            }
            wSOutboundConnection.release(null);
            this.Cleanup.add(wSOutboundConnection);
            wSOutboundConnection2 = this.createConnection(wSAddress);
        } else if (wSOutboundConnection.isClosed()) {
            if (_tc.isEventEnabled()) {
                Tr.debug(_tc, "The intended connection object: " + wSOutboundConnection + " has been closed.");
            }
            wSOutboundConnection.release(null);
            this.Cleanup.add(wSOutboundConnection);
            wSOutboundConnection2 = this.createConnection(wSAddress);
        } else {
            long l = wSOutboundConnection.timeFromLastAccess();
            if (l >= this.idleTime) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("expiredOCobject", wSOutboundConnection.toString(), String.valueOf(l)));
                }
                wSOutboundConnection.release(null);
                this.Cleanup.add(wSOutboundConnection);
                wSOutboundConnection2 = this.createConnection(wSAddress);
            } else {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("existedOCobject", wSOutboundConnection.toString()));
                }
                wSOutboundConnection2 = wSOutboundConnection;
                wSOutboundConnection2.updateEndpoint(wSAddress);
                this.thePool.put(wSOutboundConnection2, STATE_IN_USE);
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Connection object " + wSOutboundConnection2 + " has been established in group: " + this);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionGroup.addConnection()");
        }
        return wSOutboundConnection2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnConnection(WSOutboundConnection wSOutboundConnection, boolean bl) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.returnConnection()");
        }
        if (bl) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "The pool is full. Removing " + wSOutboundConnection + " from the group: " + this + " to make room.");
            }
            this.thePool.remove(wSOutboundConnection);
            return;
        }
        int n = (Integer)this.thePool.get(wSOutboundConnection);
        if (n == STATE_INVALID) {
            this.thePool.remove(wSOutboundConnection);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("returnInvalidOCobject", wSOutboundConnection.toString()));
            }
            wSOutboundConnection.release(null);
            Vector vector = this.Cleanup;
            synchronized (vector) {
                this.Cleanup.add(wSOutboundConnection);
            }
        } else if (wSOutboundConnection.isClosed()) {
            this.thePool.remove(wSOutboundConnection);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("returnClosedOCobject", wSOutboundConnection.toString()));
            }
            wSOutboundConnection.release(null);
            Vector vector = this.Cleanup;
            synchronized (vector) {
                this.Cleanup.add(wSOutboundConnection);
            }
        } else {
            this.thePool.put(wSOutboundConnection, STATE_NOT_IN_USE);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("returnValidOCobject", wSOutboundConnection.toString()));
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionGroup.returnConnection()");
        }
    }

    protected boolean isEmpty() {
        return this.thePool.isEmpty() && this.Cleanup.isEmpty();
    }

    protected int currPoolSize() {
        return this.thePool.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws ChannelException, ChainException {
        Iterator<Object> iterator;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cleanup()");
        }
        WSOutboundConnection wSOutboundConnection = null;
        Cloneable cloneable = this.thePool;
        synchronized (cloneable) {
            if (this.thePool.size() > 0) {
                iterator = this.thePool.keySet().iterator();
                WSOutboundConnection wSOutboundConnection2 = null;
                while (iterator.hasNext()) {
                    wSOutboundConnection2 = (WSOutboundConnection)iterator.next();
                    long l = wSOutboundConnection2.timeFromLastAccess();
                    int n = (Integer)this.thePool.get(wSOutboundConnection2);
                    if (n == STATE_INVALID) {
                        wSOutboundConnection2 = null;
                        continue;
                    }
                    if (l < this.idleTime || n != STATE_NOT_IN_USE) continue;
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("expiredOCobject", wSOutboundConnection2.toString(), String.valueOf(l)));
                    }
                    this.Cleanup.add(wSOutboundConnection2);
                    iterator.remove();
                    wSOutboundConnection2.release(null);
                }
            }
        }
        cloneable = this.Cleanup;
        synchronized (cloneable) {
            iterator = this.Cleanup.iterator();
            while (iterator.hasNext()) {
                wSOutboundConnection = (WSOutboundConnection)iterator.next();
                wSOutboundConnection.release(null);
                if (!_tc.isEventEnabled()) continue;
                Tr.event(_tc, Messages.getMessage("removeOCobject", wSOutboundConnection.toString()));
            }
            this.Cleanup.clear();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cleanup()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws ChannelException, ChainException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "release()");
        }
        if (this.vcf != null) {
            VirtualConnectionFactory virtualConnectionFactory = this.vcf;
            synchronized (virtualConnectionFactory) {
                if (this.vcf != null) {
                    this.vcf.destroy();
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("objectReleased", String.valueOf(this.vcf)));
                    }
                    this.vcf = null;
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "release()");
        }
    }

    public int totalInUse() {
        int n = 0;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "totalInUse()");
        }
        Iterator iterator = this.thePool.values().iterator();
        while (iterator.hasNext()) {
            if (!((Integer)iterator.next()).equals(STATE_IN_USE)) continue;
            ++n;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "totalInUse()");
        }
        return n;
    }

    public boolean findUnused() {
        boolean bl = false;
        WSOutboundConnection wSOutboundConnection = null;
        if (this.thePool.size() > 1) {
            Iterator iterator = this.thePool.keySet().iterator();
            while (iterator.hasNext()) {
                wSOutboundConnection = (WSOutboundConnection)iterator.next();
                if (!((Integer)this.thePool.get(wSOutboundConnection)).equals(STATE_NOT_IN_USE)) continue;
                this.Cleanup.add(wSOutboundConnection);
                iterator.remove();
                wSOutboundConnection.release(null);
                bl = true;
            }
        }
        return bl;
    }
}

