/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.description.TypeDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer;
import com.ibm.ws.webservices.engine.encoding.utils.FieldDesc;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.NullAttributes;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SimpleBeanDeserializer
extends SimpleDeserializer {
    protected Class proxy;
    DeserializationContext context = null;

    public SimpleBeanDeserializer(Class clazz, QName qName) {
        super(clazz, qName);
    }

    public SimpleBeanDeserializer(Class clazz, QName qName, TypeDesc typeDesc) {
        super(clazz, qName);
    }

    protected Object makeValue(String string) throws Exception {
        Deserializer deserializer = null;
        BeanPropertyDescriptor beanPropertyDescriptor = null;
        FieldDesc fieldDesc = this.beanDesc.getFieldDesc("", "_value");
        if (fieldDesc != null) {
            beanPropertyDescriptor = fieldDesc.getPropertyDescriptor();
            deserializer = this.getCachedDeserializer(fieldDesc, this.context);
            Deserializer deserializer2 = deserializer = deserializer != null ? deserializer : this.getDeserializer(null, fieldDesc.getJavaType(), null, this.context);
        }
        if (deserializer == null) {
            throw new SAXException(Messages.getMessage("noDeser00", "_value of " + this.javaType));
        }
        deserializer.onStartElement("", "_value", "", NullAttributes.singleton, null, this.context);
        deserializer.characters(string);
        deserializer.endElement("", "_value", this.context);
        Object object = deserializer.getValue();
        beanPropertyDescriptor.set(this.value, object);
        return this.value;
    }

    public void onStartElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        this.context = deserializationContext;
        this.createValue();
        this.processAttributes(attributes, mappingScope, deserializationContext, false);
    }

    protected void createValue() throws SAXException {
        try {
            this.value = this.javaType.newInstance();
        }
        catch (Exception exception) {
            try {
                Object object = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return SimpleBeanDeserializer.this.javaType.getClassLoader();
                        }
                        catch (Throwable throwable) {
                            return throwable;
                        }
                    }
                });
                ClassLoader classLoader = null;
                if (object instanceof ClassLoader) {
                    classLoader = (ClassLoader)object;
                }
                Class clazz = null;
                if (classLoader == null) {
                    clazz = ClassUtils.forName(this.javaType.getName() + "_Helper");
                } else {
                    try {
                        clazz = ClassUtils.forName(this.javaType.getName() + "_Helper", true, classLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz = ClassUtils.forName(this.javaType.getName() + "_Helper");
                    }
                }
                Method method = null;
                try {
                    method = (Method)AccessController.doPrivileged(new getMethodPRIV(clazz, "createProxy"));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
                this.value = method.invoke(null, null);
                this.proxy = this.value.getClass();
                this.beanDesc.setBeanPropertyDescriptors(this.proxy);
                this.propertyMap = this.beanDesc.getPropertyDescriptorMap();
            }
            catch (Exception exception2) {
                FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer.createValue", "644", this);
                throw new SAXException(Messages.getMessage("cantCreateBean00", this.javaType.getName(), exception.toString()));
            }
        }
    }

    public boolean recycle() {
        boolean bl = super.recycle();
        if (bl) {
            this.context = null;
        }
        return bl;
    }

    public final void valueComplete() throws SAXException {
        if (this.proxy != null && this.componentsReady()) {
            try {
                Method method = null;
                try {
                    method = (Method)AccessController.doPrivileged(new getMethodPRIV(this.proxy, "convert"));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
                this.value = method.invoke(this.value, null);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer.valueComplete", "662", this);
                throw new SAXException(exception);
            }
        }
        super.valueComplete();
    }

    private class getMethodPRIV
    implements PrivilegedExceptionAction {
        private Class clazz;
        private String methodName;

        getMethodPRIV(Class clazz, String string) {
            this.clazz = clazz;
            this.methodName = string;
        }

        public Object run() throws Exception {
            return this.clazz.getMethod(this.methodName, null);
        }
    }
}

