/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.configurable.ConfigurableImpl;
import com.ibm.ws.webservices.engine.configurable.Configured;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.CustomDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.DeserializerPool;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.apache.commons.logging.Log;

public abstract class BaseDeserializerFactory
implements DeserializerFactory {
    private static Log log = LogFactory.getLog(BaseDeserializerFactory.class.getName());
    static Vector mechanisms = null;
    protected Class deserClass = null;
    protected QName xmlType = null;
    protected Class javaType = null;
    protected boolean initialized = false;
    protected transient Constructor deserClassConstructor = null;
    protected transient Method getDeserializer = null;
    private transient DeserializerPool pool = null;
    private Configurable _configurable = null;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$java$lang$String;

    public BaseDeserializerFactory(Class clazz, QName qName, Class clazz2) {
        this.deserClass = clazz;
        this.xmlType = qName;
        this.javaType = clazz2;
    }

    protected void lazyInitialization() {
        this.deserClassConstructor = this.getConstructor(this.deserClass);
        this.getDeserializer = this.getDeserializerMethod(this.javaType);
        this.pool = new DeserializerPool();
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.xml.rpc.encoding.Deserializer getDeserializerAs(String string) throws JAXRPCException {
        BaseDeserializerFactory baseDeserializerFactory = this;
        synchronized (baseDeserializerFactory) {
            Deserializer deserializer;
            if (!this.initialized) {
                this.lazyInitialization();
            }
            if ((deserializer = this.pool.getDeserializer()) != null) {
                return deserializer;
            }
            deserializer = this.getSpecialized(string);
            if (deserializer == null) {
                deserializer = this.getGeneralPurpose(string);
            }
            this.pool.addDeserializer(deserializer);
            return deserializer;
        }
    }

    protected Deserializer getGeneralPurpose(String string) {
        if (this.deserClassConstructor != null) {
            try {
                return (Deserializer)this.deserClassConstructor.newInstance(this.javaType, this.xmlType);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Deserializer getSpecialized(String string) {
        if (this.getDeserializer != null) {
            try {
                return (Deserializer)this.getDeserializer.invoke(null, string, this.javaType, this.xmlType);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private Constructor getConstructor(Class clazz) {
        return (Constructor)AccessController.doPrivileged(new getConstructorPRIV(clazz));
    }

    protected Method getDeserializerMethod(Class clazz) {
        return (Method)AccessController.doPrivileged(new getDeserializerMethodPRIV(clazz));
    }

    public Iterator getSupportedMechanismTypes() {
        return mechanisms.iterator();
    }

    public static DeserializerFactory createFactory(Class clazz, Class clazz2, QName qName) {
        return BaseDeserializerFactory.createFactory(clazz, clazz2, qName, null, null);
    }

    public static DeserializerFactory createFactory(Class clazz, Class clazz2, QName qName, String string) {
        return BaseDeserializerFactory.createFactory(clazz, clazz2, qName, string, null, null);
    }

    public static DeserializerFactory createFactory(Class clazz, Class clazz2, QName qName, QName qName2, QName qName3) {
        return BaseDeserializerFactory.createFactory(clazz, clazz2, qName, null, qName2, qName3);
    }

    public static DeserializerFactory createFactory(Class clazz, Class clazz2, QName qName, String string, QName qName2, QName qName3) {
        return (DeserializerFactory)AccessController.doPrivileged(new CreateFactoryPRIV(clazz, clazz2, qName, string, qName2, qName3));
    }

    private void makeConfigurable() {
        if (this._configurable == null) {
            this._configurable = new ConfigurableImpl();
        }
    }

    private String toStringConfigurable(String string) {
        Iterator iterator;
        String string2 = "";
        if (this._configurable != null && (iterator = this.getOptions().entrySet().iterator()) != null) {
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                string2 = string2 + string + "KEY(" + entry.getKey() + ")\n";
                string2 = string2 + string + " VALUE(" + entry.getValue() + ")\n";
            }
        }
        return string2;
    }

    public final void setOptionsDefault(Configured configured) {
        this.makeConfigurable();
        this._configurable.setOptionsDefault(configured);
    }

    public final void setOption(String string, Object object) {
        this.makeConfigurable();
        this._configurable.setOption(string, object);
    }

    public final void setOption(String string, Object object, boolean bl) {
        this.makeConfigurable();
        this._configurable.setOption(string, object, bl);
    }

    public final boolean setOptionDefault(String string, Object object) {
        this.makeConfigurable();
        return this._configurable.setOptionDefault(string, object);
    }

    public final boolean setOptionDefault(String string, Object object, boolean bl) {
        this.makeConfigurable();
        return this._configurable.setOptionDefault(string, object, bl);
    }

    public final void setOptions(Map map) {
        this.makeConfigurable();
        this._configurable.setOptions(map);
    }

    public final Object getOption(String string) {
        this.makeConfigurable();
        return this._configurable.getOption(string);
    }

    public final void removeOption(String string) {
        if (this._configurable != null) {
            this._configurable.removeOption(string);
        }
    }

    public final Map getOptions() {
        this.makeConfigurable();
        return this._configurable.getOptions();
    }

    public Set getOptionsBooleanNames() {
        this.makeConfigurable();
        return this._configurable.getOptionsBooleanNames();
    }

    public String toString() {
        return "BaseDeserializerFactory: DeserClass=" + (this.deserClass != null ? this.deserClass.toString() : "<null>") + ", XmlType=" + (this.xmlType != null ? this.xmlType.toString() : "<null>") + ", JavaType=" + (this.javaType != null ? this.javaType.toString() : "<null>");
    }

    private static class CreateFactoryPRIV
    implements PrivilegedAction {
        private Class factory;
        private Class javaType;
        private QName xmlType;
        private String binderName;
        private QName compQName;
        private QName compTypeQName;

        CreateFactoryPRIV(Class clazz, Class clazz2, QName qName, String string, QName qName2, QName qName3) {
            this.factory = clazz;
            this.javaType = clazz2;
            this.xmlType = qName;
            this.binderName = string;
            this.compQName = qName2;
            this.compTypeQName = qName3;
        }

        public Object run() {
            DeserializerFactory deserializerFactory;
            block44: {
                block43: {
                    GenericDeclaration genericDeclaration;
                    block42: {
                        block41: {
                            block40: {
                                deserializerFactory = null;
                                try {
                                    if (this.binderName != null) {
                                        genericDeclaration = Class.forName(this.binderName, true, Thread.currentThread().getContextClassLoader());
                                        deserializerFactory = new CustomDeserializerFactory(this.javaType, this.xmlType, (Class)genericDeclaration);
                                    }
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "395", this);
                                    log.error(Messages.getMessage("noBinderFound00", this.binderName), classNotFoundException);
                                }
                                if (deserializerFactory == null) {
                                    try {
                                        genericDeclaration = this.factory.getMethod("create", class$java$lang$Class == null ? (class$java$lang$Class = BaseDeserializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                                        deserializerFactory = (DeserializerFactory)((Method)genericDeclaration).invoke(null, this.javaType, this.xmlType, this.compQName, this.compTypeQName);
                                    }
                                    catch (NoSuchMethodException noSuchMethodException) {
                                        FFDCFilter.processException((Throwable)noSuchMethodException, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "436", this);
                                        if (log.isDebugEnabled()) {
                                            log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught NoSuchMethodException: " + noSuchMethodException);
                                        }
                                    }
                                    catch (IllegalAccessException illegalAccessException) {
                                        FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "439", this);
                                        if (log.isDebugEnabled()) {
                                            log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught IllegalAccessException: " + illegalAccessException);
                                        }
                                    }
                                    catch (InvocationTargetException invocationTargetException) {
                                        FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "439", this);
                                        if (!log.isDebugEnabled()) break block40;
                                        log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught InvocationTargetException: " + invocationTargetException);
                                    }
                                }
                            }
                            if (deserializerFactory == null) {
                                try {
                                    genericDeclaration = this.factory.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = BaseDeserializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                                    deserializerFactory = (DeserializerFactory)((Constructor)genericDeclaration).newInstance(this.javaType, this.xmlType, this.compQName, this.compTypeQName);
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    FFDCFilter.processException((Throwable)noSuchMethodException, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "459", this);
                                    if (log.isDebugEnabled()) {
                                        log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught NoSuchMethodException: " + noSuchMethodException);
                                    }
                                }
                                catch (InstantiationException instantiationException) {
                                    FFDCFilter.processException((Throwable)instantiationException, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "461", this);
                                    if (log.isDebugEnabled()) {
                                        log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught InstantiationException: " + instantiationException);
                                    }
                                }
                                catch (IllegalAccessException illegalAccessException) {
                                    FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "461", this);
                                    if (log.isDebugEnabled()) {
                                        log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught IllegalAccessException: " + illegalAccessException);
                                    }
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "461", this);
                                    if (!log.isDebugEnabled()) break block41;
                                    log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught InvocationTargetException: " + invocationTargetException);
                                }
                            }
                        }
                        if (deserializerFactory == null) {
                            try {
                                genericDeclaration = this.factory.getMethod("create", class$java$lang$Class == null ? (class$java$lang$Class = BaseDeserializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                                deserializerFactory = (DeserializerFactory)((Method)genericDeclaration).invoke(null, this.javaType, this.xmlType);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                FFDCFilter.processException((Throwable)noSuchMethodException, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "484", this);
                                if (log.isDebugEnabled()) {
                                    log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught NoSuchMethodException: " + noSuchMethodException);
                                }
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "487", this);
                                if (log.isDebugEnabled()) {
                                    log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught IllegalAccessException: " + illegalAccessException);
                                }
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "487", this);
                                if (!log.isDebugEnabled()) break block42;
                                log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught InvocationTargetException: " + invocationTargetException);
                            }
                        }
                    }
                    if (deserializerFactory == null) {
                        try {
                            genericDeclaration = this.factory.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = BaseDeserializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                            deserializerFactory = (DeserializerFactory)((Constructor)genericDeclaration).newInstance(this.javaType, this.xmlType);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            FFDCFilter.processException((Throwable)noSuchMethodException, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "507", this);
                            if (log.isDebugEnabled()) {
                                log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught NoSuchMethodException: " + noSuchMethodException);
                            }
                        }
                        catch (InstantiationException instantiationException) {
                            FFDCFilter.processException((Throwable)instantiationException, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "509", this);
                            if (log.isDebugEnabled()) {
                                log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught InstantiationException: " + instantiationException);
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "509", this);
                            if (log.isDebugEnabled()) {
                                log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught IllegalAccessException: " + illegalAccessException);
                            }
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "509", this);
                            if (!log.isDebugEnabled()) break block43;
                            log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught InvocationTargetException: " + invocationTargetException);
                        }
                    }
                }
                if (deserializerFactory == null) {
                    try {
                        deserializerFactory = (DeserializerFactory)this.factory.newInstance();
                    }
                    catch (InstantiationException instantiationException) {
                        FFDCFilter.processException((Throwable)instantiationException, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "531", this);
                        if (log.isDebugEnabled()) {
                            log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught InstantiationException: " + instantiationException);
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory", "531", this);
                        if (!log.isDebugEnabled()) break block44;
                        log.debug("BaseDeserializerFactory$CreateFactoryPRIV.run() caught IllegalAccessException: " + illegalAccessException);
                    }
                }
            }
            return deserializerFactory;
        }
    }

    private class getDeserializerMethodPRIV
    implements PrivilegedAction {
        private Class clazz;

        getDeserializerMethodPRIV(Class clazz) {
            this.clazz = clazz;
        }

        public Object run() {
            Method method = null;
            Class clazz = null;
            try {
                if (this.clazz.getClassLoader() == null) {
                    clazz = ClassUtils.forName(this.clazz.getName() + "_Helper");
                } else {
                    try {
                        clazz = ClassUtils.forName(this.clazz.getName() + "_Helper", true, this.clazz.getClassLoader());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz = ClassUtils.forName(this.clazz.getName() + "_Helper");
                    }
                }
                method = clazz.getMethod("getDeserializer", class$java$lang$String == null ? (class$java$lang$String = BaseDeserializerFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Class == null ? (class$java$lang$Class = BaseDeserializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (log.isDebugEnabled()) {
                    log.debug("getDeserializerMethodPRIV caught exception - processing continues", noSuchMethodException);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return method;
        }
    }

    private class getConstructorPRIV
    implements PrivilegedAction {
        private Class clazz;

        getConstructorPRIV(Class clazz) {
            this.clazz = clazz;
        }

        public Object run() {
            try {
                return this.clazz.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = BaseDeserializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseDeserializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
    }
}

