/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.components.net;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.components.net.DefaultHTTPSTransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.DefaultHTTPTransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.SecureTransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientProperties;
import java.util.Hashtable;

public class TransportClientPropertiesFactory {
    private static final TraceComponent _tc = Tr.register(DefaultHTTPSTransportClientProperties.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static Hashtable factories = new Hashtable();

    public static synchronized TransportClientProperties create(String string) {
        TransportClientProperties transportClientProperties;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "TransportClientPropertiesFactory::create(" + string + ")");
        }
        if ((transportClientProperties = (TransportClientProperties)factories.get(string)) == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Factory not set yet");
            }
            if (string.equalsIgnoreCase("http")) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Getting TransportClientProperties");
                }
                transportClientProperties = (TransportClientProperties)WebServicesProperties.newInstance(TransportClientProperties.class);
            } else if (string.equalsIgnoreCase("https")) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Getting SecureTransportClientProperties");
                }
                transportClientProperties = (SecureTransportClientProperties)WebServicesProperties.newInstance(SecureTransportClientProperties.class);
            }
            if (transportClientProperties != null) {
                factories.put(string, transportClientProperties);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, ((Object)transportClientProperties).toString());
                }
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Factory already set");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "TransportClientPropertiesFactory::create(" + string + ")");
        }
        return transportClientProperties;
    }

    public static String print() {
        return factories.toString();
    }

    static {
        WebServicesProperties.setClassOverrideProperty(TransportClientProperties.class, "webservices.transportClientProperties");
        WebServicesProperties.setClassDefault(TransportClientProperties.class, "com.ibm.ws.webservices.engine.components.net.DefaultHTTPTransportClientProperties");
        WebServicesProperties.setClassOverrideProperty(SecureTransportClientProperties.class, "webservices.securetransportClientProperties");
        WebServicesProperties.setClassDefault(SecureTransportClientProperties.class, "com.ibm.ws.webservices.engine.components.net.DefaultHTTPSTransportClientProperties");
        WebServicesProperties.setClassDefault(TransportClientProperties.class, DefaultHTTPTransportClientProperties.class.getName());
        WebServicesProperties.setClassDefault(SecureTransportClientProperties.class, DefaultHTTPSTransportClientProperties.class.getName());
    }
}

