/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class IBMJSSEProvider
extends AbstractJSSEProvider
implements JSSEProvider {
    private String keyManager = JSSEProviderFactory.getKeyManagerFactoryAlgorithm();
    private String trustManager = JSSEProviderFactory.getTrustManagerFactoryAlgorithm();
    private String contextProvider = "IBMJSSE2";
    private String keyStoreProvider = "IBMJCE";
    private String socketFactory = "com.ibm.websphere.ssl.protocol.SSLSocketFactory";
    private String protocolPackageHandler = "com.ibm.net.ssl.www2.protocol";
    private static TraceComponent tc = Tr.register(IBMJSSEProvider.class.getName(), "SSL");

    public IBMJSSEProvider() {
        this.initializeHandlers(this.protocolPackageHandler);
    }

    public String getDefaultSSLSocketFactoryClass() {
        return super.getDefaultSSLSocketFactoryClass(this.socketFactory);
    }

    public String getSSLProtocolPackageHandler() {
        return this.protocolPackageHandler;
    }

    public SSLContext getSSLContextInstance(SSLConfig sSLConfig) throws SSLException {
        return super.getSSLContextInstance(sSLConfig);
    }

    public TrustManagerFactory getTrustManagerFactoryInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        return super.getTrustManagerFactoryInstance(this.trustManager, this.contextProvider);
    }

    public KeyManagerFactory getKeyManagerFactoryInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        return super.getKeyManagerFactoryInstance(this.keyManager, this.contextProvider);
    }

    public KeyStore getKeyStoreInstance(String string, String string2) throws KeyStoreException, NoSuchProviderException {
        if (string2 == null) {
            string2 = this.keyStoreProvider;
        }
        return super.getKeyStoreInstance(string, string2);
    }

    public String getKeyManager() {
        return this.keyManager;
    }

    public String getTrustManager() {
        return this.trustManager;
    }

    public String getContextProvider() {
        return this.contextProvider;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public String getSocketFactory() {
        return this.socketFactory;
    }

    public String getProtocolPackageHandler() {
        return this.protocolPackageHandler;
    }
}

