/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class SSLConfig
extends Properties {
    private static final TraceComponent tc = Tr.register(SSLConfig.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static SSLConfigManager sslConfigManager = SSLConfigManager.getInstance();

    public SSLConfig() {
        this.initializeDefaults();
    }

    public SSLConfig(Properties properties) {
        if (properties != null) {
            super.putAll((Map<?, ?>)properties);
        }
        this.initializeDefaults();
    }

    public SSLConfig(String string) {
        this.loadPropertiesFile(string, false);
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        String string = this.getProperty("com.ibm.ssl.keyStoreType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "keyStoreType: " + string);
        }
        if (string == null && this.getProperty("javax.net.ssl.keyStoreType") == null) {
            this.setProperty("com.ibm.ssl.keyStoreFileBased", "true");
            this.setProperty("com.ibm.ssl.keyStoreType", "JKS");
            string = "JKS";
        } else if (!(string == null || string.equals("JKS") || string.equals("JCEKS") || string.equals("PKCS12"))) {
            this.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
        } else {
            this.setProperty("com.ibm.ssl.keyStoreFileBased", "true");
        }
        String string2 = this.getProperty("com.ibm.ssl.trustStoreType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "trustStoreType: " + string2);
        }
        if (string2 == null && this.getProperty("javax.net.ssl.trustStoreType") == null) {
            this.setProperty("com.ibm.ssl.trustStoreFileBased", "true");
            this.setProperty("com.ibm.ssl.trustStoreType", "JKS");
            string2 = "JKS";
        } else if (!(string2 == null || string2.equals("JKS") || string2.equals("JCEKS") || string2.equals("PKCS12"))) {
            this.setProperty("com.ibm.ssl.trustStoreFileBased", "false");
        } else {
            this.setProperty("com.ibm.ssl.trustStoreFileBased", "true");
        }
        if (this.getProperty("com.ibm.ssl.daysBeforeExpireWarning") == null) {
            this.setProperty("com.ibm.ssl.daysBeforeExpireWarning", "60");
        }
        if (this.getProperty("com.ibm.ssl.keyManager") == null) {
            this.setProperty("com.ibm.ssl.keyManager", JSSEProviderFactory.getKeyManagerFactoryAlgorithm());
        }
        if (this.getProperty("com.ibm.ssl.keyStoreProvider") == null) {
            this.setProperty("com.ibm.ssl.keyStoreProvider", "IBMJCE");
        }
        if (this.getProperty("com.ibm.ssl.protocol") == null) {
            this.setProperty("com.ibm.ssl.protocol", "SSL_TLS");
        }
        if (this.getProperty("com.ibm.ssl.clientAuthentication") == null) {
            this.setProperty("com.ibm.ssl.clientAuthentication", "false");
        }
        if (this.getProperty("com.ibm.ssl.contextProvider") == null) {
            this.setProperty("com.ibm.ssl.contextProvider", "IBMJSSE2");
        }
        if (this.getProperty("com.ibm.ssl.securityLevel") == null) {
            this.setProperty("com.ibm.ssl.securityLevel", "HIGH");
        }
        if (this.getProperty("com.ibm.ssl.trustManager") == null) {
            this.setProperty("com.ibm.ssl.trustManager", JSSEProviderFactory.getTrustManagerFactoryAlgorithm());
        }
        if (this.getProperty("com.ibm.ssl.trustStoreProvider") == null) {
            this.setProperty("com.ibm.ssl.trustStoreProvider", "IBMJCE");
        }
        if (this.getProperty("com.ibm.ssl.validationEnabled") == null) {
            this.setProperty("com.ibm.ssl.validationEnabled", "false");
        }
        if (this.getProperty("com.ibm.ssl.tokenEnabled") == null) {
            this.setProperty("com.ibm.ssl.tokenEnabled", "false");
        }
        String string3 = this.getProperty("com.ibm.ssl.keyStore");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "keyStore: " + string3);
        }
        String string4 = this.getProperty("com.ibm.ssl.keyStorePassword");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "keyStorePassword: " + SSLConfigManager.mask(string4));
        }
        String string5 = this.getProperty("com.ibm.ssl.trustStore");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "trustStore: " + string5);
        }
        String string6 = this.getProperty("com.ibm.ssl.trustStorePassword");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "trustStorePassword: " + SSLConfigManager.mask(string6));
        }
        if (string3 == null && string5 != null && string6 != null && string2 != null) {
            this.setProperty("com.ibm.ssl.keyStore", string5);
            this.setProperty("com.ibm.ssl.keyStorePassword", string6);
            this.setProperty("com.ibm.ssl.keyStoreType", string2);
        } else if (string5 == null && string3 != null && string4 != null && string != null) {
            this.setProperty("com.ibm.ssl.trustStore", string3);
            this.setProperty("com.ibm.ssl.trustStorePassword", string4);
            this.setProperty("com.ibm.ssl.trustStoreType", string);
        }
    }

    public void validateSSLConfig() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateSSLConfig");
        }
        try {
            if (this.getProperty("com.ibm.ssl.validationEnabled").equals("true")) {
                JSSEProviderFactory.getInstance().getSSLContext(null, this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateSSLConfig -> true");
                }
                return;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateSSLConfig not enabled.");
            }
            return;
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateSSLConfig -> false");
            }
            throw exception;
        }
    }

    boolean requiredPropertiesArePresent() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requiredPropertiesArePresent");
        }
        boolean bl2 = bl = this.getProperty("com.ibm.ssl.keyStore") != null && !this.getProperty("com.ibm.ssl.keyStore").equals("") || this.getProperty("com.ibm.ssl.trustStore") != null && !this.getProperty("com.ibm.ssl.trustStore").equals("") || this.getProperty("com.ibm.ssl.tokenLibraryFile") != null && !this.getProperty("com.ibm.ssl.tokenLibraryFile").equals("") || this.getProperty("com.ibm.ssl.trustStoreName") != null && !this.getProperty("com.ibm.ssl.trustStoreName").equals("") || this.getProperty("com.ibm.ssl.keyStoreName") != null && !this.getProperty("com.ibm.ssl.keyStoreName").equals("");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requiredPropertiesArePresent -> " + bl);
        }
        return bl;
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString");
        }
        Enumeration<?> enumeration = this.propertyNames();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SSLConfig.toString() {\n");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.getProperty(string);
            if (string.toLowerCase().indexOf("password") != -1) {
                stringBuffer.append(string);
                stringBuffer.append(" = ");
                stringBuffer.append(SSLConfigManager.mask(string2));
                stringBuffer.append("\n");
                continue;
            }
            stringBuffer.append(string);
            stringBuffer.append(" = ");
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
        stringBuffer.append("}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toString");
        }
        return stringBuffer.toString();
    }

    public SSLConfig[] loadPropertiesFile(final String string, final boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadPropertiesFile", new Object[]{string, new Boolean(bl)});
        }
        SSLConfig[] sSLConfigArray = null;
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "loadPropertiesFile (null props file)");
            }
            return null;
        }
        try {
            sSLConfigArray = (SSLConfig[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    block15: {
                        InputStream inputStream = null;
                        try {
                            URL uRL = new URL(string);
                            inputStream = uRL.openStream();
                            if (!bl) {
                                SSLConfig.this.load(inputStream);
                                break block15;
                            }
                            String string4 = null;
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                            ArrayList<SSLConfig> arrayList = new ArrayList<SSLConfig>();
                            SSLConfig sSLConfig = new SSLConfig();
                            sSLConfig.clear();
                            while ((string4 = bufferedReader.readLine()) != null) {
                                String string2;
                                String string3;
                                int n;
                                if (string4.trim().startsWith("#") || string4.trim().length() <= 0) continue;
                                if (string4.trim().startsWith("com.ibm.ssl.alias")) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Saving SSL configuration...");
                                    }
                                    arrayList.add(sSLConfig);
                                    sSLConfig = new SSLConfig();
                                    n = string4.indexOf("=");
                                    string3 = string4.substring(0, n);
                                    string2 = string4.substring(n + 1);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Parsing SSL configuration with alias: " + string2);
                                    }
                                    sSLConfig.setProperty(string3, string2, true);
                                    continue;
                                }
                                if (string4.trim().indexOf("=") == -1) continue;
                                n = string4.indexOf("=");
                                string3 = string4.substring(0, n);
                                string2 = null;
                                if (string3 != null) {
                                    string2 = System.getProperty(string3);
                                }
                                if (string2 == null) {
                                    string2 = string4.substring(n + 1);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Parsing SSL property: " + string3 + " = " + string2);
                                }
                                sSLConfig.setProperty(string3, string2, true);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Saving SSL configuration...");
                            }
                            arrayList.add(sSLConfig);
                            SSLConfig[] sSLConfigArray = arrayList.toArray(new SSLConfig[arrayList.size()]);
                            return sSLConfigArray;
                        }
                        catch (Exception exception) {
                            throw exception;
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                    return null;
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "loadPropertiesFile");
            }
            return sSLConfigArray;
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadPropertiesFile exception.", new Object[]{privilegedActionException.getException()});
            }
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.ssl.config.SSLConfig.loadPropertiesFile", "341", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "loadPropertiesFile");
            }
            return null;
        }
    }

    public void decodePasswords() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decodePasswords");
        }
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.getProperty(string);
            if (string.toLowerCase().indexOf("password") == -1) continue;
            String string3 = SSLConfig.decodePassword(string2);
            this.setProperty(string, string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decodePasswords");
        }
    }

    public static String decodePassword(String string) {
        String string2;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "decodePassword");
            }
            string2 = null;
            try {
                string2 = PasswordUtil.decode(string);
                if (string2 != null && !WSKeyStore.defaultKeyStoreWarningIssued && string2.equals("WebAS")) {
                    Tr.warning(tc, "ssl.default.password.in.use.CWPKI0041W");
                    WSKeyStore.defaultKeyStoreWarningIssued = true;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Successfully decoded the KeyStore password.");
                }
            }
            catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Password was not decoded.");
                }
                string2 = string;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.ssl.config.SSLConfig.decodePassword", "402");
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception decoding KeyStore password.", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decodePassword");
        }
        return string2;
    }

    public static String validateURL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Existing propertiesURL: " + string);
        }
        int n = 0;
        for (int i = string.indexOf(58, 0) + 1; i < string.length(); ++i) {
            if (string.charAt(i) == '/' || string.charAt(i) == '\\') continue;
            n = i;
            break;
        }
        stringBuffer.append("file:/");
        stringBuffer.append(string.substring(n));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "New propertiesURL: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public String getDynamicSelectionProperty() {
        return this.getProperty("com.ibm.ssl.dynamicSelectionInfo");
    }

    public boolean equals(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals");
        }
        if (object instanceof SSLConfig) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "thisSize == " + this.size() + ", otherSize == " + ((SSLConfig)object).size());
            }
            if (this.size() != ((SSLConfig)object).size()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The two collections are different sizes, they cannot be equal.");
                }
                return false;
            }
            Enumeration<?> enumeration = this.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = this.getProperty(string);
                String string3 = ((SSLConfig)object).getProperty(string);
                if (string2 == null || string3 != null && string2.equals(string3)) continue;
                if (tc.isDebugEnabled()) {
                    if (string.toLowerCase().indexOf("password") != -1) {
                        Tr.debug(tc, "Value \"" + SSLConfigManager.mask(string2) + "\" does not match value \"" + SSLConfigManager.mask(string3) + "\" for property " + string + ", returning false.");
                    } else {
                        Tr.debug(tc, "Value \"" + string2 + "\" does not match value \"" + string3 + "\" for property " + string + ", returning false.");
                    }
                }
                return false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "All values match, returning true.");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "returning false (not SSLConfig");
        }
        return false;
    }

    public void expandPaths() {
        String string;
        String string2 = this.getProperty("com.ibm.ssl.keyStore");
        if (string2 != null && !string2.equals("")) {
            string2 = KeyStoreManager.getInstance().expand(string2);
            this.setProperty("com.ibm.ssl.keyStore", string2);
        }
        if ((string = this.getProperty("com.ibm.ssl.trustStore")) != null && !string.equals("")) {
            string = KeyStoreManager.getInstance().expand(string);
            this.setProperty("com.ibm.ssl.trustStore", string);
        }
    }

    public Object setProperty(String string, String string2, boolean bl) {
        String string3 = string2;
        if (string3 != null && bl) {
            int n = string3.indexOf("\\u");
            while (n != -1 && n < string3.length()) {
                int n2 = n + 2 < string3.length() ? n + 2 : string3.length();
                int n3 = n + 6 < string3.length() ? n + 6 : string3.length();
                String string4 = string3.substring(n2, n3);
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Potential unicode character detected: '\\u" + string4 + "'");
                }
                if (string4 != null && string4.length() == 4) {
                    try {
                        char c = (char)Integer.parseInt(string4, 16);
                        string3 = string3.substring(0, n) + c + string3.substring(n + 6, string3.length());
                    }
                    catch (Exception exception) {
                        Tr.debug(tc, "Error in unicode format", exception);
                        throw new IllegalArgumentException("Malformed \\uxxxx encoding. digits=" + string4);
                    }
                } else {
                    Tr.debug(tc, "Error in unicode format");
                    throw new IllegalArgumentException("Malformed \\uxxxx encoding. digits=" + string4);
                }
                n = string3.indexOf("\\u", n + 1);
            }
            n = string3.indexOf("\\=");
            while (n != -1 && n < string3.length()) {
                string3 = string3.substring(0, n) + "=" + string3.substring(n + 2, string3.length());
                n = string3.indexOf("\\=");
            }
            n = string3.indexOf("\\:");
            while (n != -1 && n < string3.length()) {
                string3 = string3.substring(0, n) + ":" + string3.substring(n + 2, string3.length());
                n = string3.indexOf("\\:");
            }
        }
        if (tc.isEntryEnabled() && string2 != null && !string2.equals(string3)) {
            Tr.debug(tc, "Property value changed to: " + string3);
        }
        return super.setProperty(string, string3);
    }
}

