/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jsse2.ProtoSSLEngine;
import com.ibm.jsse2.ProtoSSLEngineResult;
import com.ibm.jsse2.SSLContext;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.channel.impl.SSLChannelData;
import com.ibm.ws.ssl.channel.impl.SSLChannelFactory;
import com.ibm.ws.ssl.channel.impl.SSLConnectionLink;
import com.ibm.ws.ssl.channel.impl.SSLDiscriminatorState;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeErrorTracker;
import com.ibm.ws.ssl.channel.impl.SSLLinkConfig;
import com.ibm.ws.ssl.channel.impl.SSLUtils;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import com.ibm.ws.ssl.provider.IBMJSSE2Provider;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.InboundChannel;
import com.ibm.wsspi.channel.OutboundChannel;
import com.ibm.wsspi.channel.OutboundProtocol;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.DiscriminationProcess;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLSessionContext;

public class SSLChannel
implements InboundChannel,
OutboundChannel,
Discriminator {
    private static final TraceComponent tc = Tr.register(SSLChannel.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private static final String CLASS_NAME = "com.ibm.ws.ssl.channel.impl.SSLChannel";
    public static final String SSL_DISCRIMINATOR_STATE = "SSLDiscState";
    protected DiscriminationProcess discProcess = null;
    protected SSLChannelData sslConfig = null;
    private boolean isInitialized = false;
    protected boolean XD = false;
    protected SSLHandshakeErrorTracker handshakeErrorTracker = null;
    protected String alias = null;
    protected String endPointName = null;
    protected String inboundHost = null;
    protected String inboundPort = null;
    protected JSSEProvider jsse2Provider;
    protected ChannelFramework channelFramework = null;
    protected boolean isZOS = false;
    protected boolean isZOSCR = false;
    private SSLSessionContext sessionContext = null;
    private SSLChannelFactory myFactory = null;

    public SSLChannel(ChannelData channelData, SSLChannelFactory sSLChannelFactory) throws ChannelException {
        this.sslConfig = new SSLChannelData(channelData);
        this.myFactory = sSLChannelFactory;
        this.handshakeErrorTracker = new SSLHandshakeErrorTracker();
        this.channelFramework = channelData.getChannelFramework();
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        if (platformHelper != null) {
            this.isZOS = platformHelper.isZOS();
            this.isZOSCR = platformHelper.isControlJvm();
        }
    }

    public SSLHandshakeErrorTracker getHandshakeErrorTracker() {
        return this.handshakeErrorTracker;
    }

    public void setXD(boolean bl) {
        this.XD = bl;
    }

    public Discriminator getDiscriminator() {
        return this;
    }

    public DiscriminationProcess getDiscriminationProcess() {
        return this.discProcess;
    }

    public void setDiscriminationProcess(DiscriminationProcess discriminationProcess) {
        this.discProcess = discriminationProcess;
    }

    public Class getDiscriminatoryType() {
        return WsByteBuffer.class;
    }

    public Class getDeviceAddress() {
        return TCPConnectRequestContext.class;
    }

    public Class[] getApplicationAddress() {
        return new Class[]{TCPConnectRequestContext.class};
    }

    public ConnectionLink getConnectionLink(VirtualConnection virtualConnection) {
        if (!this.isInitialized) {
            try {
                this.init();
            }
            catch (Exception exception) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught while getting SSL connection link: " + exception);
                }
                FFDCFilter.processException(exception, CLASS_NAME, "148", this, new Object[]{virtualConnection});
                throw new RuntimeException(exception);
            }
        }
        SSLConnectionLink sSLConnectionLink = new SSLConnectionLink(this);
        sSLConnectionLink.init(virtualConnection);
        return sSLConnectionLink;
    }

    public SSLContext getSSLContextForInboundLink(SSLConnectionLink sSLConnectionLink, VirtualConnection virtualConnection) throws ChannelException {
        SSLContext sSLContext;
        Boolean bl;
        block10: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getSSLContextForInboundLink");
            }
            bl = Boolean.FALSE;
            if (this.isZOS) {
                try {
                    sSLContext = Class.forName("com.ibm.ws.webcontainer.channel.WCChannelFactory");
                    ChainData[] chainDataArray = this.channelFramework.getInternalRunningChains(this.getName());
                    if (chainDataArray == null) break block10;
                    com.ibm.websphere.channel.framework.ChannelData[] channelDataArray = null;
                    com.ibm.websphere.channel.framework.ChannelData channelData = null;
                    for (int i = 0; i < chainDataArray.length; ++i) {
                        channelDataArray = chainDataArray[i].getChannelList();
                        channelData = channelDataArray[channelDataArray.length - 1];
                        if (!channelData.getFactoryType().isInstance(sSLContext)) continue;
                        bl = Boolean.TRUE;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found web container channel in chain " + chainDataArray[i].getName());
                        }
                        break;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "The WCChannelFactory class was not found.", classNotFoundException);
                    }
                }
                catch (ChannelException channelException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error getting runtime chain.", channelException);
                    }
                    FFDCFilter.processException(channelException, CLASS_NAME, "253", this, new Object[]{virtualConnection, this.getName()});
                }
            }
        }
        sSLContext = this.getSSLContextForLink(virtualConnection, this.inboundHost, this.inboundPort, this.endPointName, bl, sSLConnectionLink);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLContextForInboundLink");
        }
        return sSLContext;
    }

    public SSLContext getSSLContextForOutboundLink(SSLConnectionLink sSLConnectionLink, VirtualConnection virtualConnection, Object object) throws ChannelException {
        Object object2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLContextForOutboundLink");
        }
        TCPConnectRequestContext tCPConnectRequestContext = (TCPConnectRequestContext)object;
        InetSocketAddress inetSocketAddress = tCPConnectRequestContext.getRemoteAddress();
        String string = "HTTP";
        String string2 = (String)virtualConnection.getStateMap().get("protocol");
        if (string2 != null) {
            string = string2;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "OutboundProtocol=" + string + " specified by in VC");
            }
        } else {
            object2 = ((OutboundVirtualConnection)virtualConnection).getChannelAccessor();
            if (object2 instanceof OutboundProtocol) {
                string = ((OutboundProtocol)object2).getProtocol();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "OutboundProtocol=" + string + " specified by " + object2.getClass().getName());
                }
            }
        }
        object2 = this.getSSLContextForLink(virtualConnection, inetSocketAddress.getHostName(), Integer.toString(inetSocketAddress.getPort()), string, Boolean.FALSE, sSLConnectionLink);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLContextForOutboundLink");
        }
        return object2;
    }

    protected SSLContext getSSLContextForLink(VirtualConnection virtualConnection, String string, String string2, String string3, Boolean bl, SSLConnectionLink sSLConnectionLink) throws ChannelException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl2;
        Object object5;
        Properties properties;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "host=" + string + " port=" + string2 + " endPoint=" + string3);
        }
        String string4 = this.getConfig().isInbound() ? "inbound" : "outbound";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("com.ibm.ssl.direction", string4);
        hashMap.put("com.ibm.ssl.remoteHost", string);
        hashMap.put("com.ibm.ssl.remotePort", string2);
        hashMap.put("com.ibm.ssl.endPointName", string3);
        if (this.isZOS && this.getConfig().isInbound()) {
            properties = new Properties();
            Object v = virtualConnection.getStateMap().get("REMOTE_ADDRESS");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "REMOTE_ADDRESS = " + v + " isZWebContainerChain = " + bl);
            }
            if (v != null) {
                properties.put(JSSEHelper.CONNECTION_INFO_CERT_MAPPING_HOST, v);
            } else {
                object5 = new Exception("REMOTE_ADDRESS was not found in the VC state map.  Z channel should put it there.");
                FFDCFilter.processException((Throwable)object5, CLASS_NAME, "329", this, new Object[]{virtualConnection});
            }
            properties.put(JSSEHelper.CONNECTION_INFO_IS_WEB_CONTAINER_INBOUND, bl);
            JSSEHelper.getInstance().setInboundConnectionInfo(properties);
            hashMap.put(JSSEHelper.CONNECTION_INFO_IS_WEB_CONTAINER_INBOUND, bl);
        }
        properties = null;
        boolean bl3 = bl2 = null != this.alias;
        if (!bl2) {
            block31: {
                try {
                    properties = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return JSSEHelper.getInstance().getSSLPropertiesOnThread();
                        }
                    });
                }
                catch (Exception exception) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block31;
                    Tr.debug(tc, "Caught exception looking for on-thread props; e=" + exception);
                }
            }
            if (null == properties || 0 == properties.size()) {
                properties = null;
                bl2 = !this.getConfig().getProperties().containsKey("com.ibm.ssl.keyStore") || !this.getConfig().getProperties().containsKey("com.ibm.ssl.trustStore");
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found on-thread ssl properties");
            }
        }
        if (bl2) {
            try {
                object5 = this.alias;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Querying security service for alias=[" + (String)object5 + "]");
                }
                properties = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction((String)object5, hashMap){
                    private final /* synthetic */ String val$aliasFinal;
                    private final /* synthetic */ Map val$connectionInfo;
                    {
                        this.val$aliasFinal = string;
                        this.val$connectionInfo = map;
                    }

                    public Object run() throws Exception {
                        return JSSEHelper.getInstance().getProperties(this.val$aliasFinal, this.val$connectionInfo, null);
                    }
                });
            }
            catch (Exception exception) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting SSL properties from alias: " + this.alias);
                }
                throw new ChannelException(exception);
            }
        }
        if (null != properties) {
            object5 = this.getConfig().getProperties().propertyNames();
            object4 = null;
            object3 = null;
            while (object5.hasMoreElements()) {
                object4 = (String)object5.nextElement();
                object3 = this.getConfig().getStringProperty((String)object4);
                if (null == object3 || properties.containsKey(object4)) continue;
                properties.put(object4, object3);
            }
        } else {
            properties = this.getConfig().getProperties();
        }
        if (null != (object5 = (String)properties.get("com.ibm.ssl.sslType"))) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLConfig type: " + (String)object5);
            }
            if (((String)object5).equals("SSSL")) {
                throw new ChannelException("Invalid SSLConfig type: " + (String)object5);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "SSL configuration <null value means non-string>:");
            object4 = properties.propertyNames();
            while (object4.hasMoreElements()) {
                object3 = (String)object4.nextElement();
                object2 = properties.getProperty((String)object3);
                if (-1 == ((String)object3).toLowerCase().indexOf("password")) {
                    Tr.debug(tc, "\t" + (String)object3 + " = " + (String)object2);
                    continue;
                }
                object = new StringBuilder(4 + ((String)object3).length() + ((String)object2).length());
                ((StringBuilder)object).append("\t").append((String)object3).append(" = ");
                for (int i = 0; i < ((String)object2).length(); ++i) {
                    ((StringBuilder)object).append("*");
                }
                Tr.debug(tc, ((StringBuilder)object).toString());
            }
        }
        object4 = null;
        try {
            object3 = new SSLConfig(properties);
            object2 = (IBMJSSE2Provider)this.jsse2Provider;
            object4 = ((AbstractJSSEProvider)object2).getSSLContext_JSSE2(hashMap, (SSLConfig)object3);
            object = new SSLLinkConfig(properties);
            if (null == sSLConnectionLink) {
                virtualConnection.getStateMap().put("SSLLINKCONFIG", object);
            } else {
                sSLConnectionLink.setLinkConfig((SSLLinkConfig)object);
            }
        }
        catch (Exception exception) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLContext from properties.", new Object[]{exception});
            }
            throw new ChannelException(exception);
        }
        return object4;
    }

    public void start() throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        try {
            if (this.getConfig().isInbound()) {
                ChainData chainData = this.channelFramework.getInternalRunningChains(this.getConfig().getName())[0];
                ChannelData channelData = (ChannelData)chainData.getChannelList()[0];
                Map map = channelData.getPropertyBag();
                this.inboundHost = (String)map.get("hostname");
                this.inboundPort = (String)map.get("port");
                this.endPointName = (String)map.get("endPointName");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "inboundHost = " + this.inboundHost + " inboundPort = " + this.inboundPort + " endPointName = " + this.endPointName);
                }
            }
        }
        catch (Exception exception) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception during start, throwing up stack.  " + exception);
            }
            throw new ChannelException(exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop(long l) throws ChannelException {
    }

    public void init() throws ChannelException {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        if (this.isInitialized) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "init");
            }
            return;
        }
        try {
            object = this.getConfig().getProperties();
            if (object != null) {
                this.alias = ((Properties)object).getProperty("alias");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    if (this.alias != null) {
                        Tr.debug(tc, "Found alias in SSL properties, " + this.alias);
                    } else {
                        Tr.debug(tc, "No alias found in SSL properties");
                    }
                }
            }
        }
        catch (Exception exception) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "init received exception handling properties; " + exception);
            }
            throw new ChannelException(exception);
        }
        this.jsse2Provider = JSSEProviderFactory.getInstance("IBMJSSE2");
        if (this.jsse2Provider == null) {
            object = "Unable to get an instance of the JSSEProvider";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, (String)object);
            }
            throw new ChannelException((String)object);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Have a valid jsse2Provider");
        }
        this.isInitialized = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void destroy() throws ChannelException {
        if (null != this.myFactory && null != this.getConfig()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing channel from factory; " + this.getConfig().getName());
            }
            this.myFactory.destroyChannel(this.getConfig().getName());
            this.myFactory = null;
        }
        this.discProcess = null;
        this.sslConfig = null;
        this.sessionContext = null;
    }

    public String getName() {
        return this.sslConfig.getName();
    }

    public Class getApplicationInterface() {
        return TCPConnectionContext.class;
    }

    public Class getDeviceInterface() {
        return TCPConnectionContext.class;
    }

    public void update(ChannelData channelData) {
        this.sslConfig.updateChannelData(channelData);
    }

    public int discriminate(VirtualConnection virtualConnection, Object object) {
        SSLDiscriminatorState sSLDiscriminatorState;
        int n;
        ProtoSSLEngineResult protoSSLEngineResult;
        SSLContext sSLContext;
        ProtoSSLEngine protoSSLEngine;
        Map map;
        WsByteBuffer wsByteBuffer;
        int n2;
        int n3;
        WsByteBuffer wsByteBuffer2;
        block35: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "discriminate");
            }
            if (object == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Received null discrim data.  Returning NO from discriminator.");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "discriminate");
                }
                return 0;
            }
            wsByteBuffer2 = ((WsByteBuffer[])object)[0];
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "netBuffer: " + SSLUtils.getBufferTraceInfo(wsByteBuffer2));
            }
            if (0 == wsByteBuffer2.position()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Received empty discrim data.  Returning MAYBE from discriminator.");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "discriminate");
                }
                return -1;
            }
            if (!this.isInitialized) {
                try {
                    this.init();
                }
                catch (Exception exception) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught while getting SSL connection link: " + exception);
                    }
                    FFDCFilter.processException(exception, CLASS_NAME, "148", this, new Object[]{virtualConnection});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "discriminate");
                    }
                    return 0;
                }
            }
            n3 = wsByteBuffer2.position();
            n2 = wsByteBuffer2.limit();
            wsByteBuffer = null;
            map = virtualConnection.getStateMap();
            protoSSLEngine = null;
            sSLContext = null;
            protoSSLEngineResult = null;
            ProtoSSLEngineResult.Status status = null;
            n = 1;
            sSLDiscriminatorState = null;
            try {
                wsByteBuffer2.flip();
                sSLDiscriminatorState = (SSLDiscriminatorState)map.get(SSL_DISCRIMINATOR_STATE);
                if (sSLDiscriminatorState == null) {
                    sSLContext = this.getSSLContextForInboundLink(null, virtualConnection);
                    protoSSLEngine = SSLUtils.getSSLEngine(sSLContext, FlowType.INBOUND, (SSLLinkConfig)virtualConnection.getStateMap().get("SSLLINKCONFIG"));
                    wsByteBuffer = SSLUtils.allocateByteBuffer(protoSSLEngine.getApplicationBufferSize(), this.getConfig().getDecryptBuffersDirect());
                } else {
                    protoSSLEngine = sSLDiscriminatorState.getEngine();
                    sSLContext = sSLDiscriminatorState.getSSLContext();
                    wsByteBuffer = sSLDiscriminatorState.getDecryptedNetBuffer();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "before unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer2) + "\r\n\tdecNetBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer));
                }
                WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[]{wsByteBuffer2};
                int[] nArray = SSLUtils.adjustBuffersForJSSE(wsByteBufferArray, protoSSLEngine.getPacketBufferSize());
                protoSSLEngineResult = protoSSLEngine.unwrap(wsByteBuffer2.getWrappedByteBuffer(), wsByteBuffer.getWrappedByteBuffer());
                if (nArray != null) {
                    SSLUtils.resetBuffersAfterJSSE(wsByteBufferArray, nArray);
                }
                status = protoSSLEngineResult.getStatus();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "after unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer2) + "\r\n\tdecNetBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer) + "\r\n\tstatus=" + protoSSLEngineResult.getStatus() + " consumed=" + protoSSLEngineResult.inBytesConsumed() + " produced=" + protoSSLEngineResult.outBytesProduced());
                }
                if (status == ProtoSSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    n = -1;
                } else {
                    n = 1;
                    if (wsByteBuffer2.remaining() == 0) {
                        wsByteBuffer2.clear();
                    }
                }
            }
            catch (Exception exception) {
                n = 0;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block35;
                Tr.debug(tc, "Caught Exception during discriminate: " + exception);
            }
        }
        switch (n) {
            case 1: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Discriminator returning YES");
                }
                if (sSLDiscriminatorState == null) {
                    sSLDiscriminatorState = new SSLDiscriminatorState();
                }
                sSLDiscriminatorState.updateState(sSLContext, protoSSLEngine, protoSSLEngineResult, wsByteBuffer, wsByteBuffer2.position(), wsByteBuffer2.limit());
                map.put(SSL_DISCRIMINATOR_STATE, sSLDiscriminatorState);
                break;
            }
            case 0: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Discriminator returning NO");
                }
                if (sSLDiscriminatorState != null) {
                    map.remove(SSL_DISCRIMINATOR_STATE);
                }
                if (null != protoSSLEngine) {
                    this.closeEngine(protoSSLEngine);
                }
                if (null == wsByteBuffer) break;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Releasing decryptedNetworkBuffer");
                }
                wsByteBuffer.release();
                wsByteBuffer = null;
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Discriminator returning MAYBE");
                }
                if (sSLDiscriminatorState != null) break;
                sSLDiscriminatorState = new SSLDiscriminatorState();
                sSLDiscriminatorState.updateState(sSLContext, protoSSLEngine, protoSSLEngineResult, wsByteBuffer, wsByteBuffer2.position(), wsByteBuffer2.limit());
                map.put(SSL_DISCRIMINATOR_STATE, sSLDiscriminatorState);
            }
        }
        wsByteBuffer2.limit(n2);
        wsByteBuffer2.position(n3);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "discriminate");
        }
        return n;
    }

    public void cleanUpState(VirtualConnection virtualConnection) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanUpState");
        }
        SSLDiscriminatorState sSLDiscriminatorState = (SSLDiscriminatorState)virtualConnection.getStateMap().remove(SSL_DISCRIMINATOR_STATE);
        this.closeEngine(sSLDiscriminatorState.getEngine());
        WsByteBuffer wsByteBuffer = sSLDiscriminatorState.getDecryptedNetBuffer();
        if (wsByteBuffer != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Releasing decryptedNetworkBuffer");
            }
            wsByteBuffer.release();
            wsByteBuffer = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanUpState");
        }
    }

    protected void onHandshakeFinish(ProtoSSLEngine protoSSLEngine) {
        SSLSessionContext sSLSessionContext = null;
        try {
            final ProtoSSLEngine protoSSLEngine2 = protoSSLEngine;
            sSLSessionContext = (SSLSessionContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return protoSSLEngine2.getSession().getSessionContext();
                }
            });
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.ssl.channel.impl.SSLChannel.onHandshakeFinish", "814");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception querying sessioncontext; " + exception);
            }
            return;
        }
        if (null == sSLSessionContext || sSLSessionContext.equals(this.sessionContext)) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Channel [" + this + "] saving context: " + sSLSessionContext);
        }
        this.sessionContext = sSLSessionContext;
        sSLSessionContext.setSessionCacheSize(this.getConfig().getSSLSessionCacheSize());
        sSLSessionContext.setSessionTimeout(this.getConfig().getSSLSessionTimeout());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Session cache size set to " + sSLSessionContext.getSessionCacheSize());
            Tr.debug(tc, "Session timeout set to " + sSLSessionContext.getSessionTimeout());
        }
    }

    private void closeEngine(ProtoSSLEngine protoSSLEngine) {
        if (null != protoSSLEngine) {
            if (!protoSSLEngine.isInboundDone()) {
                protoSSLEngine.closeInbound();
            }
            if (!protoSSLEngine.isOutboundDone()) {
                protoSSLEngine.closeOutbound();
            }
        }
    }

    public Class getDiscriminatoryDataType() {
        return WsByteBuffer.class;
    }

    public Channel getChannel() {
        return this;
    }

    public int getWeight() {
        return this.sslConfig.getWeight();
    }

    public SSLChannelData getConfig() {
        return this.sslConfig;
    }
}

