/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.J2EEManagedObjectCollaborator;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.runtime.deploy.DeployedObject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

public abstract class DeployedObjectCollaborator
extends J2EEManagedObjectCollaborator
implements PropertyChangeListener {
    private static TraceComponent tc = Tr.register(DeployedObjectCollaborator.class);
    static final String SERVER = "WebSphere:type=Server,*";
    protected String archivePath;
    protected String ddFilename;
    protected ModuleItem pmiModule;
    private long ntfySeqNum = 0L;
    private DeployedObject deployedObj;

    public DeployedObjectCollaborator(DeployedObject deployedObject) {
        this.deployedObj = deployedObject;
        Resource resource = deployedObject.getDeploymentDescriptor().eResource();
        ModuleFile moduleFile = deployedObject.getModuleFile();
        try {
            this.archivePath = moduleFile.getResourcesPath();
            this.ddFilename = resource.getURI().toFileString();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        deployedObject.addPropertyChangeListener("state", this);
    }

    protected void destroy() {
        this.deployedObj.removePropertyChangeListener("state", this);
        this.deployedObj = null;
    }

    public abstract String getType();

    public String getName() {
        return this.getObjectName().getKeyProperty("name");
    }

    public String getJavaVersion() {
        return System.getProperty("java.vm.version");
    }

    public String getJavaVendor() {
        return System.getProperty("java.vm.vendor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDeploymentDescriptor(CharsetDecoder charsetDecoder) throws IOException {
        InputStream inputStream = null;
        ZipFile zipFile = null;
        try {
            int n;
            Object object;
            Object object2;
            File file = new File(this.archivePath);
            if (file.isDirectory()) {
                object2 = new File(file, this.ddFilename);
                inputStream = new FileInputStream((File)object2);
            } else {
                zipFile = new JarFile(file);
                object2 = this.ddFilename.replace('\\', '/');
                object = ((JarFile)zipFile).getEntry((String)object2);
                inputStream = ((JarFile)zipFile).getInputStream((ZipEntry)object);
            }
            object2 = new StringBuilder();
            object = charsetDecoder == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, charsetDecoder);
            char[] cArray = new char[4096];
            while ((n = ((Reader)object).read(cArray)) != -1) {
                ((StringBuilder)object2).append(cArray, 0, n);
            }
            String string = ((StringBuilder)object2).toString();
            return string;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    public String getDeploymentDescriptor() throws IOException {
        Charset charset = Charset.forName("UTF-8");
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
        try {
            return this.getDeploymentDescriptor(charsetDecoder);
        }
        catch (MalformedInputException malformedInputException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception", malformedInputException);
            }
            return this.getDeploymentDescriptor(null);
        }
    }

    public String getServer() {
        return this.getObjectName(SERVER);
    }

    protected Set lookupMBeans(String string, QueryExp queryExp) {
        try {
            ObjectName objectName = new ObjectName(string);
            return AdminServiceFactory.getAdminService().queryNames(objectName, queryExp);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MalformedObjectName Exception", malformedObjectNameException);
            }
            return null;
        }
    }

    protected String[] getObjectNames(String string) {
        return this.getObjectNames(string, null);
    }

    protected String[] getObjectNames(String string, QueryExp queryExp) {
        Set set = this.lookupMBeans(string, queryExp);
        String[] stringArray = new String[set.size()];
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = iterator.next().toString();
        }
        return stringArray;
    }

    protected String getObjectName(String string) {
        Set set = this.lookupMBeans(string, null);
        if (set.size() == 0) {
            return null;
        }
        return set.iterator().next().toString();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = (String)propertyChangeEvent.getNewValue();
        String string2 = null;
        if (string.equals("STARTING")) {
            string2 = "j2ee.state.starting";
        } else if (string.equals("STARTED")) {
            string2 = "j2ee.state.running";
        } else if (string.equals("STOPPING")) {
            string2 = "j2ee.state.stopping";
        } else if (string.equals("STOPPED")) {
            string2 = "j2ee.state.stopped";
        } else if (string.equals("ERROR")) {
            string2 = "j2ee.state.failed";
        } else if (string.equals("DESTROYED")) {
            this.destroy();
        }
        this.sendStateNotification(string2);
    }

    protected void sendStateNotification(String string) {
        if (string != null) {
            try {
                this.sendNotification(new Notification(string, this.getObjectName(), this.ntfySeqNum++));
            }
            catch (MBeanException mBeanException) {
                FFDCFilter.processException((Throwable)mBeanException, DeployedObjectCollaborator.class.getName() + ".sendStateNotification", "211", this);
            }
        }
    }
}

