/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.UploadFile;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commanddata.TaskCommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandGroupMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.websphere.management.exception.SessionTimeoutException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import com.ibm.ws.management.cmdframework.impl.CommandUtility;
import com.ibm.ws.management.cmdframework.impl.EObjectSerializer;
import com.ibm.ws.management.cmdframework.impl.RemoteCommandMgr;
import com.ibm.ws.management.cmdframework.impl.ServerCommandMgr;
import com.ibm.ws.management.cmdframework.impl.TaskCommandSession;
import com.ibm.ws.management.cmdframework.impl.TaskCommandSessionMgr;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class RemoteCommandMgrImpl
implements RemoteCommandMgr {
    private static TraceComponent tc = Tr.register(RemoteCommandMgrImpl.class, "RemoteCommandMgrImpl", "com.ibm.ws.management.cmdframework.impl");

    public RemoteCommandMgrImpl() throws Exception {
        this.initialize();
    }

    private void initialize() throws Exception {
        CommandMgr.getCommandMgr();
    }

    public ArrayList listCommandGroups() {
        return new ArrayList(CommandMetadataMgr.getInstance().listCommandGroups());
    }

    public ArrayList listAllCommands() {
        return new ArrayList(CommandMetadataMgr.getInstance().listAllCommands());
    }

    public ArrayList listCommands(String string) {
        return new ArrayList(CommandMetadataMgr.getInstance().listCommands(string));
    }

    public ArrayList listCommands() {
        return new ArrayList(CommandMetadataMgr.getInstance().listCommands());
    }

    public CommandResult execute(EObjectSerializer eObjectSerializer) throws CommandNotFoundException, CommandLoadException {
        CommandData commandData;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", eObjectSerializer);
        }
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        try {
            object2 = eObjectSerializer.getName();
            if (object2 != null && !((String)object2).equals("")) {
                object = CommandMetadataMgr.getInstance().getParamDataEClass((String)object2);
            }
            commandData = (CommandData)eObjectSerializer.getEObjectValue();
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught", iOException);
            }
            throw new CommandLoadException(iOException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command execute is " + commandData.getName());
        }
        object2 = CommandMetadataMgr.getInstance().getCommandProvider(commandData.getName());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command provider is " + object2);
        }
        object = ((CommandProvider)object2).loadCommand(commandData);
        object.execute();
        this.cleanupUploadedFiles((AdminCommand)object);
        CommandResult commandResult = object.getCommandResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute", new Boolean(commandResult.isSuccessful()).toString());
        }
        return commandResult;
    }

    public CommandResult execute(TaskCommandSession taskCommandSession, EObjectSerializer eObjectSerializer) throws CommandNotFoundException, CommandLoadException {
        TaskCommandData taskCommandData;
        AbstractTaskCommand abstractTaskCommand;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", eObjectSerializer);
        }
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        TaskCommandSessionMgr taskCommandSessionMgr = ((ServerCommandMgr)commandMgr).getTaskCommandSessionMgr();
        try {
            abstractTaskCommand = (AbstractTaskCommand)taskCommandSessionMgr.getTaskCommand(taskCommandSession);
            taskCommandData = (TaskCommandData)eObjectSerializer.getEObjectValue();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught", exception);
            }
            throw new CommandLoadException(exception);
        }
        if (tc.isDebugEnabled()) {
            this.listAllStepParamsData(taskCommandData);
        }
        abstractTaskCommand.resetCommandData(taskCommandData);
        abstractTaskCommand.execute();
        this.cleanupUploadedFiles(abstractTaskCommand);
        CommandResult commandResult = abstractTaskCommand.getCommandResult();
        taskCommandSessionMgr.removeTaskCommand(taskCommandSession);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
        return commandResult;
    }

    private void cleanupUploadedFiles(AdminCommand adminCommand) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupUploadedFiles");
        }
        EList eList = adminCommand.getCommandMetadata().getParameters();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            try {
                Object object;
                ParameterMetadata parameterMetadata = (ParameterMetadata)iterator.next();
                if (!parameterMetadata.getType().equals("com.ibm.websphere.management.cmdframework.UploadFile") || (object = adminCommand.getParameter(parameterMetadata.getName())) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "detect DownloadFile parameter " + parameterMetadata.getName() + " value is " + object);
                }
                new File(((UploadFile)object).getPath()).delete();
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unexpected exception", throwable);
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.management.cmdframework.impl.RemoteCommandMgrImpl.cleanupUploadedFiles", "141", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupUploadedFiles");
        }
    }

    public void listAllStepParamsData(TaskCommandData taskCommandData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAllStepParamsData", taskCommandData);
        }
        EList eList = taskCommandData.getSteps();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "step data list is  ", eList);
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            CommandStepData commandStepData = (CommandStepData)iterator.next();
            String string = commandStepData.getName();
            EList eList2 = commandStepData.getCmdParams();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Parameters are " + eList2);
            }
            EObject eObject = null;
            for (int i = 0; i < eList2.size(); ++i) {
                eObject = (EObject)eList2.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "paraData name is", eObject);
                }
                EClass eClass = eObject.eClass();
                Iterator iterator2 = eClass.getEAllAttributes().iterator();
                while (iterator2.hasNext()) {
                    EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator2.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "feature", eStructuralFeature);
                    }
                    if (!eObject.eIsSet(eStructuralFeature)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setted feature is" + eStructuralFeature.getName());
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "setted feature value is" + eObject.eGet(eStructuralFeature));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAllStepParamsData");
        }
    }

    public EObjectSerializer getCommandGroupMetaInfo(String string, Locale locale) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandGroupMetaInfo", string);
        }
        try {
            CommandGroupMetadata commandGroupMetadata = CommandMgr.getCommandMgr().getCommandGroupMetadata(string);
            if (locale != null && !locale.equals(Locale.getDefault())) {
                CommandMetadataMgr.getInstance().translate(commandGroupMetadata, null, locale);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommandGroupMetaInfo");
            }
            return this.createEObjSerializer(commandGroupMetadata);
        }
        catch (CommandNotFoundException commandNotFoundException) {
            throw commandNotFoundException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.cmdframework.RemoteCommandmgrImpl", "167", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught ", exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommandMetaInfo");
            }
            CommandNotFoundException commandNotFoundException = new CommandNotFoundException(string);
            commandNotFoundException.initCause(exception);
            throw commandNotFoundException;
        }
    }

    public Collection getAllCommandGrpMetaInfo(Locale locale) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllCommandGrpMetaInfo", locale);
        }
        Collection collection = CommandMetadataMgr.getInstance().listCommandGroups();
        Iterator iterator = collection.iterator();
        ArrayList<EObjectSerializer> arrayList = new ArrayList<EObjectSerializer>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command Group to lookup is " + string);
                }
                CommandGroupMetadata commandGroupMetadata = CommandMgr.getCommandMgr().getCommandGroupMetadata(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default Locale is " + Locale.getDefault());
                }
                if (locale != null && !locale.equals(Locale.getDefault())) {
                    CommandMetadataMgr.getInstance().translate(commandGroupMetadata, null, locale);
                }
                arrayList.add(this.createEObjSerializer(commandGroupMetadata));
            }
            catch (CommandNotFoundException commandNotFoundException) {
                FFDCFilter.processException((Throwable)commandNotFoundException, "com.ibm.ws.management.cmdframework.RemoteCommandmgrImpl", "190", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "CommandNotFoundException caught ", commandNotFoundException);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.cmdframework.RemoteCommandmgrImpl", "190", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception caught ", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllCommandGrpMetaInfo");
        }
        return arrayList;
    }

    public EObjectSerializer getCommandMetaInfo(String string, Locale locale) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandMetaInfo", new Object[]{string, locale});
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Command to lookup is " + string);
            }
            CommandMetadata commandMetadata = CommandMgr.getCommandMgr().getCommandMetadata(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Default Locale is " + Locale.getDefault());
            }
            if (locale != null && !locale.equals(Locale.getDefault())) {
                CommandMetadataMgr.getInstance().translate(commandMetadata, null, locale);
            }
            EClass eClass = CommandMetadataMgr.getInstance().getParamDataEClass(string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommandMetaInfo");
            }
            return this.createEObjSerializer(commandMetadata);
        }
        catch (CommandNotFoundException commandNotFoundException) {
            FFDCFilter.processException((Throwable)commandNotFoundException, "com.ibm.ws.management.cmdframework.RemoteCommandmgrImpl", "190", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CommandNotFoundException caught ", commandNotFoundException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommandMetaInfo");
            }
            throw commandNotFoundException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.cmdframework.RemoteCommandmgrImpl", "190", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught ", exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommandMetaInfo");
            }
            CommandNotFoundException commandNotFoundException = new CommandNotFoundException(string);
            commandNotFoundException.initCause(exception);
            throw commandNotFoundException;
        }
    }

    public Collection getAllCommandMetaInfo(Locale locale) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandAllMetaInfo", locale);
        }
        Collection collection = CommandMetadataMgr.getInstance().listAllCommands();
        Iterator iterator = collection.iterator();
        ArrayList<EObjectSerializer> arrayList = new ArrayList<EObjectSerializer>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command to lookup is " + string);
                }
                CommandMetadata commandMetadata = CommandMgr.getCommandMgr().getCommandMetadata(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default Locale is " + Locale.getDefault());
                }
                if (locale != null && !locale.equals(Locale.getDefault())) {
                    CommandMetadataMgr.getInstance().translate(commandMetadata, null, locale);
                }
                arrayList.add(this.createEObjSerializer(commandMetadata));
            }
            catch (CommandNotFoundException commandNotFoundException) {
                FFDCFilter.processException((Throwable)commandNotFoundException, "com.ibm.ws.management.cmdframework.RemoteCommandmgrImpl", "190", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "CommandNotFoundException caught ", commandNotFoundException);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.cmdframework.RemoteCommandmgrImpl", "190", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception caught ", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllCommandMetaInfo");
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EObjectSerializer getCurrentStep(TaskCommandSession taskCommandSession, EObjectSerializer eObjectSerializer, Integer n, String string) {
        Object object;
        AbstractTaskCommand abstractTaskCommand;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentStep2", taskCommandSession);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Client operation is " + n);
        }
        int n2 = n;
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        try {
            object2 = ((ServerCommandMgr)commandMgr).getTaskCommandSessionMgr();
            abstractTaskCommand = (AbstractTaskCommand)((TaskCommandSessionMgr)object2).getTaskCommand(taskCommandSession);
        }
        catch (SessionTimeoutException sessionTimeoutException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught, return empty EObjectSerializer", sessionTimeoutException);
            }
            return new EObjectSerializer();
        }
        if (n2 == 3) {
            try {
                object2 = (TaskCommandData)eObjectSerializer.getEObjectValue();
                abstractTaskCommand.resetCommandData((CommandData)object2);
                AbstractCommandStep abstractCommandStep = (AbstractCommandStep)abstractTaskCommand.getCommandStep(string);
                EObject eObject = CommandUtility.clone(abstractCommandStep.getCommandStepData());
                try {
                    return this.createEObjSerializer(eObject);
                }
                catch (IOException iOException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "IOException caught, return empty EObjectSerializer", iOException);
                    }
                    return new EObjectSerializer();
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught, return empty EObjectSerializer", exception);
                }
                return new EObjectSerializer();
            }
        }
        if (abstractTaskCommand.getCurrentStepIndex() != 0) {
            try {
                object2 = (CommandStepData)eObjectSerializer.getEObjectValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Client Current command step is " + object2.getName());
                }
                object = (AbstractCommandStep)abstractTaskCommand.getCommandStep(object2.getName());
                ((AbstractCommandStep)object).resetCommandData((CommandData)object2);
                abstractTaskCommand.setCurrentStep((AbstractCommandStep)object);
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught, return empty EObjectSerializer", iOException);
                }
                return new EObjectSerializer();
            }
            catch (CommandNotFoundException commandNotFoundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught, return empty EObjectSerializer", commandNotFoundException);
                }
                return new EObjectSerializer();
            }
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "First client command step.  Reset the commanddata from the task command");
            }
            object2 = (TaskCommandData)eObjectSerializer.getEObjectValue();
            abstractTaskCommand.resetCommandData((CommandData)object2);
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught during resetting the client Task commanddata , return empty EObjectSerializer", iOException);
            }
            return new EObjectSerializer();
        }
        switch (n2) {
            case 0: {
                abstractTaskCommand.nextStep();
                break;
            }
            case 1: {
                abstractTaskCommand.previousStep();
                break;
            }
            case 2: {
                abstractTaskCommand.gotoStep(string);
            }
        }
        object2 = (AbstractCommandStep)abstractTaskCommand.getCurrentStep(n2);
        object = CommandUtility.clone(((AbstractCommandStep)object2).getCommandStepData());
        try {
            EObjectSerializer eObjectSerializer2 = this.createEObjSerializer((EObject)object);
            return eObjectSerializer2;
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught, return empty EObjectSerializer", iOException);
            }
            EObjectSerializer eObjectSerializer3 = new EObjectSerializer();
            return eObjectSerializer3;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCurrentStep", ((AbstractAdminCommand)object2).getName());
            }
        }
    }

    public ArrayList contructSteps(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contructSteps", string);
        }
        try {
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            TaskCommandSessionMgr taskCommandSessionMgr = ((ServerCommandMgr)commandMgr).getTaskCommandSessionMgr();
            AbstractTaskCommand abstractTaskCommand = (AbstractTaskCommand)commandMgr.createCommand(string);
            EClass eClass = CommandMetadataMgr.getInstance().getParamDataEClass(string);
            this.constructStepEClass(abstractTaskCommand.getTaskCommandMetadata());
            TaskCommandData taskCommandData = abstractTaskCommand.getTaskCommandData();
            TaskCommandSession taskCommandSession = taskCommandSessionMgr.createTaskCommandSession(abstractTaskCommand);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Command Session send is  " + taskCommandSession.getSessionId());
                this.listAllStepParamsData(taskCommandData);
            }
            ArrayList<Serializable> arrayList = new ArrayList<Serializable>(2);
            arrayList.add(0, taskCommandSession);
            arrayList.add(1, this.createEObjSerializer(taskCommandData));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "contructSteps");
            }
            return arrayList;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception creating command ", exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "contructSteps");
            }
            return null;
        }
    }

    private void constructStepEClass(TaskCommandMetadata taskCommandMetadata) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructStepEClass", taskCommandMetadata);
        }
        String string = taskCommandMetadata.getName();
        EList eList = taskCommandMetadata.getSteps();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            CommandStepMetadata commandStepMetadata = (CommandStepMetadata)iterator.next();
            String string2 = commandStepMetadata.getName();
            CommandMetadataMgr.getInstance().createParamDataEClass(CommandMetadataMgr.getInstance().getStepEClassName(string, string2), commandStepMetadata.getParameters());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructStepEClass");
        }
    }

    private EObjectSerializer createEObjSerializer(EObject eObject) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEObjSerializer", eObject);
        }
        EObjectSerializer eObjectSerializer = new EObjectSerializer();
        try {
            eObjectSerializer.setEObjectValue(CommandUtility.clone(eObject));
            EObjectSerializer eObjectSerializer2 = eObjectSerializer;
            return eObjectSerializer2;
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught", iOException);
            }
            throw iOException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createEObjSerializer");
            }
        }
    }
}

