/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandGroupMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.cmdframework.impl.ClientAdminCommand;
import com.ibm.ws.management.cmdframework.impl.ClientTaskCommand;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import com.ibm.ws.management.cmdframework.impl.CommandMgrImpl;
import com.ibm.ws.management.cmdframework.impl.CommandUtility;
import com.ibm.ws.management.cmdframework.impl.EObjectSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.management.MBeanException;

public class ClientCommandMgr
extends CommandMgrImpl {
    private static TraceComponent tc = Tr.register(ClientCommandMgr.class, "ClientCommandMgr", "com.ibm.ws.management.cmdframework.impl");
    private AdminClient adminClient;
    public HashMap cmdMetadataMap = new HashMap();

    public ClientCommandMgr() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Init client command manager");
        }
        cmdMgr = this;
        this.helper = new CommandProviderHelper(){

            public ConfigService getConfigService() {
                return ConfigServiceFactory.getConfigService();
            }

            public AdminClient getAdminClient() {
                return ClientCommandMgr.this.adminClient;
            }

            public AdminService getAdminService() {
                return null;
            }

            public AppManagement getAppManagement() {
                AppManagement appManagement = null;
                try {
                    appManagement = AppManagementProxy.getJMXProxyForClient(ClientCommandMgr.this.adminClient);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.cmdframework.impl.LocalCommandMgr.getAppManagement", "59", this);
                    exception.printStackTrace();
                }
                return appManagement;
            }
        };
    }

    public CommandProviderHelper getCommandProviderHelper() {
        return this.helper;
    }

    public void setAdminClient(AdminClient adminClient) {
        this.adminClient = adminClient;
    }

    public Collection listCommandGroups() throws ConnectorException, CommandException {
        try {
            return (Collection)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "listCommandGroups", null, null);
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof CommandException) {
                throw (CommandException)exception;
            }
            throw new CommandException(exception);
        }
        catch (ConnectorException connectorException) {
            throw connectorException;
        }
        catch (Exception exception) {
            throw new CommandException(exception);
        }
    }

    public Collection listCommands(String string) throws ConnectorException, CommandException {
        try {
            return (Collection)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "listCommands", new Object[]{string}, new String[]{"java.lang.String"});
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof CommandException) {
                throw (CommandException)exception;
            }
            throw new CommandException(exception);
        }
        catch (ConnectorException connectorException) {
            throw connectorException;
        }
        catch (Exception exception) {
            throw new CommandException(exception);
        }
    }

    public Collection listCommands() throws ConnectorException, CommandException {
        try {
            return (Collection)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "listCommands", null, null);
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof CommandException) {
                throw (CommandException)exception;
            }
            throw new CommandException(exception);
        }
        catch (ConnectorException connectorException) {
            throw connectorException;
        }
        catch (Exception exception) {
            throw new CommandException(exception);
        }
    }

    public Collection listAllCommands() throws ConnectorException, CommandException {
        try {
            return (Collection)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "listAllCommands", null, null);
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof CommandException) {
                throw (CommandException)exception;
            }
            throw new CommandException(exception);
        }
        catch (ConnectorException connectorException) {
            throw connectorException;
        }
        catch (Exception exception) {
            throw new CommandException(exception);
        }
    }

    public CommandGroupMetadata getCommandGroupMetadata(String string) throws ConnectorException, CommandException {
        try {
            EObjectSerializer eObjectSerializer = (EObjectSerializer)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "getCommandGroupMetaInfo", new Object[]{string, Locale.getDefault()}, new String[]{"java.lang.String", "java.util.Locale"});
            return (CommandGroupMetadata)eObjectSerializer.getEObjectValue();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof CommandException) {
                throw (CommandException)exception;
            }
            throw new CommandException(exception);
        }
        catch (ConnectorException connectorException) {
            throw connectorException;
        }
        catch (Exception exception) {
            throw new CommandException(exception);
        }
    }

    public Collection getAllCommandGroupMetadata() throws ConnectorException, CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllCommandMetadata");
        }
        ArrayList<CommandGroupMetadata> arrayList = new ArrayList<CommandGroupMetadata>();
        try {
            Collection collection = (Collection)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "getAllCommandGrpMetaInfo", new Object[]{Locale.getDefault()}, new String[]{"java.util.Locale"});
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                EObjectSerializer eObjectSerializer = (EObjectSerializer)iterator.next();
                arrayList.add((CommandGroupMetadata)eObjectSerializer.getEObjectValue());
            }
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof CommandException) {
                throw (CommandException)exception;
            }
            throw new CommandException(exception);
        }
        catch (ConnectorException connectorException) {
            throw connectorException;
        }
        catch (Exception exception) {
            throw new CommandException(exception);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAllCommandGroupMetadata", arrayList);
            }
        }
        return arrayList;
    }

    public CommandMetadata getCommandMetadata(String string) throws ConnectorException, CommandException {
        CommandMetadata commandMetadata;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandMetadata", string);
        }
        if ((commandMetadata = (CommandMetadata)this.cmdMetadataMap.get(string)) == null) {
            commandMetadata = this.initCommandMetadata(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandMetadata", commandMetadata);
        }
        return commandMetadata;
    }

    public Collection getAllCommandMetadata() throws ConnectorException, CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllCommandMetadata");
        }
        ArrayList<CommandMetadata> arrayList = new ArrayList<CommandMetadata>();
        try {
            Collection collection = (Collection)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "getAllCommandMetaInfo", new Object[]{Locale.getDefault()}, new String[]{"java.util.Locale"});
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                EObjectSerializer eObjectSerializer = (EObjectSerializer)iterator.next();
                arrayList.add((CommandMetadata)eObjectSerializer.getEObjectValue());
            }
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof CommandException) {
                throw (CommandException)exception;
            }
            throw new CommandException(exception);
        }
        catch (ConnectorException connectorException) {
            throw connectorException;
        }
        catch (Exception exception) {
            throw new CommandException(exception);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAllCommandMetadata", arrayList);
            }
        }
        return arrayList;
    }

    public AdminCommand createCommand(String string) throws ConnectorException, CommandException {
        CommandMetadata commandMetadata;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCommand", string);
        }
        if ((commandMetadata = (CommandMetadata)this.cmdMetadataMap.get(string)) == null) {
            commandMetadata = this.initCommandMetadata(string);
        }
        if (commandMetadata instanceof TaskCommandMetadata) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "createCommand", "Creating Task Command");
            }
            return new ClientTaskCommand((TaskCommandMetadata)commandMetadata);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "createCommand", "Creating Command");
        }
        return new ClientAdminCommand(commandMetadata);
    }

    private CommandMetadata initCommandMetadata(String string) throws ConnectorException, CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initCommandMetadata", string);
        }
        try {
            Object object;
            String string2;
            CommandMetadata commandMetadata;
            block16: {
                EObjectSerializer eObjectSerializer = (EObjectSerializer)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "getCommandMetaInfo", new Object[]{string, Locale.getDefault()}, new String[]{"java.lang.String", "java.util.Locale"});
                commandMetadata = (CommandMetadata)eObjectSerializer.getEObjectValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command MetaData received is " + commandMetadata);
                }
                string2 = commandMetadata.getName();
                try {
                    CommandMetadataMgr.getInstance(true).getCommandMetadata(string2);
                }
                catch (CommandNotFoundException commandNotFoundException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Command " + string2 + " does not exist locally. Process to add...");
                    }
                    ArrayList<CommandMetadata> arrayList = new ArrayList<CommandMetadata>(0);
                    arrayList.add(commandMetadata);
                    CommandMetadataMgr.getInstance(true).registerCommandMetadataRemote(arrayList);
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug(tc, "Command " + string2 + " added to local CommandMetadataMgr");
                }
            }
            CommandMetadataMgr.getInstance(true).createParamDataEObject(string2);
            if (commandMetadata instanceof TaskCommandMetadata) {
                object = ((TaskCommandMetadata)commandMetadata).getSteps();
                for (int i = 0; i < object.size(); ++i) {
                    String string3 = ((CommandStepMetadata)object.get(i)).getName();
                    CommandMetadataMgr.getInstance(true).createParamDataEObject(string2, string3);
                }
            }
            this.cmdMetadataMap.put(string, commandMetadata);
            object = commandMetadata;
            return object;
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof CommandException) {
                throw (CommandException)exception;
            }
            throw new CommandException(exception);
        }
        catch (ConnectorException connectorException) {
            throw connectorException;
        }
        catch (Exception exception) {
            throw new CommandException(exception);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initCommandMetadata");
            }
        }
    }
}

