/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.ras.TraceStateChangeListener;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.bootstrap.WsLogManager;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.logging.LoggerHelper;
import com.ibm.ws.logging.RecursionCounter;
import com.ibm.ws.logging.cbe.CBEHelper;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.hyades.logging.events.cbe.EventFactory;

public class WsLogger
extends Logger
implements TraceStateChangeListener {
    private static Logger svLogger = null;
    private static final String CLASSNAME;
    private static final String RECURSION_COUNTER_NAME;
    private static int RECURSION_COUNTER_MAX;
    private static Vector svAsyncQueue;
    private static final String BUNDLENAME = "com.ibm.ejs.resources.RasMessages";
    private String ivCachedResourceBundleName = null;
    private ResourceBundle ivCachedResourceBundle = null;
    private HashMap ivExtensions = new HashMap();
    private String ivComponent;
    private String ivOrganization;
    private String ivProduct;
    private int ivMinimumLocalizationLevelIntValue = Level.ALL.intValue();
    private Level ivMinimumLocalizationLevel = Level.ALL;
    private boolean ivComputeSourceClassAndMethodNames = false;
    private boolean ibAsync = false;
    private String ivGroupName;
    private TraceComponent ivTC;
    private EventFactory ivEventFactory = null;

    WsLogger(String string, String string2) {
        super(string, string2);
        if (string2 != null && !string2.equals("")) {
            this.ivCachedResourceBundleName = string2;
            this.ivCachedResourceBundle = this.getResourceBundle(string2);
        }
        this.registerTraceComponent(string);
        this.ivComputeSourceClassAndMethodNames = "true".equalsIgnoreCase((String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("com.ibm.ws.logging.computeLoggingSource");
            }
        }));
    }

    public void setMinimumLocalizationLevel(Level level) {
        if (level == null) {
            return;
        }
        this.ivMinimumLocalizationLevel = level;
        this.ivMinimumLocalizationLevelIntValue = level.intValue();
    }

    public Level getMinimumLocalizationLevel() {
        return this.ivMinimumLocalizationLevel;
    }

    public void setComputeSourceClassAndMethodNames(boolean bl) {
        this.ivComputeSourceClassAndMethodNames = bl;
    }

    public boolean getComputeSourceClassAndMethodNames() {
        return this.ivComputeSourceClassAndMethodNames;
    }

    public void log(LogRecord logRecord) {
        if (logRecord == null) {
            return;
        }
        Filter filter = this.getFilter();
        if (this.isLoggable(logRecord.getLevel()) && (filter == null || filter.isLoggable(logRecord))) {
            logRecord.getSourceClassName();
            this.deliverOrBuffer(logRecord);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverOrBuffer(LogRecord logRecord) {
        if (this.ibAsync) {
            WsLogger.queueAsyncEvent(logRecord);
        } else {
            boolean bl = RecursionCounter.incrementCount(RECURSION_COUNTER_NAME, RECURSION_COUNTER_MAX);
            try {
                if (bl) {
                    super.log(logRecord);
                }
            }
            finally {
                RecursionCounter.decrementCount(RECURSION_COUNTER_NAME);
            }
            this.dispatchAsyncEvents();
        }
    }

    private LogRecord createLogRecord(Level level, String string, Object[] objectArray, String string2, String string3, String string4, Throwable throwable) {
        String string5;
        WsLogRecord wsLogRecord;
        ResourceBundle resourceBundle = null;
        if (level.intValue() >= this.ivMinimumLocalizationLevelIntValue) {
            if (string4 == null) {
                string4 = this.computeResourceBundleName();
            }
            if (string4 != null) {
                resourceBundle = string4.equals(this.ivCachedResourceBundleName) ? this.ivCachedResourceBundle : this.getResourceBundle(string4);
            }
        }
        if ((wsLogRecord = WsLogRecordFactory.createWsLogRecord(this.ivEventFactory, level, string, objectArray, string2, string3, string4, resourceBundle, throwable, this.ivOrganization, this.ivProduct, this.ivComponent, this.ivExtensions, this.ivMinimumLocalizationLevelIntValue, string5 = this.getName())) == null) {
            return null;
        }
        return wsLogRecord.getImpl();
    }

    public void log(Level level, String string) {
        if (this.isLoggable(level)) {
            LogRecord logRecord;
            if (this.ivComputeSourceClassAndMethodNames) {
                StackTraceElement stackTraceElement = this.getCallerFromStack();
                logRecord = this.createLogRecord(level, string, null, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), null, null);
            } else {
                logRecord = this.createLogRecord(level, string, null, null, null, null, null);
            }
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void log(Level level, String string, Object object) {
        if (this.isLoggable(level)) {
            LogRecord logRecord;
            Object[] objectArray = new Object[]{object};
            if (this.ivComputeSourceClassAndMethodNames) {
                StackTraceElement stackTraceElement = this.getCallerFromStack();
                logRecord = this.createLogRecord(level, string, objectArray, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), null, null);
            } else {
                logRecord = this.createLogRecord(level, string, objectArray, null, null, null, null);
            }
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void log(Level level, String string, Object[] objectArray) {
        if (this.isLoggable(level)) {
            LogRecord logRecord;
            if (this.ivComputeSourceClassAndMethodNames) {
                StackTraceElement stackTraceElement = this.getCallerFromStack();
                logRecord = this.createLogRecord(level, string, objectArray, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), null, null);
            } else {
                logRecord = this.createLogRecord(level, string, objectArray, null, null, null, null);
            }
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void log(Level level, String string, Throwable throwable) {
        if (this.isLoggable(level)) {
            LogRecord logRecord;
            if (this.ivComputeSourceClassAndMethodNames) {
                StackTraceElement stackTraceElement = this.getCallerFromStack();
                logRecord = this.createLogRecord(level, string, null, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), null, throwable);
            } else {
                logRecord = this.createLogRecord(level, string, null, null, null, null, throwable);
            }
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void logp(Level level, String string, String string2, String string3) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, string3, null, string, string2, null, null);
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void logp(Level level, String string, String string2, String string3, Object object) {
        if (this.isLoggable(level)) {
            Object[] objectArray = new Object[]{object};
            LogRecord logRecord = this.createLogRecord(level, string3, objectArray, string, string2, null, null);
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void logp(Level level, String string, String string2, String string3, Object[] objectArray) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, string3, objectArray, string, string2, null, null);
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void logp(Level level, String string, String string2, String string3, Throwable throwable) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, string3, null, string, string2, null, throwable);
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void logrb(Level level, String string, String string2, String string3, String string4) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, string4, null, string, string2, string3, null);
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Object object) {
        if (this.isLoggable(level)) {
            Object[] objectArray = new Object[]{object};
            LogRecord logRecord = this.createLogRecord(level, string4, objectArray, string, string2, string3, null);
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Object[] objectArray) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, string4, objectArray, string, string2, string3, null);
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Throwable throwable) {
        if (this.isLoggable(level)) {
            LogRecord logRecord = this.createLogRecord(level, string4, null, string, string2, string3, throwable);
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void entering(String string, String string2) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, string, string2, "ENTRY");
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void entering(String string, String string2, Object object) {
        if (this.isLoggable(Level.FINER)) {
            Object[] objectArray = new Object[]{object};
            this.logp(Level.FINER, string, string2, "ENTRY {0}", objectArray);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void entering(String string, String string2, Object[] objectArray) {
        if (this.isLoggable(Level.FINER)) {
            String string3 = "ENTRY";
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    string3 = string3 + " {" + i + "}";
                }
            }
            this.logp(Level.FINER, string, string2, string3, objectArray);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void exiting(String string, String string2) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, string, string2, "RETURN");
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void exiting(String string, String string2, Object object) {
        if (this.isLoggable(Level.FINER)) {
            Object[] objectArray = new Object[]{object};
            this.logp(Level.FINER, string, string2, "RETURN {0}", objectArray);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void throwing(String string, String string2, Throwable throwable) {
        if (this.isLoggable(Level.FINER)) {
            LogRecord logRecord = this.createLogRecord(Level.FINER, "THROW", null, string, string2, null, throwable);
            this.log(logRecord);
        } else if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void severe(String string) {
        if (this.isLoggable(Level.SEVERE)) {
            this.log(Level.SEVERE, string);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void warning(String string) {
        if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, string);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void info(String string) {
        if (this.isLoggable(Level.INFO)) {
            this.log(Level.INFO, string);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    private StackTraceElement getCallerFromStack() {
        try {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                if (!CLASSNAME.equals(stackTraceElementArray[i].getClassName())) continue;
                ++i;
                while (i < stackTraceElementArray.length) {
                    if (!CLASSNAME.equals(stackTraceElementArray[i].getClassName())) {
                        return stackTraceElementArray[i];
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void config(String string) {
        if (this.isLoggable(Level.CONFIG)) {
            this.log(Level.CONFIG, string);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void fine(String string) {
        if (this.isLoggable(Level.FINE)) {
            this.log(Level.FINE, string);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void finer(String string) {
        if (this.isLoggable(Level.FINER)) {
            this.log(Level.FINER, string);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    public void finest(String string) {
        if (this.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, string);
        }
        if (svAsyncQueue != null && !this.ibAsync) {
            this.dispatchAsyncEvents();
        }
    }

    private static synchronized void queueAsyncEvent(LogRecord logRecord) {
        if (svAsyncQueue == null) {
            svAsyncQueue = new Vector();
        }
        if (svAsyncQueue.size() < 50) {
            svAsyncQueue.addElement(logRecord);
        }
    }

    private synchronized void dispatchAsyncEvents() {
        if (svAsyncQueue == null) {
            return;
        }
        Vector vector = svAsyncQueue;
        svAsyncQueue = null;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            LogRecord logRecord = (LogRecord)vector.elementAt(i);
            super.log(logRecord);
        }
    }

    private ResourceBundle getResourceBundle(String string) {
        ResourceBundle resourceBundle = null;
        try {
            return TraceNLS.getResourceBundle(string, Locale.getDefault());
        }
        catch (RuntimeException runtimeException) {
            try {
                for (Logger logger = this; null == resourceBundle && null != logger; logger = logger.getParent()) {
                    resourceBundle = logger.getResourceBundle();
                }
            }
            catch (RuntimeException runtimeException2) {
                // empty catch block
            }
            return resourceBundle;
        }
    }

    private String computeResourceBundleName() {
        for (Logger logger = this; logger != null; logger = logger.getParent()) {
            String string = logger.getResourceBundleName();
            if (string == null) continue;
            return string;
        }
        return null;
    }

    String getGroupName() {
        return this.ivGroupName;
    }

    private void registerTraceComponent(String string) {
        if (string != null && string.length() > 0) {
            this.ivTC = Tr.register(string);
            this.ivTC.setLoggerForCallback(this);
            if (!WsLogManager.isConfigureByLoggingProperties()) {
                this.traceStateChanged();
            }
        }
    }

    public void traceStateChanged() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                WsLogger.this.setLevel(WsLevel.LEVELS[LevelConstants.DISTINCT_LEVELS[WsLogger.this.ivTC.getLevel()]]);
                return null;
            }
        });
    }

    public void addToGroup(String string) {
        Tr.register(this.getName(), string);
    }

    public EventFactory getEventFactory() {
        return this.ivEventFactory;
    }

    public void setEventFactory(EventFactory eventFactory) {
        this.ivEventFactory = eventFactory;
    }

    public String getExtension(String string) {
        Object v = this.ivExtensions.get(string);
        return v == null ? null : v.toString();
    }

    public Map getExtensions() {
        return this.ivExtensions;
    }

    private boolean isValidExtensionName(String string) {
        return !CBEHelper.getReservedExtenionNames().contains(string);
    }

    public void addExtension(String string, String string2) {
        if (svLogger != null && svLogger.isLoggable(WsLevel.FINER)) {
            svLogger.entering(CLASSNAME, "addExtension", new Object[]{string, string2});
        }
        if (!this.isValidExtensionName(string)) {
            String string3 = TraceNLS.getFormattedMessage(BUNDLENAME, "EXCEPTION_RESERVED_EXTENSION", new Object[]{string}, "The extension name ''{0}'' is reserved");
            throw new IllegalArgumentException(string3);
        }
        HashMap hashMap = this.ivExtensions;
        HashMap<String, String> hashMap2 = new HashMap<String, String>(hashMap);
        hashMap2.put(string, string2);
        this.ivExtensions = hashMap2;
        if (svLogger != null && svLogger.isLoggable(WsLevel.FINER)) {
            svLogger.exiting(CLASSNAME, "addExtension");
        }
    }

    public void addExtensions(Map map) {
        if (map == null) {
            return;
        }
        if (svLogger != null && svLogger.isLoggable(WsLevel.FINER)) {
            svLogger.entering(CLASSNAME, "addExtensions");
        }
        HashMap hashMap = this.ivExtensions;
        HashMap<String, String> hashMap2 = new HashMap<String, String>(hashMap);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = entry.getKey().toString();
            String string2 = entry.getValue().toString();
            if (!this.isValidExtensionName(string)) {
                String string3 = TraceNLS.getFormattedMessage(BUNDLENAME, "EXCEPTION_RESERVED_EXTENSION", new Object[]{string}, "The extension name ''{0}'' is reserved");
                throw new IllegalArgumentException(string3);
            }
            hashMap2.put(string, string2);
        }
        this.ivExtensions = hashMap2;
        if (svLogger != null && svLogger.isLoggable(WsLevel.FINER)) {
            svLogger.exiting(CLASSNAME, "addExtensions");
        }
    }

    public void removeExtension(String string) {
        if (svLogger != null && svLogger.isLoggable(WsLevel.FINER)) {
            svLogger.entering(CLASSNAME, "removeExtension");
        }
        HashMap hashMap = this.ivExtensions;
        HashMap hashMap2 = new HashMap(hashMap);
        hashMap2.remove(string);
        this.ivExtensions = hashMap2;
        if (svLogger != null && svLogger.isLoggable(WsLevel.FINER)) {
            svLogger.exiting(CLASSNAME, "removeExtension");
        }
    }

    public void clearExtensions() {
        if (svLogger != null && svLogger.isLoggable(WsLevel.FINER)) {
            svLogger.entering(CLASSNAME, "clearExtensions");
        }
        this.ivExtensions = new HashMap();
        if (svLogger != null && svLogger.isLoggable(WsLevel.FINER)) {
            svLogger.exiting(CLASSNAME, "clearExtensions");
        }
    }

    public String getComponent() {
        return this.ivComponent;
    }

    public String getOrganization() {
        return this.ivOrganization;
    }

    public String getProduct() {
        return this.ivProduct;
    }

    public void setComponent(String string) {
        this.ivComponent = string;
    }

    public void setOrganization(String string) {
        this.ivOrganization = string;
    }

    public void setProduct(String string) {
        this.ivProduct = string;
    }

    public boolean isAsync() {
        return this.ibAsync;
    }

    public void setAsync(boolean bl) {
        this.ibAsync = bl;
    }

    static {
        RECURSION_COUNTER_NAME = CLASSNAME = WsLogger.class.getName();
        RECURSION_COUNTER_MAX = 5;
        svAsyncQueue = null;
        try {
            svLogger = Logger.getLogger("com.ibm.ws.logging.WsLogger", BUNDLENAME);
        }
        catch (MissingResourceException missingResourceException) {
            svLogger = Logger.getLogger("com.ibm.ws.logging.WsLogger");
            svLogger.throwing(CLASSNAME, "static init", missingResourceException);
            svLogger.warning("Unable to locate com.ibm.ejs.resources.RasMessages resource bundle.  WsLogger messages will not be localized");
        }
        LoggerHelper.setAttributes(svLogger, "IBM", "WebSphere", "RAS", WsLevel.DETAIL);
    }
}

