/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.logging.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;

public class LoggerThread {
    protected static final TraceComponent tc = Tr.register(LoggerThread.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final int STATE_IDLE = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_DESTROYED = 2;
    protected static final int WORKER_RUNNING = 0;
    protected static final int WORKER_STOPPING = 1;
    protected static final int WORKER_STOPPED = 2;
    protected static final long TIMEOUT = 10000L;
    private File myFile = null;
    private String myName = null;
    private String myFullName = null;
    private FileChannel myChannel = null;
    private WorkerThread myWorker = null;
    private int state = 0;
    private int maxFileSize = -1;
    private int maxBackupFiles = 1;

    public LoggerThread(String string) throws FileNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "New logger thread created for file [" + string + "]");
        }
        this.myFullName = string;
        this.myFile = new File(string);
        this.myName = this.myFile.getName();
        this.myChannel = new FileOutputStream(this.myFile, true).getChannel();
        this.myWorker = new WorkerThread();
    }

    protected FileChannel getChannel() {
        return this.myChannel;
    }

    protected void setChannel(FileChannel fileChannel) {
        this.myChannel = fileChannel;
    }

    protected File getFile() {
        return this.myFile;
    }

    public String getFilePathName() {
        return this.myFullName;
    }

    public String getFileName() {
        return this.myName;
    }

    public boolean isIdle() {
        return 0 == this.state;
    }

    public boolean isRunning() {
        return 1 == this.state;
    }

    public boolean isDestroyed() {
        return 2 == this.state;
    }

    public boolean log(WsByteBuffer wsByteBuffer) {
        if (null == wsByteBuffer) {
            return false;
        }
        if (!this.isRunning()) {
            wsByteBuffer.release();
            return false;
        }
        return this.myWorker.enqueue(wsByteBuffer);
    }

    public boolean start() {
        if (!this.isIdle()) {
            return false;
        }
        if (null == this.myWorker) {
            this.myWorker = new WorkerThread();
        }
        this.myWorker.start();
        this.state = 1;
        return true;
    }

    public boolean stop() {
        if (!this.isRunning()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this.myName + ": Logger already stopped");
            }
            return true;
        }
        this.state = 0;
        this.myWorker.triggerStop();
        this.myWorker = null;
        return true;
    }

    public boolean destroy() {
        block3: {
            if (this.isRunning()) {
                this.stop();
            }
            try {
                this.myChannel.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, this.getClass().getName() + ".destroy", "124", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Failed to close the output file: " + this.myChannel);
            }
        }
        this.state = 2;
        return true;
    }

    public boolean setMaximumFileSize(int n) {
        if (-1 > n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this.myName + ": Invalid file size-> " + n);
            }
            return false;
        }
        if (0 == n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this.myName + ": Input max-file-size is 0, using UNLIMITED");
            }
            this.maxFileSize = -1;
        } else {
            this.maxFileSize = n;
        }
        return true;
    }

    public int getMaximumFileSize() {
        return this.maxFileSize;
    }

    public int getMaximumBackupFiles() {
        return this.maxBackupFiles;
    }

    public boolean setMaxiumBackupFiles(int n) {
        if (0 > n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this.myName + ": Invalid negative number of backup files-> " + n);
            }
            return false;
        }
        this.maxBackupFiles = n;
        return true;
    }

    protected int getCurrentFileSize() {
        long l = this.myFile.length();
        if (Integer.MAX_VALUE < l) {
            return this.getMaximumFileSize();
        }
        return (int)l;
    }

    protected boolean isOverFileLimit(int n) {
        if (-1 == this.getMaximumFileSize()) {
            return false;
        }
        int n2 = this.getCurrentFileSize() + n;
        return n2 > this.getMaximumFileSize() || 0 > n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(super.toString());
        stringBuffer.append("\n  FilePathName: " + this.getFilePathName());
        stringBuffer.append("\n  FileName: " + this.getFileName());
        stringBuffer.append("\n  MaxFileSize: " + this.getMaximumFileSize());
        stringBuffer.append("\n  CurrentFileSize: " + this.getCurrentFileSize());
        stringBuffer.append("\n  MaxBackupFiles: " + this.getMaximumBackupFiles());
        stringBuffer.append("\n  Running: " + this.isRunning());
        return stringBuffer.toString();
    }

    private class WorkerThread
    extends Thread {
        private int workerState = 0;
        private Object stopLock = new Object();
        private Object lock = new Object();
        private LinkedList queue = new LinkedList();
        private File[] backups = null;
        private int backupIndex = 0;
        private String fileinfo = null;
        private String extensioninfo = "";
        private SimpleDateFormat myFormat = null;

        protected WorkerThread() {
        }

        public void start() {
            if (0 < LoggerThread.this.getMaximumBackupFiles()) {
                this.myFormat = new SimpleDateFormat("_yy.MM.dd_HH.mm.ss", Locale.US);
                this.fileinfo = LoggerThread.this.getFilePathName();
                int n = LoggerThread.this.getFileName().lastIndexOf(".");
                if (-1 != n) {
                    this.fileinfo = LoggerThread.this.getFilePathName().substring(0, n += LoggerThread.this.getFilePathName().length() - LoggerThread.this.getFileName().length());
                    this.extensioninfo = LoggerThread.this.getFilePathName().substring(n);
                }
                this.backups = new File[LoggerThread.this.getMaximumBackupFiles()];
                this.backupIndex = 0;
            }
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean enqueue(WsByteBuffer wsByteBuffer) {
            if (0 != this.workerState) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, LoggerThread.this.getFileName() + ": Ignoring buffer during stop sequence");
                }
                wsByteBuffer.release();
                return false;
            }
            Object object = this.lock;
            synchronized (object) {
                this.queue.add(wsByteBuffer);
                this.lock.notify();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void triggerStop() {
            Object object;
            block19: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, LoggerThread.this.getFileName() + ": triggerStop");
                }
                if (0 != this.workerState) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, LoggerThread.this.getFileName() + ": triggerStop");
                    }
                    return;
                }
                this.workerState = 1;
                object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                }
                try {
                    if (1 != this.workerState) break block19;
                    object = this.stopLock;
                    synchronized (object) {
                        if (1 == this.workerState) {
                            this.stopLock.wait(10000L);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, this.getClass().getName() + ".triggerStop", "201", this);
                }
            }
            object = this.lock;
            synchronized (object) {
                while (!this.queue.isEmpty()) {
                    ((WsByteBuffer)this.queue.removeFirst()).release();
                }
            }
            if (null != this.backups) {
                this.myFormat = null;
                for (int i = 0; i < this.backups.length; ++i) {
                    this.backups[i] = null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, LoggerThread.this.getFileName() + ": triggerStop");
            }
        }

        private void renameFile(File file, File file2) {
            boolean bl;
            if (!file.exists()) {
                return;
            }
            if (file2.exists()) {
                file2.delete();
            }
            if (!(bl = file.renameTo(file2)) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, LoggerThread.this.getFileName() + ": Unable to rename " + file + " to " + file2);
            }
        }

        private String getNewName() {
            return this.fileinfo + this.myFormat.format(new Date(QuickApproxTime.getRef().getApproxTime())) + this.extensioninfo;
        }

        private void addBackup() {
            File file = new File(this.getNewName());
            this.renameFile(LoggerThread.this.getFile(), file);
            int n = this.backups.length - 1;
            if (this.backupIndex == this.backups.length) {
                File file2 = this.backups[n];
                if (null != file2 && file2.exists()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, LoggerThread.this.getFileName() + ": Purging oldest backup-> " + file2.getName());
                    }
                    file2.delete();
                }
            } else {
                n = this.backupIndex++;
            }
            int n2 = n;
            while (n2 > 0) {
                this.backups[n2--] = this.backups[n2];
            }
            this.backups[0] = file;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, LoggerThread.this.getFileName() + ": number of backup files-> " + this.backupIndex);
            }
        }

        private void rotateLog() {
            block6: {
                block5: {
                    try {
                        LoggerThread.this.getChannel().close();
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, this.getClass().getName() + ".rotateLog", "470", this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                        Tr.debug(tc, LoggerThread.this.getFileName() + ": Failed to close the output file");
                    }
                }
                if (0 < LoggerThread.this.getMaximumBackupFiles()) {
                    this.addBackup();
                }
                try {
                    LoggerThread.this.setChannel(new FileOutputStream(LoggerThread.this.getFile(), true).getChannel());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, LoggerThread.this.getFileName() + ": FileNotFoundException in rotateLogs");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logData(WsByteBuffer wsByteBuffer) {
            int n;
            int n2;
            block11: {
                n2 = 0;
                n = wsByteBuffer.remaining();
                if (LoggerThread.this.isOverFileLimit(n)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, LoggerThread.this.getFileName() + ": Rotating output log");
                    }
                    try {
                        this.rotateLog();
                    }
                    catch (SecurityException securityException) {
                        FFDCFilter.processException((Throwable)securityException, this.getClass().getName() + ".logData", "539", this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                        Tr.debug(tc, LoggerThread.this.getFileName() + ": SecurityException during log rotation; " + securityException);
                    }
                }
            }
            try {
                while (n2 < n) {
                    n2 += LoggerThread.this.getChannel().write(wsByteBuffer.getWrappedByteBuffer());
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, this.getClass().getName() + ".logData", "235", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, LoggerThread.this.getFileName() + ": IOException while writing to output log");
                }
            }
            finally {
                wsByteBuffer.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            LinkedList linkedList = new LinkedList();
            while (true) {
                if (!this.queue.isEmpty()) {
                    object = this.lock;
                    synchronized (object) {
                        LinkedList linkedList2 = linkedList;
                        linkedList = this.queue;
                        this.queue = linkedList2;
                    }
                    while (!linkedList.isEmpty()) {
                        try {
                            this.logData((WsByteBuffer)linkedList.removeFirst());
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, this.getClass().getName() + ".run", "588");
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, LoggerThread.this.getFileName() + ": Unexpected exception in logData; " + throwable);
                        }
                    }
                }
                if (0 != this.workerState) break;
                if (!this.queue.isEmpty()) continue;
                try {
                    object = this.lock;
                    synchronized (object) {
                        if (!this.queue.isEmpty()) {
                            continue;
                        }
                        this.lock.wait(10000L);
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, this.getClass().getName() + ".run", "278", this);
                    continue;
                }
                break;
            }
            this.workerState = 2;
            object = this.stopLock;
            synchronized (object) {
                this.stopLock.notify();
            }
        }
    }
}

