/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.values.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.impl.HttpDateFormat;
import com.ibm.ws.http.channel.values.impl.CookieData;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.channel.HttpConstants;
import java.text.ParseException;
import java.util.Date;
import javax.servlet.http.Cookie;

public class CookieExpiresData
extends CookieData {
    private static final TraceComponent tc = Tr.register(CookieExpiresData.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");

    public CookieExpiresData() {
        super("expires");
    }

    public boolean set(Cookie cookie, byte[] byArray) {
        if (null == cookie || null == byArray || 0 == byArray.length) {
            return false;
        }
        try {
            Date date = HttpDateFormat.getRef().parseTime(byArray);
            long l = date.getTime() - QuickApproxTime.getRef().getApproxTime();
            if (-1L < l) {
                cookie.setMaxAge((int)(l / 1000L));
            } else {
                cookie.setMaxAge(0);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Expires/max-age set to " + cookie.getMaxAge());
            }
            return true;
        }
        catch (ParseException parseException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Error parsing expires date: " + GenericUtils.getEnglishString(byArray));
            }
            return false;
        }
    }

    public boolean validForHeader(HeaderKeys headerKeys, boolean bl) {
        if (HttpConstants.HDR_SET_COOKIE.equals(headerKeys) || HttpConstants.HDR_SET_COOKIE2.equals(headerKeys)) {
            return !bl;
        }
        return false;
    }
}

