/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.matcher.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.QuickCaseInsensitiveMatcher;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.values.SchemeValues;
import java.util.Iterator;

public class SchemeMatcher
extends QuickCaseInsensitiveMatcher {
    private static final TraceComponent tc = Tr.register(SchemeMatcher.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static SchemeMatcher myInstance = null;

    private SchemeMatcher() {
        super(true);
        this.init();
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new SchemeMatcher();
        }
    }

    public static final SchemeMatcher getRef() {
        if (null == myInstance) {
            SchemeMatcher.createSingleton();
        }
        return myInstance;
    }

    public SchemeValues matchScheme(String string) {
        return (SchemeValues)super.match(string);
    }

    public SchemeValues matchScheme(StringBuffer stringBuffer) {
        return (SchemeValues)super.match(stringBuffer);
    }

    public SchemeValues matchScheme(byte[] byArray) {
        return (SchemeValues)super.match(byArray);
    }

    public void init() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Initializing the Scheme matcher");
        }
        SchemeValues schemeValues = HttpConstants.SCHEME_HTTP;
        Iterator iterator = SchemeValues.getAllKeys().iterator();
        while (iterator.hasNext()) {
            schemeValues = (SchemeValues)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Matcher storing " + schemeValues);
            }
            super.add(schemeValues);
        }
        super.init();
    }

    public static void main(String[] stringArray) {
        System.out.println("Started");
        SchemeMatcher schemeMatcher = SchemeMatcher.getRef();
        System.out.println("matching...");
        System.out.println();
        System.out.println("Following should find matches...");
        System.out.println("Matching (String) http " + schemeMatcher.matchScheme("http"));
        String string = "httpS";
        System.out.println("Matching (String) " + string + " " + schemeMatcher.matchScheme(string));
        string = "FTP";
        System.out.println("Matching (byte[]) " + string + " " + schemeMatcher.matchScheme(string.getBytes()));
        string = "HttP";
        System.out.println("Matching (StringBuffer) " + string + " " + schemeMatcher.matchScheme(new StringBuffer(string)));
        System.out.println();
        System.out.println("Following should return null responses...");
        string = "ssl";
        System.out.println("Matching (StringBuffer) " + string + " " + schemeMatcher.matchScheme(new StringBuffer(string)));
        string = "httpq";
        System.out.println("Matching (byte[]) " + string + " " + schemeMatcher.matchScheme(string.getBytes()));
        string = "HTTS";
        System.out.println("Matching (String) " + string + " " + schemeMatcher.matchScheme(string));
        string = "$WSZIP";
        System.out.println("Matching (String) " + string + " " + schemeMatcher.matchScheme(string));
    }
}

