/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

public class Normalizer {
    public static final int NORMALIZE_OFF = 0;
    public static final int NORMALIZE_UPPER = 1;
    public static final int NORMALIZE_LOWER = 2;
    private int normalizeFlag = 0;

    public Normalizer(int n) {
        if (0 != n && 1 != n && 2 != n) {
            throw new IllegalArgumentException("Unable to create Normalizer using identifier " + n);
        }
        this.normalizeFlag = n;
    }

    public final int getNormalization() {
        return this.normalizeFlag;
    }

    public String normalize(String string) {
        if (0 == this.getNormalization() || null == string) {
            return string;
        }
        String string2 = string;
        int n = string.length();
        if (0 != n) {
            char[] cArray = new char[n];
            string.getChars(0, n, cArray, 0);
            for (int i = 0; i < n; ++i) {
                cArray[i] = this.normalize(cArray[i]);
            }
            string2 = new String(cArray, 0, n);
        }
        return string2;
    }

    public String normalize(byte[] byArray) {
        if (null == byArray) {
            return null;
        }
        if (0 == byArray.length) {
            return "";
        }
        if (0 == this.getNormalization()) {
            return new String(byArray);
        }
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = this.normalize((char)byArray[i]);
        }
        return new String(cArray, 0, cArray.length);
    }

    public char normalize(char c) {
        if (1 == this.getNormalization()) {
            return Normalizer.toUpper(c);
        }
        if (2 == this.getNormalization()) {
            return Normalizer.toLower(c);
        }
        return c;
    }

    private static char toUpper(char c) {
        if (c >= 'a' && c <= 'z') {
            c = (char)(c - 97 + 65);
        }
        return c;
    }

    private static char toLower(char c) {
        if (c >= 'A' && c <= 'Z') {
            c = (char)(c - 65 + 97);
        }
        return c;
    }

    public static String normalize(byte[] byArray, int n) {
        if (null == byArray) {
            return null;
        }
        if (0 == byArray.length) {
            return "";
        }
        if (0 == n) {
            return new String(byArray);
        }
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = Normalizer.normalize((char)byArray[i], n);
        }
        return new String(cArray, 0, cArray.length);
    }

    public static char normalize(char c, int n) {
        if (2 == n) {
            return Normalizer.toLower(c);
        }
        if (1 == n) {
            return Normalizer.toUpper(c);
        }
        return c;
    }

    public static String normalize(String string, int n) {
        if (0 == n || null == string) {
            return string;
        }
        String string2 = string;
        int n2 = string.length();
        if (0 != n2) {
            char[] cArray = new char[n2];
            string.getChars(0, n2, cArray, 0);
            for (int i = 0; i < n2; ++i) {
                cArray[i] = Normalizer.normalize(cArray[i], n);
            }
            string2 = new String(cArray, 0, n2);
        }
        return string2;
    }
}

