/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.FastNonSynchHashTable;
import com.ibm.ws.genericbnf.impl.GenericConstants;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.genericbnf.impl.HeaderElement;
import com.ibm.ws.genericbnf.impl.Normalizer;
import com.ibm.ws.genericbnf.impl.QuickHeaderMatcher;
import com.ibm.ws.genericbnf.impl.TokenCodes;
import com.ibm.ws.http.channel.impl.HttpDateFormat;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.genericbnf.BNFHeaders;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.Vector;

public abstract class BNFHeadersImpl
implements BNFHeaders,
Externalizable {
    private static final TraceComponent tc = Tr.register(BNFHeadersImpl.class, "GenericBNF", "com.ibm.ws.genericbnf.resources.genericbnfMessages");
    private static final long serialVersionUID = -4154557451251031540L;
    protected static final int SERIALIZATION_V1 = -1091633151;
    protected static final int SERIALIZATION_V2 = -1091633150;
    private static final int PARSING_HEADER = 0;
    private static final int PARSING_VALUE = 1;
    private static final int PARSING_CRLF = 2;
    private static final int DEFAULT_BUFFERSIZE = 1024;
    private static final int DEFAULT_CACHESIZE = 512;
    private static final int DEFAULT_LIMIT_TOKENSIZE = 16384;
    private static final int DEFAULT_LIMIT_NUMHEADERS = 500;
    private static final int BUFFERS_INITIAL_SIZE = 10;
    private static final int BUFFERS_MIN_GROWTH = 5;
    private static final boolean FILTER_YES = true;
    private static final boolean FILTER_NO = false;
    protected static final int LOG_FULL = 0;
    protected static final int LOG_NONE = 1;
    protected static final int LOG_PARTIAL = 2;
    private static byte[] whitespace = null;
    private transient HeaderElement[] headerValues;
    private transient FastNonSynchHashTable otherHeaders = null;
    private transient HeaderElement hdrSequence = null;
    private transient HeaderElement lastHdrInSequence = null;
    private transient QuickHeaderMatcher myHM = null;
    private transient HeaderElement headerElements = null;
    private transient WsByteBuffer[] parseBuffers = new WsByteBuffer[10];
    private transient int[] parseBuffersStartPos = new int[10];
    private transient int parseIndex = -1;
    private transient WsByteBuffer[] myCreatedBuffers = new WsByteBuffer[10];
    private transient int createdIndex = -1;
    private transient int numberOfHeaders = 0;
    private transient boolean bHeaderValidation = true;
    private transient int lastCRLFBufferIndex = -1;
    private transient int lastCRLFPosition = -1;
    private transient boolean lastCRLFisCR = false;
    private transient int headerChangeLimit = -1;
    private transient int headerChangeCount = 0;
    private transient int headerAddCount = 0;
    private transient boolean bOverChangeLimit = false;
    private transient int limitTokenSize = 16384;
    private transient int limitNumHeaders = 500;
    private transient int eohPosition = -1;
    private transient WsByteBuffer currentReadBB = null;
    private transient boolean useDirectBuffer = true;
    private transient int outgoingHdrBufferSize = 1024;
    private transient int incomingBufferSize = 1024;
    private transient int byteCacheSize = 512;
    private transient byte[] parsedToken = null;
    private transient int parsedTokenLength = 0;
    private transient byte[] byteCache = new byte[this.byteCacheSize];
    private transient byte[] originalByteCache = this.byteCache;
    private transient int bytePosition = 0;
    private transient int byteLimit = 0;
    private transient boolean isByteBufferArray = false;
    private transient int stateOfParsing = 2;
    private transient int binaryParsingState = 1;
    private transient HeaderElement currentElem = null;
    private transient HeaderElement lastElem = null;
    private transient boolean bIsMultiLine = false;
    private transient int numCRLFs = 0;
    private transient Object debugContext = this;
    private transient int deserializationVersion = -1091633151;

    public BNFHeadersImpl(QuickHeaderMatcher quickHeaderMatcher, int n) {
        this.headerValues = new HeaderElement[n];
        this.setHeaderMatcher(quickHeaderMatcher);
        for (int i = 0; i < this.parseBuffersStartPos.length; ++i) {
            this.parseBuffersStartPos[i] = -1;
        }
    }

    protected void init(boolean bl, int n, int n2, int n3) {
        this.useDirectBuffer = bl;
        this.outgoingHdrBufferSize = n;
        this.incomingBufferSize = n2;
        if (n3 > this.byteCacheSize) {
            this.byteCacheSize = n3;
            this.byteCache = new byte[n3];
            this.originalByteCache = this.byteCache;
        }
    }

    public void addParseBuffer(WsByteBuffer wsByteBuffer) {
        int n;
        if ((n = ++this.parseIndex) == this.parseBuffers.length) {
            int n2 = n + 5;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Increasing parse buffer array size to " + n2);
            }
            WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[n2];
            System.arraycopy(this.parseBuffers, 0, wsByteBufferArray, 0, n);
            this.parseBuffers = wsByteBufferArray;
            int[] nArray = new int[n2];
            System.arraycopy(this.parseBuffersStartPos, 0, nArray, 0, n);
            this.parseBuffersStartPos = nArray;
            for (int i = n; i < n2; ++i) {
                this.parseBuffersStartPos[i] = -1;
            }
        }
        this.parseBuffers[n] = wsByteBuffer;
    }

    public void addToCreatedBuffer(WsByteBuffer wsByteBuffer) {
        int n;
        if ((n = ++this.createdIndex) == this.myCreatedBuffers.length) {
            int n2 = n + 5;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Increasing created buffer array size to " + n2);
            }
            WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[n2];
            System.arraycopy(this.myCreatedBuffers, 0, wsByteBufferArray, 0, n);
            this.myCreatedBuffers = wsByteBufferArray;
        }
        this.myCreatedBuffers[n] = wsByteBuffer;
    }

    public void appendHeader(String string, byte[] byArray) {
        HeaderKeys headerKeys;
        if (null == string || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appendHeader(s,b): " + string);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderName(string);
            this.checkHeaderValue(byArray, 0, byArray.length);
        }
        if ((headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            HeaderElement headerElement = this.getElement(string);
            headerElement.setByteArrayValue(byArray);
            this.addUnknownHeader(string, headerElement, true);
        } else {
            HeaderElement headerElement = this.getElement(headerKeys);
            headerElement.setByteArrayValue(byArray);
            this.addKnownHeader(headerKeys, headerElement, true, true);
        }
    }

    public void appendHeader(String string, byte[] byArray, int n, int n2) {
        HeaderKeys headerKeys;
        if (null == string || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appendHeader(s,b,i,i): " + string);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderName(string);
            this.checkHeaderValue(byArray, n, n2);
        }
        if ((headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            HeaderElement headerElement = this.getElement(string);
            headerElement.setByteArrayValue(byArray, n, n2);
            this.addUnknownHeader(string, headerElement, true);
        } else {
            HeaderElement headerElement = this.getElement(headerKeys);
            headerElement.setByteArrayValue(byArray, n, n2);
            this.addKnownHeader(headerKeys, headerElement, true, true);
        }
    }

    public void appendHeader(byte[] byArray, byte[] byArray2) {
        HeaderKeys headerKeys;
        if (null == byArray || null == byArray2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appendHeader(b,b): " + GenericUtils.getEnglishString(byArray));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderName(byArray);
            this.checkHeaderValue(byArray2, 0, byArray2.length);
        }
        if ((headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            String string = GenericUtils.getEnglishString(byArray);
            HeaderElement headerElement = this.getElement(string);
            headerElement.setByteArrayValue(byArray2);
            this.addUnknownHeader(string, headerElement, true);
        } else {
            HeaderElement headerElement = this.getElement(headerKeys);
            headerElement.setByteArrayValue(byArray2);
            this.addKnownHeader(headerKeys, headerElement, true, true);
        }
    }

    public void appendHeader(byte[] byArray, byte[] byArray2, int n, int n2) {
        HeaderKeys headerKeys;
        if (null == byArray || null == byArray2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appendHeader(b,b,i,i): " + GenericUtils.getEnglishString(byArray));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderName(byArray);
            this.checkHeaderValue(byArray2, n, n2);
        }
        if ((headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            String string = GenericUtils.getEnglishString(byArray);
            HeaderElement headerElement = this.getElement(string);
            headerElement.setByteArrayValue(byArray2, n, n2);
            this.addUnknownHeader(string, headerElement, true);
        } else {
            HeaderElement headerElement = this.getElement(headerKeys);
            headerElement.setByteArrayValue(byArray2, n, n2);
            this.addKnownHeader(headerKeys, headerElement, true, true);
        }
    }

    public void appendHeader(HeaderKeys headerKeys, byte[] byArray) {
        if (null == headerKeys || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appendHeader(h,b): " + headerKeys.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray, 0, byArray.length);
        }
        HeaderElement headerElement = this.getElement(headerKeys);
        headerElement.setByteArrayValue(byArray);
        this.addKnownHeader(headerKeys, headerElement, true, true);
    }

    public void appendHeader(HeaderKeys headerKeys, byte[] byArray, int n, int n2) {
        if (null == headerKeys || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appendHeader(h,b,i,i): " + headerKeys.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray, n, n2);
        }
        HeaderElement headerElement = this.getElement(headerKeys);
        headerElement.setByteArrayValue(byArray, n, n2);
        this.addKnownHeader(headerKeys, headerElement, true, true);
    }

    public void appendHeader(String string, String string2) {
        HeaderKeys headerKeys;
        if (null == string || null == string2) {
            throw new IllegalArgumentException("Null input provided: " + string + " " + string2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appendHeader(s,s): " + string);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderName(string);
            this.checkHeaderValue(string2);
        }
        if ((headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            HeaderElement headerElement = this.getElement(string);
            headerElement.setStringValue(string2);
            this.addUnknownHeader(string, headerElement, true);
        } else {
            HeaderElement headerElement = this.getElement(headerKeys);
            headerElement.setStringValue(string2);
            this.addKnownHeader(headerKeys, headerElement, true, true);
        }
    }

    public void appendHeader(byte[] byArray, String string) {
        HeaderKeys headerKeys;
        if (null == byArray || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appendHeader(b,s): " + GenericUtils.getEnglishString(byArray));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(string);
        }
        if ((headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            String string2 = GenericUtils.getEnglishString(byArray);
            HeaderElement headerElement = this.getElement(string2);
            headerElement.setStringValue(string);
            this.addUnknownHeader(string2, headerElement, true);
        } else {
            HeaderElement headerElement = this.getElement(headerKeys);
            headerElement.setStringValue(string);
            this.addKnownHeader(headerKeys, headerElement, true, true);
        }
    }

    public void appendHeader(HeaderKeys headerKeys, String string) {
        if (null == headerKeys || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appendHeader(h,s): " + headerKeys.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(string);
        }
        HeaderElement headerElement = this.getElement(headerKeys);
        headerElement.setStringValue(string);
        this.addKnownHeader(headerKeys, headerElement, true, true);
    }

    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "clear");
        }
        this.clearAllHeaders();
        this.eohPosition = -1;
        this.lastElem = null;
        this.currentElem = null;
        this.stateOfParsing = 2;
        this.binaryParsingState = 1;
        this.parsedToken = null;
        this.parsedTokenLength = 0;
        this.bytePosition = 0;
        this.byteLimit = 0;
        this.currentReadBB = null;
        this.clearBuffers();
        this.debugContext = this;
        this.numCRLFs = 0;
        this.bIsMultiLine = false;
        this.lastCRLFBufferIndex = -1;
        this.lastCRLFPosition = -1;
        this.lastCRLFisCR = false;
        this.headerChangeCount = 0;
        this.headerAddCount = 0;
        this.bOverChangeLimit = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "clear");
        }
    }

    private void clearBuffers() {
        int n;
        for (n = 0; n <= this.parseIndex; ++n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing reference to parse buffer: " + this.parseBuffers[n]);
            }
            this.parseBuffers[n] = null;
            this.parseBuffersStartPos[n] = -1;
        }
        this.parseIndex = -1;
        for (n = 0; n <= this.createdIndex; ++n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Releasing marshall buffer: " + this.myCreatedBuffers[n]);
            }
            this.myCreatedBuffers[n].release();
            this.myCreatedBuffers[n] = null;
        }
        this.createdIndex = -1;
    }

    public int compareValue(HeaderKeys headerKeys, byte[] byArray) {
        if (null == headerKeys || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "compareValue: k[" + headerKeys.getName() + "] b[" + GenericUtils.getEnglishString(byArray) + "]");
        }
        return this.compareByteArrays(this.findHeader(headerKeys, 0), byArray);
    }

    public int compareValue(String string, byte[] byArray) {
        if (null == string || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "compareValue: s[" + string + "] b[" + GenericUtils.getEnglishString(byArray) + "]");
        }
        return this.compareByteArrays(this.findHeader(string, 0), byArray);
    }

    public int compareValue(byte[] byArray, byte[] byArray2) {
        if (null == byArray || null == byArray2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "compareValue: b[" + GenericUtils.getEnglishString(byArray) + "] b[" + GenericUtils.getEnglishString(byArray2) + "]");
        }
        return this.compareByteArrays(this.findHeader(byArray, 0), byArray2);
    }

    public int compareValue(HeaderKeys headerKeys, String string) {
        if (null == headerKeys || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "compareValue: k[" + headerKeys.getName() + "] s[" + string + "]");
        }
        return this.compareStrings(this.findHeader(headerKeys, 0), string);
    }

    public int compareValue(String string, String string2) {
        if (null == string || null == string2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "compareValue: s[" + string + "] s[" + string2 + "]");
        }
        return this.compareStrings(this.findHeader(string, 0), string2);
    }

    public int compareValue(byte[] byArray, String string) {
        if (null == byArray || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "compareValue: b[" + GenericUtils.getEnglishString(byArray) + "] s[" + string + "]");
        }
        return this.compareStrings(this.findHeader(byArray, 0), string);
    }

    public void debug() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "*** Begin Header Debug ***");
            HeaderElement headerElement = this.hdrSequence;
            while (null != headerElement) {
                this.debugPrintHeader(headerElement);
                headerElement = headerElement.nextSequence;
            }
            Tr.debug(tc, "*** End Header Debug ***");
        }
    }

    private void debugPrintHeader(HeaderElement headerElement) {
        Tr.debug(tc, "debug: " + headerElement.getName() + ": " + headerElement.getDebugValue());
    }

    protected void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Destroying these headers: " + this);
        }
        if (null != this.hdrSequence) {
            this.clear();
        }
        this.byteCacheSize = 512;
        this.incomingBufferSize = 1024;
        this.outgoingHdrBufferSize = 1024;
        this.useDirectBuffer = true;
        this.limitNumHeaders = 500;
        this.limitTokenSize = 16384;
        this.headerChangeLimit = -1;
    }

    public void duplicate(BNFHeaders bNFHeaders) {
        this.duplicate((BNFHeadersImpl)bNFHeaders);
    }

    protected void duplicate(BNFHeadersImpl bNFHeadersImpl) {
        if (null == bNFHeadersImpl) {
            throw new NullPointerException("Null object passed to duplicate");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Duplicating the headers");
        }
        HeaderElement headerElement = this.hdrSequence;
        while (null != headerElement) {
            if (!headerElement.wasRemoved()) {
                if (null != headerElement.getHeaderKey()) {
                    bNFHeadersImpl.appendHeader(headerElement.getHeaderKey(), headerElement.getByteArrayValue());
                } else {
                    bNFHeadersImpl.appendHeader(headerElement.getHeaderString(), headerElement.getByteArrayValue());
                }
            }
            headerElement = headerElement.nextSequence;
        }
        bNFHeadersImpl.init(this.useDirectBuffer, this.outgoingHdrBufferSize, this.incomingBufferSize, this.byteCacheSize);
        bNFHeadersImpl.setDebugContext(this.debugContext);
        bNFHeadersImpl.setHeaderMatcher(this.getMatcher());
        bNFHeadersImpl.setHeaderValidation(this.bHeaderValidation);
        bNFHeadersImpl.setLimitOfTokenSize(this.limitTokenSize);
        bNFHeadersImpl.setLimitOnNumberOfHeaders(this.limitNumHeaders);
    }

    protected int getDeserializationVersion() {
        return this.deserializationVersion;
    }

    protected byte[] readByteArray(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        if (-1 == n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "read byte[] found -1 length marker");
            }
            return null;
        }
        byte[] byArray = new byte[n];
        objectInput.readFully(byArray);
        return byArray;
    }

    protected void writeByteArray(ObjectOutput objectOutput, byte[] byArray) throws IOException {
        if (null == byArray || 0 == byArray.length) {
            objectOutput.writeInt(-1);
        } else {
            objectOutput.writeInt(byArray.length);
            objectOutput.write(byArray);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (null == this.getMatcher()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Missing matcher class, subclass must set first");
            }
            throw new IOException("Unable to deserialize without matcher.");
        }
        int n = objectInput.readInt();
        if (-1091633150 == n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Deserializing a V2 object");
            }
            this.deserializationVersion = -1091633150;
            n = objectInput.readInt();
        }
        this.headerValues = new HeaderElement[n];
        int n2 = objectInput.readInt();
        if (-1091633150 == this.deserializationVersion) {
            for (int i = 0; i < n2; ++i) {
                this.appendHeader(this.readByteArray(objectInput), this.readByteArray(objectInput));
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                this.appendHeader((String)objectInput.readObject(), (String)objectInput.readObject());
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        ObjectOutputStream objectOutputStream = null;
        if (objectOutput instanceof ObjectOutputStream) {
            objectOutputStream = (ObjectOutputStream)objectOutput;
        }
        objectOutput.writeInt(this.headerValues.length);
        objectOutput.writeInt(this.numberOfHeaders);
        int n = 0;
        HeaderElement headerElement = this.hdrSequence;
        while (null != headerElement) {
            if (!headerElement.wasRemoved()) {
                ++n;
                if (null != objectOutputStream) {
                    objectOutputStream.writeUnshared(headerElement.getName());
                    objectOutputStream.writeUnshared(headerElement.getStringValue());
                } else {
                    objectOutput.writeObject(headerElement.getName());
                    objectOutput.writeObject(headerElement.getStringValue());
                }
            }
            headerElement = headerElement.nextSequence;
        }
        if (n != this.numberOfHeaders) {
            throw new IOException("Expected " + this.numberOfHeaders + " headers but wrote " + n);
        }
    }

    public boolean isEOHFound() {
        return -1 != this.eohPosition;
    }

    public Vector getAllHeaders() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllHeaders");
        }
        Vector<String> vector = new Vector<String>();
        if (0 == this.numberOfHeaders) {
            return vector;
        }
        HeaderElement headerElement = this.hdrSequence;
        while (null != headerElement) {
            if (!headerElement.wasRemoved() && !vector.contains(headerElement.getName())) {
                vector.add(headerElement.getName());
            }
            headerElement = headerElement.nextSequence;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllHeaders: size=" + vector.size());
        }
        return vector;
    }

    public byte[] getHeaderAsByteArray(HeaderKeys headerKeys) {
        return this.getHeaderAsByteArray(headerKeys, 0);
    }

    public byte[] getHeaderAsByteArray(String string) {
        return this.getHeaderAsByteArray(string, 0);
    }

    public byte[] getHeaderAsByteArray(byte[] byArray) {
        return this.getHeaderAsByteArray(byArray, 0);
    }

    public byte[] getHeaderAsByteArray(HeaderKeys headerKeys, int n) {
        byte[] byArray;
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(headerKeys, n);
        byte[] byArray2 = byArray = null != headerElement ? headerElement.getByteArrayValue() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsByteArray(h,i): " + headerKeys.getName() + " " + n + " [" + byArray + "]");
        }
        return byArray;
    }

    public byte[] getHeaderAsByteArray(String string, int n) {
        byte[] byArray;
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(string, n);
        byte[] byArray2 = byArray = null != headerElement ? headerElement.getByteArrayValue() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsByteArray(s,i): " + string + " " + n + " [" + byArray + "]");
        }
        return byArray;
    }

    public byte[] getHeaderAsByteArray(byte[] byArray, int n) {
        byte[] byArray2;
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(byArray, n);
        byte[] byArray3 = byArray2 = null != headerElement ? headerElement.getByteArrayValue() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsByteArray(b,i): " + GenericUtils.getEnglishString(byArray) + " " + n + " [" + byArray2 + "]");
        }
        return byArray2;
    }

    public Date getHeaderAsDate(byte[] byArray) throws ParseException {
        return this.getHeaderAsDate(byArray, 0);
    }

    public Date getHeaderAsDate(byte[] byArray, int n) throws ParseException {
        Date date;
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(byArray, n);
        Date date2 = date = null != headerElement ? HttpDateFormat.getRef().parseTime(headerElement.getStringValue()) : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsDate(b,i): " + GenericUtils.getEnglishString(byArray) + " " + n + " [" + date + "]");
        }
        return date;
    }

    public Date getHeaderAsDate(HeaderKeys headerKeys) throws ParseException {
        return this.getHeaderAsDate(headerKeys, 0);
    }

    public Date getHeaderAsDate(HeaderKeys headerKeys, int n) throws ParseException {
        Date date;
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(headerKeys, n);
        Date date2 = date = null != headerElement ? HttpDateFormat.getRef().parseTime(headerElement.getStringValue()) : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsDate(h,i): " + headerKeys.getName() + " " + n + " [" + date + "]");
        }
        return date;
    }

    public Date getHeaderAsDate(String string) throws ParseException {
        return this.getHeaderAsDate(string, 0);
    }

    public Date getHeaderAsDate(String string, int n) throws ParseException {
        Date date;
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(string, n);
        Date date2 = date = null != headerElement ? HttpDateFormat.getRef().parseTime(headerElement.getStringValue()) : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsDate(s,i): " + string + " " + n + " [" + date + "]");
        }
        return date;
    }

    private Vector getHeaderDateValues(HeaderElement headerElement) throws ParseException {
        Vector<Date> vector = new Vector<Date>();
        while (null != headerElement) {
            if (!headerElement.wasRemoved()) {
                vector.add(HttpDateFormat.getRef().parseTime(headerElement.getStringValue()));
            }
            headerElement = headerElement.nextInstance;
        }
        return vector;
    }

    public Vector getHeaderDateValues(byte[] byArray) throws ParseException {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderDateValues(b): " + GenericUtils.getEnglishString(byArray));
        }
        return this.getHeaderDateValues(this.findHeader(byArray, 0));
    }

    public Vector getHeaderDateValues(HeaderKeys headerKeys) throws ParseException {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderDateValues(h): " + headerKeys.getName());
        }
        return this.getHeaderDateValues(this.findHeader(headerKeys, 0));
    }

    public Vector getHeaderDateValues(String string) throws ParseException {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderDateValues(s): " + string);
        }
        return this.getHeaderDateValues(this.findHeader(string, 0));
    }

    public Integer getHeaderAsInteger(byte[] byArray) throws NumberFormatException {
        return this.getHeaderAsInteger(byArray, 0);
    }

    public Integer getHeaderAsInteger(byte[] byArray, int n) throws NumberFormatException {
        Integer n2;
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(byArray, n);
        Integer n3 = n2 = null != headerElement ? new Integer(headerElement.getStringValue().trim()) : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsInteger(b,i): " + GenericUtils.getEnglishString(byArray) + " " + n + " [" + n2 + "]");
        }
        return n2;
    }

    public Integer getHeaderAsInteger(HeaderKeys headerKeys) throws NumberFormatException {
        return this.getHeaderAsInteger(headerKeys, 0);
    }

    public Integer getHeaderAsInteger(HeaderKeys headerKeys, int n) throws NumberFormatException {
        Integer n2;
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(headerKeys, n);
        Integer n3 = n2 = null != headerElement ? new Integer(headerElement.getStringValue().trim()) : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsInteger(h,i): " + headerKeys.getName() + " " + n + " [" + n2 + "]");
        }
        return n2;
    }

    public Integer getHeaderAsInteger(String string) throws NumberFormatException {
        return this.getHeaderAsInteger(string, 0);
    }

    public Integer getHeaderAsInteger(String string, int n) throws NumberFormatException {
        Integer n2;
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(string, n);
        Integer n3 = n2 = null != headerElement ? new Integer(headerElement.getStringValue().trim()) : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsInteger(s,i): " + string + " " + n + " [" + n2 + "]");
        }
        return n2;
    }

    private Vector getHeaderIntegerValues(HeaderElement headerElement) throws NumberFormatException {
        Vector<Integer> vector = new Vector<Integer>();
        while (null != headerElement) {
            if (!headerElement.wasRemoved()) {
                vector.add(new Integer(headerElement.getStringValue().trim()));
            }
            headerElement = headerElement.nextInstance;
        }
        return vector;
    }

    public Vector getHeaderIntegerValues(byte[] byArray) throws NumberFormatException {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderIntegerValues(b): " + GenericUtils.getEnglishString(byArray));
        }
        return this.getHeaderIntegerValues(this.findHeader(byArray, 0));
    }

    public Vector getHeaderIntegerValues(HeaderKeys headerKeys) throws NumberFormatException {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderIntegerValues(h): " + headerKeys.getName());
        }
        return this.getHeaderIntegerValues(this.findHeader(headerKeys, 0));
    }

    public Vector getHeaderIntegerValues(String string) throws NumberFormatException {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderIntegerValues(s): " + string);
        }
        return this.getHeaderIntegerValues(this.findHeader(string, 0));
    }

    public String getHeaderAsString(HeaderKeys headerKeys) {
        return this.getHeaderAsString(headerKeys, 0);
    }

    public String getHeaderAsString(String string) {
        return this.getHeaderAsString(string, 0);
    }

    public String getHeaderAsString(byte[] byArray) {
        return this.getHeaderAsString(byArray, 0);
    }

    public String getHeaderAsString(HeaderKeys headerKeys, int n) {
        String string;
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(headerKeys, n);
        String string2 = string = null != headerElement ? headerElement.getStringValue() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsString(h,i): " + headerKeys.getName() + " " + n + " [" + (null != string ? headerElement.getDebugValue() : string) + "]");
        }
        return string;
    }

    public String getHeaderAsString(String string, int n) {
        String string2;
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(string, n);
        String string3 = string2 = null != headerElement ? headerElement.getStringValue() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsString(s,i): " + string + " " + n + " [" + (null != string2 ? headerElement.getDebugValue() : string2) + "]");
        }
        return string2;
    }

    public String getHeaderAsString(byte[] byArray, int n) {
        String string;
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(byArray, n);
        String string2 = string = null != headerElement ? headerElement.getStringValue() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsString(b,i): " + GenericUtils.getEnglishString(byArray) + " " + n + " [" + (null != string ? headerElement.getDebugValue() : string) + "]");
        }
        return string;
    }

    private Vector getHeaderByteArrayValues(HeaderElement headerElement) {
        Vector<byte[]> vector = new Vector<byte[]>();
        while (null != headerElement) {
            if (!headerElement.wasRemoved()) {
                vector.add(headerElement.getByteArrayValue());
            }
            headerElement = headerElement.nextInstance;
        }
        return vector;
    }

    public Vector getHeaderByteArrayValues(HeaderKeys headerKeys) {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderByteArrayValues(h): " + headerKeys.getName());
        }
        return this.getHeaderByteArrayValues(this.findHeader(headerKeys, 0));
    }

    public Vector getHeaderByteArrayValues(String string) {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderByteArrayValues(s): " + string);
        }
        return this.getHeaderByteArrayValues(this.findHeader(string, 0));
    }

    public Vector getHeaderByteArrayValues(byte[] byArray) {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderByteArrayValues(b): " + GenericUtils.getEnglishString(byArray));
        }
        return this.getHeaderByteArrayValues(this.findHeader(byArray, 0));
    }

    private Vector getHeaderStringValues(HeaderElement headerElement) {
        Vector<String> vector = new Vector<String>();
        while (null != headerElement) {
            if (!headerElement.wasRemoved()) {
                vector.add(headerElement.getStringValue());
            }
            headerElement = headerElement.nextInstance;
        }
        return vector;
    }

    public Vector getHeaderStringValues(HeaderKeys headerKeys) {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderStringValues(h): " + headerKeys.getName());
        }
        return this.getHeaderStringValues(this.findHeader(headerKeys, 0));
    }

    public Vector getHeaderStringValues(String string) {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderStringValues(s): " + string);
        }
        return this.getHeaderStringValues(this.findHeader(string, 0));
    }

    public Vector getHeaderStringValues(byte[] byArray) {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderStringValues(b): " + GenericUtils.getEnglishString(byArray));
        }
        return this.getHeaderStringValues(this.findHeader(byArray, 0));
    }

    public Vector getHeaderTokens(HeaderKeys headerKeys, byte by) {
        return this.getHeaderTokens(headerKeys, by, 0);
    }

    public Vector getHeaderTokens(String string, byte by) {
        return this.getHeaderTokens(string, by, 0);
    }

    public Vector getHeaderTokens(byte[] byArray, byte by) {
        return this.getHeaderTokens(byArray, by, 0);
    }

    private Vector getHeaderTokens(HeaderElement headerElement, byte by) {
        if (null != headerElement) {
            return GenericUtils.byteArrayTokenize(headerElement.getByteArrayValue(), by);
        }
        return new Vector();
    }

    public Vector getHeaderTokens(HeaderKeys headerKeys, byte by, int n) {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderTokens(h,d,i): " + headerKeys.getName() + " " + (char)by + " " + n);
        }
        return this.getHeaderTokens(this.findHeader(headerKeys, n), by);
    }

    public Vector getHeaderTokens(String string, byte by, int n) {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderTokens(s,d,i): " + string + " " + (char)by + " " + n);
        }
        return this.getHeaderTokens(this.findHeader(string, n), by);
    }

    public Vector getHeaderTokens(byte[] byArray, byte by, int n) {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderTokens(b,d,i): " + GenericUtils.getEnglishString(byArray) + " " + (char)by + " " + n);
        }
        return this.getHeaderTokens(this.findHeader(byArray, n), by);
    }

    public int getPositionOfHeader(HeaderKeys headerKeys) {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.findSequencePosition(this.findHeader(headerKeys, 0));
    }

    public int getPositionOfHeader(String string) {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.findSequencePosition(this.findHeader(string, 0));
    }

    public int getPositionOfHeader(byte[] byArray) {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.findSequencePosition(this.findHeader(byArray, 0));
    }

    public int getNumberOfHeaderInstances(String string) {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.countInstances(this.findHeader(string, 0));
    }

    public int getNumberOfHeaderInstances(byte[] byArray) {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.countInstances(this.findHeader(byArray, 0));
    }

    public int getNumberOfHeaderInstances(HeaderKeys headerKeys) {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.countInstances(this.findHeader(headerKeys, 0));
    }

    public boolean containsHeader(String string) {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        return null != this.findHeader(string, 0);
    }

    public boolean containsHeader(byte[] byArray) {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        return null != this.findHeader(byArray, 0);
    }

    public boolean containsHeader(HeaderKeys headerKeys) {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        return null != this.findHeader(headerKeys, 0);
    }

    public WsByteBuffer[] marshallBinaryHeaders(WsByteBuffer[] wsByteBufferArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "marshallBinaryHeaders");
        }
        this.preMarshallHeaders();
        WsByteBuffer[] wsByteBufferArray2 = wsByteBufferArray;
        if (null == wsByteBufferArray2) {
            wsByteBufferArray2 = new WsByteBuffer[]{this.allocateBuffer(this.outgoingHdrBufferSize)};
            this.bytePosition = 0;
        }
        HeaderElement headerElement = this.hdrSequence;
        while (null != headerElement) {
            wsByteBufferArray2 = null != headerElement.getHeaderKey() ? this.marshallKnownBinaryHeader(wsByteBufferArray2, headerElement) : this.marshallUnknownBinaryHeader(wsByteBufferArray2, headerElement);
            headerElement = headerElement.nextSequence;
        }
        wsByteBufferArray2 = this.putInt(0, wsByteBufferArray2);
        wsByteBufferArray2 = this.flushCache(wsByteBufferArray2);
        wsByteBufferArray2[wsByteBufferArray2.length - 1].flip();
        this.postMarshallHeaders();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "marshallBinaryHeaders");
        }
        return wsByteBufferArray2;
    }

    public WsByteBuffer[] marshallHeaders(WsByteBuffer[] wsByteBufferArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "marshallHeaders");
        }
        this.preMarshallHeaders();
        WsByteBuffer[] wsByteBufferArray2 = wsByteBufferArray;
        if (null != this.parseBuffers[0] && !this.overHeaderChangeLimit()) {
            wsByteBufferArray2 = this.marshallReuseHeaders(wsByteBufferArray);
        } else {
            if (null == wsByteBufferArray2) {
                wsByteBufferArray2 = new WsByteBuffer[]{this.allocateBuffer(this.outgoingHdrBufferSize)};
                this.bytePosition = 0;
            }
            HeaderElement headerElement = this.hdrSequence;
            while (null != headerElement) {
                wsByteBufferArray2 = null != headerElement.getHeaderKey() ? this.marshallKnownHeader(wsByteBufferArray2, headerElement) : this.marshallUnknownHeader(wsByteBufferArray2, headerElement);
                headerElement = headerElement.nextSequence;
            }
            wsByteBufferArray2 = this.putBytes(BNFHeaders.EOL, wsByteBufferArray2);
            wsByteBufferArray2 = this.flushCache(wsByteBufferArray2);
            wsByteBufferArray2[wsByteBufferArray2.length - 1].flip();
        }
        this.postMarshallHeaders();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "marshallHeaders");
        }
        return wsByteBufferArray2;
    }

    private void scribbleWhiteSpace(WsByteBuffer wsByteBuffer, int n, int n2) {
        if (wsByteBuffer.hasArray()) {
            byte[] byArray = wsByteBuffer.array();
            for (int i = n; i < n2; ++i) {
                byArray[i] = 32;
            }
        } else {
            int n3;
            int n4;
            if (null == whitespace) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Allocating static whitespace data");
                }
                whitespace = new byte[1024];
                for (n4 = 0; n4 < 1024; ++n4) {
                    BNFHeadersImpl.whitespace[n4] = 32;
                }
            }
            wsByteBuffer.position(n);
            for (n4 = n2 - n; n4 > 0; n4 -= n3) {
                if (whitespace.length >= n4) {
                    wsByteBuffer.put(whitespace, 0, n4);
                    break;
                }
                n3 = whitespace.length;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Scribbling " + n3 + " bytes of whitespace");
                }
                wsByteBuffer.put(whitespace, 0, n3);
            }
        }
    }

    private void eraseValue(HeaderElement headerElement) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Erasing existing header: " + headerElement.getName());
        }
        int n = this.lastCRLFBufferIndex;
        int n2 = this.lastCRLFPosition;
        if (null != headerElement.nextSequence && !headerElement.nextSequence.wasAdded()) {
            n = headerElement.nextSequence.getLastCRLFBufferIndex();
            n2 = headerElement.nextSequence.getLastCRLFPosition();
        }
        int n3 = headerElement.getLastCRLFPosition();
        for (int i = headerElement.getLastCRLFBufferIndex(); i < n; ++i) {
            this.parseBuffers[i].position(n3);
            this.parseBuffers[i].limit(n3);
            n3 = 0;
        }
        this.scribbleWhiteSpace(this.parseBuffers[n], n3, n2);
    }

    private int overlayBytes(byte[] byArray, int n, int n2, int n3) {
        WsByteBuffer wsByteBuffer = this.parseBuffers[n3];
        if (-1 == n2) {
            n2 = byArray.length;
        }
        while (n3 <= this.parseIndex) {
            int n4 = wsByteBuffer.remaining();
            if (n4 >= n2) {
                wsByteBuffer.put(byArray, n, n2);
                return n3;
            }
            wsByteBuffer.put(byArray, n, n4);
            n += n4;
            n2 -= n4;
            wsByteBuffer = this.parseBuffers[++n3];
            wsByteBuffer.position(0);
        }
        return n3;
    }

    private void overlayValue(HeaderElement headerElement) {
        int n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Overlaying existing header: " + headerElement.getName());
        }
        int n2 = this.lastCRLFBufferIndex;
        int n3 = this.lastCRLFPosition;
        if (null != headerElement.nextSequence && !headerElement.nextSequence.wasAdded()) {
            n2 = headerElement.nextSequence.getLastCRLFBufferIndex();
            n3 = headerElement.nextSequence.getLastCRLFPosition();
        }
        WsByteBuffer wsByteBuffer = this.parseBuffers[headerElement.getLastCRLFBufferIndex()];
        wsByteBuffer.position(headerElement.getLastCRLFPosition() + (headerElement.isLastCRLFaCR() ? 2 : 1));
        if (n2 == headerElement.getLastCRLFBufferIndex()) {
            if (null != headerElement.getHeaderKey()) {
                wsByteBuffer.put(headerElement.getHeaderKey().getMarshalledByteArray());
            } else {
                wsByteBuffer.put(GenericUtils.getEnglishBytes(headerElement.getHeaderString()));
                wsByteBuffer.put(KEY_VALUE_SEPARATOR);
            }
            wsByteBuffer.put(headerElement.getRawByteArrayValue(), headerElement.getOffset(), headerElement.getValueLength());
        } else {
            n = headerElement.getLastCRLFBufferIndex();
            if (null != headerElement.getHeaderKey()) {
                n = this.overlayBytes(headerElement.getHeaderKey().getMarshalledByteArray(), 0, -1, n);
            } else {
                n = this.overlayBytes(GenericUtils.getEnglishBytes(headerElement.getHeaderString()), 0, -1, n);
                n = this.overlayBytes(KEY_VALUE_SEPARATOR, 0, KEY_VALUE_SEPARATOR.length, n);
            }
            n = this.overlayBytes(headerElement.getRawByteArrayValue(), headerElement.getOffset(), headerElement.getValueLength(), n);
            wsByteBuffer = this.parseBuffers[n];
        }
        n = wsByteBuffer.position();
        if (n < n3) {
            this.scribbleWhiteSpace(wsByteBuffer, n, n3);
        }
    }

    private WsByteBuffer[] marshallAddedHeaders(WsByteBuffer[] wsByteBufferArray, int n) {
        wsByteBufferArray[n] = this.allocateBuffer(this.outgoingHdrBufferSize);
        HeaderElement headerElement = this.hdrSequence;
        while (null != headerElement) {
            if (headerElement.wasAdded()) {
                wsByteBufferArray = null != headerElement.getHeaderKey() ? this.marshallKnownHeader(wsByteBufferArray, headerElement) : this.marshallUnknownHeader(wsByteBufferArray, headerElement);
            }
            headerElement = headerElement.nextSequence;
        }
        wsByteBufferArray = this.putBytes(BNFHeaders.EOL, wsByteBufferArray);
        wsByteBufferArray = this.flushCache(wsByteBufferArray);
        wsByteBufferArray[wsByteBufferArray.length - 1].flip();
        return wsByteBufferArray;
    }

    private WsByteBuffer[] marshallReuseHeaders(WsByteBuffer[] wsByteBufferArray) {
        int n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Marshalling headers and re-using buffers, change=" + this.headerChangeCount + ", add=" + this.headerAddCount + ", src=" + wsByteBufferArray);
        }
        HeaderElement headerElement = this.hdrSequence;
        WsByteBuffer[] wsByteBufferArray2 = wsByteBufferArray;
        int n2 = this.parseIndex + (0 < this.headerAddCount ? 2 : 1);
        int n3 = 0;
        int n4 = 0;
        if (null == wsByteBufferArray || 0 == wsByteBufferArray.length) {
            wsByteBufferArray2 = new WsByteBuffer[n2];
        } else {
            int n5;
            wsByteBufferArray = this.flushCache(wsByteBufferArray);
            wsByteBufferArray[wsByteBufferArray.length - 1].flip();
            n = headerElement.getLastCRLFBufferIndex();
            for (n5 = 0; n5 < n; ++n5) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trimming first line data from " + this.parseBuffers[n5]);
                }
                this.parseBuffersStartPos[n5] = this.parseBuffers[n5].limit();
            }
            n5 = headerElement.getLastCRLFPosition() + (headerElement.isLastCRLFaCR() ? 2 : 1);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting first buffer with headers pos to " + n5);
            }
            this.parseBuffersStartPos[n] = n5;
            n2 = n2 - n + wsByteBufferArray.length;
            wsByteBufferArray2 = new WsByteBuffer[n2];
            System.arraycopy(wsByteBufferArray, 0, wsByteBufferArray2, 0, wsByteBufferArray.length);
            n3 = wsByteBufferArray.length;
            n4 = n;
        }
        if (0 < this.headerChangeCount) {
            headerElement = this.hdrSequence;
            n = 0;
            while (n < this.headerChangeCount && null != headerElement && -1 != headerElement.getLastCRLFBufferIndex()) {
                if (headerElement.wasRemoved()) {
                    this.eraseValue(headerElement);
                    ++n;
                } else if (headerElement.wasChanged()) {
                    this.overlayValue(headerElement);
                    ++n;
                }
                headerElement = headerElement.nextSequence;
            }
        }
        while (n4 < this.parseIndex) {
            wsByteBufferArray2[n3] = this.parseBuffers[n4];
            wsByteBufferArray2[n3].position(this.parseBuffersStartPos[n4]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Copying existing parse buffer: " + wsByteBufferArray2[n3]);
            }
            ++n4;
            ++n3;
        }
        n = this.eohPosition;
        if (0 < this.headerAddCount) {
            n = this.lastCRLFPosition + 1;
            if (this.lastCRLFisCR) {
                ++n;
            }
        }
        WsByteBuffer wsByteBuffer = this.parseBuffers[n4];
        int n6 = wsByteBuffer.position();
        int n7 = wsByteBuffer.limit();
        wsByteBuffer.position(this.parseBuffersStartPos[n4]);
        wsByteBuffer.limit(n);
        wsByteBufferArray2[n3] = wsByteBuffer.slice();
        this.addToCreatedBuffer(wsByteBufferArray2[n3]);
        wsByteBuffer.limit(n7);
        wsByteBuffer.position(n6);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Sliced last header buffer: " + wsByteBufferArray2[n3]);
        }
        if (0 < this.headerAddCount) {
            wsByteBufferArray2 = this.marshallAddedHeaders(wsByteBufferArray2, ++n3);
        }
        return wsByteBufferArray2;
    }

    private boolean moveHeader(HeaderElement headerElement, int n) {
        this.bOverChangeLimit = true;
        if (null != headerElement) {
            this.removeHeaderFromSequence(headerElement);
            this.addToSequenceList(n, headerElement);
            return true;
        }
        return false;
    }

    public boolean moveHeader(HeaderKeys headerKeys, int n) {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "moveHeader(h,i): " + headerKeys.getName() + " to " + n);
        }
        return this.moveHeader(this.findHeader(headerKeys, 0), n);
    }

    public boolean moveHeader(String string, int n) {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "moveHeader(s,i): " + string + " to " + n);
        }
        return this.moveHeader(this.findHeader(string, 0), n);
    }

    public boolean moveHeader(byte[] byArray, int n) {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "moveHeader(b,i): " + GenericUtils.getEnglishString(byArray) + " to " + n);
        }
        return this.moveHeader(this.findHeader(byArray, 0), n);
    }

    public boolean parseBinaryHeaders(WsByteBuffer wsByteBuffer, HeaderKeys headerKeys) throws MalformedMessageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing binary headers with input buff: " + wsByteBuffer);
        }
        if (null == this.parsedToken) {
            this.createCacheToken(4);
        }
        boolean bl = false;
        block8: while (!bl) {
            if (!this.fillCacheToken(wsByteBuffer)) {
                return false;
            }
            switch (this.binaryParsingState) {
                case 1: {
                    int n = GenericUtils.asInt(this.parsedToken);
                    if (0 == n) {
                        bl = true;
                        continue block8;
                    }
                    if (1 == n) {
                        this.binaryParsingState = 2;
                        this.resetCacheToken(4);
                        continue block8;
                    }
                    if (2 != n) continue block8;
                    this.binaryParsingState = 3;
                    this.resetCacheToken(4);
                    continue block8;
                }
                case 2: {
                    HeaderKeys headerKeys2 = (HeaderKeys)headerKeys.getEnumByOrdinal(GenericUtils.asInt(this.parsedToken));
                    this.currentElem = this.getElement(headerKeys2);
                    this.binaryParsingState = 5;
                    this.resetCacheToken(4);
                    continue block8;
                }
                case 3: {
                    this.binaryParsingState = 4;
                    this.resetCacheToken(GenericUtils.asInt(this.parsedToken));
                    continue block8;
                }
                case 4: {
                    this.currentElem = this.getElement(GenericUtils.getEnglishString(this.parsedToken));
                    this.binaryParsingState = 5;
                    this.resetCacheToken(4);
                    continue block8;
                }
                case 5: {
                    this.binaryParsingState = 6;
                    this.resetCacheToken(GenericUtils.asInt(this.parsedToken));
                    continue block8;
                }
                case 6: {
                    this.setHeaderValue();
                    this.binaryParsingState = 1;
                    this.createCacheToken(4);
                    continue block8;
                }
            }
            throw new MalformedMessageException("Invalid state in headers: " + this.binaryParsingState);
        }
        this.eohPosition = this.isByteBufferArray ? this.bytePosition : wsByteBuffer.position() - (this.byteLimit - this.bytePosition);
        wsByteBuffer.position(this.eohPosition);
        this.resetByteCache();
        this.clearCacheToken();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "End of binary headers at pos: " + this.eohPosition);
        }
        return true;
    }

    public boolean parseHeaders(WsByteBuffer wsByteBuffer, boolean bl) throws MalformedMessageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing headers with input buff: " + wsByteBuffer);
        }
        boolean bl2 = false;
        while (-1 == this.eohPosition) {
            switch (this.stateOfParsing) {
                case 0: {
                    bl2 = this.parseHeaderName(wsByteBuffer);
                    break;
                }
                case 1: {
                    bl2 = bl || this.bIsMultiLine ? this.parseHeaderValueExtract(wsByteBuffer) : this.parseHeaderValueNonExtract(wsByteBuffer);
                    break;
                }
                case 2: {
                    bl2 = this.parseCRLFs(wsByteBuffer);
                    break;
                }
                default: {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Found invalid parsing ID of " + this.stateOfParsing);
                }
            }
            if (bl2) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Need more data");
            }
            this.resetByteCache();
            return false;
        }
        this.resetByteCache();
        this.headerChangeCount = 0;
        this.headerAddCount = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "End of headers found at position " + this.eohPosition);
        }
        return true;
    }

    public void postMarshallHeaders() {
    }

    public void preMarshallHeaders() {
    }

    private void checkPrependedHeader(HeaderElement headerElement) {
        headerElement = headerElement.nextInstance;
        while (null != headerElement) {
            if (!headerElement.wasAdded()) {
                this.bOverChangeLimit = true;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug(tc, "New header is before old one, disabling change limit");
                break;
            }
            headerElement = headerElement.nextInstance;
        }
    }

    public void prependHeader(HeaderKeys headerKeys, byte[] byArray) {
        if (null == headerKeys || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prependHeader(h,b): " + headerKeys.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray, 0, byArray.length);
        }
        HeaderElement headerElement = this.getElement(headerKeys);
        headerElement.setByteArrayValue(byArray);
        this.addKnownHeader(headerKeys, headerElement, false, true);
        this.checkPrependedHeader(headerElement);
    }

    public void prependHeader(HeaderKeys headerKeys, byte[] byArray, int n, int n2) {
        if (null == headerKeys || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prependHeader(h,b,i,i): " + headerKeys.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray, n, n2);
        }
        HeaderElement headerElement = this.getElement(headerKeys);
        headerElement.setByteArrayValue(byArray, n, n2);
        this.addKnownHeader(headerKeys, headerElement, false, true);
        this.checkPrependedHeader(headerElement);
    }

    public void prependHeader(HeaderKeys headerKeys, String string) {
        if (null == headerKeys || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prependHeader(h,s): " + headerKeys.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(string);
        }
        HeaderElement headerElement = this.getElement(headerKeys);
        headerElement.setStringValue(string);
        this.addKnownHeader(headerKeys, headerElement, false, true);
        this.checkPrependedHeader(headerElement);
    }

    public void prependHeader(String string, byte[] byArray) {
        HeaderElement headerElement;
        HeaderKeys headerKeys;
        if (null == string || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prependHeader(s,b): " + string);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderName(string);
            this.checkHeaderValue(byArray, 0, byArray.length);
        }
        if ((headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            headerElement = this.getElement(string);
            headerElement.setByteArrayValue(byArray);
            this.addUnknownHeader(string, headerElement, false);
        } else {
            headerElement = this.getElement(headerKeys);
            headerElement.setByteArrayValue(byArray);
            this.addKnownHeader(headerKeys, headerElement, false, true);
        }
        this.checkPrependedHeader(headerElement);
    }

    public void prependHeader(String string, byte[] byArray, int n, int n2) {
        HeaderElement headerElement;
        HeaderKeys headerKeys;
        if (null == string || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prependHeader(s,b,i,i): " + string);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderName(string);
            this.checkHeaderValue(byArray, n, n2);
        }
        if ((headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            headerElement = this.getElement(string);
            headerElement.setByteArrayValue(byArray, n, n2);
            this.addUnknownHeader(string, headerElement, false);
        } else {
            headerElement = this.getElement(headerKeys);
            headerElement.setByteArrayValue(byArray, n, n2);
            this.addKnownHeader(headerKeys, headerElement, false, true);
        }
        this.checkPrependedHeader(headerElement);
    }

    public void prependHeader(byte[] byArray, byte[] byArray2) {
        HeaderElement headerElement;
        HeaderKeys headerKeys;
        if (null == byArray || null == byArray2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prependHeader(b,b): " + GenericUtils.getEnglishString(byArray));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderName(byArray);
            this.checkHeaderValue(byArray2, 0, byArray2.length);
        }
        if ((headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            String string = GenericUtils.getEnglishString(byArray);
            headerElement = this.getElement(string);
            headerElement.setByteArrayValue(byArray2);
            this.addUnknownHeader(string, headerElement, false);
        } else {
            headerElement = this.getElement(headerKeys);
            headerElement.setByteArrayValue(byArray2);
            this.addKnownHeader(headerKeys, headerElement, false, true);
        }
        this.checkPrependedHeader(headerElement);
    }

    public void prependHeader(byte[] byArray, byte[] byArray2, int n, int n2) {
        HeaderElement headerElement;
        HeaderKeys headerKeys;
        if (null == byArray || null == byArray2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prependHeader(b,b,i,i): " + GenericUtils.getEnglishString(byArray));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderName(byArray);
            this.checkHeaderValue(byArray2, n, n2);
        }
        if ((headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            String string = GenericUtils.getEnglishString(byArray);
            headerElement = this.getElement(string);
            headerElement.setByteArrayValue(byArray2, n, n2);
            this.addUnknownHeader(string, headerElement, false);
        } else {
            headerElement = this.getElement(headerKeys);
            headerElement.setByteArrayValue(byArray2, n, n2);
            this.addKnownHeader(headerKeys, headerElement, false, true);
        }
        this.checkPrependedHeader(headerElement);
    }

    public void prependHeader(String string, String string2) {
        HeaderElement headerElement;
        HeaderKeys headerKeys;
        if (null == string || null == string2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prependHeader(s,s): " + string);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderName(string);
            this.checkHeaderValue(string2);
        }
        if ((headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            headerElement = this.getElement(string);
            headerElement.setStringValue(string2);
            this.addUnknownHeader(string, headerElement, false);
        } else {
            headerElement = this.getElement(headerKeys);
            headerElement.setStringValue(string2);
            this.addKnownHeader(headerKeys, headerElement, false, true);
        }
        this.checkPrependedHeader(headerElement);
    }

    public void prependHeader(byte[] byArray, String string) {
        HeaderElement headerElement;
        HeaderKeys headerKeys;
        if (null == byArray || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prependHeader(b,s): " + GenericUtils.getEnglishString(byArray));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderName(byArray);
            this.checkHeaderValue(string);
        }
        if ((headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            String string2 = GenericUtils.getEnglishString(byArray);
            headerElement = this.getElement(string2);
            headerElement.setStringValue(string);
            this.addUnknownHeader(string2, headerElement, false);
        } else {
            headerElement = this.getElement(headerKeys);
            headerElement.setStringValue(string);
            this.addKnownHeader(headerKeys, headerElement, false, true);
        }
        this.checkPrependedHeader(headerElement);
    }

    public void removeAllHeaders() {
        HeaderElement headerElement;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAllHeaders()");
        }
        for (int i = 0; i < this.headerValues.length; ++i) {
            headerElement = this.headerValues[i];
            if (null == headerElement || null == headerElement.getHeaderKey() || !headerElement.getHeaderKey().useFilters()) continue;
            headerElement.getHeaderKey().filterRemHeader(this, null);
        }
        headerElement = this.hdrSequence;
        while (null != headerElement) {
            headerElement.remove();
            headerElement = headerElement.nextSequence;
        }
        this.numberOfHeaders = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAllHeaders()");
        }
    }

    private void clearAllHeaders() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "clearAllHeaders()");
        }
        HeaderElement headerElement = this.hdrSequence;
        while (null != headerElement) {
            HeaderElement headerElement2 = headerElement.nextSequence;
            HeaderKeys headerKeys = headerElement.getHeaderKey();
            if (null != headerKeys) {
                if (null != this.headerValues[headerKeys.getOrdinal()]) {
                    if (headerKeys.useFilters()) {
                        headerKeys.filterRemHeader(this, null);
                    }
                    this.headerValues[headerKeys.getOrdinal()] = null;
                }
            } else {
                this.deleteUnknownHeader(headerElement.getHeaderString());
            }
            headerElement.destroy();
            headerElement = headerElement2;
        }
        this.hdrSequence = null;
        this.lastHdrInSequence = null;
        this.numberOfHeaders = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "clearAllHeaders()");
        }
    }

    public void removeHeader(HeaderKeys headerKeys) {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeHeader(h): " + headerKeys.getName());
        }
        this.removeKnownHeader(headerKeys, true);
    }

    public void removeHeader(String string) {
        HeaderKeys headerKeys;
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeHeader(s): " + string);
        }
        if ((headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            this.removeUnknownHeader(string);
        } else {
            this.removeKnownHeader(headerKeys, true);
        }
    }

    public void removeHeader(byte[] byArray) {
        HeaderKeys headerKeys;
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeHeader(b): " + GenericUtils.getEnglishString(byArray));
        }
        if ((headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            this.removeUnknownHeader(GenericUtils.getEnglishString(byArray));
        } else {
            this.removeKnownHeader(headerKeys, true);
        }
    }

    public void removeHeader(HeaderKeys headerKeys, int n) {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeHeader(h,i): " + headerKeys.getName() + " " + n);
        }
        this.removeKnownHeader(headerKeys, n);
    }

    public void removeHeader(String string, int n) {
        HeaderKeys headerKeys;
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeHeader(s,i): " + string + " " + n);
        }
        if ((headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            this.removeUnknownHeader(string, n);
        } else {
            this.removeKnownHeader(headerKeys, n);
        }
    }

    public void removeHeader(byte[] byArray, int n) {
        HeaderKeys headerKeys;
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeHeader(b,i): " + GenericUtils.getEnglishString(byArray) + " " + n);
        }
        if ((headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            this.removeUnknownHeader(GenericUtils.getEnglishString(byArray), n);
        } else {
            this.removeKnownHeader(headerKeys, n);
        }
    }

    public void removeSpecialHeader(HeaderKeys headerKeys) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeSpecialHeader(h): " + headerKeys.getName());
        }
        this.removeKnownHeader(headerKeys, false);
    }

    public void replaceHeader(HeaderKeys headerKeys, int n, byte[] byArray) {
        if (null == headerKeys || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "replaceHeader(h,i,b): " + headerKeys.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray, 0, byArray.length);
        }
        this.replaceKnownHeader(headerKeys, byArray, n);
    }

    public void replaceHeader(HeaderKeys headerKeys, int n, byte[] byArray, int n2, int n3) {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "replaceHeader(h,i,b,i,i): " + headerKeys.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray, n2, n3);
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        this.replaceKnownHeader(headerKeys, byArray2, n);
    }

    public void replaceHeader(HeaderKeys headerKeys, int n, String string) {
        if (null == headerKeys || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "replaceHeader(h,i,s): " + headerKeys.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(string);
        }
        this.replaceKnownHeader(headerKeys, string, n);
    }

    public void replaceHeader(String string, int n, byte[] byArray) {
        HeaderKeys headerKeys;
        if (null == string || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "replaceHeader(s,i,b): " + string);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderName(string);
            this.checkHeaderValue(byArray, 0, byArray.length);
        }
        if ((headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            this.replaceUnknownHeader(string, byArray, n);
        } else {
            this.replaceKnownHeader(headerKeys, byArray, n);
        }
    }

    public void replaceHeader(String string, int n, byte[] byArray, int n2, int n3) {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "replaceHeader(s,i,b,i,i): " + string);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderName(string);
            this.checkHeaderValue(byArray, n2, n3);
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        HeaderKeys headerKeys = this.getMatcher().matchHeader(string);
        if (headerKeys.equals(GenericConstants.NO_MATCH)) {
            this.replaceUnknownHeader(string, byArray2, n);
        } else {
            this.replaceKnownHeader(headerKeys, byArray2, n);
        }
    }

    public void replaceHeader(byte[] byArray, int n, byte[] byArray2) {
        HeaderKeys headerKeys;
        if (null == byArray || null == byArray2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "replaceHeader(b,i,b): " + GenericUtils.getEnglishString(byArray));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderName(byArray);
            this.checkHeaderValue(byArray2, 0, byArray2.length);
        }
        if ((headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            this.replaceUnknownHeader(GenericUtils.getEnglishString(byArray), byArray2, n);
        } else {
            this.replaceKnownHeader(headerKeys, byArray2, n);
        }
    }

    public void replaceHeader(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (null == byArray2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "replaceHeader(b,i,b,i,i): " + GenericUtils.getEnglishString(byArray));
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray2, n2, byArray3, 0, n3);
        this.replaceHeader(byArray, n, byArray3);
    }

    public void replaceHeader(String string, int n, String string2) {
        HeaderKeys headerKeys;
        if (null == string || null == string2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "replaceHeader(s,i,s): " + string);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderName(string);
            this.checkHeaderValue(string2);
        }
        if ((headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            this.replaceUnknownHeader(string, string2, n);
        } else {
            this.replaceKnownHeader(headerKeys, string2, n);
        }
    }

    public void replaceHeader(byte[] byArray, int n, String string) {
        HeaderKeys headerKeys;
        if (null == byArray || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "replaceHeader(b,i,s): " + GenericUtils.getEnglishString(byArray));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderName(byArray);
            this.checkHeaderValue(string);
        }
        if ((headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            this.replaceUnknownHeader(GenericUtils.getEnglishString(byArray), string, n);
        } else {
            this.replaceKnownHeader(headerKeys, string, n);
        }
    }

    public WsByteBuffer returnCurrentBuffer() {
        if (-1 != this.parseIndex) {
            WsByteBuffer wsByteBuffer = this.parseBuffers[this.parseIndex];
            --this.parseIndex;
            return wsByteBuffer;
        }
        return null;
    }

    public void setHeader(String string, byte[] byArray) {
        HeaderKeys headerKeys;
        if (null == string || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader(s,b): " + string);
        }
        if (!(headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            this.setHeader(headerKeys, byArray);
        } else {
            if (this.bHeaderValidation) {
                this.checkHeaderName(string);
                this.checkHeaderValue(byArray, 0, byArray.length);
            }
            this.createSingleHeader(string, byArray);
        }
    }

    public void setHeader(String string, byte[] byArray, int n, int n2) {
        HeaderKeys headerKeys;
        if (null == string || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader(s,b,i,i): " + string);
        }
        if (!(headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            this.setHeader(headerKeys, byArray, n, n2);
        } else {
            if (this.bHeaderValidation) {
                this.checkHeaderName(string);
                this.checkHeaderValue(byArray, n, n2);
            }
            this.createSingleHeader(string, byArray, n, n2);
        }
    }

    public void setHeader(byte[] byArray, byte[] byArray2) {
        HeaderKeys headerKeys;
        if (null == byArray || null == byArray2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader(b,b): " + GenericUtils.getEnglishString(byArray));
        }
        if (!(headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            this.setHeader(headerKeys, byArray2);
        } else {
            if (this.bHeaderValidation) {
                this.checkHeaderName(byArray);
                this.checkHeaderValue(byArray2, 0, byArray2.length);
            }
            this.createSingleHeader(GenericUtils.getEnglishString(byArray), byArray2);
        }
    }

    public void setHeader(byte[] byArray, byte[] byArray2, int n, int n2) {
        HeaderKeys headerKeys;
        if (null == byArray || null == byArray2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader(b,b,i,i): " + GenericUtils.getEnglishString(byArray));
        }
        if (!(headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            this.setHeader(headerKeys, byArray2, n, n2);
        } else {
            if (this.bHeaderValidation) {
                this.checkHeaderName(byArray);
                this.checkHeaderValue(byArray2, n, n2);
            }
            this.createSingleHeader(GenericUtils.getEnglishString(byArray), byArray2, n, n2);
        }
    }

    public void setHeader(HeaderKeys headerKeys, byte[] byArray) {
        if (null == headerKeys || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader(h,b): " + headerKeys.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray, 0, byArray.length);
        }
        if (headerKeys.useFilters()) {
            HeaderElement headerElement = this.findHeader(headerKeys, 0);
            if (null != headerElement) {
                headerKeys.filterRemHeader(this, null);
            }
            if (!headerKeys.filterAddHeader(this, byArray)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "New value disallowed: " + GenericUtils.getEnglishString(byArray));
                }
                this.removeKnownHeader(headerKeys, false);
                return;
            }
        }
        this.createSingleHeader(headerKeys, byArray);
    }

    public void setHeader(HeaderKeys headerKeys, byte[] byArray, int n, int n2) {
        if (null == headerKeys || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader(h,b,i,i): " + headerKeys.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray, n, n2);
        }
        if (headerKeys.useFilters()) {
            HeaderElement headerElement = this.findHeader(headerKeys, 0);
            if (null != headerElement) {
                headerKeys.filterRemHeader(this, null);
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            byArray = byArray2;
            if (!headerKeys.filterAddHeader(this, byArray)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "New value disallowed: " + GenericUtils.getEnglishString(byArray));
                }
                this.removeKnownHeader(headerKeys, false);
                return;
            }
        }
        this.createSingleHeader(headerKeys, byArray, n, n2);
    }

    public void setHeader(HeaderKeys headerKeys, String string) {
        if (null == headerKeys || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader(h,s): " + headerKeys.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(string);
        }
        if (headerKeys.useFilters()) {
            HeaderElement headerElement = this.findHeader(headerKeys, 0);
            if (null != headerElement) {
                headerKeys.filterRemHeader(this, null);
            }
            if (!headerKeys.filterAddHeader(this, GenericUtils.getEnglishBytes(string))) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "New value disallowed: " + string);
                }
                this.removeKnownHeader(headerKeys, false);
                return;
            }
        }
        this.createSingleHeader(headerKeys, string);
    }

    public void setHeader(String string, String string2) {
        HeaderKeys headerKeys;
        if (null == string || null == string2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader(s,s): " + string);
        }
        if (!(headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            this.setHeader(headerKeys, string2);
        } else {
            if (this.bHeaderValidation) {
                this.checkHeaderName(string);
                this.checkHeaderValue(string2);
            }
            this.createSingleHeader(string, string2);
        }
    }

    public void setHeader(byte[] byArray, String string) {
        HeaderKeys headerKeys;
        if (null == byArray || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader(b,s): " + GenericUtils.getEnglishString(byArray));
        }
        if (!(headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            this.setHeader(headerKeys, string);
        } else {
            if (this.bHeaderValidation) {
                this.checkHeaderName(byArray);
                this.checkHeaderValue(string);
            }
            this.createSingleHeader(GenericUtils.getEnglishString(byArray), string);
        }
    }

    protected void setHeaderMatcher(QuickHeaderMatcher quickHeaderMatcher) {
        this.myHM = quickHeaderMatcher;
    }

    private QuickHeaderMatcher getMatcher() {
        return this.myHM;
    }

    private void createSingleHeader(HeaderKeys headerKeys, byte[] byArray) {
        boolean bl;
        HeaderElement headerElement = this.findHeader(headerKeys, 0);
        boolean bl2 = bl = null == headerElement;
        if (!bl) {
            if (null != headerElement.nextInstance) {
                HeaderElement headerElement2 = headerElement.nextInstance;
                while (null != headerElement2) {
                    headerElement2.remove();
                    headerElement2 = headerElement2.nextInstance;
                }
            }
            if (-1 < this.headerChangeLimit) {
                if (byArray.length <= headerElement.getValueLength()) {
                    ++this.headerChangeCount;
                    headerElement.setByteArrayValue(byArray);
                } else {
                    headerElement.remove();
                    bl = true;
                }
            } else {
                headerElement.setByteArrayValue(byArray);
            }
        }
        if (bl) {
            headerElement = this.getElement(headerKeys);
            headerElement.setByteArrayValue(byArray);
            this.addKnownHeader(headerKeys, headerElement, true, false);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Replacing known header " + headerKeys.getName() + " with [" + headerElement.getDebugValue() + "]");
        }
    }

    private void createSingleHeader(HeaderKeys headerKeys, byte[] byArray, int n, int n2) {
        boolean bl;
        HeaderElement headerElement = this.findHeader(headerKeys, 0);
        boolean bl2 = bl = null == headerElement;
        if (!bl) {
            if (null != headerElement.nextInstance) {
                HeaderElement headerElement2 = headerElement.nextInstance;
                while (null != headerElement2) {
                    headerElement2.remove();
                    headerElement2 = headerElement2.nextInstance;
                }
            }
            if (-1 < this.headerChangeLimit) {
                if (n2 <= headerElement.getValueLength()) {
                    ++this.headerChangeCount;
                    headerElement.setByteArrayValue(byArray, n, n2);
                } else {
                    headerElement.remove();
                    bl = true;
                }
            } else {
                headerElement.setByteArrayValue(byArray, n, n2);
            }
        }
        if (bl) {
            headerElement = this.getElement(headerKeys);
            headerElement.setByteArrayValue(byArray, n, n2);
            this.addKnownHeader(headerKeys, headerElement, true, false);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Replacing known header " + headerKeys.getName() + " with [" + headerElement.getDebugValue() + "]");
        }
    }

    private void createSingleHeader(HeaderKeys headerKeys, String string) {
        boolean bl;
        HeaderElement headerElement = this.findHeader(headerKeys, 0);
        boolean bl2 = bl = null == headerElement;
        if (!bl) {
            if (null != headerElement.nextInstance) {
                HeaderElement headerElement2 = headerElement.nextInstance;
                while (null != headerElement2) {
                    headerElement2.remove();
                    headerElement2 = headerElement2.nextInstance;
                }
            }
            if (-1 < this.headerChangeLimit) {
                if (string.length() <= headerElement.getValueLength()) {
                    ++this.headerChangeCount;
                    headerElement.setStringValue(string);
                } else {
                    headerElement.remove();
                    bl = true;
                }
            } else {
                headerElement.setStringValue(string);
            }
        }
        if (bl) {
            headerElement = this.getElement(headerKeys);
            headerElement.setStringValue(string);
            this.addKnownHeader(headerKeys, headerElement, true, false);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Replacing known header " + headerKeys.getName() + " with [" + headerElement.getDebugValue() + "]");
        }
    }

    private void addKnownHeader(HeaderKeys headerKeys, HeaderElement headerElement, boolean bl, boolean bl2) {
        boolean bl3;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding known header [" + headerKeys.getName() + "] with value [" + headerElement.getDebugValue() + "]");
        }
        if (bl2 && headerKeys.useFilters() && !headerKeys.filterAddHeader(this, headerElement.getByteArrayValue())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "filter disallowed: " + headerElement.getDebugValue());
            }
            return;
        }
        this.incrementHeaderCounter();
        boolean bl4 = bl3 = bl ? this.addInstanceOfElement(this.headerValues[headerKeys.getOrdinal()], headerElement) : this.addLeadingInstanceOfElement(this.headerValues[headerKeys.getOrdinal()], headerElement);
        if (bl3) {
            this.headerValues[headerKeys.getOrdinal()] = headerElement;
        }
    }

    private HeaderElement getElement(HeaderKeys headerKeys) {
        HeaderElement headerElement = this.headerElements;
        if (null != headerElement) {
            this.headerElements = headerElement.nextInstance;
            headerElement.nextInstance = null;
            headerElement.init(headerKeys);
        } else {
            headerElement = new HeaderElement(headerKeys, this);
        }
        return headerElement;
    }

    private HeaderElement getElement(String string) {
        HeaderElement headerElement = this.headerElements;
        if (null != headerElement) {
            this.headerElements = headerElement.nextInstance;
            headerElement.nextInstance = null;
            headerElement.init(string);
        } else {
            headerElement = new HeaderElement(string, this);
        }
        return headerElement;
    }

    protected void freeElement(HeaderElement headerElement) {
        headerElement.nextInstance = this.headerElements;
        this.headerElements = headerElement;
    }

    private HeaderElement findHeader(HeaderKeys headerKeys, int n) {
        HeaderElement headerElement = this.headerValues[headerKeys.getOrdinal()];
        int n2 = -1;
        while (null != headerElement) {
            if (!headerElement.wasRemoved() && ++n2 == n) {
                return headerElement;
            }
            headerElement = headerElement.nextInstance;
        }
        return null;
    }

    private void removeKnownHeader(HeaderKeys headerKeys, int n) {
        HeaderElement headerElement = this.findHeader(headerKeys, n);
        if (null != headerElement) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing " + headerElement.getName() + " (" + n + ") [" + headerElement.getDebugValue() + "]");
            }
            headerElement.remove();
            if (headerKeys.useFilters()) {
                headerKeys.filterRemHeader(this, headerElement.getByteArrayValue());
            }
        }
    }

    private void removeKnownHeader(HeaderKeys headerKeys, boolean bl) {
        HeaderElement headerElement = this.findHeader(headerKeys, 0);
        if (null != headerElement) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing known header [" + headerElement.getName() + "]");
            }
            if (bl && headerKeys.useFilters()) {
                headerKeys.filterRemHeader(this, null);
            }
            while (null != headerElement) {
                headerElement.remove();
                headerElement = headerElement.nextInstance;
            }
        }
    }

    private void replaceKnownHeader(HeaderKeys headerKeys, byte[] byArray, int n) {
        HeaderElement headerElement;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Replacing known header " + headerKeys.getName() + " (" + n + ")");
        }
        if (null != (headerElement = this.findHeader(headerKeys, n))) {
            if (headerKeys.useFilters()) {
                byte[] byArray2 = headerElement.getByteArrayValue();
                headerKeys.filterRemHeader(this, byArray2);
                if (!headerKeys.filterAddHeader(this, byArray)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "replaceHeader failed filterAdd: " + GenericUtils.getEnglishString(byArray));
                    }
                    headerKeys.filterAddHeader(this, byArray2);
                    return;
                }
            }
            headerElement.setByteArrayValue(byArray);
            ++this.headerChangeCount;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Value replaced with [" + headerElement.getDebugValue() + "]");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Instance not found");
        }
    }

    private void replaceKnownHeader(HeaderKeys headerKeys, String string, int n) {
        HeaderElement headerElement;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Replacing known header " + headerKeys.getName() + " (" + n + ")");
        }
        if (null != (headerElement = this.findHeader(headerKeys, n))) {
            if (headerKeys.useFilters()) {
                byte[] byArray = headerElement.getByteArrayValue();
                headerKeys.filterRemHeader(this, byArray);
                if (!headerKeys.filterAddHeader(this, GenericUtils.getEnglishBytes(string))) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "replaceHeader failed filterAdd: " + string);
                    }
                    headerKeys.filterAddHeader(this, byArray);
                    return;
                }
            }
            headerElement.setStringValue(string);
            ++this.headerChangeCount;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Value replaced with [" + headerElement.getDebugValue() + "]");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Instance not found");
        }
    }

    protected void setSpecialHeader(HeaderKeys headerKeys, byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setSpecialHeader(h,b[]): " + headerKeys.getName());
        }
        this.removeKnownHeader(headerKeys, false);
        HeaderElement headerElement = this.getElement(headerKeys);
        headerElement.setByteArrayValue(byArray);
        this.addKnownHeader(headerKeys, headerElement, true, false);
    }

    protected void setSpecialHeader(HeaderKeys headerKeys, String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setSpecialHeader(h,s): " + headerKeys.getName());
        }
        this.removeKnownHeader(headerKeys, false);
        HeaderElement headerElement = this.getElement(headerKeys);
        headerElement.setStringValue(string);
        this.addKnownHeader(headerKeys, headerElement, true, false);
    }

    protected boolean overHeaderChangeLimit() {
        if (this.bOverChangeLimit || -1 == this.parseIndex) {
            return true;
        }
        this.bOverChangeLimit = this.headerChangeCount >= this.headerChangeLimit;
        return this.bOverChangeLimit;
    }

    public void setHeaderChangeLimit(int n) {
        this.headerChangeLimit = n;
        this.bOverChangeLimit = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting header change limit to " + n);
        }
    }

    public int getHeaderChangeLimit() {
        return this.headerChangeLimit;
    }

    protected WsByteBuffer[] marshallKnownHeader(WsByteBuffer[] wsByteBufferArray, HeaderElement headerElement) {
        if (headerElement.wasRemoved()) {
            return wsByteBufferArray;
        }
        if (null != headerElement.getRawByteArrayValue()) {
            wsByteBufferArray = this.putBytes(headerElement.getHeaderKey().getMarshalledByteArray(), wsByteBufferArray);
            wsByteBufferArray = this.putBytes(headerElement.getRawByteArrayValue(), headerElement.getOffset(), headerElement.getValueLength(), wsByteBufferArray);
            wsByteBufferArray = this.putBytes(BNFHeaders.EOL, wsByteBufferArray);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Marshalling known: " + headerElement.getHeaderKey() + " [" + headerElement.getDebugValue() + "]");
            }
        }
        return wsByteBufferArray;
    }

    protected WsByteBuffer[] marshallKnownBinaryHeader(WsByteBuffer[] wsByteBufferArray, HeaderElement headerElement) {
        if (headerElement.wasRemoved()) {
            return wsByteBufferArray;
        }
        if (null != headerElement.getRawByteArrayValue()) {
            wsByteBufferArray = this.putInt(1, wsByteBufferArray);
            wsByteBufferArray = this.putInt(headerElement.getHeaderKey().getOrdinal(), wsByteBufferArray);
            wsByteBufferArray = this.putInt(headerElement.getValueLength(), wsByteBufferArray);
            wsByteBufferArray = this.putBytes(headerElement.getRawByteArrayValue(), headerElement.getOffset(), headerElement.getValueLength(), wsByteBufferArray);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Marshalling known: " + headerElement.getName() + " [" + headerElement.getDebugValue() + "]");
            }
        }
        return wsByteBufferArray;
    }

    private void createSingleHeader(String string, byte[] byArray) {
        boolean bl;
        HeaderElement headerElement = this.findHeader(string, 0);
        boolean bl2 = bl = null == headerElement;
        if (!bl) {
            if (null != headerElement.nextInstance) {
                HeaderElement headerElement2 = headerElement.nextInstance;
                while (null != headerElement2) {
                    headerElement2.remove();
                    headerElement2 = headerElement2.nextInstance;
                }
            }
            if (-1 < this.headerChangeLimit) {
                if (byArray.length <= headerElement.getValueLength()) {
                    ++this.headerChangeCount;
                    headerElement.setByteArrayValue(byArray);
                } else {
                    headerElement.remove();
                    bl = true;
                }
            } else {
                headerElement.setByteArrayValue(byArray);
            }
        }
        if (bl) {
            headerElement = this.getElement(string);
            headerElement.setByteArrayValue(byArray);
            this.addUnknownHeader(string, headerElement, true);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Replacing unknown header " + string + " with [" + headerElement.getStringValue() + "]");
        }
    }

    private void createSingleHeader(String string, byte[] byArray, int n, int n2) {
        boolean bl;
        HeaderElement headerElement = this.findHeader(string, 0);
        boolean bl2 = bl = null == headerElement;
        if (!bl) {
            if (null != headerElement.nextInstance) {
                HeaderElement headerElement2 = headerElement.nextInstance;
                while (null != headerElement2) {
                    headerElement2.remove();
                    headerElement2 = headerElement2.nextInstance;
                }
            }
            if (-1 < this.headerChangeLimit) {
                if (n2 <= headerElement.getValueLength()) {
                    ++this.headerChangeCount;
                    headerElement.setByteArrayValue(byArray, n, n2);
                } else {
                    headerElement.remove();
                    bl = true;
                }
            } else {
                headerElement.setByteArrayValue(byArray, n, n2);
            }
        }
        if (bl) {
            headerElement = this.getElement(string);
            headerElement.setByteArrayValue(byArray, n, n2);
            this.addUnknownHeader(string, headerElement, true);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Replacing unknown header " + string + " with [" + headerElement.getStringValue() + "]");
        }
    }

    private void createSingleHeader(String string, String string2) {
        boolean bl;
        HeaderElement headerElement = this.findHeader(string, 0);
        boolean bl2 = bl = null == headerElement;
        if (!bl) {
            if (null != headerElement.nextInstance) {
                HeaderElement headerElement2 = headerElement.nextInstance;
                while (null != headerElement2) {
                    headerElement2.remove();
                    headerElement2 = headerElement2.nextInstance;
                }
            }
            if (-1 < this.headerChangeLimit) {
                if (string2.length() <= headerElement.getValueLength()) {
                    ++this.headerChangeCount;
                    headerElement.setStringValue(string2);
                } else {
                    headerElement.remove();
                    bl = true;
                }
            } else {
                headerElement.setStringValue(string2);
            }
        }
        if (bl) {
            headerElement = this.getElement(string);
            headerElement.setStringValue(string2);
            this.addUnknownHeader(string, headerElement, true);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Replacing unknown header " + string + " with [" + headerElement.getStringValue() + "]");
        }
    }

    private void addUnknownHeader(String string, HeaderElement headerElement, boolean bl) {
        boolean bl2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding unknown header [" + string + "] with value [" + headerElement.getStringValue() + "]");
        }
        this.incrementHeaderCounter();
        HeaderElement headerElement2 = this.getUnknownHeader(string);
        boolean bl3 = bl2 = bl ? this.addInstanceOfElement(headerElement2, headerElement) : this.addLeadingInstanceOfElement(headerElement2, headerElement);
        if (bl2) {
            this.putUnknownHeader(string, headerElement);
        }
    }

    protected void appendHeaderNoMatch(String string, byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appendHeaderNoMatch: " + string);
        }
        HeaderElement headerElement = this.getElement(string);
        headerElement.setByteArrayValue(byArray);
        this.addUnknownHeader(string, headerElement, true);
    }

    private HeaderElement deleteUnknownHeader(String string) {
        if (null == this.otherHeaders) {
            return null;
        }
        String string2 = Normalizer.normalize(string, 2);
        return (HeaderElement)this.otherHeaders.remove(string2);
    }

    private HeaderElement getUnknownHeader(String string) {
        if (null == this.otherHeaders) {
            return null;
        }
        String string2 = Normalizer.normalize(string, 2);
        return (HeaderElement)this.otherHeaders.get(string2);
    }

    private HeaderElement findHeader(String string, int n) {
        HeaderKeys headerKeys = this.getMatcher().matchHeader(string);
        HeaderElement headerElement = headerKeys.equals(GenericConstants.NO_MATCH) ? this.getUnknownHeader(string) : this.headerValues[headerKeys.getOrdinal()];
        int n2 = -1;
        while (null != headerElement) {
            if (!headerElement.wasRemoved() && ++n2 == n) {
                return headerElement;
            }
            headerElement = headerElement.nextInstance;
        }
        return headerElement;
    }

    private HeaderElement findHeader(byte[] byArray, int n) {
        HeaderKeys headerKeys = this.getMatcher().matchHeader(byArray);
        HeaderElement headerElement = headerKeys.equals(GenericConstants.NO_MATCH) ? this.getUnknownHeader(GenericUtils.getEnglishString(byArray)) : this.headerValues[headerKeys.getOrdinal()];
        int n2 = -1;
        while (null != headerElement) {
            if (!headerElement.wasRemoved() && ++n2 == n) {
                return headerElement;
            }
            headerElement = headerElement.nextInstance;
        }
        return headerElement;
    }

    private void putUnknownHeader(String string, HeaderElement headerElement) {
        if (null == this.otherHeaders) {
            this.otherHeaders = new FastNonSynchHashTable(32);
        }
        String string2 = Normalizer.normalize(string, 2);
        this.otherHeaders.forcePut(string2, headerElement);
    }

    private void removeUnknownHeader(String string, int n) {
        HeaderElement headerElement = this.getUnknownHeader(string);
        int n2 = -1;
        while (null != headerElement) {
            if (!headerElement.wasRemoved() && ++n2 == n) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removing unknown " + string + " (" + n + ") [" + headerElement.getStringValue() + "]");
                }
                headerElement.remove();
                return;
            }
            headerElement = headerElement.nextInstance;
        }
    }

    private void removeUnknownHeader(String string) {
        HeaderElement headerElement = this.getUnknownHeader(string);
        if (null == headerElement) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Removing unknown header [" + string + "]");
        }
        while (null != headerElement) {
            headerElement.remove();
            headerElement = headerElement.nextInstance;
        }
    }

    private void replaceUnknownHeader(String string, byte[] byArray, int n) {
        HeaderElement headerElement;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Replacing unknown header " + string + " (" + n + ") with [" + GenericUtils.getEnglishString(byArray) + "]");
        }
        if (null != (headerElement = this.findHeader(string, n))) {
            headerElement.setByteArrayValue(byArray);
            ++this.headerChangeCount;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Instance not found");
        }
    }

    private void replaceUnknownHeader(String string, String string2, int n) {
        HeaderElement headerElement;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Replacing unknown header " + string + " (" + n + ") with [" + string2 + "]");
        }
        if (null != (headerElement = this.findHeader(string, n))) {
            headerElement.setStringValue(string2);
            ++this.headerChangeCount;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Instance not found");
        }
    }

    protected WsByteBuffer[] marshallUnknownHeader(WsByteBuffer[] wsByteBufferArray, HeaderElement headerElement) {
        if (headerElement.wasRemoved()) {
            return wsByteBufferArray;
        }
        if (null != headerElement.getRawByteArrayValue()) {
            wsByteBufferArray = this.putBytes(GenericUtils.getEnglishBytes(headerElement.getHeaderString()), wsByteBufferArray);
            wsByteBufferArray = this.putBytes(KEY_VALUE_SEPARATOR, wsByteBufferArray);
            wsByteBufferArray = this.putBytes(headerElement.getRawByteArrayValue(), headerElement.getOffset(), headerElement.getValueLength(), wsByteBufferArray);
            wsByteBufferArray = this.putBytes(EOL, wsByteBufferArray);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Marshalling unknown: " + headerElement.getHeaderString() + " [" + headerElement.getStringValue() + "]");
            }
        }
        return wsByteBufferArray;
    }

    protected WsByteBuffer[] marshallUnknownBinaryHeader(WsByteBuffer[] wsByteBufferArray, HeaderElement headerElement) {
        if (headerElement.wasRemoved()) {
            return wsByteBufferArray;
        }
        if (null != headerElement.getRawByteArrayValue()) {
            byte[] byArray = GenericUtils.getEnglishBytes(headerElement.getHeaderString());
            wsByteBufferArray = this.putInt(2, wsByteBufferArray);
            wsByteBufferArray = this.putInt(byArray.length, wsByteBufferArray);
            wsByteBufferArray = this.putBytes(byArray, wsByteBufferArray);
            wsByteBufferArray = this.putInt(headerElement.getValueLength(), wsByteBufferArray);
            wsByteBufferArray = this.putBytes(headerElement.getRawByteArrayValue(), headerElement.getOffset(), headerElement.getValueLength(), wsByteBufferArray);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Marshalling unknown: " + headerElement.getHeaderString() + " [" + headerElement.getStringValue() + "]");
            }
        }
        return wsByteBufferArray;
    }

    protected final int getBinaryParseState() {
        return this.binaryParsingState;
    }

    protected final void setBinaryParseState(int n) {
        this.binaryParsingState = n;
    }

    public WsByteBuffer allocateBuffer(int n) {
        WsByteBuffer wsByteBuffer = this.useDirectBuffer ? WsByteBufferPoolManagerImpl.getRef().allocateDirect(n) : WsByteBufferPoolManagerImpl.getRef().allocate(n);
        this.addToCreatedBuffer(wsByteBuffer);
        return wsByteBuffer;
    }

    public final WsByteBuffer getCurrentBuffer() {
        return this.currentReadBB;
    }

    public final void setCurrentBuffer(WsByteBuffer wsByteBuffer) {
        this.currentReadBB = wsByteBuffer;
    }

    public void setDebugContext(Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "debugContext set to " + object + " for " + this);
        }
        if (null != object) {
            this.debugContext = object;
        }
    }

    protected final Object getDebugContext() {
        return this.debugContext;
    }

    protected final int getIncomingBufferSize() {
        return this.incomingBufferSize;
    }

    protected final int getOutgoingBufferSize() {
        return this.outgoingHdrBufferSize;
    }

    protected final boolean shouldAllocateDirectBuffer() {
        return this.useDirectBuffer;
    }

    protected final void setParsedToken(byte[] byArray) {
        this.parsedToken = byArray;
    }

    protected final byte[] getParsedToken() {
        return this.parsedToken;
    }

    protected final int getByteCacheSize() {
        return this.byteCacheSize;
    }

    protected WsByteBuffer getParseBuffer(int n) {
        if (0 > n || n >= this.parseBuffers.length) {
            return null;
        }
        return this.parseBuffers[n];
    }

    public final int getBuffersIndex() {
        return this.parseIndex;
    }

    public void setLimitOfTokenSize(int n) {
        if (0 >= n) {
            throw new IllegalArgumentException("Invalid limit on token size: " + n);
        }
        this.limitTokenSize = n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Limit on token size now: " + this.limitTokenSize);
        }
    }

    public final int getLimitOfTokenSize() {
        return this.limitTokenSize;
    }

    public final int getNumberOfHeaders() {
        return this.numberOfHeaders;
    }

    private void incrementHeaderCounter() {
        ++this.numberOfHeaders;
        ++this.headerAddCount;
        if (this.limitNumHeaders < this.numberOfHeaders) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Too many headers in storage: " + this.numberOfHeaders);
            }
            throw new IllegalArgumentException("Too many headers in storage: " + this.numberOfHeaders);
        }
    }

    void decrementHeaderCounter() {
        --this.numberOfHeaders;
        ++this.headerChangeCount;
        if (0 > this.numberOfHeaders) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Number of headers counter went negative");
            }
            this.numberOfHeaders = 0;
        }
    }

    public final void setLimitOnNumberOfHeaders(int n) {
        if (0 >= n) {
            throw new IllegalArgumentException("Invalid limit on number headers: " + n);
        }
        this.limitNumHeaders = n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Limit on number of headers now: " + this.limitNumHeaders);
        }
    }

    public final int getLimitOnNumberOfHeaders() {
        return this.limitNumHeaders;
    }

    protected final void setHeaderValidation(boolean bl) {
        this.bHeaderValidation = bl;
    }

    private void checkHeaderName(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if (13 != byArray[i] && 10 != byArray[i]) continue;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Illegal CRLF found in name");
            FFDCFilter.processException((Throwable)illegalArgumentException, this.getClass().getName() + ".checkHeaderName(byte[])", "1", this);
            throw illegalArgumentException;
        }
    }

    private void checkHeaderName(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('\r' != c && '\n' != c) continue;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Illegal CRLF found in name");
            FFDCFilter.processException((Throwable)illegalArgumentException, this.getClass().getName() + ".checkHeaderName(String)", "1", this);
            throw illegalArgumentException;
        }
    }

    private void checkHeaderValue(byte[] byArray, int n, int n2) {
        int n3 = n + n2 - 1;
        if (n3 < 0) {
            return;
        }
        String string = null;
        if (10 == byArray[n3] || 13 == byArray[n3]) {
            string = "Illegal trailing EOL";
        }
        for (int i = n; null == string && i < n3; ++i) {
            if (13 == byArray[i]) {
                if (10 == byArray[i + 1]) continue;
                string = "Invalid CR not followed by LF";
                continue;
            }
            if (10 != byArray[i] || 9 == byArray[++i] || 32 == byArray[i]) continue;
            string = "Invalid LF not followed by whitespace";
        }
        if (null != string) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            FFDCFilter.processException((Throwable)illegalArgumentException, this.getClass().getName() + ".checkHeaderValue(byte[])", "1", this);
            throw illegalArgumentException;
        }
    }

    private void checkHeaderValue(String string) {
        int n = string.length() - 1;
        if (n < 0) {
            return;
        }
        String string2 = null;
        char c = string.charAt(n);
        if ('\n' == c || '\r' == c) {
            string2 = "Illegal trailing EOL";
        }
        for (int i = 0; null == string2 && i < n; ++i) {
            c = string.charAt(i);
            if ('\r' == c) {
                if ('\n' == string.charAt(i + 1)) continue;
                string2 = "Invalid CR not followed by LF";
                continue;
            }
            if ('\n' != c || '\t' == (c = string.charAt(++i)) || ' ' == c) continue;
            string2 = "Invalid LF not followed by whitespace";
        }
        if (null != string2) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
            FFDCFilter.processException((Throwable)illegalArgumentException, this.getClass().getName() + ".checkHeaderValue(String)", "1", this);
            throw illegalArgumentException;
        }
    }

    private int countInstances(HeaderElement headerElement) {
        int n = 0;
        while (null != headerElement) {
            if (!headerElement.wasRemoved()) {
                ++n;
            }
            headerElement = headerElement.nextInstance;
        }
        return n;
    }

    private int compareByteArrays(HeaderElement headerElement, byte[] byArray) {
        if (null == headerElement) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Compare failed against nonexistant header");
            }
            return -1;
        }
        if (null != headerElement) {
            HeaderElement headerElement2 = headerElement;
            while (null != headerElement2) {
                if (!headerElement2.wasRemoved()) {
                    int n;
                    byte[] byArray2 = headerElement2.getByteArrayValue();
                    if (byArray2.length != byArray.length) {
                        headerElement2 = headerElement2.nextInstance;
                        continue;
                    }
                    for (n = 0; n < byArray2.length && byArray2[n] == byArray[n]; ++n) {
                    }
                    if (n == byArray2.length) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Compare found a match");
                        }
                        return 1;
                    }
                }
                headerElement2 = headerElement2.nextInstance;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Compare did not find a match");
        }
        return 0;
    }

    private int compareStrings(HeaderElement headerElement, String string) {
        if (null == headerElement) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Compare against missing header");
            }
            return -1;
        }
        if (null != headerElement) {
            HeaderElement headerElement2 = headerElement;
            while (null != headerElement2) {
                if (!headerElement2.wasRemoved() && headerElement2.getStringValue().equals(string)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Compare found a match");
                    }
                    return 1;
                }
                headerElement2 = headerElement2.nextInstance;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Compare did not find a match");
        }
        return 0;
    }

    private int findSequencePosition(HeaderElement headerElement) {
        if (null != headerElement) {
            int n = 0;
            HeaderElement headerElement2 = this.hdrSequence;
            while (null != headerElement2) {
                if (!headerElement2.wasRemoved()) {
                    if (headerElement2.isSameName(headerElement)) {
                        return n;
                    }
                    ++n;
                }
                headerElement2 = headerElement2.nextSequence;
            }
        }
        return -1;
    }

    private boolean skipWhiteSpace(WsByteBuffer wsByteBuffer) {
        byte by;
        do {
            if (this.bytePosition < this.byteLimit || this.fillByteCache(wsByteBuffer)) continue;
            return false;
        } while (32 == (by = this.byteCache[this.bytePosition++]) || 9 == by);
        --this.bytePosition;
        return true;
    }

    private boolean addInstanceOfElement(HeaderElement headerElement, HeaderElement headerElement2) {
        this.addToSequenceList(headerElement2);
        if (null == headerElement) {
            return true;
        }
        while (null != headerElement.nextInstance) {
            headerElement = headerElement.nextInstance;
        }
        headerElement.nextInstance = headerElement2;
        return false;
    }

    private boolean addLeadingInstanceOfElement(HeaderElement headerElement, HeaderElement headerElement2) {
        if (null == headerElement) {
            this.addToSequenceList(headerElement2);
        } else {
            headerElement2.nextInstance = headerElement;
            this.prependHeaderInSequence(headerElement, headerElement2);
        }
        return true;
    }

    private void addToSequenceList(int n, HeaderElement headerElement) {
        if (null == this.hdrSequence) {
            this.hdrSequence = headerElement;
            this.lastHdrInSequence = headerElement;
        } else if (0 == n) {
            headerElement.nextSequence = this.hdrSequence;
            this.hdrSequence.prevSequence = headerElement;
            this.hdrSequence = headerElement;
        } else if (-1 == n) {
            this.lastHdrInSequence.nextSequence = headerElement;
            headerElement.prevSequence = this.lastHdrInSequence;
            this.lastHdrInSequence = headerElement;
        } else {
            HeaderElement headerElement2 = this.hdrSequence;
            HeaderElement headerElement3 = null;
            for (int i = 0; i < n && null != headerElement2; ++i) {
                headerElement3 = headerElement2;
                headerElement2 = headerElement2.nextSequence;
            }
            headerElement3.nextSequence = headerElement;
            headerElement.prevSequence = headerElement3;
            headerElement.nextSequence = headerElement2;
            if (null != headerElement2) {
                headerElement2.prevSequence = headerElement;
            } else {
                this.lastHdrInSequence = headerElement;
            }
        }
    }

    private void addToSequenceList(HeaderElement headerElement) {
        if (null == this.hdrSequence) {
            this.hdrSequence = headerElement;
            this.lastHdrInSequence = headerElement;
        } else {
            this.lastHdrInSequence.nextSequence = headerElement;
            headerElement.prevSequence = this.lastHdrInSequence;
            this.lastHdrInSequence = headerElement;
        }
    }

    private void prependHeaderInSequence(HeaderElement headerElement, HeaderElement headerElement2) {
        HeaderElement headerElement3 = headerElement.prevSequence;
        headerElement2.nextSequence = headerElement;
        headerElement2.prevSequence = headerElement3;
        headerElement.prevSequence = headerElement2;
        if (null != headerElement3) {
            headerElement3.nextSequence = headerElement2;
        } else {
            this.hdrSequence = headerElement2;
        }
    }

    private void removeHeaderFromSequence(HeaderElement headerElement) {
        HeaderElement headerElement2 = headerElement.nextSequence;
        HeaderElement headerElement3 = headerElement.prevSequence;
        if (null != headerElement3) {
            headerElement3.nextSequence = headerElement2;
        } else {
            this.hdrSequence = headerElement2;
        }
        if (null != headerElement.nextSequence) {
            headerElement2.prevSequence = headerElement3;
        } else {
            this.lastHdrInSequence = headerElement3;
        }
        headerElement.nextSequence = null;
        headerElement.prevSequence = null;
    }

    protected WsByteBuffer[] putInt(int n, WsByteBuffer[] wsByteBufferArray) {
        return this.putBytes(GenericUtils.asBytes(n), wsByteBufferArray);
    }

    protected WsByteBuffer[] putByte(byte by, WsByteBuffer[] wsByteBufferArray) {
        this.byteCache[this.bytePosition] = by;
        ++this.bytePosition;
        if (this.bytePosition >= this.byteCacheSize) {
            wsByteBufferArray = this.flushFullCache(wsByteBufferArray);
        }
        return wsByteBufferArray;
    }

    protected WsByteBuffer[] putBytes(byte[] byArray, WsByteBuffer[] wsByteBufferArray) {
        int n = this.byteCacheSize - this.bytePosition;
        if (byArray.length <= n) {
            System.arraycopy(byArray, 0, this.byteCache, this.bytePosition, byArray.length);
            this.bytePosition += byArray.length;
        } else {
            wsByteBufferArray = this.flushCache(wsByteBufferArray);
            return GenericUtils.putByteArray(wsByteBufferArray, byArray, 0, byArray.length, this);
        }
        if (this.bytePosition == this.byteCacheSize) {
            wsByteBufferArray = this.flushFullCache(wsByteBufferArray);
        }
        return wsByteBufferArray;
    }

    protected WsByteBuffer[] putBytes(byte[] byArray, int n, int n2, WsByteBuffer[] wsByteBufferArray) {
        int n3 = this.byteCacheSize - this.bytePosition;
        if (n2 <= n3) {
            System.arraycopy(byArray, n, this.byteCache, this.bytePosition, n2);
            this.bytePosition += n2;
        } else {
            wsByteBufferArray = this.flushCache(wsByteBufferArray);
            return GenericUtils.putByteArray(wsByteBufferArray, byArray, n, n2, this);
        }
        if (this.bytePosition == this.byteCacheSize) {
            wsByteBufferArray = this.flushFullCache(wsByteBufferArray);
        }
        return wsByteBufferArray;
    }

    protected WsByteBuffer[] flushFullCache(WsByteBuffer[] wsByteBufferArray) {
        this.bytePosition = 0;
        return GenericUtils.putByteArray(wsByteBufferArray, this.byteCache, this);
    }

    protected WsByteBuffer[] flushCache(WsByteBuffer[] wsByteBufferArray) {
        int n = this.bytePosition;
        if (0 == n) {
            return wsByteBufferArray;
        }
        this.bytePosition = 0;
        return GenericUtils.putByteArray(wsByteBufferArray, this.byteCache, 0, n, this);
    }

    protected final void resetByteCache() {
        if (this.isByteBufferArray) {
            this.byteCache = this.originalByteCache;
            this.isByteBufferArray = false;
        }
        this.bytePosition = 0;
        this.byteLimit = 0;
    }

    protected final void setBytePosition(int n) {
        this.bytePosition = n;
    }

    protected final void decrementBytePosition() {
        --this.bytePosition;
        if (0 > this.bytePosition && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Negative byteposition: " + this.bytePosition);
        }
    }

    protected final void decrementBytePositionIgnoringLFs() {
        --this.bytePosition;
        if (10 == this.byteCache[this.bytePosition]) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "decrementILF found an LF character");
            }
            ++this.bytePosition;
        }
    }

    protected final int getBytePosition() {
        return this.bytePosition;
    }

    protected final int getByteLimit() {
        return this.byteLimit;
    }

    protected final void clearCacheToken() {
        this.parsedToken = null;
        this.parsedTokenLength = 0;
    }

    protected final void createCacheToken(int n) {
        this.parsedToken = new byte[n];
        this.parsedTokenLength = 0;
    }

    protected final void resetCacheToken(int n) {
        if (null == this.parsedToken || n != this.parsedToken.length) {
            this.parsedToken = new byte[n];
        }
        this.parsedTokenLength = 0;
    }

    protected final boolean fillCacheToken(WsByteBuffer wsByteBuffer) {
        int n;
        int n2 = this.parsedTokenLength;
        int n3 = n = this.parsedToken.length - n2;
        while (0 < n) {
            if (this.bytePosition >= this.byteLimit && !this.fillByteCache(wsByteBuffer)) {
                this.parsedTokenLength = n2;
                return false;
            }
            int n4 = this.byteLimit - this.bytePosition;
            n3 = n4 < n ? n4 : n;
            System.arraycopy(this.byteCache, this.bytePosition, this.parsedToken, n2, n3);
            n -= n3;
            n2 += n3;
            this.bytePosition += n3;
        }
        return true;
    }

    protected boolean fillByteCache(WsByteBuffer wsByteBuffer) {
        if (this.bytePosition < this.byteLimit) {
            return false;
        }
        if (wsByteBuffer.hasArray()) {
            this.bytePosition = wsByteBuffer.position();
            this.byteLimit = wsByteBuffer.limit();
            if (this.bytePosition == this.byteLimit) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Already parsed entire indirect buffer");
                }
                return false;
            }
            wsByteBuffer.position(this.byteLimit);
            this.byteCache = wsByteBuffer.array();
            this.isByteBufferArray = true;
            if (-1 != this.headerChangeLimit && -1 != this.parseIndex && -1 == this.parseBuffersStartPos[this.parseIndex]) {
                this.parseBuffersStartPos[this.parseIndex] = this.bytePosition;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Grabbed a Heap buffer's array");
            }
        } else {
            int n;
            if (this.isByteBufferArray) {
                this.byteCache = this.originalByteCache;
                this.isByteBufferArray = false;
            }
            if ((n = wsByteBuffer.remaining()) > this.byteCacheSize) {
                n = this.byteCacheSize;
            }
            this.bytePosition = 0;
            this.byteLimit = n;
            if (0 == this.byteLimit) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "fillByteCache: no data");
                }
                return false;
            }
            if (-1 != this.headerChangeLimit && -1 != this.parseIndex && -1 == this.parseBuffersStartPos[this.parseIndex]) {
                this.parseBuffersStartPos[this.parseIndex] = wsByteBuffer.position();
            }
            wsByteBuffer.get(this.byteCache, this.bytePosition, this.byteLimit);
        }
        return true;
    }

    private int findCurrentBufferPosition(WsByteBuffer wsByteBuffer) {
        if (this.isByteBufferArray) {
            return this.bytePosition;
        }
        return wsByteBuffer.position() - (this.byteLimit - this.bytePosition);
    }

    protected TokenCodes findCRLFTokenLength(WsByteBuffer wsByteBuffer) throws MalformedMessageException {
        TokenCodes tokenCodes = TokenCodes.TOKEN_RC_MOREDATA;
        if (null == wsByteBuffer) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Null buffer provided");
            }
            return tokenCodes;
        }
        int n = this.parsedTokenLength;
        while (this.bytePosition < this.byteLimit || this.fillByteCache(wsByteBuffer)) {
            byte by;
            if (13 == (by = this.byteCache[this.bytePosition++])) {
                tokenCodes = TokenCodes.TOKEN_RC_DELIM;
                if (-1 == this.headerChangeLimit) break;
                this.lastCRLFPosition = this.findCurrentBufferPosition(wsByteBuffer) - 1;
                this.lastCRLFBufferIndex = this.parseIndex;
                this.lastCRLFisCR = true;
                break;
            }
            if (10 == by) {
                tokenCodes = TokenCodes.TOKEN_RC_DELIM;
                this.numCRLFs = 1;
                if (-1 == this.headerChangeLimit) break;
                this.lastCRLFPosition = this.findCurrentBufferPosition(wsByteBuffer) - 1;
                this.lastCRLFBufferIndex = this.parseIndex;
                this.lastCRLFisCR = false;
                break;
            }
            if (++n <= this.limitTokenSize) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "findCRLFTokenLength: length is too big: " + n);
            }
            throw new MalformedMessageException("Token length: " + n);
        }
        this.parsedTokenLength = n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "findCRLFTokenLength returning " + tokenCodes.getName() + "; len=" + n);
        }
        return tokenCodes;
    }

    protected TokenCodes findTokenLength(WsByteBuffer wsByteBuffer, byte by, boolean bl) throws MalformedMessageException {
        TokenCodes tokenCodes = TokenCodes.TOKEN_RC_MOREDATA;
        if (null == wsByteBuffer) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "findTokenLength: null buffer provided");
            }
            return tokenCodes;
        }
        int n = this.parsedTokenLength;
        while (this.bytePosition < this.byteLimit || this.fillByteCache(wsByteBuffer)) {
            byte by2;
            if (by == (by2 = this.byteCache[this.bytePosition++])) {
                tokenCodes = TokenCodes.TOKEN_RC_DELIM;
                break;
            }
            if (13 == by2) {
                if (!bl) {
                    throw new MalformedMessageException("Invalid CR found in token");
                }
                tokenCodes = TokenCodes.TOKEN_RC_CRLF;
                if (-1 == this.headerChangeLimit) break;
                this.lastCRLFPosition = this.findCurrentBufferPosition(wsByteBuffer) - 1;
                this.lastCRLFBufferIndex = this.parseIndex;
                this.lastCRLFisCR = true;
                break;
            }
            if (10 == by2) {
                if (!bl) {
                    throw new MalformedMessageException("Invalid LF found in token");
                }
                tokenCodes = TokenCodes.TOKEN_RC_CRLF;
                this.numCRLFs = 1;
                if (-1 == this.headerChangeLimit) break;
                this.lastCRLFPosition = this.findCurrentBufferPosition(wsByteBuffer) - 1;
                this.lastCRLFBufferIndex = this.parseIndex;
                this.lastCRLFisCR = false;
                break;
            }
            if (++n <= this.limitTokenSize) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "findTokenLength: length is too big: " + n);
            }
            throw new MalformedMessageException("Token length: " + n);
        }
        this.parsedTokenLength = n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "findTokenLength: [" + (char)by + "] " + tokenCodes.getName() + "; len=" + n);
        }
        return tokenCodes;
    }

    protected TokenCodes skipCRLFs(WsByteBuffer wsByteBuffer) {
        int n = 33;
        if (this.bytePosition >= this.byteLimit && !this.fillByteCache(wsByteBuffer)) {
            return TokenCodes.TOKEN_RC_MOREDATA;
        }
        byte by = this.byteCache[this.bytePosition++];
        for (int i = 0; i < n; ++i) {
            if (-1 == by) {
                return TokenCodes.TOKEN_RC_MOREDATA;
            }
            if (13 != by && 10 != by) {
                this.decrementBytePosition();
                return TokenCodes.TOKEN_RC_DELIM;
            }
            if (this.bytePosition >= this.byteLimit) {
                return TokenCodes.TOKEN_RC_MOREDATA;
            }
            by = this.byteCache[this.bytePosition++];
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Too many leading CRLFs found");
        }
        return TokenCodes.TOKEN_RC_CRLF;
    }

    private boolean parseCRLFs(WsByteBuffer wsByteBuffer) throws MalformedMessageException {
        for (int i = 0; i < 4; ++i) {
            byte by;
            if (this.bytePosition >= this.byteLimit && !this.fillByteCache(wsByteBuffer)) {
                return false;
            }
            if (13 == (by = this.byteCache[this.bytePosition++])) continue;
            if (10 == by) {
                ++this.numCRLFs;
            } else {
                if (32 == by || 9 == by) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Multiline header follows");
                    }
                    this.bIsMultiLine = true;
                    if (null == this.lastElem) {
                        throw new MalformedMessageException("Incorrect multiline header value");
                    }
                    this.currentElem = this.lastElem;
                    this.stateOfParsing = 1;
                    this.numCRLFs = 0;
                    return true;
                }
                this.decrementBytePosition();
                break;
            }
            if (2 > this.numCRLFs) continue;
            this.eohPosition = this.isByteBufferArray ? this.bytePosition : wsByteBuffer.position() - (this.byteLimit - this.bytePosition);
            wsByteBuffer.position(this.eohPosition);
            break;
        }
        this.bIsMultiLine = false;
        this.stateOfParsing = 0;
        this.numCRLFs = 0;
        return true;
    }

    protected TokenCodes parseCRLFTokenExtract(WsByteBuffer wsByteBuffer, int n) throws MalformedMessageException {
        int n2;
        if (null == this.parsedToken && !this.skipWhiteSpace(wsByteBuffer)) {
            return TokenCodes.TOKEN_RC_MOREDATA;
        }
        int n3 = n2 = this.isByteBufferArray ? this.bytePosition : wsByteBuffer.position() - (this.byteLimit - this.bytePosition);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "parseCRLFTokenExtract: start:" + n2 + " lim:" + this.byteLimit + " pos:" + this.bytePosition);
        }
        TokenCodes tokenCodes = this.findCRLFTokenLength(wsByteBuffer);
        this.saveParsedToken(wsByteBuffer, n2, TokenCodes.TOKEN_RC_DELIM.equals(tokenCodes), n);
        return tokenCodes;
    }

    protected int parseCRLFTokenNonExtract(WsByteBuffer wsByteBuffer) throws MalformedMessageException {
        this.findCRLFTokenLength(wsByteBuffer);
        return this.parsedTokenLength;
    }

    protected TokenCodes findHeaderLength(WsByteBuffer wsByteBuffer) throws MalformedMessageException {
        TokenCodes tokenCodes = TokenCodes.TOKEN_RC_MOREDATA;
        if (null == wsByteBuffer) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "findHeaderLength: null buffer provided");
            }
            return tokenCodes;
        }
        int n = 0;
        int n2 = this.parsedTokenLength;
        while (this.bytePosition < this.byteLimit || this.fillByteCache(wsByteBuffer)) {
            byte by;
            if (58 == (by = this.byteCache[this.bytePosition++])) {
                n2 -= n;
                tokenCodes = TokenCodes.TOKEN_RC_DELIM;
                break;
            }
            n = 32 == by || 9 == by ? ++n : 0;
            if (13 == by || 10 == by) {
                throw new MalformedMessageException("Invalid CRLF found in header name");
            }
            if (++n2 <= this.limitTokenSize) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "findTokenLength: length is too big: " + n2);
            }
            throw new MalformedMessageException("Token length: " + n2);
        }
        this.parsedTokenLength = n2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "findHeaderLength: " + tokenCodes.getName() + "; len=" + n2);
        }
        return tokenCodes;
    }

    private boolean parseHeaderName(WsByteBuffer wsByteBuffer) throws MalformedMessageException {
        byte[] byArray;
        if (null == this.parsedToken && !this.skipWhiteSpace(wsByteBuffer)) {
            return false;
        }
        int n = this.isByteBufferArray ? this.bytePosition : wsByteBuffer.position() - (this.byteLimit - this.bytePosition);
        int n2 = this.bytePosition;
        TokenCodes tokenCodes = this.findHeaderLength(wsByteBuffer);
        if (TokenCodes.TOKEN_RC_MOREDATA.equals(tokenCodes)) {
            this.saveParsedToken(wsByteBuffer, n, false, 0);
            return false;
        }
        int n3 = this.parsedTokenLength;
        if (null == this.parsedToken && n3 < this.bytePosition) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Using bytecache, length=" + n3 + " pos=" + this.bytePosition + " start=" + n2);
            }
            byArray = this.byteCache;
            n = n2;
        } else {
            this.saveParsedToken(wsByteBuffer, n, true, 0);
            byArray = this.parsedToken;
            n = 0;
            n3 = byArray.length;
        }
        Object object = this.getMatcher().match(byArray, n, n3);
        if (null == object) {
            if (null == this.parsedToken) {
                this.parsedToken = new byte[n3];
                System.arraycopy(this.byteCache, n, this.parsedToken, 0, n3);
            }
            String string = GenericUtils.getEnglishString(this.parsedToken);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found unknown header name [" + string + "]");
            }
            this.currentElem = this.getElement(string);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found known header: " + object);
            }
            this.currentElem = this.getElement((HeaderKeys)object);
        }
        if (-1 != this.headerChangeLimit) {
            this.currentElem.updateLastCRLFInfo(this.lastCRLFBufferIndex, this.lastCRLFPosition, this.lastCRLFisCR);
        }
        this.stateOfParsing = 1;
        this.parsedToken = null;
        this.parsedTokenLength = 0;
        return true;
    }

    private boolean parseHeaderValueExtract(WsByteBuffer wsByteBuffer) throws MalformedMessageException {
        TokenCodes tokenCodes;
        int n = 0;
        HeaderKeys headerKeys = this.currentElem.getHeaderKey();
        if (null != headerKeys && !headerKeys.shouldLogValue()) {
            n = 1;
        }
        if (!(tokenCodes = this.parseCRLFTokenExtract(wsByteBuffer, n)).equals(TokenCodes.TOKEN_RC_MOREDATA)) {
            this.setHeaderValue();
            this.parsedToken = null;
            this.lastElem = this.currentElem;
            this.currentElem = null;
            this.stateOfParsing = 2;
            return true;
        }
        return false;
    }

    private boolean parseHeaderValueNonExtract(WsByteBuffer wsByteBuffer) throws MalformedMessageException {
        if (0 == this.parsedTokenLength) {
            if (!this.skipWhiteSpace(wsByteBuffer)) {
                return false;
            }
            int n = this.isByteBufferArray ? this.bytePosition : wsByteBuffer.position() - (this.byteLimit - this.bytePosition);
            this.currentElem.setParseInformation(this.parseIndex, n);
        }
        if (TokenCodes.TOKEN_RC_MOREDATA.equals(this.findCRLFTokenLength(wsByteBuffer))) {
            return false;
        }
        this.currentElem.setValueLength(this.parsedTokenLength);
        if (null != this.currentElem.getHeaderKey()) {
            this.addKnownHeader(this.currentElem.getHeaderKey(), this.currentElem, true, true);
        } else {
            this.addUnknownHeader(this.currentElem.getHeaderString(), this.currentElem, true);
        }
        this.parsedTokenLength = 0;
        this.lastElem = this.currentElem;
        this.currentElem = null;
        this.stateOfParsing = 2;
        return true;
    }

    protected TokenCodes parseTokenExtract(WsByteBuffer wsByteBuffer, byte by, boolean bl, int n) throws MalformedMessageException {
        TokenCodes tokenCodes;
        int n2;
        if (null == this.parsedToken && !this.skipWhiteSpace(wsByteBuffer)) {
            return TokenCodes.TOKEN_RC_MOREDATA;
        }
        int n3 = n2 = this.isByteBufferArray ? this.bytePosition : wsByteBuffer.position() - (this.byteLimit - this.bytePosition);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "parseTokenExtract: start:" + n2 + " lim:" + this.byteLimit + " pos:" + this.bytePosition);
        }
        this.saveParsedToken(wsByteBuffer, n2, !TokenCodes.TOKEN_RC_MOREDATA.equals(tokenCodes = this.findTokenLength(wsByteBuffer, by, bl)), n);
        return tokenCodes;
    }

    protected int parseTokenNonExtract(WsByteBuffer wsByteBuffer, byte by, boolean bl) throws MalformedMessageException {
        TokenCodes tokenCodes = this.findTokenLength(wsByteBuffer, by, bl);
        return TokenCodes.TOKEN_RC_MOREDATA.equals(tokenCodes) ? -1 : this.parsedTokenLength;
    }

    protected void setHeaderValue() throws MalformedMessageException {
        if (null == this.parsedToken) {
            this.parsedToken = new byte[]{32};
        }
        if (this.bIsMultiLine) {
            byte[] byArray = this.currentElem.getByteArrayValue();
            int n = byArray.length + this.parsedToken.length + 1;
            if (n > this.limitTokenSize) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Multiline header value too large: " + n);
                }
                throw new MalformedMessageException("Multiline value length: " + n);
            }
            byte[] byArray2 = new byte[byArray.length + this.parsedToken.length + 1];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray2[byArray.length] = 32;
            System.arraycopy(this.parsedToken, 0, byArray2, byArray.length + 1, this.parsedToken.length);
            this.currentElem.setByteArrayValue(byArray2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Saved multiline header value [" + this.currentElem.getDebugValue() + "]");
            }
        } else {
            this.currentElem.setByteArrayValue(this.parsedToken);
            if (null != this.currentElem.getHeaderKey()) {
                this.addKnownHeader(this.currentElem.getHeaderKey(), this.currentElem, true, true);
            } else {
                this.addUnknownHeader(this.currentElem.getHeaderString(), this.currentElem, true);
            }
        }
        this.currentElem.startTracking();
    }

    private void saveParsedToken(WsByteBuffer wsByteBuffer, int n, boolean bl, int n2) {
        int n3;
        int n4;
        Object object;
        int n5 = this.parsedTokenLength;
        this.parsedTokenLength = 0;
        if (0 > n5) {
            throw new IllegalArgumentException("Negative token length: " + n5);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            object = GenericUtils.getEnglishString(this.parsedToken);
            if (null != object) {
                if (2 == n2) {
                    object = GenericUtils.nullOutPasswords((String)object, (byte)10);
                } else if (1 == n2) {
                    object = GenericUtils.blockContents((String)object);
                }
            }
            Tr.debug(tc, "Saving token: " + (String)object + " len:" + n5 + " start:" + n + " pos:" + this.bytePosition + " delim:" + bl);
        }
        if (null != this.parsedToken) {
            n4 = this.parsedToken.length;
            object = new byte[n4 + n5];
            System.arraycopy(this.parsedToken, 0, object, 0, n4);
        } else {
            n4 = 0;
            object = new byte[n5];
        }
        if (this.bytePosition > n5) {
            n3 = this.bytePosition - n5;
            if (bl) {
                --n3;
            }
            System.arraycopy(this.byteCache, n3, object, n4, n5);
        } else {
            n3 = wsByteBuffer.position();
            wsByteBuffer.position(n);
            wsByteBuffer.get((byte[])object, n4, n5);
            wsByteBuffer.position(n3);
        }
        this.parsedToken = (byte[])object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String string = GenericUtils.getEnglishString(this.parsedToken);
            if (2 == n2) {
                string = GenericUtils.nullOutPasswords(string, (byte)10);
            } else if (1 == n2) {
                string = GenericUtils.blockContents(string);
            }
            Tr.debug(tc, "Saved token [" + string + "]");
        }
    }
}

