/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.TriggerInfo;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class TriggerInfoImpl
implements TriggerInfo {
    private static final TraceComponent tc = Tr.register(TriggerInfo.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    public static final TriggerInfo TRIGGER_STRUCTURE;
    public static final TriggerInfo TRIGGER_STRUCTURE_MEMBER;
    public static final TriggerInfo TRIGGER_STRUCTURE_MEMBER_RUNNING;
    public static final TriggerInfo TRIGGER_STRUCTURE_MEMBER_STOPPING;
    public static final TriggerInfo TRIGGER_INFLUENCE;
    private String event = null;
    private TriggerInfo parent = null;
    private boolean structural = false;
    private boolean influential = false;

    public TriggerInfoImpl() {
    }

    protected TriggerInfoImpl(String string, TriggerInfo triggerInfo) {
        this.event = triggerInfo == null ? string : triggerInfo.getEventType() + "." + string;
        this.parent = triggerInfo;
        this.structural = this.event.startsWith("structure");
        this.influential = this.event.startsWith("influence");
    }

    public String getEventType() {
        return this.event;
    }

    public boolean isStructural() {
        return this.structural;
    }

    public boolean isInfluential() {
        return this.influential;
    }

    public TriggerInfo getSuperType() {
        return this.parent;
    }

    public boolean equals(Object object) {
        try {
            TriggerInfoImpl triggerInfoImpl = (TriggerInfoImpl)object;
            if (this.event.equals(triggerInfoImpl.event)) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.event.hashCode();
    }

    public String toString() {
        return this.event;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(0);
        objectOutput.writeObject(this.event);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readByte();
        this.event = (String)objectInput.readObject();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.2 ");
        }
        TRIGGER_STRUCTURE = new TriggerInfoImpl("structure", null);
        TRIGGER_STRUCTURE_MEMBER = new TriggerInfoImpl("member.state", TRIGGER_STRUCTURE);
        TRIGGER_STRUCTURE_MEMBER_RUNNING = new TriggerInfoImpl("running", TRIGGER_STRUCTURE_MEMBER);
        TRIGGER_STRUCTURE_MEMBER_STOPPING = new TriggerInfoImpl("stopping", TRIGGER_STRUCTURE_MEMBER);
        TRIGGER_INFLUENCE = new TriggerInfoImpl("influence", null);
    }
}

