/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.ws.cluster.topography.DescriptionKeyImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class KeyRepositoryImpl
implements KeyRepository {
    private static final TraceComponent tc = Tr.register(KeyRepositoryImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private Map keys = new HashMap();
    private Map reverseKeys = new HashMap();
    private ReferenceQueue refQueue = new ReferenceQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescriptionKey getDescriptionKey(DescriptionKey descriptionKey, Map map) throws IllegalArgumentException {
        if (descriptionKey == null) {
            throw new IllegalArgumentException("The parent key must not be null.");
        }
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("The identitiesToAppend argument must not be null and must contain at least one entry.");
        }
        HashMap hashMap = new HashMap(descriptionKey.getProperties());
        hashMap.putAll(map);
        DescriptionKey descriptionKey2 = null;
        Map map2 = this.keys;
        synchronized (map2) {
            Reference reference = (Reference)this.keys.get(hashMap);
            if (reference != null) {
                descriptionKey2 = (DescriptionKey)reference.get();
            }
            if (descriptionKey2 == null) {
                descriptionKey2 = this.buildDescriptionKey(hashMap);
            }
        }
        return descriptionKey2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescriptionKey getDescriptionKey(Map map) throws IllegalArgumentException {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("The identities argument must not be null and must contain at least one entry.");
        }
        DescriptionKey descriptionKey = null;
        Map map2 = this.keys;
        synchronized (map2) {
            Reference reference = (Reference)this.keys.get(map);
            if (reference != null) {
                descriptionKey = (DescriptionKey)reference.get();
            }
            if (descriptionKey == null) {
                HashMap hashMap = new HashMap((int)((float)map.size() / 0.75f) + 1, 0.75f);
                hashMap.putAll(map);
                descriptionKey = this.buildDescriptionKey(hashMap);
            }
        }
        return descriptionKey;
    }

    private DescriptionKey buildDescriptionKey(Map map) throws IllegalArgumentException {
        Object object;
        Object object2;
        Iterator iterator = map.entrySet().iterator();
        HashMap hashMap = new HashMap();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = object2.getKey();
            Object v = object2.getValue();
            if (object instanceof String && v instanceof String) {
                hashMap.put(object, v);
                continue;
            }
            throw new IllegalArgumentException("The identities argument should consist of String keys and values.");
        }
        object2 = new DescriptionKeyImpl(hashMap);
        object = new SoftReference<Object>(object2, this.refQueue);
        this.keys.put(map, object);
        this.reverseKeys.put(object, map);
        this.purge();
        return object2;
    }

    public void exportToStream(DataOutput dataOutput, DescriptionKey descriptionKey) throws IOException {
        Map map = descriptionKey.getProperties();
        dataOutput.writeByte(0);
        int n = map.size();
        dataOutput.writeInt(n);
        Iterator iterator = map.entrySet().iterator();
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = iterator.next();
            dataOutput.writeUTF((String)entry.getKey());
            dataOutput.writeUTF((String)entry.getValue());
        }
    }

    public DescriptionKey importFromStream(DataInput dataInput) throws IOException {
        Object var2_2 = null;
        dataInput.readByte();
        int n = dataInput.readInt();
        HashMap<String, String> hashMap = new HashMap<String, String>((int)((float)n / 0.75f) + 1, 0.75f);
        for (int i = 0; i < n; ++i) {
            String string = dataInput.readUTF();
            String string2 = dataInput.readUTF();
            hashMap.put(string, string2);
        }
        return this.getDescriptionKey(hashMap);
    }

    private void purge() {
        SoftReference softReference = null;
        while ((softReference = (SoftReference)this.refQueue.poll()) != null) {
            Map map = (Map)this.reverseKeys.get(softReference);
            this.reverseKeys.remove(softReference);
            this.keys.remove(map);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "purge", map);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.15 ");
        }
    }
}

