/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionA;
import com.ibm.websphere.cluster.topography.DescriptionFactory;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.ExtrinsicDescription;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.IntrinsicDescription;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class IntrinsicDescriptionA
extends DescriptionA
implements IntrinsicDescription {
    private static final TraceComponent tc = Tr.register(IntrinsicDescriptionA.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private final String commonImplKey = "com.ibm.ws.cluster.topography.CommonClusterMemberDescription";
    private final String[] distinction = new String[]{"CommonClusterMemberDescriptionDistinction", "common"};
    private static final DescriptionManager descMgr;
    private static final DescriptionFactory descFactory;
    private static final KeyRepository keyRepository;
    private Map extrinsicData = Collections.synchronizedMap(new HashMap());
    private Map ivCommonMemberDistinction = null;

    protected IntrinsicDescriptionA(DescriptionKey descriptionKey) {
        super(descriptionKey);
    }

    public void exportToStream(DataOutput dataOutput, Format format) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportToStream");
        }
        int n = format.getType();
        MementoA mementoA = null;
        if (n == 3) {
            mementoA = (MementoA)this.getMemento();
        }
        dataOutput.writeByte(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote version 0");
        }
        Set set = null;
        set = mementoA != null ? mementoA.getExtrinsicData().entrySet() : this.extrinsicData.entrySet();
        int n2 = set.size();
        dataOutput.writeInt(n2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote extrinsics size = " + n2);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            DescriptionKey descriptionKey = (DescriptionKey)entry.getKey();
            keyRepository.exportToStream(dataOutput, descriptionKey);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote descriptionKey " + descriptionKey);
            }
            ExtrinsicDescription extrinsicDescription = (ExtrinsicDescription)entry.getValue();
            dataOutput.writeUTF(extrinsicDescription.getDefinitionKey());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote definition key " + extrinsicDescription.getDefinitionKey());
            }
            if (mementoA == null) continue;
            extrinsicDescription.exportToStream(dataOutput, format);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportToStream");
        }
    }

    public Description.Memento importFromStream(DataInput dataInput, Format format, Description.Memento memento) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importFromStream");
        }
        MementoA mementoA = (MementoA)memento;
        byte by = dataInput.readByte();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read version " + by);
        }
        int n = dataInput.readInt();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read extrinsics size = " + n);
        }
        for (int i = 0; i < n; ++i) {
            DescriptionKey descriptionKey = keyRepository.importFromStream(dataInput);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read descriptionKey = " + descriptionKey);
            }
            String string = dataInput.readUTF();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read definition = " + string);
            }
            Description description = (Description)mementoA.m_extrinsicData.get(descriptionKey);
            try {
                if (description == null) {
                    try {
                        description = descMgr.getDescription(descriptionKey, string);
                    }
                    catch (Exception exception) {
                        if (format.getType() == 4) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Unexpected", exception);
                            }
                        }
                        IOException iOException = new IOException("Error serializing the description " + descriptionKey + ".");
                        iOException.initCause(exception);
                        throw iOException;
                    }
                    mementoA.m_extrinsicData.put(descriptionKey, description);
                }
                if (format.getType() != 3) continue;
                ExtrinsicDescription.Memento memento2 = (ExtrinsicDescription.Memento)description.importFromStream(dataInput, format, null);
                description.setMemento(memento2);
                continue;
            }
            catch (Exception exception) {
                IOException iOException = new IOException("Error serializing the description " + descriptionKey + ".");
                iOException.initCause(exception);
                throw iOException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importFromStream");
        }
        return mementoA;
    }

    public void setExtrinsicData(DescriptionKey descriptionKey, ExtrinsicDescription extrinsicDescription) {
        this.setExtrinsicData(extrinsicDescription);
    }

    public void setExtrinsicData(ExtrinsicDescription extrinsicDescription) throws IllegalArgumentException {
        DescriptionKey descriptionKey = extrinsicDescription.getKey();
        if (descriptionKey.equals(this.getKey())) {
            throw new IllegalArgumentException("The ExtrinsicDescription has the same key as the IntrinsicDescription: " + this.getKey());
        }
        this.extrinsicData.put(descriptionKey, extrinsicDescription);
        this.updateMemento();
        this.notifyListeners("type.add.extrinsic", extrinsicDescription);
    }

    public ExtrinsicDescription removeExtrinsicData(DescriptionKey descriptionKey) throws IllegalArgumentException {
        ExtrinsicDescription extrinsicDescription = (ExtrinsicDescription)this.extrinsicData.remove(descriptionKey);
        this.updateMemento();
        return extrinsicDescription;
    }

    public void setMemento(Description.Memento memento) {
        Object v;
        Map.Entry entry;
        MementoA mementoA = (MementoA)this.getMemento();
        Map map = mementoA.getExtrinsicData();
        Map map2 = ((MementoA)memento).getExtrinsicData();
        super.setMemento(memento);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (map2.containsKey(entry.getKey())) continue;
            v = entry.getValue();
            this.notifyListeners("type.remove.extrinsic", v);
            descFactory.notifyListeners(this.getKey(), "type.remove.extrinsic", v);
        }
        iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            v = entry.getValue();
            if (map.containsKey(entry.getKey())) continue;
            this.notifyListeners("type.add.extrinsic", v);
            descFactory.notifyListeners(this.getKey(), "type.add.extrinsic", v);
        }
    }

    public String toString() {
        return "[" + super.toString() + this.extrinsicData + ']';
    }

    static {
        DescriptionManagerFactory.getInstance();
        descMgr = DescriptionManagerFactory.getDescriptionManager();
        descFactory = DescriptionFactory.getInstance();
        keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    }

    public abstract class MementoA
    extends DescriptionA.MementoA
    implements IntrinsicDescription.Memento {
        protected Map m_extrinsicData = new HashMap();

        protected MementoA() {
        }

        public ExtrinsicDescription getExtrinsicData(DescriptionKey descriptionKey) {
            return (ExtrinsicDescription)this.m_extrinsicData.get(descriptionKey);
        }

        public Map getExtrinsicData() {
            return Collections.unmodifiableMap(this.m_extrinsicData);
        }

        public String toString() {
            return "[" + super.toString() + this.m_extrinsicData + ']';
        }
    }
}

