/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Concern;
import com.ibm.websphere.cluster.topography.Format;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class FormatImpl
implements Format {
    private static final TraceComponent tc = Tr.register(FormatImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    static final long serialVersionUID = 4190911471127139349L;
    private int type = 0;
    private Concern concern = null;
    private byte version = 1;

    public FormatImpl() {
    }

    public FormatImpl(Concern concern, int n) {
        if (concern == null) {
            throw new NullPointerException("Concern must not be null.");
        }
        this.concern = concern;
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public byte getVersion() {
        return this.version;
    }

    public Concern getConcern() {
        return this.concern;
    }

    public boolean equals(Object object) {
        try {
            Format format = (Format)object;
            if (format.getType() != this.type) {
                return false;
            }
            if (!format.getConcern().equals(this.concern)) {
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.type | this.concern.hashCode();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(this.version);
        objectOutput.writeInt(this.type);
        objectOutput.writeObject(this.concern);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.version = objectInput.readByte();
        this.type = objectInput.readInt();
        this.concern = (Concern)objectInput.readObject();
    }

    public String toString() {
        return FormatImpl.class.getName() + "[t" + this.type + ", c" + this.concern + "]";
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.4 ");
        }
    }
}

