/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.service.delaycache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.ws.cluster.WLMCustomPropertyUtility;
import com.ibm.ws.cluster.service.delaycache.DelayCacheManagementThread;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DelayCache {
    static final TraceComponent tc = Tr.register(DelayCache.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    public static Object delayCacheMutex;
    private static final Map delayedUpdatesCache;
    private static final int UPDATE_MEMENTO_DELAY_TIME_MINIMUM = 250;
    private static final int UPDATE_MEMENTO_DELAY_TIME_MAXIMUM = 60000;
    private static boolean acsDelayPostingEnabled;
    private static int delayCacheManagementCycleTime;
    private static boolean managementThreadExists;
    private static boolean runningHot;
    private static int hotCounter;
    private static int totalDelayCounter;
    private static final int MAXIMUM_ALLOWABLE_DELAY = 30000;
    public static boolean hit30secDelay;
    public static boolean hit2secDelay;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(DescriptionKey descriptionKey, int n) throws IllegalArgumentException {
        if (n < 250 || n > 60000) {
            throw new IllegalArgumentException("Specified value of " + n + " for Key " + descriptionKey + " is outside the acceptable bounds for the delay time (" + 250 + " to " + 60000 + ")");
        }
        Object object = delayCacheMutex;
        synchronized (object) {
            delayedUpdatesCache.put(descriptionKey, new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(DescriptionKey descriptionKey) {
        Object object = delayCacheMutex;
        synchronized (object) {
            delayedUpdatesCache.remove(descriptionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEmpty() {
        Object object = delayCacheMutex;
        synchronized (object) {
            return delayedUpdatesCache.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isManagementThreadWorkComplete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isManagementThreadWorkComplete");
        }
        Object object = delayCacheMutex;
        synchronized (object) {
            if (delayedUpdatesCache.isEmpty() && hotCounter == 0 && !runningHot) {
                managementThreadExists = false;
                hotCounter = 0;
                totalDelayCounter = 0;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "isManagementThreadWorkComplete - true");
                }
                return true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "isManagementThreadWorkComplete - false");
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleManagementThreadException() {
        Object object = delayCacheMutex;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "handleManagementThreadException - runningHot is false");
            }
            managementThreadExists = false;
            runningHot = false;
            hotCounter = 0;
            totalDelayCounter = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getDelayedUpdatesToBePublished(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDelayedUpdatesToBePublished");
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        Object object = delayCacheMutex;
        synchronized (object) {
            Object object2;
            Object object3;
            Iterator iterator = delayedUpdatesCache.entrySet().iterator();
            while (iterator != null && iterator.hasNext()) {
                object3 = iterator.next();
                object2 = (DescriptionKey)object3.getKey();
                int n2 = (Integer)object3.getValue();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getDelayedUpdatesToBePublished processing ", new Object[]{object2, new Integer(n2), new Integer(n)});
                }
                if ((n2 -= n) <= 0) {
                    hashSet.add(object2);
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getDelayedUpdatesToBePublished updating", new Object[]{object2, new Integer(n2)});
                }
                hashMap.put(object2, new Integer(n2));
            }
            object3 = hashMap.keySet().iterator();
            while (object3 != null && object3.hasNext()) {
                object2 = (DescriptionKey)object3.next();
                delayedUpdatesCache.put(object2, hashMap.get(object2));
            }
            object2 = hashSet.iterator();
            while (object2 != null && object2.hasNext()) {
                DescriptionKey descriptionKey = (DescriptionKey)object2.next();
                delayedUpdatesCache.remove(descriptionKey);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getDelayedUpdatesToBePublished", hashSet);
            }
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetTotalDelayCounter() {
        Object object = delayCacheMutex;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "resetTotalDelayCounter");
            }
            totalDelayCounter = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDelayCacheCounters(int n) {
        Object object = delayCacheMutex;
        synchronized (object) {
            totalDelayCounter += n;
            if (hotCounter == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "updateDelayCacheCounters - runningHot is false");
                }
                runningHot = false;
                hit2secDelay = true;
            } else {
                hotCounter = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean useDelayedActiveClusterSet() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "useDelayedActiveClusterSet");
        }
        boolean bl = false;
        if (!acsDelayPostingEnabled) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "useDelayedActiveClusterSet - batching not enabled");
            }
            bl = false;
        } else {
            Object object = delayCacheMutex;
            synchronized (object) {
                if (!managementThreadExists) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "useDelayedActiveClusterSet - creating management thread");
                    }
                    managementThreadExists = true;
                    DelayCacheManagementThread delayCacheManagementThread = new DelayCacheManagementThread(delayCacheManagementCycleTime);
                    delayCacheManagementThread.start();
                }
                ++hotCounter;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "useDelayedActiveClusterSet - counter is " + hotCounter);
                }
                if (runningHot) {
                    if (totalDelayCounter >= 30000) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "useDelayedActiveClusterSet - Reached maximum allowable delay, forcing a publish");
                        }
                        totalDelayCounter = 0;
                        hit30secDelay = true;
                        bl = false;
                    } else {
                        bl = true;
                    }
                } else if (hotCounter >= 5) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "useDelayedActiveClusterSet - threshold reached, runningHot is true");
                    }
                    runningHot = true;
                    bl = true;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "useDelayedActiveClusterSet", new Boolean(bl));
        }
        return bl;
    }

    public static void setDelayed(boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setDelayed", new Boolean(bl));
        }
        acsDelayPostingEnabled = bl;
    }

    public static void setManagementCycleTime(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setManagementCycleTime", new Integer(n));
        }
        delayCacheManagementCycleTime = n;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.2");
        }
        delayCacheMutex = new Object();
        delayedUpdatesCache = new HashMap(2);
        acsDelayPostingEnabled = WLMCustomPropertyUtility.getACSDelayPostingValue();
        delayCacheManagementCycleTime = WLMCustomPropertyUtility.getDelayCacheManagementCycleTimeValue();
        managementThreadExists = false;
        runningHot = false;
        hotCounter = 0;
        totalDelayCounter = 0;
        hit30secDelay = false;
        hit2secDelay = false;
    }
}

