/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.Compressor;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.FormatImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.distribution.ServerClusterContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServerClusterContextImpl
implements ServerClusterContext {
    private static final TraceComponent tc = Tr.register(ServerClusterContextImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final int serverContextVersion = 3;
    protected Map localJoinedClusterMap = Collections.synchronizedMap(new HashMap());
    protected Object localJoinedClusterMapMutex = this.localJoinedClusterMap;
    private ProcessProperties ivProcessProperties = ProcessProperties.getInstance();
    private Identity me = (Identity)this.ivProcessProperties.get("key.local.member");

    public byte[] checkClientContext(byte[] byArray) {
        byte[] byArray2;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkClientContext", byArray);
            }
            byArray2 = null;
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                WsObjectInputStream wsObjectInputStream = new WsObjectInputStream(byteArrayInputStream);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                int n = wsObjectInputStream.readInt();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "clientVersion " + n);
                }
                HashMap hashMap = new HashMap();
                this.receiveServerContextCluster(wsObjectInputStream, hashMap);
                if (!hashMap.isEmpty()) {
                    objectOutputStream.writeInt(3);
                    DescriptionManagerFactory.getDescriptionManager().stream(hashMap, objectOutputStream);
                    objectOutputStream.flush();
                    byArray2 = Compressor.compress(byteArrayOutputStream.toByteArray(), 4);
                    objectOutputStream.close();
                }
                byteArrayOutputStream.close();
                wsObjectInputStream.close();
                byteArrayInputStream.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, ServerClusterContextImpl.class.getName() + ".checkClientContext", "106", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "unexpected exception", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkClientContext", byArray2);
        }
        return byArray2;
    }

    private void receiveServerContextCluster(ObjectInput objectInput, Map map) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receiveServerContextCluster");
        }
        if (objectInput.readBoolean()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Read cluster available to process true");
            }
            DescriptionKey descriptionKey = KeyRepositoryFactory.getInstance().getKeyRepository().importFromStream(objectInput);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read cluster Key " + descriptionKey);
            }
            long l = objectInput.readLong();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read structural epoch " + l);
            }
            long l2 = objectInput.readLong();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read influential epoch " + l2);
            }
            ClusterDescription clusterDescription = (ClusterDescription)DescriptionManagerFactory.getDescriptionManager().getDescription(descriptionKey);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cluster available to process ", new Object[]{new Long(l), new Long(l2), descriptionKey, clusterDescription});
            }
            if (clusterDescription != null) {
                if (l == -2L) {
                    FormatImpl formatImpl = new FormatImpl(new ConcernImpl(Integer.MAX_VALUE), 4);
                    this.addAllClusterKeys(map, clusterDescription, formatImpl);
                } else {
                    ClusterDescription.Memento memento = (ClusterDescription.Memento)clusterDescription.getMemento();
                    int n = 0;
                    if (l < memento.getStructuralEpoch()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "structural epoch has changed");
                        }
                        n = 1;
                    } else if (l2 < memento.getInfluentialEpoch()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "influential epoch has changed");
                        }
                        n = 2;
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "client is up to date");
                    }
                    if (n != 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "client needs updated cluster information");
                        }
                        FormatImpl formatImpl = new FormatImpl(new ConcernImpl(Integer.MAX_VALUE), n);
                        this.addClusterKey(map, clusterDescription, formatImpl);
                    }
                }
            } else if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to find cluster " + (descriptionKey == null ? "" : descriptionKey.toString()));
            }
            this.receiveServerContextCluster(objectInput, map);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receiveServerContextCluster");
        }
    }

    protected void addAllClusterKeys(Map map, ClusterDescription clusterDescription, Format format) {
        this.addClusterKey(map, clusterDescription, format);
    }

    protected void addClusterKey(Map map, ClusterDescription clusterDescription, Format format) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addClusterKey");
        }
        Set<DescriptionKey> set = null;
        if (map.containsKey(format)) {
            set = (Set)map.get(format);
            if (!set.contains(clusterDescription.getKey())) {
                set.add(clusterDescription.getKey());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "added key ", clusterDescription.getKey());
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "set already contains cluster key");
            }
        } else {
            set = new HashSet();
            set.add(clusterDescription.getKey());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "added key ", clusterDescription.getKey());
            }
            map.put(format, set);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addClusterKey");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateClusterResidency(Identity identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateClusterResidency", identity);
        }
        boolean bl = false;
        if (this.me == null) {
            this.me = (Identity)this.ivProcessProperties.get("key.local.member");
        }
        if (this.me == identity) {
            bl = true;
        } else {
            List list = (List)this.localJoinedClusterMap.get(identity);
            if (list != null && list.size() >= 1 && list.get(0) == this.me) {
                bl = true;
            } else {
                Object object = this.localJoinedClusterMapMutex;
                synchronized (object) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "localJoinedClusterMap", this.printLocalJoinedClusterMap());
                    }
                    bl = this.findChild(identity);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateClusterResidency", String.valueOf(bl));
        }
        return bl;
    }

    private boolean findChild(Identity identity) {
        List list = (List)this.localJoinedClusterMap.get(identity);
        if (list == null) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Identity identity2 = (Identity)iterator.next();
            if (this.me == identity2) {
                return true;
            }
            if (!this.findChild(identity2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateClusterProcessResidency(Identity identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateClusterProcessResidency", identity);
        }
        boolean bl = false;
        if (this.me == null) {
            this.me = (Identity)this.ivProcessProperties.get("key.local.member");
        }
        if (this.me == identity) {
            bl = true;
        } else {
            List list = (List)this.localJoinedClusterMap.get(identity);
            if (list != null && list.size() >= 1 && list.get(0) == this.me) {
                bl = true;
            } else {
                Object object = this.localJoinedClusterMapMutex;
                synchronized (object) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "localJoinedClusterMap", this.printLocalJoinedClusterMap());
                    }
                    bl = this.findChild(identity);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateClusterProcessResidency", String.valueOf(bl));
        }
        return bl;
    }

    protected void updateLocalJoinedClusterMap(Map map, Object object) {
        this.localJoinedClusterMapMutex = object;
        this.localJoinedClusterMap = map;
    }

    private String printLocalJoinedClusterMap() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "me is: " + this.me);
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("[");
        Iterator iterator = this.localJoinedClusterMap.keySet().iterator();
        Identity identity = null;
        while (iterator.hasNext()) {
            identity = (Identity)iterator.next();
            stringBuffer.append(identity);
            stringBuffer.append(" = ");
            stringBuffer.append(this.localJoinedClusterMap.get(identity).toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("\n ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.12.1.1 ");
        }
    }
}

