/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.websphere.cluster.topography.IdentityMap;
import com.ibm.websphere.cluster.topography.IntrinsicDescription;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.service.ClientClusterContextImpl;
import com.ibm.ws.cluster.service.EndPointImpl;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescription;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.ClusterObserver;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.IdentityMapping;
import com.ibm.wsspi.cluster.NoClusterDefinedException;
import com.ibm.wsspi.cluster.NoMemberAvailableException;
import com.ibm.wsspi.cluster.distribution.ClientClusterContext;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class ClusterServiceImpl
implements ClusterService,
DescriptionModificationListener {
    private static final TraceComponent tc = Tr.register(ClusterServiceImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private Map listeners = new HashMap();
    private Map coIdentifiers = Collections.synchronizedMap(new HashMap());
    private DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    protected ReferenceQueue refQueue = new ReferenceQueue();
    private boolean purgeNotifications = ClusterServiceImpl.getPurgeNotificationsValue();

    public Identity getIdentity(Map map) throws IllegalArgumentException {
        return this.keyRepository.getDescriptionKey(map);
    }

    public byte[] getClusterScopedData(Identity identity, Identity identity2) throws NoClusterDefinedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterScopedData", new Object[]{identity, identity2});
        }
        byte[] byArray = null;
        DescriptionKey descriptionKey = (DescriptionKey)identity;
        DescriptionKey descriptionKey2 = (DescriptionKey)identity2;
        ClusterDescription clusterDescription = null;
        try {
            clusterDescription = (ClusterDescription)this.descMgr.getDescription(descriptionKey, ClusterDescription.class.getName());
            ClusterDescription.Memento memento = (ClusterDescription.Memento)clusterDescription.getMemento();
            byArray = memento.getClusterScopedData(descriptionKey2);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ClusterServiceImpl.class.getName() + ".getClusterScopedData", "174");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception ", exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterScopedData");
            }
            throw new NoClusterDefinedException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterScopedData", byArray);
        }
        return byArray;
    }

    public byte[] getMemberScopedData(Identity identity, Identity identity2) throws NoMemberAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMemberScopedData", new Object[]{identity, identity2});
        }
        byte[] byArray = null;
        DescriptionKey descriptionKey = (DescriptionKey)identity;
        ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)this.descMgr.getDescription(descriptionKey);
        if (clusterMemberDescription == null) {
            throw new NoMemberAvailableException();
        }
        ClusterMemberDescription.Memento memento = (ClusterMemberDescription.Memento)clusterMemberDescription.getMemento();
        EndPointImpl endPointImpl = (EndPointImpl)memento.getExtrinsicData((DescriptionKey)identity2);
        if (endPointImpl != null) {
            byArray = endPointImpl.getData();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMemberScopedData", byArray);
        }
        return byArray;
    }

    public ClientClusterContext getClientClusterContextListener(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientClusterContext", list);
        }
        ClientClusterContext clientClusterContext = null;
        SoftReference softReference = (SoftReference)this.listeners.get(list);
        if (softReference != null && (clientClusterContext = (ClientClusterContext)softReference.get()) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClientClusterContext", clientClusterContext);
            }
            return clientClusterContext;
        }
        clientClusterContext = new ClientClusterContextImpl(list);
        this.listeners.put(list, new SoftReference<ClientClusterContext>(clientClusterContext));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientClusterContext", clientClusterContext);
        }
        return clientClusterContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInterest(ClusterObserver clusterObserver, Identity identity, String string) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        block24: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "registerInterest", new Object[]{clusterObserver, identity, string});
            }
            if (this.purgeNotifications) {
                this.purge();
            }
            object4 = identity;
            try {
                if (string.equals("cluster.active")) {
                    object3 = (IdentityMap)this.descMgr.getDescription((DescriptionKey)identity, IdentityMap.class.getName());
                    object3.registerNotificationListener(this, "type.key.added", "cluster.active");
                } else if (string.equals("cluster.deactive")) {
                    object3 = (IdentityMap)this.descMgr.getDescription((DescriptionKey)identity, IdentityMap.class.getName());
                    object3.registerNotificationListener(this, "type.key.removed", "cluster.deactive");
                } else if (string.equals("type.endpoint.added")) {
                    object3 = (ClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)identity, ClusterMemberDescription.class.getName());
                    object3.registerNotificationListener(this, "type.add.extrinsic", "type.endpoint.added");
                } else if (string.equals("type.endpoint.removed")) {
                    object3 = (ClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)identity, ClusterMemberDescription.class.getName());
                    object3.registerNotificationListener(this, "type.remove.extrinsic", "type.endpoint.removed");
                } else if (string.equals("type.attribute.added")) {
                    object3 = new HashMap(identity.getProperties());
                    object3.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
                    object2 = this.getIdentity((Map)object3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SelectionClusterMemberDescription Identity = ", object2);
                    }
                    object = (SelectionClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)object2, SelectionClusterMemberDescription.class.getName());
                    object.registerNotificationListener(this, "type.attribute.added", "type.attribute.added");
                    object4 = object2;
                } else if (string.equals("type.attribute.removed")) {
                    object3 = new HashMap<String, String>(identity.getProperties());
                    object3.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
                    object2 = this.getIdentity((Map)object3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SelectionClusterMemberDescription Identity = ", object2);
                    }
                    object = (SelectionClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)object2, SelectionClusterMemberDescription.class.getName());
                    object.registerNotificationListener(this, "type.attribute.removed", "type.attribute.removed");
                    object4 = object2;
                } else {
                    object3 = (ClusterDescription)this.descMgr.getDescription((DescriptionKey)identity, ClusterDescription.class.getName());
                    object3.registerNotificationListener(this, string, string);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, ClusterServiceImpl.class.getName() + ".registerInterest", "301");
                if (!tc.isDebugEnabled()) break block24;
                Tr.debug(tc, "unexpected exception ", exception);
            }
        }
        object3 = this.coIdentifiers;
        synchronized (object3) {
            object2 = (HashMap)this.coIdentifiers.get(object4);
            if (object2 == null) {
                object2 = new HashMap();
                this.coIdentifiers.put(object4, object2);
            }
            if ((object = (HashSet<WeakReference<ClusterObserver>>)object2.get(string)) == null) {
                object = new HashSet<WeakReference<ClusterObserver>>();
                object2.put(string, object);
            }
            object.add(new WeakReference<ClusterObserver>(clusterObserver, this.refQueue));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerInterest");
        }
    }

    public void deregisterInterest(ClusterObserver clusterObserver, Identity identity, String string) {
        Identity identity2;
        block39: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deregisterInterest", new Object[]{clusterObserver, identity, string});
            }
            identity2 = identity;
            try {
                if (string.equals("cluster.active")) {
                    IdentityMap identityMap = (IdentityMap)this.descMgr.getDescription((DescriptionKey)identity);
                    if (identityMap != null) {
                        identityMap.deregisterNotificationListener(this, "type.key.added");
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deregister of cluster.active invalid, no description for given key", identity);
                    }
                } else if (string.equals("cluster.deactive")) {
                    IdentityMap identityMap = (IdentityMap)this.descMgr.getDescription((DescriptionKey)identity);
                    if (identityMap != null) {
                        identityMap.deregisterNotificationListener(this, "type.key.removed");
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deregister of cluster.deactive invalid, no description for given key", identity);
                    }
                } else if (string.equals("type.endpoint.added")) {
                    ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)identity);
                    if (clusterMemberDescription != null) {
                        clusterMemberDescription.deregisterNotificationListener(this, "type.add.extrinsic");
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deregister of type.endpoint.added invalid, no description for given key", identity);
                    }
                } else if (string.equals("type.endpoint.removed")) {
                    ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)identity);
                    if (clusterMemberDescription != null) {
                        clusterMemberDescription.deregisterNotificationListener(this, "type.remove.extrinsic");
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deregister of type.endpoint.removed invalid, no description for given key", identity);
                    }
                } else if (string.equals("type.attribute.added")) {
                    SelectionClusterMemberDescription selectionClusterMemberDescription;
                    HashMap<String, String> hashMap = new HashMap<String, String>(identity.getProperties());
                    hashMap.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
                    Identity identity3 = this.getIdentity(hashMap);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SelectionClusterMemberDescription Identity = ", identity3);
                    }
                    if ((selectionClusterMemberDescription = (SelectionClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)identity3, SelectionClusterMemberDescription.class.getName())) != null) {
                        selectionClusterMemberDescription.deregisterNotificationListener(this, "type.attribute.added");
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deregister of type.attribute.added invalid, no description for given key", identity);
                    }
                    identity2 = identity3;
                } else if (string.equals("type.attribute.removed")) {
                    SelectionClusterMemberDescription selectionClusterMemberDescription;
                    HashMap<String, String> hashMap = new HashMap<String, String>(identity.getProperties());
                    hashMap.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
                    Identity identity4 = this.getIdentity(hashMap);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SelectionClusterMemberDescription Identity = ", identity4);
                    }
                    if ((selectionClusterMemberDescription = (SelectionClusterMemberDescription)this.descMgr.getDescription((DescriptionKey)identity4, SelectionClusterMemberDescription.class.getName())) != null) {
                        selectionClusterMemberDescription.deregisterNotificationListener(this, "type.attribute.removed");
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deregister of type.attribute.removed invalid, no description for given key", identity);
                    }
                    identity2 = identity4;
                } else {
                    ClusterDescription clusterDescription = (ClusterDescription)this.descMgr.getDescription((DescriptionKey)identity, ClusterDescription.class.getName());
                    if (clusterDescription != null) {
                        clusterDescription.deregisterNotificationListener(this, string);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deregister of " + string + " invalid, no description for given key", identity);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, ClusterServiceImpl.class.getName() + ".registerInterest", "301");
                if (!tc.isDebugEnabled()) break block39;
                Tr.debug(tc, "unexpected exception ", exception);
            }
        }
        this.removeDeregisteredObserver(clusterObserver, string, identity2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterInterest");
        }
    }

    public Identity[] getMemberIdentities(Identity identity) {
        ClusterDescription clusterDescription;
        Identity[] identityArray;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getMemberIdentities", identity);
            }
            identityArray = null;
            DescriptionKey descriptionKey = (DescriptionKey)identity;
            clusterDescription = null;
            try {
                clusterDescription = (ClusterDescription)this.descMgr.getDescription(descriptionKey, ClusterDescription.class.getName());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, ClusterServiceImpl.class.getName() + ".getMemberIdentities", "346");
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "unexpected exception ", exception);
            }
        }
        if (clusterDescription != null) {
            Set set = ((ClusterDescription.Memento)clusterDescription.getMemento()).getMembers().keySet();
            identityArray = new Identity[set.size()];
            set.toArray(identityArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMemberIdentities", identityArray);
        }
        return identityArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(DescriptionKey descriptionKey, String string, Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new Object[]{descriptionKey, string, object, object2});
        }
        if (this.purgeNotifications) {
            this.purge();
        }
        if ((string.equals("type.add.extrinsic") || string.equals("type.remove.extrinsic")) && object2 != null && (object2.equals("type.endpoint.added") || object2.equals("type.endpoint.removed"))) {
            if (!(object instanceof EndPoint)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleNotification: Not emitting a EndPoint added/removed notification for a non-EndPoint data type.");
                }
                return;
            }
            if (!((EndPointImpl)object).isChannelEndPoint()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleNotification: Not emitting a EndPoint added/removed notification for a non-Channel EndPoint");
                }
                return;
            }
        }
        if (object instanceof Description) {
            object = ((Description)object).getKey();
        }
        boolean bl = false;
        if ((string.equals("type.key.added") || string.equals("type.key.removed") || string.equals("type.value.modified") || string.equals("type.add.extrinsic") || string.equals("type.remove.extrinsic")) && object2 != null && object2 instanceof String) {
            if (object instanceof EndPoint) {
                object = ((EndPoint)object).getIdentity();
            }
            string = (String)object2;
        } else if ((string.equals("type.attribute.added") || string.equals("type.attribute.removed")) && object2 != null && object2 instanceof String) {
            string = (String)object2;
            bl = true;
        }
        Map map = this.coIdentifiers;
        synchronized (map) {
            Map map2 = (Map)this.coIdentifiers.get(descriptionKey);
            if (map2 != null) {
                HashSet hashSet = (HashSet)map2.get(string);
                if (hashSet != null) {
                    Stack<WeakReference> stack = new Stack<WeakReference>();
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        ClusterObserver clusterObserver;
                        WeakReference weakReference = (WeakReference)iterator.next();
                        ClusterObserver clusterObserver2 = clusterObserver = weakReference == null ? null : (ClusterObserver)weakReference.get();
                        if (clusterObserver != null) {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Cluster Service, notify observer", clusterObserver);
                            }
                            if (bl) {
                                SelectionClusterMemberDescription selectionClusterMemberDescription = (SelectionClusterMemberDescription)this.descMgr.getDescription(descriptionKey);
                                if (selectionClusterMemberDescription != null) {
                                    SelectionClusterMemberDescription.Memento memento = (SelectionClusterMemberDescription.Memento)selectionClusterMemberDescription.getMemento();
                                    if (memento != null) {
                                        DescriptionKey descriptionKey2 = memento.getClusterMemberAssociation();
                                        if (descriptionKey2 != null) {
                                            clusterObserver.notify(descriptionKey2, string, object);
                                            continue;
                                        }
                                        if (!tc.isEventEnabled()) continue;
                                        Tr.event(tc, "ClusterMemberAssociation was null trying to send notification");
                                        continue;
                                    }
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "SelectionClusterMemberDescription.Memento was null, not sending notification");
                                    continue;
                                }
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "SelectionClusterMemberDescription was null, not sending notification");
                                continue;
                            }
                            clusterObserver.notify(descriptionKey, string, object);
                            continue;
                        }
                        if (weakReference.get() != null) continue;
                        stack.push(weakReference);
                    }
                    while (!stack.empty()) {
                        hashSet.remove(stack.pop());
                    }
                    if (hashSet.isEmpty()) {
                        map2.remove(string);
                    }
                }
                if (map2.isEmpty()) {
                    this.coIdentifiers.remove(descriptionKey);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    public EndPoint[] matchEndPoints(Identity identity, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "matchEndPoints", new Object[]{identity, map});
        }
        EndPoint[] endPointArray = null;
        IntrinsicDescription intrinsicDescription = (IntrinsicDescription)this.descMgr.getDescription((DescriptionKey)identity);
        if (intrinsicDescription == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "matchEndPoints - no intrinsic description for passed Identity");
            }
            return new EndPoint[0];
        }
        IntrinsicDescription.Memento memento = (IntrinsicDescription.Memento)intrinsicDescription.getMemento();
        Map map2 = memento.getExtrinsicData();
        endPointArray = this.matchEndPoints(map2, map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "matchEndPoints");
        }
        return endPointArray;
    }

    public EndPoint[] matchEndPoints(Map map, Map map2) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "matchEndPoints", new Object[]{map2});
        }
        if (map == null) {
            throw new IllegalArgumentException("The endPoints argument must not be null.");
        }
        if (map2 == null) {
            throw new IllegalArgumentException("The propertyNames argument must not be null.");
        }
        EndPoint[] endPointArray = new EndPoint[]{};
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            EndPoint[] endPointArray2;
            Iterator iterator2 = map2.entrySet().iterator();
            Object v = iterator.next();
            if (!(v instanceof EndPoint)) continue;
            EndPoint endPoint = (EndPoint)v;
            Identity identity = endPoint.getIdentity();
            Map map3 = identity.getProperties();
            while (iterator2.hasNext()) {
                endPointArray2 = iterator2.next();
                try {
                    if (!map3.containsKey(endPointArray2.getKey()) || endPointArray2.getValue() != null && !((String)map3.get(endPointArray2.getKey())).startsWith((String)endPointArray2.getValue())) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "setting next to null", endPoint);
                        }
                        endPoint = null;
                        break;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "found a match: " + endPointArray2.getKey() + " " + endPointArray2.getValue());
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException("The property value " + endPointArray2.getValue().toString() + " should be a String type.");
                }
            }
            if (endPoint == null) continue;
            endPointArray2 = new EndPoint[endPointArray.length + 1];
            endPointArray2[endPointArray.length] = endPoint;
            System.arraycopy(endPointArray, 0, endPointArray2, 0, endPointArray.length);
            endPointArray = endPointArray2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "matchEndPoints", endPointArray);
        }
        return endPointArray;
    }

    public String identityToString(Identity identity) {
        return this.descMgr.keyToString((DescriptionKey)identity);
    }

    public Identity stringToIdentity(String string) {
        return this.descMgr.stringToKey(string);
    }

    public Set getActiveClusterSet() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActiveClusterSet");
        }
        Set set = null;
        String string = (String)ProcessProperties.getInstance().get("key.containing.cellname");
        DescriptionKey descriptionKey = (DescriptionKey)IdentityMapping.getActiveClusterSetIdentityFromCellName(string == null ? "" : string);
        IdentityMap identityMap = this.getIdentityMap(descriptionKey);
        set = identityMap.keySet();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActiveClusterSet", set);
        }
        return set;
    }

    IdentityMap getIdentityMap(DescriptionKey descriptionKey) {
        IdentityMap identityMap;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getIdentityMap");
            }
            identityMap = null;
            try {
                identityMap = (IdentityMap)this.descMgr.getDescription(descriptionKey, IdentityMap.class.getName());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, ClusterServiceImpl.class.getName() + "getIdentityMap", "623");
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "unexpected", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIdentityMap", identityMap.toString());
        }
        return identityMap;
    }

    protected void purge() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "purge");
        }
        boolean bl = false;
        while (this.refQueue.poll() != null) {
            bl = true;
        }
        if (bl) {
            this.cleanupRegistrationTree();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "purge " + bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupRegistrationTree() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupRegistrationTree");
        }
        Map map = this.coIdentifiers;
        synchronized (map) {
            Set set = this.coIdentifiers.keySet();
            Iterator iterator = set.iterator();
            while (iterator != null && iterator.hasNext()) {
                Identity identity = (Identity)iterator.next();
                Map map2 = (Map)this.coIdentifiers.get(identity);
                Set set2 = map2.keySet();
                Iterator iterator2 = set2.iterator();
                while (iterator2 != null && iterator2.hasNext()) {
                    String string = (String)iterator2.next();
                    Set set3 = (Set)map2.get(string);
                    if (set3 != null && !set3.isEmpty()) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cleanupRegistrationTree removing notification", string);
                    }
                    iterator2.remove();
                }
                if (map2 != null && !map2.isEmpty()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cleanupRegistrationTree identity", identity);
                }
                iterator.remove();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupRegistrationTree");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeregisteredObserver(ClusterObserver clusterObserver, String string, Identity identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeDeregisteredObserver", new Object[]{clusterObserver, string, identity});
        }
        Map map = this.coIdentifiers;
        synchronized (map) {
            Map map2 = (Map)this.coIdentifiers.get(identity);
            if (map2 != null) {
                WeakReference<Object> weakReference;
                Iterator<Object> iterator;
                Set set = (Set)map2.get(string);
                if (clusterObserver != null && set != null) {
                    iterator = set.iterator();
                    while (iterator != null && iterator.hasNext()) {
                        weakReference = (WeakReference)iterator.next();
                        if (!weakReference.get().equals(clusterObserver)) continue;
                        iterator.remove();
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "removeDeregisteredObserver removed observer", clusterObserver);
                    }
                }
                if (set == null || set.isEmpty()) {
                    iterator = map2.remove(string);
                    if (tc.isDebugEnabled()) {
                        if (iterator != null) {
                            Tr.debug(tc, "removeDeregisteredObserver removed notification", string);
                        } else {
                            Tr.debug(tc, "Unexpected removeDeregisteredObserver notification not removed", string);
                        }
                    }
                    if (map2.isEmpty()) {
                        weakReference = this.coIdentifiers.remove(identity);
                        if (tc.isDebugEnabled()) {
                            if (weakReference != null) {
                                Tr.debug(tc, "removeDeregisteredObserver cleared ref", identity);
                            } else {
                                Tr.debug(tc, "Unexpected removeDeregisteredObserver ref did not exist", identity);
                            }
                        }
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected empty notification in removeDeregisteredObserver");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeDeregisteredObserver");
        }
    }

    public static boolean getPurgeNotificationsValue() {
        ProcessProperties processProperties = ProcessProperties.getInstance();
        String string = (String)processProperties.get("IBM_CLUSTER_PURGE_NOTIFICATIONS");
        boolean bl = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PurgeNotifications is currently set to " + string);
        }
        if (string != null && string.compareToIgnoreCase("true") == 0) {
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PurgeNotifications is currently set to " + bl);
        }
        return bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.35.1.8 ");
        }
    }
}

