/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.Contract;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.IdentityMap;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.websphere.cluster.topography.ProcessDescription;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.WLMCustomPropertyUtility;
import com.ibm.ws.cluster.service.ClusterManagementImpl;
import com.ibm.ws.cluster.service.EndPointImpl;
import com.ibm.ws.cluster.service.ServerClusterContextFactory;
import com.ibm.ws.cluster.service.ServerClusterContextImpl;
import com.ibm.ws.cluster.service.delaycache.DelayCache;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.ContractImpl;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescription;
import com.ibm.ws.cluster.topography.TriggerInfoImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.Server;
import com.ibm.wsspi.cluster.ClusterManagement;
import com.ibm.wsspi.cluster.ClusterManagementFactory;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.IdentityMapping;
import com.ibm.wsspi.cluster.NoClusterDefinedException;
import com.ibm.wsspi.cluster.distribution.ClusterContextDistributor;
import com.ibm.wsspi.cluster.distribution.ServerClusterContext;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ClusterMemberServiceImpl
extends WsComponentImpl
implements ClusterMemberService {
    private static final TraceComponent tc = Tr.register(ClusterMemberServiceImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private DescriptionManager ivDescMgr = DescriptionManagerFactory.getDescriptionManager();
    private ServerClusterContext ivServerClusterContext = ServerClusterContextFactory.getServerClusterContextFactory().createServerClusterContext();
    private Map localJoinedClusterMap = Collections.synchronizedMap(new HashMap());
    private DescriptionKey activeClusterSetKey;
    private IdentityMap activeClusterSet;
    private Map ivDistributors = new HashMap();
    private String ivCellName = null;
    private String ivNodeName = null;
    private String ivProcessName = null;
    private ProcessDescription ivClusterMember = null;
    private Contract ivContract = null;
    private ClusterManagement ivClusterManagement = ClusterManagementFactory.getClusterManagement();
    private ProcessProperties ivProcessProperties = null;
    private Server server = null;
    private static Integer acsDelayPostingWaitTime;
    static /* synthetic */ Class class$com$ibm$websphere$cluster$topography$ClusterDescription;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", object);
        }
        this.ivContract = new ContractImpl();
        this.ivContract.addEvent(TriggerInfoImpl.TRIGGER_STRUCTURE);
        this.ivContract.addEvent(TriggerInfoImpl.TRIGGER_INFLUENCE);
        this.ivContract.setInterest(new ConcernImpl(Integer.MAX_VALUE));
        try {
            this.server = (Server)WsServiceRegistry.getService(this, Server.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ClusterMemberServiceImpl.class.getName() + ".initialize", "199");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize getService Failed");
            }
            throw new ComponentDisabledException();
        }
        this.ivCellName = this.server.getCellName();
        this.ivNodeName = this.server.getNodeName();
        this.ivProcessName = this.server.getName();
        this.activeClusterSetKey = (DescriptionKey)IdentityMapping.getActiveClusterSetIdentityFromCellName(this.ivCellName);
        this.activeClusterSet = this.getActiveClusterSet();
        DescriptionKey descriptionKey = (DescriptionKey)((ClusterManagementImpl)this.ivClusterManagement).createClusterMember(this.ivCellName, this.ivNodeName, null, this.ivProcessName);
        this.ivProcessProperties = ProcessProperties.getInstance();
        this.ivProcessProperties.put("key.local.member", descriptionKey);
        this.ivClusterMember = (ProcessDescription)this.ivDescMgr.getDescription(descriptionKey);
        Map map = this.localJoinedClusterMap;
        synchronized (map) {
            LinkedList<DescriptionKey> linkedList = (LinkedList<DescriptionKey>)this.localJoinedClusterMap.get(descriptionKey);
            if (linkedList == null) {
                linkedList = new LinkedList<DescriptionKey>();
                linkedList.add(descriptionKey);
            } else if (!linkedList.contains(descriptionKey)) {
                linkedList.add(descriptionKey);
            }
            this.localJoinedClusterMap.put(descriptionKey, linkedList);
        }
        try {
            WsServiceRegistry.addService(this, ClusterMemberService.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ClusterMemberServiceImpl.class.getName() + ".initialize", "235");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize addService Failed");
            }
            throw new ComponentDisabledException();
        }
        this.ivProcessProperties.put("key.clustermember.service", this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        super.start();
        if (this.server.getServerMode() == 1) {
            this.ivClusterMember.setAvailability((byte)9);
        } else {
            this.ivClusterMember.setAvailability((byte)0);
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
        DescriptionKey descriptionKey = KeyRepositoryFactory.getInstance().getKeyRepository().getDescriptionKey(this.ivClusterMember.getKey(), treeMap);
        SelectionClusterMemberDescription selectionClusterMemberDescription = (SelectionClusterMemberDescription)this.ivDescMgr.getDescription(descriptionKey);
        selectionClusterMemberDescription.updateMemento();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public EndPoint defineLocalScopedData(Identity identity, byte[] byArray) {
        EndPointImpl endPointImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "defineLocalScopedData ", identity);
        }
        try {
            endPointImpl = (EndPointImpl)this.ivDescMgr.getDescription((DescriptionKey)identity, EndPoint.class.getName());
            endPointImpl.setlocal(true);
            endPointImpl.setData(byArray);
            this.ivClusterMember.setExtrinsicData(endPointImpl);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, this.getClass().getName() + ".defineLocalScopedData", "341");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected exception ", exception);
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("An internal error occurred while trying to process the local data.");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "defineLocalScopedData", endPointImpl);
        }
        return endPointImpl;
    }

    public EndPoint defineMemberScopedData(Identity identity, byte[] byArray) {
        EndPoint endPoint;
        block2: {
            endPoint = null;
            try {
                endPoint = this.ivClusterManagement.defineMemberScopedData(this.ivClusterMember.getKey(), identity, byArray);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, ClusterMemberServiceImpl.class.getName() + ".defineMemberScopedData", "221");
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "unexpected exception ", exception);
            }
        }
        return endPoint;
    }

    public byte[] undefineMemberScopedData(EndPoint endPoint) {
        try {
            this.ivClusterManagement.undefineMemberScopedData(this.ivClusterMember.getKey(), endPoint);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ClusterMemberServiceImpl.class.getName() + ".undefineMemberScopedData", "240");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception ", exception);
            }
            return null;
        }
        return endPoint.getData();
    }

    public byte[] undefineLocalScopedData(EndPoint endPoint) {
        DescriptionKey descriptionKey = (DescriptionKey)endPoint.getIdentity();
        this.ivClusterMember.removeExtrinsicData(descriptionKey);
        return endPoint.getData();
    }

    public void joinCluster(Identity identity) throws NoClusterDefinedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "joinCluster", identity);
        }
        DescriptionKey descriptionKey = this.ivClusterMember.getKey();
        this.addToLocalJoinedClusterMap(identity, descriptionKey);
        this.addToActiveClusterSet(identity);
        this.ivClusterManagement.joinCluster(identity, new Identity[]{descriptionKey});
        ((ServerClusterContextImpl)this.ivServerClusterContext).updateLocalJoinedClusterMap(this.localJoinedClusterMap, this.localJoinedClusterMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "joinCluster", this.localJoinedClusterMap);
        }
    }

    public void disjoinCluster(Identity identity) throws NoClusterDefinedException {
        DescriptionKey descriptionKey;
        ClusterDescription clusterDescription;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disjoinCluster", identity);
        }
        if ((clusterDescription = (ClusterDescription)this.ivDescMgr.getDescription(descriptionKey = (DescriptionKey)identity)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "disjoinCluster", "throw NoClusterDefinedException()");
            }
            throw new NoClusterDefinedException();
        }
        DescriptionKey descriptionKey2 = this.ivClusterMember.getKey();
        this.ivClusterManagement.disjoinCluster(descriptionKey, new Identity[]{descriptionKey2});
        if (this.removeFromLocalJoinedClusterMap(identity, descriptionKey2)) {
            this.removeFromActiveClusterSet(identity);
        }
        ((ServerClusterContextImpl)this.ivServerClusterContext).updateLocalJoinedClusterMap(this.localJoinedClusterMap, this.localJoinedClusterMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disjoinCluster", this.localJoinedClusterMap);
        }
    }

    public ServerClusterContext getServerClusterContextListener() {
        return this.ivServerClusterContext;
    }

    public void registerDistributor(ClusterContextDistributor clusterContextDistributor, Identity identity) {
        this.ivDistributors.put(identity, clusterContextDistributor);
    }

    public void joinCluster(Identity[] identityArray) throws NoClusterDefinedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "joinCluster", identityArray);
        }
        HashMap<Identity, Object> hashMap = new HashMap<Identity, Object>();
        try {
            Identity identity = identityArray[0];
            Identity identity2 = null;
            int n = identityArray.length;
            for (int i = 1; i < n; ++i) {
                identity2 = identityArray[i];
                this.ivDescMgr.getDescription((DescriptionKey)identity2, (class$com$ibm$websphere$cluster$topography$ClusterDescription == null ? ClusterMemberServiceImpl.class$("com.ibm.websphere.cluster.topography.ClusterDescription") : class$com$ibm$websphere$cluster$topography$ClusterDescription).getName());
                this.addToLocalJoinedClusterMap(identity, identity2);
                hashMap.put(identity, null);
                this.ivClusterManagement.joinCluster(identity, new Identity[]{identity2});
                identity = identity2;
            }
            this.ivClusterManagement.joinCluster(identityArray[n - 1], new Identity[]{this.ivClusterMember.getKey()});
            this.addToLocalJoinedClusterMap(identityArray[n - 1], this.ivClusterMember.getKey());
            hashMap.put(identityArray[n - 1], null);
            ((ServerClusterContextImpl)this.ivServerClusterContext).updateLocalJoinedClusterMap(this.localJoinedClusterMap, this.localJoinedClusterMap);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ClusterMemberServiceImpl.class.getName() + ".joinCluster", "325");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception ", exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "joinCluster");
            }
            throw new NoClusterDefinedException(exception);
        }
        finally {
            this.addToActiveClusterSet(hashMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "joinCluster", this.localJoinedClusterMap);
        }
    }

    public void disjoinCluster(Identity[] identityArray) throws NoClusterDefinedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disjoinCluster", identityArray);
        }
        HashSet<DescriptionKey> hashSet = new HashSet<DescriptionKey>();
        int n = identityArray.length;
        if (n > 1) {
            DescriptionKey descriptionKey = (DescriptionKey)identityArray[n - 1];
            ClusterDescription clusterDescription = (ClusterDescription)this.ivDescMgr.getDescription(descriptionKey);
            if (clusterDescription == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "disjoinCluster", "throw NoClusterDefinedException()");
                }
                throw new NoClusterDefinedException();
            }
            for (int i = n - 2; i >= 0; --i) {
                DescriptionKey descriptionKey2 = (DescriptionKey)identityArray[i];
                DescriptionKey descriptionKey3 = clusterDescription.getKey();
                if (this.removeFromLocalJoinedClusterMap(descriptionKey2, descriptionKey3)) {
                    hashSet.add(descriptionKey2);
                }
                this.ivClusterManagement.disjoinCluster(descriptionKey2, new Identity[]{descriptionKey3});
                clusterDescription = (ClusterDescription)this.ivDescMgr.getDescription(descriptionKey2);
                if (clusterDescription != null) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "disjoinCluster", "throw NoClusterDefinedException()");
                }
                throw new NoClusterDefinedException();
            }
            ((ServerClusterContextImpl)this.ivServerClusterContext).updateLocalJoinedClusterMap(this.localJoinedClusterMap, this.localJoinedClusterMap);
            this.removeFromActiveClusterSet(hashSet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disjoinCluster", this.localJoinedClusterMap);
        }
    }

    public void defineAttribute(String string) {
        this.ivClusterManagement.defineAttribute(this.ivClusterMember.getKey(), string);
    }

    public void undefineAttribute(String string) {
        this.ivClusterManagement.undefineAttribute(this.ivClusterMember.getKey(), string);
    }

    public Identity getIdentity() {
        return this.ivClusterMember.getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLocalJoinedClusterMap(Identity identity, Identity identity2) {
        Map map = this.localJoinedClusterMap;
        synchronized (map) {
            LinkedList<Identity> linkedList = (LinkedList<Identity>)this.localJoinedClusterMap.get(identity);
            if (linkedList == null) {
                linkedList = new LinkedList<Identity>();
                linkedList.add(identity2);
            } else if (!linkedList.contains(identity2)) {
                linkedList.add(identity2);
            }
            this.localJoinedClusterMap.put(identity, linkedList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFromLocalJoinedClusterMap(Identity identity, Identity identity2) {
        boolean bl = false;
        Map map = this.localJoinedClusterMap;
        synchronized (map) {
            List list = (List)this.localJoinedClusterMap.get(identity);
            if (list != null && list.remove(identity2)) {
                if (list.isEmpty()) {
                    this.localJoinedClusterMap.remove(identity);
                    bl = true;
                } else {
                    this.localJoinedClusterMap.put(identity, list);
                }
            }
        }
        return bl;
    }

    private void addToActiveClusterSet(Identity identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToActiveClusterSet", identity);
        }
        if (DelayCache.useDelayedActiveClusterSet()) {
            this.activeClusterSet.put(identity, null, acsDelayPostingWaitTime);
        } else {
            this.activeClusterSet.put(identity, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToActiveClusterSet", this.activeClusterSet);
        }
    }

    private void addToActiveClusterSet(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToActiveClusterSet", map);
        }
        if (DelayCache.useDelayedActiveClusterSet()) {
            this.activeClusterSet.putAll(map, acsDelayPostingWaitTime);
        } else {
            this.activeClusterSet.putAll(map);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToActiveClusterSet", this.activeClusterSet);
        }
    }

    private IdentityMap getActiveClusterSet() {
        IdentityMap identityMap;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getActiveClusterSet");
            }
            identityMap = null;
            try {
                identityMap = (IdentityMap)this.ivDescMgr.getDescription(this.activeClusterSetKey, IdentityMap.class.getName());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, ClusterMemberServiceImpl.class.getName() + "getIdentityMap", "623");
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "unexpected", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActiveClusterSet", identityMap.toString());
        }
        return identityMap;
    }

    private void removeFromActiveClusterSet(Identity identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeFromActiveClusterSet", identity);
        }
        if (DelayCache.useDelayedActiveClusterSet()) {
            this.activeClusterSet.remove((Object)identity, acsDelayPostingWaitTime);
        } else {
            this.activeClusterSet.remove(identity);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeFromActiveClusterSet", this.activeClusterSet);
        }
    }

    private void removeFromActiveClusterSet(HashSet hashSet) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeFromActiveClusterSet", hashSet);
        }
        if (DelayCache.useDelayedActiveClusterSet()) {
            this.activeClusterSet.removeSet(hashSet, acsDelayPostingWaitTime);
        } else {
            this.activeClusterSet.removeSet(hashSet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeFromActiveClusterSet", this.activeClusterSet);
        }
    }

    public void setWaitTime(int n) {
        acsDelayPostingWaitTime = new Integer(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentityMap setupForUT() {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setupForUT");
        }
        this.ivContract = new ContractImpl();
        this.ivContract.addEvent(TriggerInfoImpl.TRIGGER_STRUCTURE);
        this.ivContract.addEvent(TriggerInfoImpl.TRIGGER_INFLUENCE);
        this.ivContract.setInterest(new ConcernImpl(Integer.MAX_VALUE));
        this.ivCellName = "UTCell";
        this.ivNodeName = "UTNode";
        this.ivProcessName = "UTServer";
        this.activeClusterSetKey = (DescriptionKey)IdentityMapping.getActiveClusterSetIdentityFromCellName(this.ivCellName);
        this.activeClusterSet = this.getActiveClusterSet();
        DescriptionKey descriptionKey = (DescriptionKey)((ClusterManagementImpl)this.ivClusterManagement).createClusterMember(this.ivCellName, this.ivNodeName, null, this.ivProcessName);
        this.ivProcessProperties = ProcessProperties.getInstance();
        this.ivProcessProperties.put("key.local.member", descriptionKey);
        this.ivClusterMember = (ProcessDescription)this.ivDescMgr.getDescription(descriptionKey);
        TreeMap<String, String> treeMap = this.localJoinedClusterMap;
        synchronized (treeMap) {
            object = (LinkedList<DescriptionKey>)this.localJoinedClusterMap.get(descriptionKey);
            if (object == null) {
                object = new LinkedList<DescriptionKey>();
                object.add(descriptionKey);
            } else if (!object.contains(descriptionKey)) {
                object.add(descriptionKey);
            }
            this.localJoinedClusterMap.put(descriptionKey, object);
        }
        this.ivProcessProperties.put("key.clustermember.service", this);
        treeMap = new TreeMap<String, String>();
        treeMap.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
        object = KeyRepositoryFactory.getInstance().getKeyRepository().getDescriptionKey(this.ivClusterMember.getKey(), treeMap);
        SelectionClusterMemberDescription selectionClusterMemberDescription = (SelectionClusterMemberDescription)this.ivDescMgr.getDescription((DescriptionKey)object);
        selectionClusterMemberDescription.updateMemento();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setupForUT");
        }
        return this.activeClusterSet;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.60.1.2 ");
        }
        acsDelayPostingWaitTime = new Integer(WLMCustomPropertyUtility.getACSDelayPostingWaitTimeValue());
    }
}

