/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.classloader.ClassGraph;
import com.ibm.ws.classloader.ReloadableClassLoader;
import com.ibm.ws.util.PathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class JarClassLoader
extends ReloadableClassLoader {
    private static final TraceComponent tc = Tr.register(JarClassLoader.class, "Websphere ClassLoader", null);
    protected Map jarPaths = new LinkedHashMap();
    protected boolean delegationMode = false;

    public JarClassLoader(String[] stringArray, ClassLoader classLoader, boolean bl) {
        super(classLoader);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JarClassLoader", stringArray);
        }
        this.setPaths(stringArray);
        this.delegationMode = bl;
        this.createLoader();
        Tr.exit(tc, "JarClassLoader");
    }

    public JarClassLoader(String[] stringArray, ClassLoader classLoader, boolean bl, boolean bl2) {
        super(classLoader, bl2);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JarClassLoader", stringArray);
        }
        this.setPaths(stringArray);
        this.delegationMode = bl;
        this.createLoader();
        Tr.exit(tc, "JarClassLoader");
    }

    public JarClassLoader(String string, ClassLoader classLoader, ClassGraph classGraph, boolean bl) {
        this(new String[]{string}, classLoader, bl);
    }

    public void dispose(boolean bl) {
        super.dispose(bl);
        this.jarPaths = null;
    }

    public String[] getPaths() {
        Set set = this.jarPaths.keySet();
        String[] stringArray = new String[set.size()];
        set.toArray(stringArray);
        return stringArray;
    }

    protected boolean addPath(String string) {
        return this.jarPaths.put(string, Boolean.TRUE) == null;
    }

    public void addPaths(String[] stringArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addPaths paths='" + PathUtils.arrayToString((String[])stringArray) + "'");
        }
        if (stringArray != null && stringArray.length != 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.addPath(stringArray[i])) continue;
                arrayList.add(stringArray[i]);
            }
            if (this.classLoader != null) {
                this.classLoader.addPaths(arrayList.toArray(new String[0]));
            }
        }
    }

    public void addNativeLibPaths(String[] stringArray) {
        if (this.classLoader != null) {
            this.classLoader.addNativeLibPaths(stringArray);
        }
    }

    protected boolean removePath(String string) {
        return this.jarPaths.remove(string) != null;
    }

    public void removePaths(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.removePath(stringArray[i])) continue;
            arrayList.add(stringArray[i]);
        }
        if (this.classLoader != null) {
            String[] stringArray2 = new String[arrayList.size()];
            arrayList.toArray(stringArray2);
            this.classLoader.removePaths(stringArray2);
        }
    }

    protected void setPaths(String[] stringArray) {
        this.jarPaths = new LinkedHashMap();
        this.addPaths(stringArray);
    }

    public boolean getDelegationMode() {
        return this.delegationMode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('@');
        stringBuffer.append(this.hashCode());
        stringBuffer.append(" Local Classpath: ");
        if (this.jarPaths != null) {
            String[] stringArray = this.getPaths();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(File.pathSeparator);
                }
                stringBuffer.append(stringArray[i]);
            }
        }
        if (this.classLoader != null) {
            boolean bl = this.classLoader.getDelegationMode();
            stringBuffer.append(" Delegation mode: ");
            stringBuffer.append(bl ? "PARENT_FIRST" : "PARENT_LAST");
        }
        if (this.disposed) {
            stringBuffer.append("DISPOSED CLASSLOADER");
        }
        return stringBuffer.toString();
    }
}

