/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.buffermgmt.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.PooledWsByteBufferImpl;
import com.ibm.ws.buffermgmt.impl.WsByteBufferImpl;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.util.objectpool.ObjectDestroyer;
import com.ibm.ws.util.objectpool.ObjectFactory;
import com.ibm.ws.util.objectpool.TwoTierObjectPool;

public class WsByteBufferPool {
    private int intEntrySize;
    private int globalPoolSize;
    private int localThreadPoolSize;
    private TwoTierObjectPool pool = null;
    private WsByteBufferFactory wsbbFactory = null;
    int intUniqueCounter = 0;
    private static final TraceComponent tc = Tr.register(WsByteBufferPool.class, "WsByteBuffer", "com.ibm.ws.buffermgmt.resources.wsbytebuffermessages");

    public WsByteBufferPool(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        this.intEntrySize = n;
        this.globalPoolSize = n3;
        this.localThreadPoolSize = n2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Creating WsByteBufferPool: " + this.toString() + " backing pool size: " + this.globalPoolSize + " local thread pool size: " + this.localThreadPoolSize);
        }
        this.wsbbFactory = new WsByteBufferFactory();
        this.pool = bl2 ? new TwoTierObjectPool(this.localThreadPoolSize, this.globalPoolSize, this.wsbbFactory, this.wsbbFactory, bl) : new TwoTierObjectPool(this.localThreadPoolSize, this.globalPoolSize, this.wsbbFactory, null, bl);
        if (!bl3) {
            this.pool.doNotCleanUpOld();
        }
    }

    public PooledWsByteBufferImpl getEntry() {
        PooledWsByteBufferImpl pooledWsByteBufferImpl = null;
        pooledWsByteBufferImpl = (PooledWsByteBufferImpl)this.pool.get();
        return pooledWsByteBufferImpl;
    }

    public void release(Object object, Object object2) {
        this.pool.put(object);
    }

    public Object[] getInUse() {
        return this.pool.getInUseTable();
    }

    public void removeFromInUse(Object object) {
        this.pool.removeFromInUse(object);
    }

    public String toString() {
        String string = "WSByteBufferPool: " + super.toString() + " buffer size: " + this.intEntrySize;
        return string;
    }

    public class WsByteBufferFactory
    implements ObjectFactory,
    ObjectDestroyer {
        private WsByteBufferPoolManagerImpl wsbbPoolManager = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object create() {
            int n;
            PooledWsByteBufferImpl pooledWsByteBufferImpl = new PooledWsByteBufferImpl();
            WsByteBufferFactory wsByteBufferFactory = this;
            synchronized (wsByteBufferFactory) {
                n = WsByteBufferPool.this.intUniqueCounter++;
                if (WsByteBufferPool.this.intUniqueCounter == -1) {
                    ++WsByteBufferPool.this.intUniqueCounter;
                }
            }
            pooledWsByteBufferImpl.setID(new Integer(n));
            return pooledWsByteBufferImpl;
        }

        public void destroy(Object object) {
            if (this.wsbbPoolManager == null) {
                this.wsbbPoolManager = (WsByteBufferPoolManagerImpl)WsByteBufferPoolManagerImpl.getRef();
            }
            if (this.wsbbPoolManager != null) {
                this.wsbbPoolManager.releasing(((WsByteBufferImpl)object).oByteBuffer);
            }
        }
    }
}

