/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.SyncToOSThreadHelper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessControlContext;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;

public final class WSSubject {
    private static final TraceComponent tc = Tr.register(WSSubject.class, null, "com.ibm.ejs.resources.security");
    private static final SyncToOSThreadHelper syncHelper = new SyncToOSThreadHelper();
    private static final AuthPermission DOAS_PERM = new AuthPermission("doAs");
    private static final AuthPermission DOASPRIVILEGED_PERM = new AuthPermission("doAsPrivileged");
    private static final AuthPermission GETCALLERSUBJECT_PERM = new AuthPermission("wssecurity.getCallerSubject");
    private static final AuthPermission GETRUNASSUBJECT_PERM = new AuthPermission("wssecurity.getRunAsSubject");
    private static final AuthPermission SETRUNASSUBJECT_PERM = new AuthPermission("wssecurity.setRunAsSubject");
    private static final PrivilegedExceptionAction getCallerSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws WSSecurityException {
            ContextManager contextManager;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "WSSubject.getCallerSubjectAction.run");
            }
            if ((contextManager = ContextManagerFactory.getInstance()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to get ContextManager");
                }
                throw new WSSecurityException("Failed to get ContextManager");
            }
            Subject subject = contextManager.getCallerSubject();
            if (subject != null) {
                subject.setReadOnly();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No caller subject");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "WSSubject.getCallerSubjectAction.run");
            }
            return subject;
        }
    };
    private static final PrivilegedExceptionAction getRunAsSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws WSSecurityException {
            ContextManager contextManager;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "WSSubject.getRunAsSubjectAction.run");
            }
            if ((contextManager = ContextManagerFactory.getInstance()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to get ContextManager");
                }
                throw new WSSecurityException("Failed to get ContextManager");
            }
            Subject subject = contextManager.getInvocationSubject();
            if (subject != null) {
                subject.setReadOnly();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No invocation credential");
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "WSSubject.getRunAsSubjectAction.run");
            }
            return subject;
        }
    };

    public static Object doAs(Subject subject, PrivilegedAction privilegedAction) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doAs", new Object[]{subject, privilegedAction});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(DOAS_PERM);
        }
        if (privilegedAction == null) {
            throw new IllegalArgumentException("null PrivilegedAction provided");
        }
        SubjectCookie subjectCookie = WSSubject.setInvocationSubject(subject);
        try {
            Object t = Subject.doAs(subject, privilegedAction);
            return t;
        }
        catch (Throwable throwable) {
            Tr.event(tc, "WSSubject.doAs(Subject, PrivilegedAction) Exception caught " + WSSubject.dump(throwable));
            FFDCFilter.processException(throwable, "com.ibm.websphere.security.auth.WSSubject.doAs", "123");
            throw new RuntimeException(throwable);
        }
        finally {
            WSSubject.restoreInvocationSubject(subjectCookie);
        }
    }

    public static Object doAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doAs", new Object[]{subject, privilegedExceptionAction});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(DOAS_PERM);
        }
        if (privilegedExceptionAction == null) {
            throw new IllegalArgumentException("null PrivilegedExceptionAction provided");
        }
        SubjectCookie subjectCookie = WSSubject.setInvocationSubject(subject);
        try {
            Object t = Subject.doAs(subject, privilegedExceptionAction);
            return t;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException;
        }
        catch (Throwable throwable) {
            Tr.event(tc, "WSSubject.doAs(Subject, PrivilegedExceptionAction) Exception caught " + WSSubject.dump(throwable));
            FFDCFilter.processException(throwable, "com.ibm.websphere.security.auth.WSSubject.doAs", "177");
            throw new RuntimeException(throwable);
        }
        finally {
            WSSubject.restoreInvocationSubject(subjectCookie);
        }
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doAsPrivileged", new Object[]{subject, privilegedAction, accessControlContext});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(DOASPRIVILEGED_PERM);
        }
        if (privilegedAction == null) {
            throw new IllegalArgumentException("null PrivilegedAction provided");
        }
        SubjectCookie subjectCookie = WSSubject.setInvocationSubject(subject);
        try {
            Object t = Subject.doAsPrivileged(subject, privilegedAction, accessControlContext);
            return t;
        }
        catch (Throwable throwable) {
            Tr.event(tc, "WSSubject.doAsPrivileged(Subject, PrivilegedAction, AccessControlContext) Exception caught " + WSSubject.dump(throwable));
            FFDCFilter.processException(throwable, "com.ibm.websphere.security.auth.WSSubject.doAsPrivileged", "227");
            throw new RuntimeException(throwable);
        }
        finally {
            WSSubject.restoreInvocationSubject(subjectCookie);
        }
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doAsPrivileged", new Object[]{subject, privilegedExceptionAction, accessControlContext});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(DOASPRIVILEGED_PERM);
        }
        if (privilegedExceptionAction == null) {
            throw new IllegalArgumentException("null PrivilegedExceptionAction provided");
        }
        SubjectCookie subjectCookie = WSSubject.setInvocationSubject(subject);
        try {
            Object t = Subject.doAsPrivileged(subject, privilegedExceptionAction, accessControlContext);
            return t;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException;
        }
        catch (Throwable throwable) {
            Tr.event(tc, "WSSubject.doAsPrivileged(Subject, PrivilegedExceptionAction, AccessControlContext) Exception caught " + WSSubject.dump(throwable));
            FFDCFilter.processException(throwable, "com.ibm.websphere.security.auth.WSSubject.doAsPrivileged", "283");
            throw new RuntimeException(throwable);
        }
        finally {
            WSSubject.restoreInvocationSubject(subjectCookie);
        }
    }

    public static Subject getCallerSubject() throws WSSecurityException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCallerSubject");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GETCALLERSUBJECT_PERM);
        }
        Subject subject = null;
        if (SecurityContext.isServerProcess()) {
            try {
                subject = (Subject)AccessController.doPrivileged(getCallerSubjectAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                WSSecurityException wSSecurityException = (WSSecurityException)privilegedActionException.getException();
                Tr.event(tc, "Failed in getting the caller identity: " + WSSubject.dump(wSSecurityException));
                FFDCFilter.processException(wSSecurityException, "com.ibm.websphere.security.auth.WSSubject.getCallerSubject", "348");
                throw wSSecurityException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCallerSubject", subject);
        }
        return subject;
    }

    public static Subject getRunAsSubject() throws WSSecurityException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunAsSubject");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GETRUNASSUBJECT_PERM);
        }
        Subject subject = null;
        try {
            subject = (Subject)AccessController.doPrivileged(getRunAsSubjectAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            WSSecurityException wSSecurityException = (WSSecurityException)privilegedActionException.getException();
            Tr.event(tc, "Failed in getting the run as identity: " + WSSubject.dump(wSSecurityException));
            FFDCFilter.processException(wSSecurityException, "com.ibm.websphere.security.auth.WSSubject.getRunAsSubject", "406");
            throw wSSecurityException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunAsSubject", subject);
        }
        return subject;
    }

    public static void setRunAsSubject(final Subject subject) throws WSSecurityException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRunAsSubject", subject);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(SETRUNASSUBJECT_PERM);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws WSSecurityException {
                    ContextManager contextManager = ContextManagerFactory.getInstance();
                    contextManager.setInvocationSubject(subject);
                    contextManager.addWSSubjectToCache(subject);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            WSSecurityException wSSecurityException = (WSSecurityException)privilegedActionException.getException();
            Tr.event(tc, "Failed in setting the run as identity: " + WSSubject.dump(wSSecurityException));
            FFDCFilter.processException(wSSecurityException, "com.ibm.websphere.security.auth.WSSubject.setRunAsSubject", "457");
            throw wSSecurityException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRunAsSubject");
        }
    }

    public static String getCallerPrincipal() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCallerPrincipal");
        }
        String string = null;
        try {
            WSCredential wSCredential;
            Subject subject = ContextManagerFactory.getInstance().getCallerSubject();
            if (subject != null && (wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject)) != null && !wSCredential.isUnauthenticated()) {
                string = wSCredential.getSecurityName();
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception of getting the caller principal", WSSubject.dump(generalSecurityException));
            }
            FFDCFilter.processException(generalSecurityException, "com.ibm.websphere.security.auth.WSSubject.getCallerPrincipal", "509");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCallerPrincipal", string);
        }
        return string;
    }

    public static Throwable getRootLoginException() {
        return ContextManagerFactory.getInstance().getRootException();
    }

    private static SubjectCookie setInvocationSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInvocationSubject", subject);
        }
        SubjectCookie subjectCookie = new SubjectCookie();
        try {
            if (subject == null) {
                subject = SubjectHelper.createUnauthenticatedSubject();
            }
            subjectCookie.subject = ContextManagerFactory.getInstance().pushInvocationSubject(subject);
            subjectCookie.syncEnabled = syncHelper.isThreadLocalApplicationSyncEnabled();
            if (syncHelper.isCurrentComponentAppSyncEnabled()) {
                subjectCookie.credToken = syncHelper.setAppSyncToThread(subject);
                syncHelper.setThreadLocalApplicationSyncEnabled(true);
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSubject.setInvocationSubject(Subject), Exception caught " + WSSubject.dump(throwable));
            }
            FFDCFilter.processException(throwable, "com.ibm.websphere.security.auth.WSSubject.setInvocationSubject", "591");
            WSSubject.restoreInvocationSubject(subjectCookie);
            throw new RuntimeException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInvocationSubject", subjectCookie);
        }
        return subjectCookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoreInvocationSubject(SubjectCookie subjectCookie) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreInvocationSubject", subjectCookie);
        }
        try {
            try {
                if (syncHelper.isCurrentComponentAppSyncEnabled()) {
                    syncHelper.setThreadLocalApplicationSyncEnabled(subjectCookie.syncEnabled);
                    syncHelper.restoreAppSyncToThread(subjectCookie.credToken);
                }
            }
            finally {
                ContextManagerFactory.getInstance().popInvocationSubject(subjectCookie.subject);
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSubject.restoreInvocationSubject(Subject) Exception caught " + WSSubject.dump(throwable));
            }
            FFDCFilter.processException(throwable, "com.ibm.websphere.security.auth.WSSubject.restoreInvocationSubject", "628");
            throw new RuntimeException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreInvocationSubject");
        }
    }

    private static String dump(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private WSSubject() {
    }

    private static final class SubjectCookie {
        boolean syncEnabled = false;
        Subject subject = null;
        Object credToken = null;

        SubjectCookie() {
        }

        public String toString() {
            return super.toString() + ";syncEnabled=" + this.syncEnabled + ",credToken=" + this.credToken + ",subject=" + this.subject;
        }
    }
}

