/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws390.utility.ws390FileUtilities;
import java.io.File;
import java.io.IOException;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;

public class EarUtils {
    private static TraceComponent tc = Tr.register(EarUtils.class);
    private static int[][] versionTable = new int[][]{{12, 5}, {13, 5}, {14, 6}};

    public static EARFile getEarFile(String string, boolean bl) throws OpenFailureException {
        return EarUtils.getEarFile(string, bl, false);
    }

    public static EARFile getEarFile(String string, boolean bl, boolean bl2) throws OpenFailureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEarFile " + string);
        }
        EARFile eARFile = null;
        CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
        ArchiveOptions archiveOptions = new ArchiveOptions();
        archiveOptions.setUseJavaReflection(bl);
        archiveOptions.setIsReadOnly(bl2);
        eARFile = commonarchiveFactory.openEARFile(archiveOptions, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEarFile " + eARFile);
        }
        return eARFile;
    }

    public static void extractEar(EARFile eARFile, String string, boolean bl) throws SaveFailureException, IOException {
        EarUtils.extractEar(eARFile, string, bl, 66);
    }

    public static void extractEar(EARFile eARFile, String string, boolean bl, int n) throws SaveFailureException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractEar: " + string);
        }
        File file = new File(string);
        if (bl && file.exists()) {
            EarUtils.deleteDirTree(file);
        }
        file.mkdirs();
        eARFile.extractTo(string, n);
        if (AdminHelper.getPlatformHelper().isZOS()) {
            EarUtils.setDLLExecutePermissions(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractEar");
        }
    }

    private static void setDLLExecutePermissions(String string) {
        File file;
        File[] fileArray;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDLLExecutePermissions " + string);
        }
        int n2 = n = (fileArray = (file = new File(string)).listFiles()) != null ? fileArray.length : 0;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Number of files= " + n);
        }
        for (int i = 0; i < n; ++i) {
            int n3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Check dir entry=" + fileArray[i].getName());
            }
            String string2 = string + File.separator + fileArray[i].getName();
            if (fileArray[i].isDirectory()) {
                EarUtils.setDLLExecutePermissions(string2);
                continue;
            }
            if (!fileArray[i].getName().endsWith(".so")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Set execute permission on file=" + string2);
            }
            if ((n3 = ws390FileUtilities.chmod((String)string2, (int)509)) == 0) continue;
            Tr.debug(tc, "chmod return code= " + n3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDLLExecutePermissions");
        }
    }

    public static synchronized void deleteDirTree(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteDirTree");
        }
        EarUtils.deleteDirTree(new File(string));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteDirTree");
        }
    }

    public static synchronized void deleteDirTree(File file) throws IOException {
        if (!file.exists()) {
            Tr.event(tc, "directory does not exist");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteDirTree");
            }
            return;
        }
        String string = System.getProperty("os.name");
        boolean bl = true;
        if (!string.startsWith("Windows")) {
            bl = string.equals("OS/400") ? file.getAbsolutePath().equalsIgnoreCase(file.getCanonicalPath()) : file.getAbsolutePath().equals(file.getCanonicalPath());
        }
        if (!bl) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "file/dir a symlink: " + file);
            }
            if (!file.delete()) {
                Tr.warning(tc, "ADMA0078W", file);
            }
            return;
        }
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file.getPath(), stringArray[i]);
                EarUtils.deleteDirTree(file2);
            }
        }
        if (!file.delete()) {
            Tr.warning(tc, "ADMA0078W", file);
        }
    }

    public static int getAppVersionForDeployment(EARFile eARFile) {
        int n = eARFile.getDeploymentDescriptor().getVersionID();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "App Version in app DD " + n);
        }
        return n;
    }

    public static int getLowestNodeVersionForModule(Module module) {
        int n = module.getApplication().getVersionID();
        for (int i = 0; i < versionTable.length; ++i) {
            if (n != versionTable[i][0]) continue;
            return versionTable[i][1];
        }
        return Integer.MAX_VALUE;
    }
}

