/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASFileHandler;
import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASIFormatter;
import com.ibm.ras.RASUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RASMultiFileHandler
extends RASFileHandler {
    private static final String S = "(C) Copyright IBM Corp. 1999.";
    private static final long serialVersionUID = -6038340063368985500L;
    public static final int DEFAULT_FILE_NUMBER = 3;
    public static final int DEFAULT_FILE_SIZE = 512;
    protected transient long fileSize;
    private int maxFiles;
    private long maxFileSize;
    protected String baseFileName;
    protected String fileDir;
    protected String fileExt;

    public RASMultiFileHandler() {
    }

    public RASMultiFileHandler(String string) {
        super(string);
    }

    public RASMultiFileHandler(String string, String string2) {
        super(string, string2);
    }

    public RASMultiFileHandler(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public RASMultiFileHandler(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
    }

    protected void init() {
        super.init();
        this.fileSize = 0L;
        this.setMaxFiles(3);
        this.setMaxFileSize(512);
        this.baseFileName = null;
        this.fileDir = null;
        this.fileExt = null;
    }

    public Hashtable getConfig() {
        Hashtable hashtable = super.getConfig();
        hashtable.put("maxFiles", new Integer(this.getMaxFiles()).toString());
        hashtable.put("maxFileSize", new Integer(this.getMaxFileSize()).toString());
        return hashtable;
    }

    public void setConfig(Hashtable hashtable) {
        this.init();
        super.setConfig(hashtable);
        if (hashtable.containsKey("maxFiles")) {
            this.setMaxFiles(new Integer((String)hashtable.get("maxFiles")));
        }
        if (hashtable.containsKey("maxFileSize")) {
            this.setMaxFileSize(new Integer((String)hashtable.get("maxFileSize")));
        }
    }

    public void setFileName(String string) {
        if (string != null) {
            int n;
            super.setFileName(string);
            string = this.getFileName();
            String string2 = new File(string).getAbsolutePath();
            File file = new File(string2);
            this.fileDir = file.getParent();
            if (this.fileDir != null && !this.fileDir.endsWith(File.separator)) {
                this.fileDir = this.fileDir + File.separator;
            }
            if ((n = (string2 = file.getName()).lastIndexOf(46)) == -1) {
                this.baseFileName = string2;
            } else {
                this.baseFileName = string2.substring(0, n);
                this.fileExt = string2.substring(n);
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (this.fileDir != null) {
                stringBuffer.append(this.fileDir);
            }
            stringBuffer.append(this.baseFileName + "1");
            if (this.fileExt != null) {
                stringBuffer.append(this.fileExt);
            }
            this.fileName = stringBuffer.toString();
        }
    }

    public String getNumberedFileName(int n) {
        String string;
        if (this.getFileName() == null || n < 1 || n > this.getMaxFiles()) {
            string = null;
        } else {
            string = this.fileDir + this.baseFileName + n;
            if (this.fileExt != null) {
                string = string + this.fileExt;
            }
        }
        return string;
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    public void setMaxFiles(int n) {
        if (n >= 0) {
            this.maxFiles = n;
        }
    }

    public int getMaxFileSize() {
        return (int)(this.maxFileSize / 1024L);
    }

    public void setMaxFileSize(int n) {
        if (n > 0) {
            this.maxFileSize = n * 1024;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDevice() {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.deviceOpen || this.fileSize >= this.maxFileSize) {
                this.closeDevice();
                if (this.fileSize >= this.maxFileSize) {
                    Vector vector = this.getDirList(this.fileDir);
                    vector = this.deleteExtraFiles(vector, this.fileDir);
                    this.renameFiles(vector, this.fileDir);
                }
                super.openDevice();
                this.fileSize = new File(this.getFileName()).length();
            }
        }
    }

    protected Vector getDirList(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                boolean bl = false;
                try {
                    int n;
                    int n2 = RASMultiFileHandler.this.baseFileName.length();
                    if (RASMultiFileHandler.this.fileExt == null) {
                        int n3;
                        if (string.startsWith(RASMultiFileHandler.this.baseFileName) && (n3 = Integer.parseInt(string.substring(n2))) >= 1 && n3 <= RASMultiFileHandler.this.getMaxFiles()) {
                            bl = true;
                        }
                    } else if (string.startsWith(RASMultiFileHandler.this.baseFileName) && string.endsWith(RASMultiFileHandler.this.fileExt) && (n = Integer.parseInt(string.substring(n2, string.indexOf(RASMultiFileHandler.this.fileExt)))) >= 1 && n <= RASMultiFileHandler.this.getMaxFiles()) {
                        bl = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return bl;
            }
        };
        Vector<String> vector = new Vector<String>();
        String[] stringArray = file.list(filenameFilter);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                vector.addElement(stringArray[i]);
            }
        }
        return this.sortFiles(vector);
    }

    protected void renameFiles(Vector vector, String string) {
        int n = vector.size() + 1;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = this.fileExt == null ? this.baseFileName + n : this.baseFileName + n + this.fileExt;
            File file = new File(string + string2);
            File file2 = new File(string + string3);
            file.renameTo(file2);
            --n;
        }
    }

    protected Vector sortFiles(Vector vector) {
        int n = this.baseFileName.length();
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            for (int j = i + 1; j < vector.size(); ++j) {
                int n2;
                int n3;
                String string2 = (String)vector.elementAt(j);
                if (this.fileExt == null) {
                    n3 = Integer.parseInt(string.substring(n));
                    n2 = Integer.parseInt(string2.substring(n));
                } else {
                    n3 = Integer.parseInt(string.substring(n, string.indexOf(this.fileExt)));
                    n2 = Integer.parseInt(string2.substring(n, string2.indexOf(this.fileExt)));
                }
                if (n3 >= n2) continue;
                vector.setElementAt(string2, i);
                vector.setElementAt(string, j);
                string = string2;
            }
        }
        return vector;
    }

    protected Vector deleteExtraFiles(Vector vector, String string) {
        int n = this.getMaxFiles();
        if (n > 0) {
            while (vector.size() >= n) {
                File file = new File(string + (String)vector.firstElement());
                file.delete();
                vector.removeElement(vector.firstElement());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeEvent(RASIEvent rASIEvent) {
        this.openDevice();
        Object object = this.deviceLock;
        synchronized (object) {
            RASIFormatter rASIFormatter;
            if (this.deviceOpen && (rASIFormatter = this.findFormatter(rASIEvent)) != null) {
                String string = rASIFormatter.format(rASIEvent);
                this.fileSize += (long)string.length();
                this.pWriter.println(string);
                if (this.pWriter.checkError()) {
                    this.closeDevice();
                    if (++this.deviceFailures <= 2) {
                        RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_WRITE_MSG", this.getName()));
                    }
                } else if (this.deviceFailures != 0) {
                    RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("RETRY_OK", this.getName()));
                    this.deviceFailures = 0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLog() {
        Object object = this.deviceLock;
        synchronized (object) {
            this.closeDevice();
            if (this.getFileName() != null) {
                Enumeration enumeration = this.getDirList(this.fileDir).elements();
                while (enumeration.hasMoreElements()) {
                    File file = new File(this.fileDir + (String)enumeration.nextElement());
                    if (!file.exists() || file.delete()) continue;
                    RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_DELETE_FILE", this.getFileName()));
                }
            }
        }
    }
}

