/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASConstants;
import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASIHandler;
import com.ibm.ras.RASILogger;
import com.ibm.ras.RASIMaskChangeListener;
import com.ibm.ras.RASMaskChangeEvent;
import com.ibm.ras.RASMaskChangeGenerator;
import com.ibm.ras.RASUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class RASLogger
extends RASMaskChangeGenerator
implements RASConstants,
RASILogger,
RASIMaskChangeListener {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    public boolean isLogging;
    private boolean isSync;
    protected transient int handlerFailures;
    protected long isLoggableMask;
    private String handlerNames;
    private String client;
    private String server;
    private Vector handlers = new Vector(1);

    public RASLogger() {
    }

    public RASLogger(String string) {
        super(string);
    }

    public RASLogger(String string, String string2) {
        super(string, string2);
    }

    public RASLogger(String string, String string2, String string3, String string4) {
        this(string, string2);
        this.setServer(string3);
        this.setClient(string4);
    }

    protected void init() {
        super.init();
        this.setLogging(false);
        this.setSynchronous(false);
        this.handlerFailures = 0;
        this.isLoggableMask = 0L;
        this.handlerNames = "";
        this.setClient("");
        this.setServer("");
        this.addMaskChangeListener(this);
    }

    public Hashtable getConfig() {
        Hashtable hashtable = super.getConfig();
        hashtable.put("isLogging", new Boolean(this.isLogging).toString());
        hashtable.put("isSync", new Boolean(this.isSync).toString());
        hashtable.put("server", this.getServer());
        hashtable.put("client", this.getClient());
        hashtable.put("handlerNames", this.handlerNames);
        return hashtable;
    }

    public void setConfig(Hashtable hashtable) {
        super.setConfig(hashtable);
        if (hashtable.containsKey("isLogging")) {
            this.isLogging = new Boolean((String)hashtable.get("isLogging"));
        }
        if (hashtable.containsKey("isSync")) {
            this.isSync = new Boolean((String)hashtable.get("isSync"));
        }
        if (hashtable.containsKey("server")) {
            this.setServer((String)hashtable.get("server"));
        }
        if (hashtable.containsKey("client")) {
            this.setClient((String)hashtable.get("client"));
        }
        if (hashtable.containsKey("handlerNames")) {
            this.handlerNames = (String)hashtable.get("handlerNames");
        }
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String string) {
        if (string != null) {
            this.client = string;
        }
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String string) {
        if (string != null) {
            this.server = string;
        }
    }

    public void addHandler(RASIHandler rASIHandler) {
        if (rASIHandler != null && !this.handlers.contains(rASIHandler)) {
            this.handlers.addElement(rASIHandler);
            rASIHandler.addMaskChangeListener(this);
            this.maskValueChanged(new RASMaskChangeEvent(this, 0L, 0L, false));
        }
    }

    public void removeHandler(RASIHandler rASIHandler) {
        if (rASIHandler != null && this.handlers.contains(rASIHandler)) {
            this.handlers.removeElement(rASIHandler);
            rASIHandler.removeMaskChangeListener(this);
            this.maskValueChanged(new RASMaskChangeEvent(this, 0L, 0L, false));
        }
    }

    public Enumeration getHandlers() {
        return this.handlers.elements();
    }

    public boolean isSynchronous() {
        return this.isSync;
    }

    public void setSynchronous(boolean bl) {
        this.isSync = bl;
    }

    public boolean isLogging() {
        return this.isLogging;
    }

    public void setLogging(boolean bl) {
        this.isLogging = bl;
    }

    public boolean isLoggable(long l) {
        boolean bl = false;
        long l2 = this.isLoggableMask ^ 0xFFFFFFFFFFFFFFFFL;
        if (this.isLogging && ((l | l2) ^ l2) != 0L) {
            bl = true;
        }
        return bl;
    }

    public abstract void maskValueChanged(RASMaskChangeEvent var1);

    public void fireRASEvent(RASIEvent rASIEvent) {
        if (rASIEvent != null) {
            Enumeration enumeration = this.getHandlers();
            if (enumeration.hasMoreElements()) {
                long l = rASIEvent.getType();
                while (enumeration.hasMoreElements()) {
                    RASIHandler rASIHandler = (RASIHandler)enumeration.nextElement();
                    long l2 = rASIEvent.isMessageEvent() ? rASIHandler.getMessageMask() ^ 0xFFFFFFFFFFFFFFFFL : rASIHandler.getTraceMask() ^ 0xFFFFFFFFFFFFFFFFL;
                    if (((l | l2) ^ l2) == 0L) continue;
                    if (this.isSynchronous()) {
                        rASIHandler.writeEvent(rASIEvent);
                        continue;
                    }
                    rASIHandler.logEvent(rASIEvent);
                }
                this.handlerFailures = 0;
            } else if (this.handlerFailures == 0) {
                RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_NO_HANDLERS", this.getName()));
                ++this.handlerFailures;
            }
        }
    }
}

