/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasEvent6;
import com.ibm.ejs.ras.TraceComponent;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;
import java.util.Vector;

public class StreamEvent6
extends RasEvent6 {
    private static final int svBasicFormatMaxNameLength = 13;
    private static String svAdvancedPadding = "          ";
    public String ivStringData = null;
    public byte[] ivByteArray = null;
    public char[] ivCharArray = null;
    public Vector ivDataCache = null;

    StreamEvent6(int n, TraceComponent traceComponent, String string) {
        super(n, traceComponent, null, null, "", "IBM", "WebSphere", "Application Server", null, false);
        this.ivStringData = string;
    }

    StreamEvent6(int n, TraceComponent traceComponent, byte[] byArray) {
        super(n, traceComponent, null, null, "", "IBM", "WebSphere", "Application Server", null, false);
        this.ivByteArray = byArray;
    }

    StreamEvent6(int n, TraceComponent traceComponent, char[] cArray) {
        super(n, traceComponent, null, null, "", "IBM", "WebSphere", "Application Server", null, false);
        this.ivCharArray = cArray;
    }

    synchronized void addDataCache(Vector vector) {
        this.ivDataCache = vector;
    }

    synchronized void writeSelfToStream(PrintStream printStream, String string, boolean bl, StringBuffer stringBuffer, DateFormat dateFormat, Date date, FieldPosition fieldPosition) {
        if ("basic".equals(string)) {
            this.formatHeaderBasic(stringBuffer, dateFormat, date, fieldPosition);
            printStream.print(new String(stringBuffer));
        } else {
            this.formatHeaderAdvanced(stringBuffer, dateFormat, date, fieldPosition);
            printStream.println(new String(stringBuffer));
            printStream.print(svAdvancedPadding);
        }
        this.writeDataToStream(printStream, bl);
    }

    synchronized void writeDataToStream(PrintStream printStream, boolean bl) {
        try {
            if (this.ivStringData != null) {
                printStream.print(this.ivStringData);
            }
            if (this.ivCharArray != null) {
                printStream.print(this.ivCharArray);
            }
            if (this.ivByteArray != null) {
                printStream.write(this.ivByteArray);
            }
            if (this.ivDataCache != null) {
                int n = this.ivDataCache.size();
                for (int i = 0; i < n; ++i) {
                    Object e = this.ivDataCache.elementAt(i);
                    if (e instanceof String) {
                        printStream.print((String)e);
                    }
                    if (e instanceof char[]) {
                        printStream.print((char[])e);
                    }
                    if (!(e instanceof byte[])) continue;
                    printStream.write((byte[])e);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (bl) {
            printStream.println();
        }
    }

    synchronized void writeSelfToStream(PrintWriter printWriter, String string, boolean bl, StringBuffer stringBuffer, DateFormat dateFormat, Date date, FieldPosition fieldPosition) {
        if ("basic".equals(string)) {
            this.formatHeaderBasic(stringBuffer, dateFormat, date, fieldPosition);
            printWriter.print(new String(stringBuffer));
        } else {
            this.formatHeaderAdvanced(stringBuffer, dateFormat, date, fieldPosition);
            printWriter.println(new String(stringBuffer));
            printWriter.print(svAdvancedPadding);
        }
        this.writeDataToStream(printWriter, bl);
    }

    synchronized void writeDataToStream(PrintWriter printWriter, boolean bl) {
        if (this.ivStringData != null) {
            printWriter.print(this.ivStringData);
        }
        if (this.ivCharArray != null) {
            printWriter.print(this.ivCharArray);
        }
        if (this.ivByteArray != null) {
            String string = new String(this.ivByteArray);
            printWriter.write(string);
        }
        if (this.ivDataCache != null) {
            int n = this.ivDataCache.size();
            for (int i = 0; i < n; ++i) {
                Object e = this.ivDataCache.elementAt(i);
                if (e instanceof String) {
                    printWriter.print((String)e);
                }
                if (e instanceof char[]) {
                    printWriter.print((char[])e);
                }
                if (!(e instanceof byte[])) continue;
                String string = new String((byte[])e);
                printWriter.write(string);
            }
        }
        if (bl) {
            printWriter.println();
        }
    }

    public String convertToString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.writeDataToStream(printWriter, false);
        return stringWriter.toString();
    }

    private void formatHeaderBasic(StringBuffer stringBuffer, DateFormat dateFormat, Date date, FieldPosition fieldPosition) {
        int n;
        this.formatTimeAndThread(stringBuffer, dateFormat, date, fieldPosition);
        String string = null;
        int n2 = this.ivEventSource.lastIndexOf(46) + 1;
        string = n2 + 13 >= this.ivEventSource.length() ? this.ivEventSource.substring(n2) : this.ivEventSource.substring(n2, n2 + 13);
        stringBuffer.append(string);
        for (int i = n = 13 - string.length(); i > 0; --i) {
            stringBuffer.append(' ');
        }
        try {
            stringBuffer.append(svTypePrefixes[this.ivType - 1]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            stringBuffer.append(" Z ");
        }
    }

    private void formatHeaderAdvanced(StringBuffer stringBuffer, DateFormat dateFormat, Date date, FieldPosition fieldPosition) {
        this.formatTimeAndThread(stringBuffer, dateFormat, date, fieldPosition);
        try {
            stringBuffer.append(svTypePrefixes[this.ivType - 1]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            stringBuffer.append(" Z ");
        }
        if (this.ivUnitOfWork == null) {
            stringBuffer.append("UOW= ");
        } else {
            stringBuffer.append("UOW=");
            stringBuffer.append(this.ivUnitOfWork);
        }
        stringBuffer.append(" source=");
        stringBuffer.append(this.ivEventSource);
        if (this.ivClassName != null) {
            stringBuffer.append(" class=");
            stringBuffer.append(this.ivClassName);
        }
        if (this.ivMethodName != null) {
            stringBuffer.append(" method=");
            stringBuffer.append(this.ivMethodName);
        }
        stringBuffer.append(" org=");
        stringBuffer.append(this.ivOrganization);
        stringBuffer.append(" prod=");
        stringBuffer.append(this.ivProduct);
        stringBuffer.append(" component=");
        stringBuffer.append(this.ivComponent);
        if (this.ivThreadName != null) {
            stringBuffer.append(" thread=[");
            stringBuffer.append(this.ivThreadName);
            stringBuffer.append("]");
        }
    }

    private void formatTimeAndThread(StringBuffer stringBuffer, DateFormat dateFormat, Date date, FieldPosition fieldPosition) {
        stringBuffer.setLength(0);
        stringBuffer.append('[');
        date.setTime(this.ivTimeStamp);
        dateFormat.format(date, stringBuffer, fieldPosition);
        stringBuffer.append("] ");
        stringBuffer.append(this.ivThreadId);
        stringBuffer.append(' ');
    }
}

