/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.LoggerHelper;
import com.ibm.ws.logging.TraceLogFormatter;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.logging.ZRasHelper;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;

public class CB390TraceEventListener
implements WsHandler {
    static final int LEVELVALUE_SEVERE = Level.SEVERE.intValue();
    static final int LEVELVALUE_WARNING = Level.WARNING.intValue();
    static final int RECORD_VERSION = 1;
    private static final int MAX_LOGSTREAM_HEADER_SIZE = 256;
    private static final String CLASSNAME = CB390TraceEventListener.class.getName();
    private static final String svLoggerName = "com.ibm.ejs.ras.CB390TraceEventListener";
    private static final String BUNDLENAME = "com.ibm.ejs.resources.RasMessages";
    private static Logger svLogger = null;
    private static boolean sbUseCBEFormat;
    private String serverName = nativeMethodsLoaded ? this.getServerName() : "";
    private static String ibm;
    private static String websphere;
    private static boolean nativeMethodsLoaded;

    private native String getServerName();

    private native void writeTrace(int var1, byte[] var2, int var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, int var12, String var13, String var14, String var15, byte[] var16, boolean var17);

    public void processEvent(LogRecord logRecord) {
        if (!nativeMethodsLoaded) {
            return;
        }
        if (svLogger.isLoggable(Level.FINE)) {
            svLogger.entering(CLASSNAME, "processEvent");
        }
        int n = 0;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        byte[] byArray = null;
        String string10 = null;
        String string11 = null;
        WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(logRecord);
        n = logRecord.getLevel().intValue();
        string3 = logRecord.getSourceMethodName();
        string4 = logRecord.getLoggerName();
        string8 = logRecord.getLevel().getName();
        if (wsLogRecord != null) {
            string9 = wsLogRecord.getStackTrace();
            byArray = wsLogRecord.getRawData();
            string = wsLogRecord.getComponent();
            string5 = wsLogRecord.getOrganization();
            string6 = wsLogRecord.getProduct();
            if (string5 == ibm && string6 == websphere) {
                string7 = wsLogRecord.getVersion();
            }
            string11 = wsLogRecord.getExtension("handler_preference");
        }
        string2 = RasHelper.getThreadId(logRecord);
        string10 = TraceLogFormatter.formatMessage(logRecord, Locale.getDefault(), 4);
        if (string9 == null) {
            string9 = TraceLogFormatter.getStackTrace(logRecord);
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string4 == null) {
            string4 = "";
        }
        if (string5 == null) {
            string5 = "";
        }
        if (string6 == null) {
            string6 = "";
        }
        if (string7 == null) {
            string7 = "";
        }
        if (string8 == null) {
            string8 = "";
        }
        if (string9 == null) {
            string9 = "";
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        if (string10 == null) {
            string10 = "";
        }
        if (string11 == null) {
            string11 = "";
        }
        int n2 = 0;
        n2 = n >= LEVELVALUE_SEVERE ? 1 : (n >= LEVELVALUE_WARNING ? 2 : 3);
        if (string3.length() == 0 && string4.length() > 0) {
            string3 = string4;
        }
        boolean bl = false;
        if (string11 != null && string11.equals("operator")) {
            bl = true;
        }
        CommonBaseEvent commonBaseEvent = null;
        byte[] byArray2 = null;
        if (sbUseCBEFormat && (commonBaseEvent = WsLogRecordFactory.getCommonBaseEvent(logRecord)) != null) {
            byArray2 = CB390TraceEventListener.convertToZippedCBEXML(commonBaseEvent);
        }
        if (nativeMethodsLoaded) {
            this.writeTrace(1, byArray2, n, string, string2, string3, string4, string5, string6, string7, this.serverName, n2, string8, string10, string9, byArray, bl);
        }
    }

    private static byte[] convertToZippedCBEXML(CommonBaseEvent commonBaseEvent) {
        byte[] byArray;
        block10: {
            byArray = null;
            String string = EventFormatter.toCanonicalXMLString(commonBaseEvent, false);
            if (string != null) {
                try {
                    byArray = CB390TraceEventListener.zip(string);
                    if (byArray == null) {
                        if (svLogger.isLoggable(Level.FINE)) {
                            svLogger.logp(Level.FINE, CLASSNAME, "processEvent", "No data returned from zip method -- CommonBaseEvent will not be logged.  CommonBaseEvent:" + string);
                        }
                    } else {
                        int n = ZRasHelper.ProcessInfo.getLogRecordSize();
                        int n2 = byArray.length + 256;
                        if (n > 0 && n2 > n) {
                            if (svLogger.isLoggable(Level.FINE)) {
                                svLogger.logp(Level.FINE, CLASSNAME, "processEvent", "Log entry is of size " + n2 + " bytes which is too large to be added to log stream which is configured for " + n + " byte records.  This CommonBaseEvent will not be logged to log stream.  CommonBaseEvent:" + string);
                            }
                            byArray = CB390TraceEventListener.createZippedMessage_MessageTooLong(byArray.length, n);
                        }
                    }
                    break block10;
                }
                catch (IOException iOException) {
                    if (svLogger.isLoggable(Level.FINE)) {
                        svLogger.logp(Level.FINE, CLASSNAME, "processEvent", "IOException encountered during zip of CommonBaseEvent.  CommonBaseEvent will not be logged to log stream.  CommonBaseEvent:" + string);
                    }
                    break block10;
                }
            }
            if (svLogger.isLoggable(Level.FINE)) {
                svLogger.logp(Level.FINE, CLASSNAME, "processEvent", "Unable to convert cbe into an XML string.  CommonBaseEvent will not be logged to log stream.");
            }
        }
        return byArray;
    }

    private static byte[] zip(String string) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            deflaterOutputStream.write(string.getBytes("UTF-8"));
            deflaterOutputStream.flush();
            deflaterOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            svLogger.throwing(CLASSNAME, "zip", iOException);
            throw iOException;
        }
    }

    private static String unzip(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        int n2 = 1024;
        int n3 = 0;
        byte[] byArray2 = new byte[1024];
        while (n3 >= 0) {
            n3 = inflaterInputStream.read(byArray2, 0, 1024);
            if (n3 <= 0) continue;
            byteArrayOutputStream.write(byArray2, 0, n3);
            n += n3;
            n2 -= n3;
        }
        byteArrayOutputStream.flush();
        return new String(byteArrayOutputStream.toByteArray(), "UTF-8");
    }

    private static byte[] createZippedMessage_MessageTooLong(int n, int n2) {
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        byte[] byArray = CB390TraceEventListener.createZippedMessage("MSG_TOO_LARGE_FOR_LOGSTREAM", objectArray);
        if (byArray == null || byArray.length + 256 > n2) {
            return null;
        }
        return byArray;
    }

    private static byte[] createZippedMessage(String string, Object[] objectArray) {
        WsLogRecord wsLogRecord = WsLogRecordFactory.createWsLogRecord(null, Level.SEVERE, string, objectArray, CLASSNAME, "processEvent", BUNDLENAME, null, null, null, null, null, null, Level.ALL.intValue(), svLoggerName);
        CommonBaseEvent commonBaseEvent = WsLogRecordFactory.getCommonBaseEvent(wsLogRecord.getImpl());
        String string2 = EventFormatter.toCanonicalXMLString(commonBaseEvent, false);
        byte[] byArray = null;
        try {
            byArray = CB390TraceEventListener.zip(string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    static {
        try {
            svLogger = Logger.getLogger(svLoggerName, BUNDLENAME);
        }
        catch (MissingResourceException missingResourceException) {
            svLogger = Logger.getLogger(svLoggerName);
            svLogger.throwing(CLASSNAME, "static init", missingResourceException);
        }
        LoggerHelper.setAttributes(svLogger, "IBM", "WebSphere", "RAS", WsLevel.DETAIL);
        String string = RasHelper.getSystemProperty("com.ibm.ws.logging.zOS.errorLog.format");
        sbUseCBEFormat = string != null && string.equals("CBE-XML-1.0.1");
        ibm = "IBM";
        websphere = "WebSphere";
        nativeMethodsLoaded = false;
        if (System.getProperty("com.ibm.ws390.trace.nolib") == null) {
            string = System.getProperty("com.ibm.vm.bitmode");
            int n = Integer.parseInt(string);
            if (n == 64) {
                System.loadLibrary("bbgrjras");
            } else {
                System.loadLibrary("bborjras");
            }
            nativeMethodsLoaded = true;
        } else {
            nativeMethodsLoaded = false;
        }
    }
}

