/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordCipherException;
import com.ibm.ISecurityUtilityImpl.UnsupportedCryptoAlgorithmException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.security.crypto.CustomPasswordEncryption;
import com.ibm.wsspi.security.crypto.EncryptedInfo;
import com.ibm.wsspi.security.crypto.PasswordDecryptException;
import com.ibm.wsspi.security.crypto.PasswordEncryptException;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public class PasswordCipherUtil {
    private static final byte XOR_MASK = 95;
    private static final TraceComponent tc;
    private static String[] _supported_crypto_algorithms;
    private static final String DEFAULT_CRYPTO_ALGORITHM_PROPERTY = "os400.security.password.encoding.algorithm";
    private static final String VALIDATION_LIST_PROPERTY = "os400.security.password.validation.list.object";
    private static final String[] DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS;
    private static final String DEFAULT_CUSTOM_CRYPTO_CLASS = "com.ibm.wsspi.security.crypto.CustomPasswordEncryptionImpl";
    private static final String CUSTOM_CRYPTO_CLASS_PROPERTY = "com.ibm.wsspi.security.crypto.customPasswordEncryptionClass";
    private static final String CUSTOM_CRYPTO_ENABLE_PROPERTY = "com.ibm.wsspi.security.crypto.customPasswordEncryptionEnabled";
    private static final int XOR_INDEX = 0;
    private static final int OS400_INDEX = 1;
    private static final int CUSTOM_INDEX = 2;
    private static final int ADVANCED_EDITION = 0;
    private static final int ADVANCED_EDITION_SINGLE_SERVER = 1;
    private static String[] _validation_list_objects;
    private static CustomPasswordEncryption customPasswordEncryptionClass;
    private static boolean _standalone;
    private static int _edition;
    private static boolean _debug;
    private static String custom_crypto_class;
    private static boolean custom_crypto_enabled;
    static String osName;

    /*
     * Unable to fully structure code
     */
    public static byte[] decipher(byte[] var0, String var1_1) throws InvalidPasswordCipherException, UnsupportedCryptoAlgorithmException {
        if (var1_1 == null) {
            throw new UnsupportedCryptoAlgorithmException();
        }
        var2_2 = null;
        if (var1_1.equalsIgnoreCase(PasswordCipherUtil.DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0])) {
            var2_2 = PasswordCipherUtil.xor(var0);
        } else if (var1_1.startsWith(PasswordCipherUtil.DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[2])) {
            try {
                if (PasswordCipherUtil.customPasswordEncryptionClass == null) ** GOTO lbl37
                var3_3 = var1_1.indexOf(":");
                var4_7 = null;
                if (var3_3 != -1) {
                    var4_7 = var1_1.substring(var3_3 + 1);
                }
                var2_2 = PasswordCipherUtil.customPasswordEncryptionClass.decrypt(new EncryptedInfo(var0, var4_7));
                if (!PasswordCipherUtil.tc.isDebugEnabled()) ** GOTO lbl37
                Tr.debug(PasswordCipherUtil.tc, "Successfully decrypted password using custom encryption plug point.");
            }
            catch (PasswordDecryptException var3_4) {
                FFDCFilter.processException(var3_4, "com.ibm.ISecurityUtilityImpl.PasswordCipherUtil.decipher", "282");
                Tr.error(PasswordCipherUtil.tc, "PasswordDecryptException during custom decryption: " + var3_4.getMessage());
                throw new InvalidPasswordCipherException();
            }
            catch (Exception var3_5) {
                FFDCFilter.processException(var3_5, "com.ibm.ISecurityUtilityImpl.PasswordCipherUtil.decipher", "288");
                Tr.error(PasswordCipherUtil.tc, "Exception during custom decryption: " + var3_5.getMessage());
                throw new InvalidPasswordCipherException();
            }
        } else if (PasswordCipherUtil.osName.compareTo("OS/400") == 0 && var1_1.equalsIgnoreCase(PasswordCipherUtil.DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[1])) {
            try {
                var4_8 = new String(var0, "UTF8");
                var3_6 = PasswordCipherUtil.ntv_os400Decipher(var4_8, PasswordCipherUtil._validation_list_objects, PasswordCipherUtil._edition, PasswordCipherUtil._standalone, PasswordCipherUtil._debug);
                if (var3_6 == null) {
                    throw new InvalidPasswordCipherException();
                }
                var2_2 = var3_6.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException var4_9) {
                throw new InvalidPasswordCipherException();
            }
        } else {
            throw new UnsupportedCryptoAlgorithmException();
        }
lbl37:
        // 5 sources

        if (var2_2 == null) {
            throw new InvalidPasswordCipherException();
        }
        return var2_2;
    }

    public static byte[] encipher(byte[] byArray, String string) throws InvalidPasswordCipherException, UnsupportedCryptoAlgorithmException {
        try {
            EncryptedInfo encryptedInfo = PasswordCipherUtil.encipher_internal(byArray, string);
            return encryptedInfo.getEncryptedBytes();
        }
        catch (PasswordEncryptException passwordEncryptException) {
            throw new InvalidPasswordCipherException();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static EncryptedInfo encipher_internal(byte[] var0, String var1_1) throws InvalidPasswordCipherException, UnsupportedCryptoAlgorithmException, PasswordEncryptException {
        if (var1_1 == null) {
            throw new UnsupportedCryptoAlgorithmException();
        }
        var2_2 = null;
        var3_3 = null;
        if (var1_1.equalsIgnoreCase(PasswordCipherUtil.DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0])) {
            var3_3 = PasswordCipherUtil.xor(var0);
            if (var3_3 != null) {
                var2_2 = new EncryptedInfo(var3_3, "");
            }
        } else if (var1_1.startsWith(PasswordCipherUtil.DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[2])) {
            try {
                if (PasswordCipherUtil.customPasswordEncryptionClass != null) {
                    var2_2 = PasswordCipherUtil.customPasswordEncryptionClass.encrypt(var0);
                    if (!PasswordCipherUtil.tc.isDebugEnabled()) ** GOTO lbl41
                    Tr.debug(PasswordCipherUtil.tc, "Successfully encrypted password using custom encryption plug point.");
                }
                var3_3 = PasswordCipherUtil.xor(var0);
                if (var3_3 == null) ** GOTO lbl41
                var2_2 = new EncryptedInfo(var3_3, "");
            }
            catch (PasswordEncryptException var4_4) {
                FFDCFilter.processException(var4_4, "com.ibm.ISecurityUtilityImpl.PasswordCipherUtil.encipher", "387");
                Tr.error(PasswordCipherUtil.tc, "PasswordEncryptException during custom encryption: " + var4_4.getMessage());
                return new EncryptedInfo(PasswordCipherUtil.xor(var0), "");
            }
            catch (Exception var4_5) {
                FFDCFilter.processException(var4_5, "com.ibm.ISecurityUtilityImpl.PasswordCipherUtil.encipher", "393");
                Tr.error(PasswordCipherUtil.tc, "Received a password encrypted with a custom algorithm that is not currently configured.");
                return new EncryptedInfo(PasswordCipherUtil.xor(var0), "");
            }
        } else if (PasswordCipherUtil.osName.compareTo("OS/400") == 0 && var1_1.equalsIgnoreCase(PasswordCipherUtil.DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[1])) {
            try {
                var4_6 = PasswordCipherUtil.ntv_os400Encipher(new String(var0, "UTF8"), PasswordCipherUtil._validation_list_objects, PasswordCipherUtil._edition, PasswordCipherUtil._standalone, PasswordCipherUtil._debug);
                if (var4_6 == null) {
                    throw new InvalidPasswordCipherException();
                }
                var3_3 = var4_6.getBytes("UTF8");
                if (var3_3 == null) ** GOTO lbl41
                var2_2 = new EncryptedInfo(var3_3, "");
            }
            catch (UnsupportedEncodingException var5_7) {
                throw new InvalidPasswordCipherException();
            }
        } else {
            throw new UnsupportedCryptoAlgorithmException();
        }
lbl41:
        // 7 sources

        if (var2_2 == null) {
            throw new InvalidPasswordCipherException();
        }
        return var2_2;
    }

    public static String[] getSupportedCryptoAlgorithms() {
        return _supported_crypto_algorithms;
    }

    public static String getFailSafeCryptoAlgorithm() {
        return DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0];
    }

    public static void updateValidationList() {
        Tr.entry(tc, "updateValidationList");
        if (osName.compareTo("OS/400") == 0) {
            String string = System.getProperty(VALIDATION_LIST_PROPERTY, null);
            try {
                int n;
                int n2 = 0;
                if (string != null && string.length() != 0) {
                    if ((string = string.toUpperCase()).indexOf(58) == -1) {
                        ++n2;
                    } else {
                        int n3 = 0;
                        while (n3 < string.length() && (n = string.indexOf(58, n3)) > -1) {
                            ++n2;
                            n3 = n + 1;
                        }
                        ++n2;
                    }
                }
                _validation_list_objects = new String[n2];
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    PasswordCipherUtil._validation_list_objects[n] = stringTokenizer.nextToken();
                    ++n;
                }
            }
            catch (Exception exception) {
                _validation_list_objects = null;
            }
        }
        Tr.exit(tc, "updateValidationList");
    }

    private static byte[] xor(byte[] byArray) {
        byte[] byArray2 = null;
        if (byArray != null) {
            byArray2 = new byte[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray2[i] = (byte)(0x5F ^ byArray[i]);
            }
        }
        return byArray2;
    }

    private static void initializeCustomPasswordEncryption() {
        block20: {
            if (customPasswordEncryptionClass == null) {
                try {
                    String string = System.getProperty(CUSTOM_CRYPTO_ENABLE_PROPERTY);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "com.ibm.wsspi.security.crypto.customPasswordEncryptionEnabled = " + string);
                    }
                    if (string == null || string != null && (string.equalsIgnoreCase("no") || string.equalsIgnoreCase("false"))) {
                        custom_crypto_enabled = false;
                    } else if (string != null && (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true"))) {
                        custom_crypto_enabled = true;
                    }
                    custom_crypto_class = System.getProperty(CUSTOM_CRYPTO_CLASS_PROPERTY);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "com.ibm.wsspi.security.crypto.customPasswordEncryptionClass = " + custom_crypto_class);
                    }
                    if (custom_crypto_class == null) {
                        custom_crypto_class = DEFAULT_CUSTOM_CRYPTO_CLASS;
                    }
                    if (custom_crypto_class == null) break block20;
                    try {
                        Class<?> clazz = null;
                        try {
                            ClassLoader classLoader = ExtClassLoader.getInstance();
                            if (classLoader == null) {
                                classLoader = PasswordCipherUtil.class.getClassLoader();
                            }
                            clazz = Class.forName(custom_crypto_class, true, classLoader);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (clazz == null) {
                            clazz = Class.forName(custom_crypto_class);
                        }
                        if ((customPasswordEncryptionClass = (CustomPasswordEncryption)clazz.newInstance()) != null && string == null && custom_crypto_class.equals(DEFAULT_CUSTOM_CRYPTO_CLASS)) {
                            custom_crypto_enabled = true;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Successfully loaded the custom encryption class: " + custom_crypto_class);
                        }
                    }
                    catch (Exception exception) {
                        if (!DEFAULT_CUSTOM_CRYPTO_CLASS.equals(custom_crypto_class)) {
                            FFDCFilter.processException(exception, "com.ibm.ISecurityUtilityImpl.PasswordCipherUtil.initializeCustomPasswordEncryption", "611");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Could not load the custom encryption class: " + custom_crypto_class);
                        }
                        custom_crypto_enabled = false;
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ISecurityUtilityImpl.PasswordCipherUtil", "620");
                    Tr.error(tc, "Could not load class: " + custom_crypto_class);
                    custom_crypto_enabled = false;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Custom encryption enabled = " + custom_crypto_enabled);
        }
    }

    private static native String ntv_os400Encipher(String var0, String[] var1, int var2, boolean var3, boolean var4);

    private static native String ntv_os400Decipher(String var0, String[] var1, int var2, boolean var3, boolean var4);

    private static native void ntv_os400ReportBadDefaultCryptoAlgorithm(int var0, boolean var1, boolean var2);

    static {
        String string;
        tc = Tr.register(PasswordCipherUtil.class, "SASRas", "com.ibm.ejs.resources.security");
        _supported_crypto_algorithms = null;
        DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS = new String[]{"xor", "os400", "custom"};
        _validation_list_objects = null;
        customPasswordEncryptionClass = null;
        _standalone = false;
        _edition = 0;
        _debug = false;
        custom_crypto_class = null;
        custom_crypto_enabled = false;
        PasswordCipherUtil.initializeCustomPasswordEncryption();
        osName = System.getProperty("os.name");
        if (osName.compareTo("OS/400") == 0) {
            string = System.getProperty("was.install.library");
            try {
                String string2;
                Tr.debug(tc, "Loading native library: /QSYS.LIB/" + string + ".LIB/QWASPMGT.SRVPGM");
                System.load("/QSYS.LIB/" + string + ".LIB/QWASPMGT.SRVPGM");
                String string3 = System.getProperty("was.standalone", "false");
                if (string3.equalsIgnoreCase("true")) {
                    _standalone = true;
                }
                if ((string2 = System.getProperty("os400.security.password.debug", "false")).equalsIgnoreCase("true")) {
                    _debug = true;
                }
                String string4 = System.getProperty(DEFAULT_CRYPTO_ALGORITHM_PROPERTY, DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0]);
                if (custom_crypto_enabled && customPasswordEncryptionClass != null) {
                    string4 = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[2];
                }
                int n = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS.length;
                boolean bl = false;
                string4 = string4.trim();
                for (int i = 0; i < n; ++i) {
                    if (!string4.equalsIgnoreCase(DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[i])) continue;
                    bl = true;
                    _supported_crypto_algorithms = new String[n];
                    PasswordCipherUtil._supported_crypto_algorithms[0] = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[i];
                    int n2 = 1;
                    for (int j = 0; j < n; ++j) {
                        if (j == i) continue;
                        PasswordCipherUtil._supported_crypto_algorithms[n2++] = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[j];
                    }
                    break;
                }
                if (!bl) {
                    PasswordCipherUtil.ntv_os400ReportBadDefaultCryptoAlgorithm(_edition, _standalone, _debug);
                }
            }
            catch (Throwable throwable) {
                _supported_crypto_algorithms = null;
            }
            if (_supported_crypto_algorithms == null) {
                _supported_crypto_algorithms = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS;
            }
        } else if (_supported_crypto_algorithms == null) {
            if (custom_crypto_enabled && customPasswordEncryptionClass != null) {
                _supported_crypto_algorithms = new String[2];
                PasswordCipherUtil._supported_crypto_algorithms[0] = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[2];
                PasswordCipherUtil._supported_crypto_algorithms[1] = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0];
            } else if (customPasswordEncryptionClass != null) {
                _supported_crypto_algorithms = new String[2];
                PasswordCipherUtil._supported_crypto_algorithms[0] = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0];
                PasswordCipherUtil._supported_crypto_algorithms[1] = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[2];
            } else {
                _supported_crypto_algorithms = new String[1];
                PasswordCipherUtil._supported_crypto_algorithms[0] = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0];
            }
        }
        if (osName.compareTo("OS/400") == 0) {
            string = System.getProperty(VALIDATION_LIST_PROPERTY, null);
            try {
                int n = 0;
                if (string != null && string.length() != 0) {
                    if ((string = string.toUpperCase()).indexOf(58) == -1) {
                        ++n;
                    } else {
                        int n3;
                        int n4 = 0;
                        while (n4 < string.length() && (n3 = string.indexOf(58, n4)) > -1) {
                            ++n;
                            n4 = n3 + 1;
                        }
                        ++n;
                    }
                }
                _validation_list_objects = new String[n];
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                int n5 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    PasswordCipherUtil._validation_list_objects[n5] = stringTokenizer.nextToken();
                    ++n5;
                }
            }
            catch (Exception exception) {
                _validation_list_objects = null;
            }
        }
    }
}

