/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import sun.tools.jconsole.ClassTab;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.MemoryTab;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.SummaryTab;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.ThreadTab;
import sun.tools.jconsole.VMTab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMPanel
extends JTabbedPane {
    private ProxyClient proxyClient;
    private Timer timer;
    private int updateInterval;
    private String hostName;
    private int port;
    private int vmid;
    private String userName;
    private String password;
    private String jmxUrl;
    private boolean mmEnabled = true;
    private static final String windowsLaF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    String verboseException = System.getProperty("com.ibm.jconsole.verbose");
    private static ArrayList<TabInfo> tabInfos = new ArrayList();

    public static TabInfo[] getTabInfos() {
        return tabInfos.toArray(new TabInfo[tabInfos.size()]);
    }

    VMPanel(ProxyClient proxyClient, int n) {
        this.proxyClient = proxyClient;
        this.updateInterval = n;
        this.hostName = proxyClient.getHostName();
        this.port = proxyClient.getPort();
        this.vmid = proxyClient.getVmid();
        this.userName = proxyClient.getUserName();
        this.password = proxyClient.getPassword();
        this.jmxUrl = proxyClient.getUrl();
        for (TabInfo object2 : tabInfos) {
            if (!object2.tabVisible) continue;
            this.addTab(object2);
        }
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        this.setTransparency(lookAndFeel.getClass().getName().equals(windowsLaF));
        TimerTask timerTask = new TimerTask(){

            public void run() {
                VMPanel.this.update();
            }
        };
        String string = "Timer-" + this.getConnectionName();
        this.timer = new Timer(string, true);
        this.timer.schedule(timerTask, 0L, (long)n);
    }

    private synchronized void addTab(TabInfo tabInfo) {
        Tab tab = this.instantiate(tabInfo);
        if (tab != null) {
            this.addTab(tabInfo.name, tab);
        } else {
            tabInfo.tabVisible = false;
        }
    }

    private synchronized void insertTab(TabInfo tabInfo, int n) {
        Tab tab = this.instantiate(tabInfo);
        if (tab != null) {
            this.insertTab(tabInfo.name, null, tab, null, n);
        } else {
            tabInfo.tabVisible = false;
        }
    }

    @Override
    public synchronized void removeTabAt(int n) {
        super.removeTabAt(n);
    }

    private Tab instantiate(TabInfo tabInfo) {
        try {
            Constructor constructor = tabInfo.tabClass.getConstructor(VMPanel.class);
            return (Tab)constructor.newInstance(this);
        }
        catch (Exception exception) {
            if (this.verboseException != null) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    synchronized boolean isMMEnabled() {
        return this.mmEnabled;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    ProxyClient getProxyClient(boolean bl) {
        if (bl) {
            return this.getProxyClient();
        }
        return this.proxyClient;
    }

    public ProxyClient getProxyClient() {
        String string = Thread.currentThread().getClass().getName();
        if (string.equals("java.awt.EventDispatchThread")) {
            String string2 = "Calling VMPanel.getProxyClient() from the Event Dispatch Thread!";
            new RuntimeException(string2).printStackTrace();
            System.exit(1);
        }
        return this.proxyClient;
    }

    public void disconnect() {
        for (Tab tab : this.getTabs()) {
            tab.dispose();
        }
        this.timer.cancel();
    }

    protected synchronized List<Tab> getTabs() {
        ArrayList<Tab> arrayList = new ArrayList<Tab>();
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add((Tab)this.getComponentAt(i));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        if (!this.isMMEnabled()) {
            try {
                if (!this.proxyClient.isDead()) {
                    this.proxyClient.getMBeanServerConnection().getDefaultDomain();
                }
            }
            catch (IOException iOException) {
                this.proxyClient.markAsDead();
            }
            if (this.proxyClient.isDead()) {
                this.disconnect();
                JConsole jConsole = (JConsole)SwingUtilities.getWindowAncestor(this);
                if (jConsole != null) {
                    jConsole.vmPanelDied(this);
                }
            }
            return;
        }
        List<Tab> list = this.getTabs();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            try {
                if (this.proxyClient.isDead()) continue;
                list.get(i).update();
                continue;
            }
            catch (Exception exception) {
                if (this.verboseException != null) {
                    exception.printStackTrace();
                }
                VMPanel vMPanel = this;
                synchronized (vMPanel) {
                    this.mmEnabled = false;
                }
                this.setEnabledAt(i, false);
                this.timer.cancel();
                this.timer.purge();
            }
        }
        if (!this.isMMEnabled()) {
            this.setSelectedIndex(4);
            TimerTask timerTask = new TimerTask(){

                public void run() {
                    VMPanel.this.update();
                }
            };
            String string = "Timer-" + this.proxyClient.getConnectionName();
            this.timer = new Timer(string, true);
            this.timer.schedule(timerTask, 0L, (long)this.updateInterval);
            return;
        }
        if (this.proxyClient.isDead()) {
            this.disconnect();
            JConsole jConsole = (JConsole)SwingUtilities.getWindowAncestor(this);
            if (jConsole != null) {
                jConsole.vmPanelDied(this);
            }
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUrl() {
        return this.jmxUrl;
    }

    public String getPassword() {
        return this.password;
    }

    public String getConnectionName() {
        return this.proxyClient.getConnectionName();
    }

    public void setTransparency(boolean bl) {
        for (Component component : this.getComponents()) {
            if (!(component instanceof Tab)) continue;
            this.setTransparency((JComponent)component, bl);
        }
    }

    private void setTransparency(JComponent jComponent, boolean bl) {
        jComponent.setOpaque(!bl);
        for (Component component : jComponent.getComponents()) {
            if (!(component instanceof JPanel)) continue;
            this.setTransparency((JComponent)component, bl);
        }
    }

    static {
        tabInfos.add(new TabInfo(SummaryTab.class, SummaryTab.getTabName(), true));
        tabInfos.add(new TabInfo(MemoryTab.class, MemoryTab.getTabName(), true));
        tabInfos.add(new TabInfo(ThreadTab.class, ThreadTab.getTabName(), true));
        tabInfos.add(new TabInfo(ClassTab.class, ClassTab.getTabName(), true));
        tabInfos.add(new TabInfo(MBeansTab.class, MBeansTab.getTabName(), true));
        tabInfos.add(new TabInfo(VMTab.class, VMTab.getTabName(), true));
        String string = System.getProperty("jconsole.addTabClass");
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(":")) {
                try {
                    Class<?> clazz = Class.forName(string2);
                    Method method = clazz.getDeclaredMethod("getTabName", new Class[0]);
                    String string3 = (String)method.invoke(null, new Object[0]);
                    tabInfos.add(new TabInfo(clazz, string3, true));
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
    }

    static class TabInfo {
        Class tabClass;
        String name;
        boolean tabVisible;

        TabInfo(Class clazz, String string, boolean bl) {
            this.tabClass = clazz;
            this.name = string;
            this.tabVisible = bl;
        }
    }
}

