/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.ibm.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GcInfo {
    private final long index;
    private final long startTime;
    private final long endTime;
    private final Map<String, MemoryUsage> usageBeforeGc;
    private final Map<String, MemoryUsage> usageAfterGc;
    String verboseException = System.getProperty("com.ibm.jconsole.verbose");

    public GcInfo(GarbageCollectorMXBean garbageCollectorMXBean) {
        this.index = garbageCollectorMXBean.getCollectionCount();
        this.startTime = garbageCollectorMXBean.getLastCollectionStartTime();
        this.endTime = garbageCollectorMXBean.getLastCollectionEndTime();
        String[] stringArray = garbageCollectorMXBean.getMemoryPoolNames();
        this.usageBeforeGc = new HashMap<String, MemoryUsage>(stringArray.length);
        this.usageAfterGc = new HashMap<String, MemoryUsage>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                String string = "java.lang:type=MemoryPool,name=" + stringArray[i];
                ObjectName objectName = new ObjectName(string);
                CompositeData compositeData = (CompositeData)mBeanServer.getAttribute(objectName, "MemoryUsagePostLastCollection");
                MemoryUsage memoryUsage = MemoryUsage.from(compositeData);
                this.usageAfterGc.put(stringArray[i], memoryUsage);
                CompositeData compositeData2 = (CompositeData)mBeanServer.getAttribute(objectName, "MemoryUsagePreLastCollection");
                MemoryUsage memoryUsage2 = MemoryUsage.from(compositeData2);
                this.usageBeforeGc.put(stringArray[i], memoryUsage2);
                continue;
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                if (this.verboseException == null) continue;
                malformedObjectNameException.printStackTrace();
                continue;
            }
            catch (MBeanException mBeanException) {
                if (this.verboseException == null) continue;
                mBeanException.printStackTrace();
                continue;
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                if (this.verboseException == null) continue;
                attributeNotFoundException.printStackTrace();
                continue;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (this.verboseException == null) continue;
                instanceNotFoundException.printStackTrace();
                continue;
            }
            catch (ReflectionException reflectionException) {
                if (this.verboseException == null) continue;
                reflectionException.printStackTrace();
            }
        }
    }

    public long getId() {
        return this.index;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.endTime - this.startTime;
    }

    public Map<String, MemoryUsage> getMemoryUsageBeforeGc() {
        return Collections.unmodifiableMap(this.usageBeforeGc);
    }

    public Map<String, MemoryUsage> getMemoryUsageAfterGc() {
        return Collections.unmodifiableMap(this.usageAfterGc);
    }
}

