/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.management.remote.JMXServiceURL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;
import sun.tools.jconsole.ConnectionParameters;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.LabeledComponent;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.VariableGridLayout;

public class ConnectDialog
extends JDialog
implements ActionListener,
DocumentListener,
FocusListener,
ItemListener,
KeyListener {
    private int LOCAL_TAB;
    private int REMOTE_TAB;
    private int ADVANCED_TAB;
    JConsole jConsole;
    JTextField hostName;
    JTextField jmxUrl;
    JTextField portNumber;
    JTextField userNameTF;
    JTextField passwordTF;
    JTextField userNameUrl;
    JTextField passwordUrl;
    JButton addButton;
    JButton cancelButton;
    JLabel statusBar;
    JTabbedPane pan;
    JTable vmTable;
    ManagedVmTableModel vmModel = null;
    private static JLabel label = new JLabel();

    public ConnectDialog(JConsole jConsole) {
        super(jConsole, Resources.getText("JConsole: Connect to Agent", new Object[0]), true);
        Dimension dimension;
        this.jConsole = jConsole;
        Container container = this.getContentPane();
        ((JComponent)container).setBorder(new EmptyBorder(10, 10, 4, 10));
        JPanel jPanel = new JPanel(new VariableGridLayout(0, 1, 4, 4, false, true));
        JPanel jPanel2 = new JPanel(new VariableGridLayout(0, 1, 4, 4, false, true));
        this.jmxUrl = new JTextField(20);
        this.jmxUrl.addFocusListener(this);
        this.jmxUrl.addFocusListener(this);
        this.jmxUrl.addActionListener(this);
        this.jmxUrl.getAccessibleContext().setAccessibleName(Resources.getText("JMX URL: ", new Object[0]));
        jPanel2.add(new LabeledComponent(Resources.getText("JMX URL: ", new Object[0]), this.jmxUrl));
        this.jmxUrl.setText("service:jmx:");
        this.userNameUrl = new JTextField(20);
        this.userNameUrl.addActionListener(this);
        this.userNameUrl.getDocument().addDocumentListener(this);
        this.userNameUrl.addFocusListener(this);
        this.userNameUrl.getAccessibleContext().setAccessibleName(Resources.getText("User Name: ", new Object[0]));
        jPanel2.add(new LabeledComponent(Resources.getText("User Name: ", new Object[0]), this.userNameUrl));
        this.passwordUrl = new JPasswordField(20);
        this.passwordUrl.addActionListener(this);
        this.passwordUrl.getDocument().addDocumentListener(this);
        this.passwordUrl.addFocusListener(this);
        this.passwordUrl.getAccessibleContext().setAccessibleName(Resources.getText("Password: ", new Object[0]));
        jPanel2.add(new LabeledComponent(Resources.getText("Password: ", new Object[0]), this.passwordUrl));
        LabeledComponent.layout(jPanel2);
        this.hostName = new JTextField(20);
        this.hostName.addActionListener(this);
        this.hostName.getDocument().addDocumentListener(this);
        this.hostName.addFocusListener(this);
        this.hostName.getAccessibleContext().setAccessibleName(Resources.getText("Host or IP: ", new Object[0]));
        jPanel.add(new LabeledComponent(Resources.getText("Host or IP: ", new Object[0]), this.hostName));
        this.portNumber = new JTextField(6);
        this.portNumber.addActionListener(this);
        this.portNumber.addKeyListener(this);
        this.portNumber.addFocusListener(this);
        this.portNumber.getAccessibleContext().setAccessibleName(Resources.getText("Port: ", new Object[0]));
        jPanel.add(new LabeledComponent(Resources.getText("Port: ", new Object[0]), this.portNumber));
        this.userNameTF = new JTextField(20);
        this.userNameTF.addActionListener(this);
        this.userNameTF.getDocument().addDocumentListener(this);
        this.userNameTF.addFocusListener(this);
        this.userNameTF.getAccessibleContext().setAccessibleName(Resources.getText("User Name: ", new Object[0]));
        jPanel.add(new LabeledComponent(Resources.getText("User Name: ", new Object[0]), this.userNameTF));
        this.passwordTF = new JPasswordField(20);
        this.passwordTF.addActionListener(this);
        this.passwordTF.getDocument().addDocumentListener(this);
        this.passwordTF.addFocusListener(this);
        this.passwordTF.getAccessibleContext().setAccessibleName(Resources.getText("Password: ", new Object[0]));
        jPanel.add(new LabeledComponent(Resources.getText("Password: ", new Object[0]), this.passwordTF));
        LabeledComponent.layout(jPanel);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        container.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel();
        jPanel3.add((Component)jPanel4, "North");
        this.addButton = new JButton(Resources.getText("Connect", new Object[0]));
        jPanel4.add(this.addButton);
        this.cancelButton = new JButton(Resources.getText("Cancel", new Object[0]));
        jPanel4.add(this.cancelButton);
        this.statusBar = new JLabel(" ", 0);
        jPanel3.add((Component)this.statusBar, "South");
        this.addButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.pan = new JTabbedPane();
        int n = 0;
        if (ConnectDialog.isLocalAttachAvailable()) {
            int n2 = 400;
            dimension = new Dimension(n2, 300);
            this.vmModel = new ManagedVmTableModel();
            this.vmTable = new JTable(this.vmModel);
            this.vmTable.setAutoResizeMode(0);
            this.vmTable.setColumnSelectionAllowed(false);
            TableColumn tableColumn = this.vmTable.getColumnModel().getColumn(0);
            tableColumn.setMaxWidth(ConnectDialog.getLabelWidth("999999"));
            TableColumn tableColumn2 = this.vmTable.getColumnModel().getColumn(1);
            tableColumn2.setMinWidth(n2 - tableColumn.getMaxWidth());
            int n3 = this.vmModel.getCmdLineSize();
            tableColumn2.setPreferredWidth(n3);
            this.vmTable.getTableHeader().addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    ConnectDialog.this.refresh();
                }
            });
            this.pan.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                    if (jTabbedPane.getSelectedIndex() == ConnectDialog.this.LOCAL_TAB) {
                        ConnectDialog.this.refresh();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.vmTable);
            this.pan.add((Component)jScrollPane, Resources.getText("Local", new Object[0]));
            this.LOCAL_TAB = n++;
        } else {
            this.LOCAL_TAB = -99;
            dimension = new Dimension(300, 250);
        }
        jPanel.getAccessibleContext().setAccessibleName(Resources.getText("Remote", new Object[0]));
        this.pan.add((Component)jPanel, Resources.getText("Remote", new Object[0]));
        this.REMOTE_TAB = n++;
        jPanel2.getAccessibleContext().setAccessibleName(Resources.getText("Advanced", new Object[0]));
        this.pan.add((Component)jPanel2, Resources.getText("Advanced", new Object[0]));
        this.ADVANCED_TAB = n++;
        container.add(this.pan);
        this.setPreferredSize(dimension);
        this.pack();
        this.setLocationRelativeTo(jConsole);
    }

    public static int getLabelWidth(String string) {
        label.setText(string);
        return (int)label.getPreferredSize().getWidth() + 1;
    }

    public void setConnectionParameters(String string, String string2, int n, String string3, String string4, String string5) {
        if (string != null && string.length() != 0) {
            this.pan.setSelectedIndex(this.ADVANCED_TAB);
            this.jmxUrl.setText(string);
            this.userNameUrl.setText(string3 != null ? string3 : "");
            this.passwordUrl.setText(string3 != null && string4 != null ? string4 : "");
            this.statusBar.setText(string5 != null ? string5 : "");
            if (this.getPreferredSize().width > this.getWidth()) {
                this.pack();
            }
            if (string3 != null && (string4 == null || string5 != null)) {
                this.passwordUrl.requestFocus();
                this.passwordUrl.selectAll();
            } else {
                this.jmxUrl.selectAll();
            }
            return;
        }
        this.hostName.setText(string2);
        this.portNumber.setText(n + "");
        this.userNameTF.setText(string3 != null ? string3 : "");
        this.passwordTF.setText(string3 != null && string4 != null ? string4 : "");
        this.statusBar.setText(string5 != null ? string5 : "");
        if (this.getPreferredSize().width > this.getWidth()) {
            this.pack();
        }
        if (string3 != null && (string4 == null || string5 != null)) {
            this.passwordTF.requestFocus();
            this.passwordTF.selectAll();
        } else {
            this.hostName.requestFocus();
            this.hostName.selectAll();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() != this.addButton || this.pan.getSelectedIndex() != this.LOCAL_TAB) {
            this.setVisible(false);
        }
        this.statusBar.setText("");
        if (actionEvent.getSource() != this.cancelButton) {
            if (this.pan.getSelectedIndex() == this.REMOTE_TAB) {
                String string = this.hostName.getText().trim();
                String string2 = this.portNumber.getText().trim();
                String string3 = this.userNameTF.getText().trim();
                String string4 = this.passwordTF.getText();
                if (string3.length() == 0 || string4.length() == 0) {
                    string4 = null;
                }
                if (string3.length() == 0) {
                    string3 = null;
                }
                if (string.length() > 0 && string2.length() > 0) {
                    try {
                        int n = Integer.parseInt(string2.trim());
                        this.jConsole.addHost(string, n, string3, string4);
                        this.hostName.setText("");
                        this.portNumber.setText("");
                        this.userNameTF.setText("");
                        this.passwordTF.setText("");
                        return;
                    }
                    catch (Exception exception) {
                        this.statusBar.setText(exception.toString());
                    }
                }
                this.setVisible(true);
            } else if (this.pan.getSelectedIndex() == this.ADVANCED_TAB) {
                String string = this.jmxUrl.getText().trim();
                String string5 = null;
                if (string.length() > 0) {
                    String string6 = this.userNameUrl.getText().trim();
                    String string7 = this.passwordUrl.getText();
                    if (string6.length() == 0 || string7.length() == 0) {
                        string7 = null;
                    }
                    if (string6.length() == 0) {
                        string6 = null;
                    }
                    try {
                        ConnectionParameters connectionParameters = JConsole.createParameters(new JMXServiceURL(string));
                        if (string7 != null && string6 != null) {
                            if (connectionParameters.map == null) {
                                connectionParameters.map = new HashMap();
                            }
                            String[] stringArray = new String[]{string6, string7};
                            connectionParameters.map.put("jmx.remote.credentials", stringArray);
                        }
                        this.jConsole.addUrl(connectionParameters.jmxUrl, connectionParameters.map, string6, string7, false);
                        this.jmxUrl.setText("service:jmx:");
                        this.userNameUrl.setText("");
                        this.passwordUrl.setText("");
                        return;
                    }
                    catch (MalformedURLException malformedURLException) {
                        string5 = Resources.getText("Invalid URL", new Object[0]) + malformedURLException.getMessage();
                    }
                    catch (IOException iOException) {
                        string5 = Resources.getText("Connection failed", new Object[0]);
                    }
                    catch (Exception exception) {
                        string5 = exception.toString();
                    }
                    this.statusBar.setText(string5);
                }
                this.setVisible(true);
            } else if (this.pan.getSelectedIndex() == this.LOCAL_TAB) {
                Throwable throwable = null;
                int[] nArray = this.vmTable.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    ManagedVirtualMachine managedVirtualMachine = this.vmModel.vmAt(nArray[i]);
                    try {
                        ProxyClient proxyClient = ProxyClient.getProxyClient(managedVirtualMachine.vmid(), managedVirtualMachine.connectorAddress());
                        this.jConsole.addVmid(managedVirtualMachine.vmid(), proxyClient);
                        continue;
                    }
                    catch (IOException iOException) {
                        throwable = iOException;
                    }
                }
                if (nArray.length > 0 && throwable == null) {
                    this.setVisible(false);
                } else if (throwable != null) {
                    this.statusBar.setText(throwable.getMessage());
                    this.vmModel.refresh();
                }
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        final String string = this.hostName.getText();
        if (string.endsWith(":")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConnectDialog.this.hostName.setText(string.substring(0, string.length() - 1));
                    ConnectDialog.this.portNumber.requestFocus();
                }
            });
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        Component component = focusEvent.getOppositeComponent();
        if (!focusEvent.isTemporary() && object instanceof JTextField && component instanceof JComponent && SwingUtilities.getWindowAncestor(component) == this) {
            ((JTextField)object).selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\u001b') {
            this.setVisible(false);
        } else if (!Character.isDigit(c) && c != '\b' && c != '\u007f') {
            this.getToolkit().beep();
            keyEvent.consume();
        }
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        super.setVisible(bl);
        if (bl && !bl2) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (ConnectDialog.this.pan.getSelectedIndex() == ConnectDialog.this.REMOTE_TAB) {
                        ConnectDialog.this.hostName.requestFocus();
                        ConnectDialog.this.hostName.selectAll();
                    } else {
                        ConnectDialog.this.jmxUrl.requestFocus();
                        ConnectDialog.this.jmxUrl.selectAll();
                    }
                }
            });
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void refresh() {
        if (this.vmModel != null) {
            this.vmModel.refresh();
            int n = this.vmModel.getCmdLineSize();
            this.vmTable.getColumnModel().getColumn(1).setPreferredWidth(n);
            this.pack();
            if (this.vmModel.getRowCount() == 1) {
                this.vmTable.addRowSelectionInterval(0, 0);
            }
        }
    }

    private static boolean isLocalAttachAvailable() {
        try {
            Class.forName("sun.jvmstat.monitor.MonitoredHost");
            return false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static class ManagedVirtualMachine {
        private int vmid;
        private String address;
        private String cmdLine;

        ManagedVirtualMachine(int n, String string, String string2) {
            this.vmid = n;
            this.address = string;
            this.cmdLine = string2;
        }

        public int vmid() {
            return this.vmid;
        }

        public String connectorAddress() {
            return this.address;
        }

        public String commandLine() {
            return this.cmdLine;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ManagedVmTableModel
    extends AbstractTableModel {
        private static String[] columnNames = new String[]{Resources.getText("Column.PID", new Object[0]), Resources.getText("Column.Class and Arguments", new Object[0])};
        private ArrayList<ManagedVirtualMachine> vmList;
        private int longestCmdLineLength = 0;
        private String longestCmdLine = "";

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return columnNames[n];
        }

        @Override
        public synchronized int getRowCount() {
            return this.vmList.size();
        }

        @Override
        public synchronized Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 <= 1);
            ManagedVirtualMachine managedVirtualMachine = this.vmList.get(n);
            if (n2 == 0) {
                return Integer.toString(managedVirtualMachine.vmid());
            }
            return managedVirtualMachine.commandLine();
        }

        public ManagedVmTableModel() {
            this.refresh();
        }

        public synchronized ManagedVirtualMachine vmAt(int n) {
            return this.vmList.get(n);
        }

        public synchronized void refresh() {
            this.vmList = this.getManagedVirtualMachines();
            this.fireTableDataChanged();
        }

        public int getCmdLineSize() {
            return ConnectDialog.getLabelWidth(this.longestCmdLine);
        }

        private ArrayList<ManagedVirtualMachine> getManagedVirtualMachines() {
            Set<Integer> set;
            MonitoredHost monitoredHost;
            try {
                monitoredHost = MonitoredHost.getMonitoredHost(new HostIdentifier((String)null));
                set = monitoredHost.activeVms();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new InternalError(uRISyntaxException.getMessage());
            }
            catch (MonitorException monitorException) {
                throw new InternalError(monitorException.getMessage());
            }
            ArrayList<ManagedVirtualMachine> arrayList = new ArrayList<ManagedVirtualMachine>();
            for (Integer n : set) {
                try {
                    int n2 = n;
                    String string = null;
                    if (string == null) continue;
                    VmIdentifier vmIdentifier = new VmIdentifier(Integer.toString(n2));
                    String string2 = MonitoredVmUtil.commandLine(monitoredHost.getMonitoredVm(vmIdentifier));
                    int n3 = string2.length();
                    if (n3 > this.longestCmdLineLength) {
                        this.longestCmdLineLength = n3;
                        this.longestCmdLine = string2;
                    }
                    arrayList.add(new ManagedVirtualMachine(n2, string, string2));
                }
                catch (Exception exception) {}
            }
            return arrayList;
        }
    }
}

