/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.VariableGridLayout;

public class BorderedComponent
extends JPanel
implements ActionListener {
    JButton moreOrLessButton;
    String labelStr;
    String valueLabelStr;
    TitledBorder border;
    JLabel label;
    JComponent comp;
    boolean collapsed = false;
    static ImageIcon collapseIcon;
    static ImageIcon expandIcon;

    public BorderedComponent(String string, JComponent jComponent) {
        this(string, jComponent, false);
    }

    public void setTitle(String string) {
        this.border.setTitle(string);
    }

    public BorderedComponent(String string, JComponent jComponent, boolean bl) {
        super(null);
        this.labelStr = string;
        this.border = new TitledBorder(string);
        this.comp = jComponent;
        this.setBorder(new CompoundBorder(this.border, new EmptyBorder(0, 10, 0, 0)));
        if (collapseIcon == null || expandIcon == null) {
            Class<?> clazz = this.getClass();
            collapseIcon = new ImageIcon(clazz.getResource("resources/collapse.png"));
            expandIcon = new ImageIcon(clazz.getResource("resources/expand.png"));
        }
        if (bl) {
            this.moreOrLessButton = new JButton(collapseIcon);
            this.moreOrLessButton.addActionListener(this);
            this.moreOrLessButton.getAccessibleContext().setAccessibleName(string + " toggle");
            this.moreOrLessButton.setToolTipText("Toggle " + string + " Display");
            this.add(this.moreOrLessButton);
        }
        this.add(jComponent);
    }

    public void setValueLabel(String string) {
        this.valueLabelStr = string;
        if (this.label != null) {
            this.label.setText(Resources.getText("Current value", this.valueLabelStr));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.collapsed) {
            if (this.label != null) {
                this.remove(this.label);
            }
            this.add(this.comp);
            this.moreOrLessButton.setIcon(collapseIcon);
        } else {
            this.remove(this.comp);
            if (this.valueLabelStr != null) {
                if (this.label == null) {
                    this.label = new JLabel(Resources.getText("Current value", this.valueLabelStr));
                }
                this.add(this.label);
            }
            this.moreOrLessButton.setIcon(expandIcon);
        }
        this.collapsed = !this.collapsed;
        JComponent jComponent = (JComponent)this.getParent();
        if (jComponent != null && jComponent.getLayout() instanceof VariableGridLayout) {
            ((VariableGridLayout)jComponent.getLayout()).setFillRow(this, !this.collapsed);
            jComponent.revalidate();
        }
    }

    public Dimension getMinimumSize() {
        if (this.moreOrLessButton != null) {
            Dimension dimension = this.moreOrLessButton.getMinimumSize();
            Insets insets = this.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }
        return super.getMinimumSize();
    }

    public void layout() {
        Dimension dimension;
        Dimension dimension2 = this.getSize();
        Insets insets = this.getInsets();
        if (this.collapsed) {
            if (this.label != null) {
                dimension = this.label.getPreferredSize();
                this.label.setBounds(insets.left, insets.top + (dimension2.height - insets.top - insets.bottom - dimension.height) / 2, dimension.width, dimension.height);
            }
        } else {
            this.comp.setBounds(insets.left, insets.top, dimension2.width - insets.left - insets.right, dimension2.height - insets.top - insets.bottom);
        }
        if (this.moreOrLessButton != null) {
            dimension = this.moreOrLessButton.getPreferredSize();
            this.moreOrLessButton.setBounds(dimension2.width - insets.right - dimension.width, dimension2.height - insets.bottom - dimension.height, dimension.width, dimension.height);
        }
    }
}

